/*
 * Decompiled with CFR 0.152.
 */
package RC6;

import NIST.NIST_CipherSpi;
import RC6.KeySchedule;
import RC6.RC6_Algorithm;
import RC6.TextDwords;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;

abstract class RC6_Mode
implements NIST_CipherSpi {
    protected KeySchedule keySchedule;
    protected int direction;
    protected TextDwords iv = new TextDwords();
    protected byte[] buffer = new byte[16];
    protected int bytesInBuffer;

    protected RC6_Mode() {
    }

    public void init(int n, byte[] byArray) throws InvalidKeyException {
        this.keySchedule = (KeySchedule)RC6_Algorithm.makeKey(byArray);
        this.direction = n;
        this.bytesInBuffer = 0;
    }

    public void setIV(byte[] byArray) throws InvalidParameterException {
        if (byArray.length != 16) {
            throw new InvalidParameterException();
        }
        this.iv.fromBytes(byArray, 0);
    }

    protected abstract void assertBufferIsEmpty() throws InvalidParameterException;

    public byte[] doFinal(byte[] byArray, int n, int n2) throws InvalidParameterException {
        byte[] byArray2 = this.update(byArray, n, n2);
        this.assertBufferIsEmpty();
        return byArray2;
    }

    public boolean self_test() {
        return true;
    }

    public abstract byte[] update(byte[] var1, int var2, int var3);
}

