#ifndef RXPARSEH
#define RXPARSEH

/*	Copyright (C) 1992 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
/*  t. lord	Thu Sep 24 03:42:41 1992	*/

#include "rxregex.h"

enum rx_regex_side_effects
{
  /* These reserve successive integers for certain side effects. */
  regex_lparen_1 = 1,
  regex_last_lparen = regex_lparen_1 + RE_NREGS - 1,

  regex_rparen_1 = regex_last_lparen + 1,
  regex_last_rparen = regex_rparen_1 + RE_NREGS - 1,

  regex_backreference_1 = regex_last_rparen + 1,
  regex_last_backreference = regex_backreference_1 + RE_NREGS - 1,

  /* This fails except at the beginning of a line. */
  regex_hat = regex_last_backreference + 1,

  /* This fails except at the end of a line. */
  regex_dollar = regex_hat + 1,

  /* The regex never generates `win' itself. */
  regex_win = regex_dollar + 1,
  num_regex_side_effects = regex_win
};

#ifdef __STDC__

extern struct rexp_node * copy_parse_tree (struct rx_buf *,
					   struct rexp_node *); 
extern void free_parse_tree (struct rx_buf *, struct rexp_node *);

/* This compiles the pattern pointed to, and advances the pointer past
 * what was matched.  REGSET, if not NULL, is a bitset whose 1's indicate
 * registers that are purely syntactic (i.e., imply no side-effects).
  */
extern struct rexp_node * parse_rexp (struct rx_buf *, const char **,
				      int len, ut_Bitset regset);

#else /* !defined(__STDC__) */

extern struct rexp_node * copy_parse_tree ();
extern void free_parse_tree ();

/* This compiles the pattern pointed to, and advances the pointer past
 * what was matched.  REGSET, if not NULL, is a bitset whose 1's indicate
 * registers that are purely syntactic (i.e., imply no side-effects).
 */
extern struct rexp_node * parse_rexp ();

#endif /* __STDC__ */

#endif

