// Copyright (C) 2004 Etoile Diese
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with the Dialogic runtime libraries to produce a executable image
// without requiring Dialogic's sources to be supplied so long as each
// each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#ifdef REROUTE_TEST
#include <stdio.h>
#endif

#include "driver.h"
#include "reroute.h"

void encodeNas(unsigned char *pt, unsigned char *num)
{
	int i1, i2;

	*pt++ = 0x83;	// Nombre impairs de signaux d'adresse , numero national
	*pt++ = 0x10;	// Numero complet , plan de numerotage RNIS

	i1 = num[0] - 0x30;
	i2 = num[1] - 0x30;
	*pt++ = i2*16 + i1;

	i1 = num[2] - 0x30;
	i2 = num[3] - 0x30;
	*pt++ = i2*16 + i1;

	i1 = num[4] - 0x30;
	i2 = num[5] - 0x30;
	*pt++ = i2*16 + i1;

	i1 = num[6] - 0x30;
	i2 = num[7] - 0x30;
	*pt++ = i2*16 + i1;

	i1 = num[8] - 0x30;
	i2 = 0;
	*pt++ = i2*16 + i1;

	*pt = 0;
	
}

void decodeNas(unsigned char *pt, int len, char *out)
{
	char nas[10 + 1];
	int temp, num;

	pt++;	/* Parit + Indicateur de la nature de l'adresse */
	pt++;	/* Indicateur de numro incomplet + Plan de numrotage + 4 bits  0 (0000) */

	num = (unsigned int) *pt;


	temp = num/16;
	nas[1] = 0x30 + temp;
	temp = num - temp*16;
	nas[0] = 0x30 + temp;

	pt++;	/* 2 */
	num = (unsigned int) *pt;
	temp = num/16;
	nas[3] = 0x30 + temp;
	temp = num - temp*16;
	nas[2] = 0x30 + temp;

	pt++;	/* 3 */
	num = (unsigned int) *pt;
	temp = num/16;
	nas[5] = 0x30 + temp;
	temp = num - temp*16;
	nas[4] = 0x30 + temp;

	pt++;	/* 4 */
	num = (unsigned int) *pt;
	temp = num/16;
	nas[7] = 0x30 + temp;
	temp = num - temp*16;
	nas[6] = 0x30 + temp;

	pt++;	/* 5 */
	num = (unsigned int) *pt;
	temp = num/16;
	temp = num - temp*16;
	nas[8] = 0x30 + temp;
	nas[9] = 0;
	strcpy(out, nas);
//	return(9);
}


#ifdef REROUTE_TEST
void dumpCommande(unsigned char  *com, int len) {
	int i, v;

	printf("Dump de la commande de longueur %d\n", len);
	for (i = 0; i < len; i++) {
		v = *(com + i);
		printf("%d", v);
	}
	printf("Fin.\n");
}
#endif

int makeTrame(reroutage_t *r, unsigned char *pt) {
	unsigned char *ptsave1, *ptsave2;
	char nastemp[NAS_LEN + 1];
	int len, i;

	*pt++ = 0x9e;

	*pt++ = 0x76;	// Sens rerouteur --> PCS

	ptsave1 = pt;
	*pt++ = 0;	// longueur a prciser plus tard
	*pt++ = 0x47;	// Audiotel
	*pt++ = 0;	// informations complementaires


	*pt++ = DEMANDE_REROUTAGE;		// Type de reroutage
	ptsave2=pt;
	*pt++ = 0;		// Longueur : sera mis  la fin

	*pt++ = PARAM_REROUTAGE;
	*pt++ = LENPARAM_REROUTAGE;	// Longueur = 1
	*pt++ = r->typereroutage;
	len = 3; 	// pour le moment

	if (!r->cascade) {			// Cascade interdit
		*pt++ = PARAM_NOCASCADE;
		*pt++ = LENPARAM_NOCASCADE;
		len +=2;
	}

	*pt++ = r->typenum;
	*pt++ = 0x07;			// Longueur
	for (i = 0 ; i < 7; i++)
		*pt++ = r->numero[i];
	len += 9;

	if (r->typectx != -1) {		// Contexte
		*pt++ = r->typectx;
		switch(r->typectx) {
			case PARAM_CONTEXTE_ASCII :
				len++;
				*pt++ = strlen((char *) r->ctx) + 1;
				*pt++ = CODAGE_ASCII;
				break;

			default :
				*pt++ = strlen((char *) r->ctx);
				break;
		}

		len += 2;
		for (i = 0 ; i < strlen((char *) r->ctx); i++) {
			*pt++ = r->ctx[i];
			len++;
		}
	}

	if (r->donneesretour[0] != 0) {
		*pt++ = PARAM_DONNEES_RETOUR;
		*pt++ = strlen((char *) r->donneesretour);
		len += 2;
		for (i = 0 ; i < strlen((char *) r->donneesretour); i++) {
			*pt++ = r->donneesretour[i];
			len++;
		}

	}

	if (r->nasretour[0] != 0) {
		*pt++ = PARAM_NAS_RETOUR;
		*pt++ = 0x07;
		for (i = 0 ; i < 7; i++)
			*pt++ = r->nasretour[i];
		len += 9;
	}

	if (r->posinterdit != 0) {
		*pt++ = PARAM_NO_POSSIBILITE;
		*pt++ = LENPARAM_NO_POSSIBILITE;
		len += 2;
	}

	if (r->transmetid != 0) {
		*pt++ = r->transmetid;
		*pt++ = LENPARAM_NO_ID_APPELANT;
		len += 2;
	}
	*ptsave2 = len;
	*ptsave1 = len + 4;

	return(len);
}

#ifdef REROUTE_TEST
void dumpReroute(reroutage_t *r) {
	char nastemp[NAS_LEN + 1];

	printf("Longueur : %d\n", r->len);

	printf("typereroutage : %x ", r->typereroutage);
	switch(r->typereroutage) {
		case REROUTAGE_NAS_GTX	: printf("(NAS_GTX)\n"); break;
		case REROUTAGE_NAB_GTX	: printf("NAB_GTX)\n"); break;
		case REROUTAGE_ANNUAIRE	: printf("(ANNUAIRE)\n"); break;
		case REROUTAGE_NTR_NAS	: printf("NTR_NAS)\n"); break;
		case REROUTAGE_INDEFINI	: printf("(INDEFINI)\n"); break;
		case REROUTAGE_NONTRANSPARENT	: printf("(NONTRANSPARENT)\n"); break;
		default : printf("(Invalide !!!)\n"); break;
	}

	if (r->cascade)
		printf("cascade autorisee (%x)\n", r->cascade);
	else
		printf("cascade interdite (%x)\n", r->cascade);
	printf("typenum : %x", r->typenum);
	switch(r->typenum) {
		case PARAM_NUM : printf("(PARAM_NUM)\n");
			break;
		case PARAM_NAB : printf("(PARAM_NAB)\n");
			break;
		default : printf("(Invalide !!!)\n"); break;
	}
	printf("typectx : %x\n", r->typectx);
	printf("ctx : '%s'\n", r->ctx);
	if (r->donneesretour[0] != 0)
		printf("donneesretour : '%s'\n", r->donneesretour);
	else
		printf("Pas de donneesretour\n");

	if (r->nasretour[0] != 0) {
		decodeNas(r->nasretour,NAS_LEN, nastemp);
		printf("nasretour : '%s'\n", nastemp);
		} else 
		printf("Pas de nasretour \n");

	decodeNas(r->numero,NAS_LEN, nastemp);
	printf("numero : '%s'\n", nastemp);
	printf("posinterdit : %x\n", r->posinterdit);
	printf("transmetid : %x\n", r->transmetid);
	printf("\n");
}
#endif

int setRetour(reroutage_t *r, unsigned char *donnees) {
	strncpy((char *) r->donneesretour, (char *) donnees, 16);
	return(1);
}

int setNasRetour(reroutage_t *r, unsigned char *numero) {
	if (strlen((char *) numero) != NAS_LEN)
		return(0);
	encodeNas(r->nasretour, numero);
	return(1);
}
int setNumero(reroutage_t *r, int typeCodage,  unsigned char *numero) {

	if (typeCodage != PARAM_NUM && typeCodage != PARAM_NAB)
		return(0);

	if (strlen((char *) numero) != NAS_LEN)
		return(0);

	encodeNas(r->numero, numero);
	r->typenum = typeCodage;

	return(1);
}
int setContexte(reroutage_t *r, int typeCodage,  unsigned char *donnees) {
	if (typeCodage != PARAM_CONTEXTE_ASCII && typeCodage != PARAM_CONTEXTE_DCB)
		return(0);
	r->typectx = typeCodage;
	switch(typeCodage) {
		case PARAM_CONTEXTE_ASCII :
			strncpy((char *) r->ctx, (char *) donnees, CTX_LEN);
			break;
		case PARAM_CONTEXTE_DCB :
			// PARAM_CONTEXTE_DCB not supported 
			return(0);
			break;
	}
	return(1);
}

int setTransmitId(reroutage_t *r, int type) {

	if (type != PARAM_NO_ID_APPELANT && type != PARAM_ID_DEP && type != 0)
		return(0);
	r->transmetid = type;
	return(1);
}
int setType(reroutage_t *r, int type) {

	if (type < TYPEREROUTAGE_MIN || type > TYPEREROUTAGE_MAX)
		return(0);
	r->typereroutage = type;
	return(1);
}

int setNoPossibilite(reroutage_t *r, int type) {
	if (type != 0 && type != PARAM_NO_POSSIBILITE)
		return(0);


	if (type) 
		r->posinterdit = type;
	else
		r->posinterdit = 0;

	return(1);

}
void setCascade(reroutage_t *r, int type) {
	if (type)
		r->cascade = 1;
	else
		r->cascade = 0;

}

void initReroute(reroutage_t *r) {
	r->len = 0;
	r->typereroutage = REROUTAGE_NAS_GTX;
	r->cascade = 1;

	r->typectx = -1 ;
	r->ctx[0] = 0;

	r->donneesretour[0] = 0;
	r->nasretour[0] = 0;

	r->typenum = PARAM_NUM;
	r->numero[0] = 0;

	r->posinterdit = 0;
	r->transmetid = 0;
		
}

#ifdef CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

bool DialogicTrunk::rerouteHandler(TrunkEvent *event)
{
	TrunkEvent jevent;
	struct tm *dt, tbuf;
	struct stat ino;
	const char *cp;
	char buffer[32];
	const char *ext;
	char *fn;
	Audio::Info info;

	switch(event->id)
	{

	case TRUNK_CALL_FACILITY:
		slog(Slog::levelDebug) << "RerouteHandler : TRUNK_CALL_FACILITY " << endl ;
		// Forwarding has failed
		setSymbol(SYM_ERROR, "reroute-failed");
		trunkSignal(TRUNK_SIGNAL_ERROR);
		handler = &DialogicTrunk::stepHandler;
		return true;

	case TRUNK_STOP_STATE:
		slog(Slog::levelDebug) << "RerouteHandler : STOP_STATE " << endl ;
		stopChannel(EV_ASYNC);
		_stopping_state = true;
		trunkSignal(TRUNK_SIGNAL_STEP);
		handler = &DialogicTrunk::stepHandler;
		return true;

	case TRUNK_TIMER_EXPIRED:
		slog(Slog::levelDebug) << "RerouteHandler : TRUNK_TIMER_EXPIRED " << endl ;
		if(!trunkSignal(TRUNK_SIGNAL_ERROR))
			trunkSignal(TRUNK_SIGNAL_STEP);
		setSymbol(SYM_ERROR, "reroute-failed");
		handler = &DialogicTrunk::stepHandler;
		return true;

	case TRUNK_ENTER_STATE:
		slog(Slog::levelDebug) << "RerouteHandler : TRUNK_ENTER_STATE " << endl ;
		enterState("reroute");
		status[id] = 'r';
		return true;

	case TRUNK_STOP_DISCONNECT:
		slog(Slog::levelDebug) << "RerouteHandler : TRUNK_STOP_DISCONNECT " << endl ;
		// Success
		handler = &DialogicTrunk::stepHandler;
		return false;

	default :
		slog(Slog::levelDebug) << "RerouteHandler : default : " << event->id << endl ;
		handler = &DialogicTrunk::stepHandler;
		return false;

	}
	return false;
}

#ifdef CCXX_NAMESPACES
};
#endif
