// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "module.h"

namespace binder {
using namespace ost;
using namespace std;

bool Methods::scrJoin(void)
{
	Event event;

	state.timeout = 0;
	state.join.peer = getSid(var_joined);
	state.join.dtmf = false;
	state.join.hangup = false;
	state.peering = true;

	if(!state.join.peer)
	{
		error("peer-missing");
		return true;
	}
	
	memset(&event, 0, sizeof(event));
	event.id = PEER_WAITING;
	release();
	if(!state.join.peer->postEvent(&event))
	{
		error("peer-invalid");
		return true;
	}
	peer = state.join.peer;
	setState(STATE_JOIN);
	return false;
}

bool Methods::scrReconnect(void)
{
	const char *encoding = getKeyword("encoding");
	timeout_t framing = getTimeoutKeyword("framing");

	if(!framing || framing == TIMEOUT_INF)
		framing = 0;

	if(setReconnect(encoding, framing))
		return false;

	error("reconnect-unsupported");
	return true;
}

bool Methods::scrStart(void)
{
	Line *line = getLine();
	const char *dial = getValue(NULL);
	const char *name = getValue(NULL);
	const char *caller = getKeyword("caller");
	const char *display = getKeyword("display");
	Symbol *sym = getKeysymbol("session", 16);
	BayonneSession *child;
	const char *cp, *id;
	char buf[65];
	TelTone::tonekey_t *key = NULL;
	Audio::Level level = 26000;
	bool connect_flag = false;
	bool dg = false;
	const char *encoding = getKeyword("encoding");
	timeout_t framing = getTimeoutKeyword("framing");

	if(framing == TIMEOUT_INF)
		framing = 0;

	if(encoding)
		if(setReconnect(encoding, framing))
			return false;	

	if(!name)
	{
		dg = true;
		name = dial;
	}

	if(!stricmp(line->cmd, "connect"))
	{

		state.timeout = getTimeoutKeyword("timeout");
		state.tone.duration = getTimeoutKeyword("duration");
		state.tone.dtmf = true;
		state.peering = true;

		if(!caller)
			caller = getSymbol("session.caller");

		if(!display)
			display = getSymbol("session.display");

		if(audio.tone)
		{
			delete audio.tone;
			audio.tone = NULL;
		}
		cp = getKeyword("tone");
		if(!cp)
			cp = "ring";
		if(cp && !stricmp(cp, "ringback"))
			cp = "ring";
		if(cp && stricmp(cp, "none"))
			key = TelTone::find(cp, Bayonne::server->getLast("location"));
		if(key)
			audio.tone = new TelTone(key, level, getToneFraming());
		else if(stricmp(cp, "none"))
			slog.debug("%s: connect; cannot find tone %s", logname, cp);
		connect_flag = true;
	}
	
	if(!dial || !name)
	{
		if(sym)
			ScriptInterp::commit(sym, "none");
		if(!scriptEvent("start:invalid"))
		{
			if(!stricmp(line->cmd, "connect"))
				error("connect-incomplete");
			else
				error("start-incomplete");
		}
		return true;
	}

	if(dg)
		dial = name;

	child = startDialing(dial, name, caller, display, this);

	if(!child)
	{
		if(sym)
			ScriptInterp::commit(sym, "none");
		if(!stricmp(line->cmd, "connect"))
		{
			if(!scriptEvent("dial:failed"))
				error("dial-failed");
		}
		else if(!scriptEvent("start:failed"))
			error("start-failed");
		return true;
	}

	if(sym)
		ScriptInterp::commit(sym, child->getExternal("session.id"));

	if(!stricmp(line->cmd, "connect"))
	{
		state.tone.hangup = true;
		strcpy(state.tone.sessionid, child->getExternal("session.id"));
		strcpy(var_joined, child->getExternal("session.id"));
	}
	else
		state.tone.hangup = false;

	while(NULL != (cp = getOption(NULL)))
	{
		sym = mapSymbol(cp, 0);
		if(!sym)
			continue;

		id = sym->id;
		if(!strchr(id, '.'))
		{
			snprintf(buf, sizeof(buf), "parent.%s", id);
			id = buf;
		}
		child->setConst(id, sym->data);
	}

	if(connect_flag)
		child->startConnecting();

	child->leave();
	if(!stricmp(line->cmd, "connect"))
	{
		setState(STATE_CONNECT);
		return false;
	}
	advance();
	return true;
}

bool Methods::scrStop(void)
{
	Event event;
	BayonneSession *s;
	const char *cp = getValue(NULL);

	if(!cp)
	{
		error("no-timeslot");
		return true;
	}

	s = getSid(cp);
	if(!s)
	{
		error("invalid-timeslot");
		return true;
	}

	memset(&event, 0, sizeof(event));
	event.id = CANCEL_CHILD;
	s->queEvent(&event);
	advance();
	return true;
}
	
bool Methods::scrEndinput(void)
{
	frame[stack].mask &= ~0x08;
	state.menu = NULL;
	advance();
	return false;
}

bool Methods::scrEndform(void)
{
	if(stack < 1 || stack == frame[stack].base)
	{
		error("stack-underflow");
		return true;
	}

	if(!frame[stack].line->argc)
		goto exit;

	if(conditional())
		goto exit;

	frame[stack].line = frame[stack - 1].line;
	frame[stack].tranflag = true;

	if(!state.menu)
		state.menu = getName();

	goto clear;
	
exit:

	frame[stack - 1] = frame[stack];
	--stack;

	if(stack < state.stack)
		state.menu = NULL;
		
	frame[stack].tranflag = false;

clear:
	*dtmf_digits = 0;
	advance();
	return false;
}

bool Methods::scrForm(void)
{
	const char *cp, *value;
	Line *line = getLine();
	unsigned idx = 0;

	if(!push())
	{
		error("stack-overflow");
		return true;
	}

	if(!state.menu)
	{
		state.menu = getName();
		state.stack = stack;
	}

	while(idx < line->argc)
	{
		cp = line->args[idx++];
		if(*cp != '=')
			continue;

                value = getContent(line->args[idx++]);   
		if(!value)
			continue;

		setSymbol(++cp, value);
	}

	frame[stack].tranflag = true;

	*dtmf_digits = 0;

	if(!requiresDTMF())
		return true;

	advance();
	return false;
}

bool Methods::scrDial(void)
{
        unsigned len = 0;
        const char *cp;
        
        state.join.answer_timer = state.timeout = getTimeoutKeyword("timeout");
        
        while(NULL != (cp = getValue(NULL)))
        {
                setString(state.join.digits + len, sizeof(state.join.digits) - len, cp);
                len = strlen(state.join.digits);
        }

        state.join.dial = state.join.digits;
        setState(STATE_DIAL);
        return false;  
}

bool Methods::scrKey(void)
{
        const char *cp;
        const char *val = getKeyword("value");
        const char *ind = getKeyword("index");
        Symbol *sym;

        while(NULL != (cp = getOption(NULL)))
        {
                sym = mapSymbol(cp, PersistProperty::getSize());
                if(!sym)
                        continue;
                PersistProperty::refresh(sym, ind, val);
        }
        advance();       
        return true;  
} 

} // end namespace
