/* translation of file "petrinet-patterns-links.k" */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.10 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_FUNCTIONS_petrinet_patterns_links

#include <stdlib.h>
#include "ast-system-k.h"
#include "petrinet-patterns-links.h"
namespace kc { }
using namespace kc;
/* included stuff */
#line 22 "petrinet-patterns-links.k"
/*!
 * \file    petrinet-patterns-links.cc
 *
 * \brief   Petri net patterns for the link wrappers
 *
 *          This file implements the wrapper patterns necessary to model
 *          incoming and outgoing links of an activity:
 *           - link wrapper 0: no incoming or outgoing links
 *           - link wrapper 1: outgoing links
 *           - link wrapper 2: incoming links, suppressJoinFailure="yes"
 *           - link wrapper 3: incoming links, suppressJoinFailure="no"
 *           - link wrapper 4: incoming and outgoing links,
 *             suppressJoinFailure="yes"
 *           - link wrapper 5: incoming and outgoing links,
 *             suppressJoinFailure="no"
 *
 * \author  Niels Lohmann <nlohmann@informatik.hu-berlin.de>,
 *          last changes of: \$Author: nielslohmann $
 * 
 * \since   2007-03-04
 *
 * \date    \$Date: 2007/03/18 21:23:07 $
 * 
 * \note    This file is part of the tool BPEL2oWFN and was created during the
 *          project "Tools4BPEL" at the Humboldt-Universitt zu Berlin. See
 *          http://www.informatik.hu-berlin.de/top/tools4bpel for details.
 *
 * \note    This file was created using Kimwitu++ reading file
 *          petrinet-patterns-links.k.
 *          See http://site.informatik.hu-berlin.de/kimwitu++ for details.
 *
 * \version \$Revision: 1.22 $
 */

#line  49 "petrinet-patterns-links.cc"
#line 68 "petrinet-patterns-links.k"
#include <cmath>
#include <set>
#include <map>
#include <string>

#include "ast-config.h"
#include "helpers.h"
#include "ast-tools.h"
#include "ast-details.h"
#include "options.h"
#include "globals.h"
#include "petrinet-patterns-shortcuts.h"

using std::cerr;
using std::endl;
using std::set;
using std::string;
using std::map;

extern PetriNet PN;

#line  72 "petrinet-patterns-links.cc"
#line 99 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper0(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 0
 *
 *          Wrapper pattern for an activity that has neither incoming nor
 *          outgoing links.
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  88 "petrinet-patterns-links.cc"
#line 151 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper1(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 1
 *
 *          Wrapper pattern for an activity that has only outgoing links.
 *
 *          \image   html "wrapper1.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  105 "petrinet-patterns-links.cc"
#line 212 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper2(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 2
 *
 *          Wrapper pattern for an activity that has incoming links only, with
 *          attribute "suppressJoinFailure" set to "yes".
 *
 *          \image html "wrapper2.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  123 "petrinet-patterns-links.cc"
#line 291 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper3(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 3
 *
 *          Wrapper pattern for an activity that has incoming links only, with
 *          attribute "suppressJoinFailure" set to "false".
 *
 *          \image html "wrapper3.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    In mode "communication only", wrapper pattern 2 is used instead.
 *
 * \ingroup patterns
 */

#line  143 "petrinet-patterns-links.cc"
#line 382 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper4(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 4
 *
 *          Wrapper pattern for an activity that has incoming and outgoing
 *          links, with attribute suppressJoinFailure" set to "yes".
 *
 *          \image html "wrapper4.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 *
 * \todo    Check this pattern.
 */

#line  163 "petrinet-patterns-links.cc"
#line 468 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper5(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 5
 *
 *          Wrapper pattern for an activity that has incoming and outgoing
 *          links, with attribute suppressJoinFailure" set to "no".
 *
 *          \image html "wrapper5.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    In mode "communication only", wrapper pattern 4 is used instead.
 *
 * \ingroup patterns
 *
 * \todo    Check this pattern.
 */

#line  185 "petrinet-patterns-links.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void P_LinkWrapper0(impl_standardElements *abstract_phylum, uview current_view)
#line 114 "petrinet-patterns-links.k"
{
    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");


    PN.mergePlaces(p1, newPrefix + ".initial");
    PN.mergePlaces(p2, newPrefix + ".final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");

	PN.mergePlaces(p3, newPrefix + ".stop");
	PN.mergePlaces(p4, newPrefix + ".stopped");
    }

#line 140 "petrinet-patterns-links.k"
}
#line  226 "petrinet-patterns-links.cc"

void P_LinkWrapper1(impl_standardElements *abstract_phylum, uview current_view)
#line 167 "petrinet-patterns-links.k"
{
    trace(TRACE_DEBUG, "[PNU]" + inString() + "  wrapper-pattern 1\n");

    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p5 = PN.newPlace(prefix + "done");


    P_transitionCondition(prefix, phylum->tSource_list_1);


    PN.mergePlaces(p1, newPrefix + ".initial");
    PN.mergePlaces(p5, newPrefix + ".final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");

	Transition *t = stop(p2, "final", prefix);

	PN.mergePlaces(p3, newPrefix + ".stop");
	PN.mergePlaces(p4, newPrefix + ".stopped");
    }

#line 201 "petrinet-patterns-links.k"
}
#line  267 "petrinet-patterns-links.cc"

void P_LinkWrapper2(impl_standardElements *abstract_phylum, uview current_view)
#line 229 "petrinet-patterns-links.k"
{
    trace(TRACE_DEBUG, "[PNU]" + inString() + "  wrapper-pattern 2\n");

    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p5 = PN.newPlace(prefix + "jc_true");
    Place *p6 = PN.newPlace(prefix + "jc_false");
    Place *p7 = PN.newPlace(prefix + "begin");


    Transition *t1 = PN.newTransition(prefix + "start");
    PN.newArc(p1, t1);
    PN.newArc(p5, t1);
    PN.newArc(t1, p7);


    Transition *t2 = PN.newTransition(prefix + "skip");
    PN.newArc(p1, t2);
    PN.newArc(p6, t2);
    PN.newArc(t2, p2);


    dpeLinks(t2, phylum->parentId);


    P_joinCondition(prefix, phylum->tTarget_list_1, phylum->joinCondition_1);


    PN.mergePlaces(p7, newPrefix + ".initial");
    PN.mergePlaces(p2, newPrefix + ".final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");

	Transition *t = stop(p1, "initial", prefix);

	PN.mergePlaces(p3, newPrefix + ".stop");
	PN.mergePlaces(p4, newPrefix + ".stopped");
    }

#line 280 "petrinet-patterns-links.k"
}
#line  325 "petrinet-patterns-links.cc"

void P_LinkWrapper3(impl_standardElements *abstract_phylum, uview current_view)
#line 310 "petrinet-patterns-links.k"
{
    trace(TRACE_DEBUG, "[PNU]" + inString() + "  wrapper-pattern 3\n");

    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";



    if (petrinetsmall_enum == current_view)
    {
	cerr << "ignoring attribute suppressJoinFailure=\"no\"" << endl;
	P_LinkWrapper2(abstract_phylum, current_view);
	return;
    }


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p3 = PN.newPlace(prefix + "stop");
    Place *p4 = PN.newPlace(prefix + "stopped");
    Place *p6 = PN.newPlace(prefix + "jc_true");
    Place *p7 = PN.newPlace(prefix + "jc_false");
    Place *p8 = PN.newPlace(prefix + "begin");
    Place *p9 = PN.newPlace(prefix + "faulted");


    Transition *t1 = PN.newTransition(prefix + "start");
    PN.newArc(p1, t1);
    PN.newArc(p6, t1);
    PN.newArc(t1, p8);



    Transition *t2 = throwFault(p7, p9, "joinFailure", prefix,
	mkinteger(phylum->parentId),
	globals::ASTEmap[phylum->parentId]->controlFlow);
    PN.newArc(p1, t2);
    PN.newArc(p7, t2);
    PN.newArc(t2, p9);


    dpeLinks(t2, phylum->parentId);


    Transition *t3 = stop(p1, "initial", prefix);
    Transition *t4 = stop(p9, "faulted", prefix);


    P_joinCondition(prefix, phylum->tTarget_list_1, phylum->joinCondition_1);


    PN.mergePlaces(p8, newPrefix + ".initial");
    PN.mergePlaces(p2, newPrefix + ".final");
    PN.mergePlaces(p3, newPrefix + ".stop");
    PN.mergePlaces(p4, newPrefix + ".stopped");

#line 370 "petrinet-patterns-links.k"
}
#line  392 "petrinet-patterns-links.cc"

void P_LinkWrapper4(impl_standardElements *abstract_phylum, uview current_view)
#line 401 "petrinet-patterns-links.k"
{
    trace(TRACE_DEBUG, "[PNU]" + inString() + "  wrapper-pattern 4\n");

    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p5 = PN.newPlace(prefix + "jc_true");
    Place *p6 = PN.newPlace(prefix + "jc_false");
    Place *p7 = PN.newPlace(prefix + "begin");
    Place *p8 = PN.newPlace(prefix + "done");


    Transition *t1 = PN.newTransition(prefix + "start");
    PN.newArc(p1, t1);
    PN.newArc(p5, t1);
    PN.newArc(t1, p7);


    Transition *t2 = PN.newTransition(prefix + "skip");
    PN.newArc(p1, t2);
    PN.newArc(p6, t2);
    PN.newArc(t2, p2);


    dpeLinks(t2, phylum->parentId);


    P_transitionCondition(prefix, phylum->tSource_list_1);


    P_joinCondition(prefix, phylum->tTarget_list_1, phylum->joinCondition_1);


    PN.mergePlaces(p7, newPrefix + ".initial");
    PN.mergePlaces(p8, newPrefix + ".final"); 


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");

	Transition *t3 = stop(p1, "initial", prefix);
	Transition *t4 = stop(p2, "final", prefix);

	PN.mergePlaces(p3, newPrefix + ".stop");
	PN.mergePlaces(p4, newPrefix + ".stopped");
    }

#line 457 "petrinet-patterns-links.k"
}
#line  455 "petrinet-patterns-links.cc"

void P_LinkWrapper5(impl_standardElements *abstract_phylum, uview current_view)
#line 489 "petrinet-patterns-links.k"
{
    trace(TRACE_DEBUG, "[PNU]" + inString() + "  wrapper-pattern 5\n");

    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";



    if (petrinetsmall_enum == current_view)
    {
	cerr << "ignoring attribute suppressJoinFailure=\"no\"" << endl;
	P_LinkWrapper4(abstract_phylum, current_view);
	return;
    }


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p3 = PN.newPlace(prefix + "stop");
    Place *p4 = PN.newPlace(prefix + "stopped");
    Place *p6 = PN.newPlace(prefix + "jc_true");
    Place *p7 = PN.newPlace(prefix + "jc_false");
    Place *p8 = PN.newPlace(prefix + "begin");
    Place *p9 = PN.newPlace(prefix + "done");
    Place *p10 = PN.newPlace(prefix + "faulted");


    Transition *t1 = PN.newTransition(prefix + "start");
    PN.newArc(p1, t1);
    PN.newArc(p6, t1);
    PN.newArc(t1, p8);



    Transition *t2 = throwFault(p7, p10, "joinFailure", prefix,
	mkinteger(phylum->parentId),
	globals::ASTEmap[phylum->parentId]->controlFlow);
    PN.newArc(p1, t2);
    PN.newArc(p7, t2);
    PN.newArc(t2, p10);


    dpeLinks(t2, phylum->parentId);


    Transition *t3 = stop(p1, "initial", prefix);
    Transition *t4 = stop(p2, "final", prefix);
    Transition *t5 = stop(p10, "faulted", prefix);


    P_transitionCondition(prefix, phylum->tSource_list_1);


    P_joinCondition(prefix, phylum->tTarget_list_1, phylum->joinCondition_1);


    PN.mergePlaces(p8, newPrefix + ".initial");
    PN.mergePlaces(p9, newPrefix + ".final");
    PN.mergePlaces(p3, newPrefix + ".stop");
    PN.mergePlaces(p4, newPrefix + ".stopped");

#line 554 "petrinet-patterns-links.k"
}
#line  527 "petrinet-patterns-links.cc"


} // namespace kc
