/* translation of file(s)
	"petrinet-patterns-basic.k"
	"petrinet-patterns-structured.k"
	"petrinet-patterns-scopes.k"
	"petrinet-patterns-handlers.k"
	"petrinet-patterns-links.k"
	"petrinet-patterns-shortcuts.k"
	"ast-grammar.k"
	"ast-config.k"
	"ast-to-petrinet.k"
	"ast-to-xml.k"
	"ast-to-cfg.k"
	"ast-postprocess.k"
	"ast-rewrite.k"
	"ast-to-visualization.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.11 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_UNPARSE

#include <stdio.h>
#include <string>
#include <stdlib.h>
#include "ast-system-k.h"
#include "ast-system-unpk.h"


namespace kc {
base_uview_class base_uview;
petrinetsmall_class petrinetsmall;
petrinetnew_class petrinetnew;
xml_class xml;
cfg_class cfg;
postprocessing_class postprocessing;
evaluation_class evaluation;
visualization_class visualization;

impl_uviews uviews[] = {
    {"base_uview",&base_uview},
    {"petrinetsmall",&petrinetsmall},
    {"petrinetnew",&petrinetnew},
    {"xml",&xml},
    {"cfg",&cfg},
    {"postprocessing",&postprocessing},
    {"evaluation",&evaluation},
    {"visualization",&visualization},
    {0,0}
};

} // namespace kc
namespace kc { }
using namespace kc;
/* included stuff */
#line 98 "ast-config.k"
#include <iostream>
#include <cmath>
#include <cassert>
#include <map>
#include <set>
#include <climits>
#include <string>

#include "petrinet-patterns-basic.h"
#include "petrinet-patterns-structured.h"
#include "petrinet-patterns-scopes.h"
#include "petrinet-patterns-handlers.h"
#include "petrinet-patterns-links.h"
#include "extension-wsdl.h"			// for class WSDL
#include "options.h"
#include "cfg.h"
#include "helpers.h"
#include "ast-details.h"
#include "ast-tools.h"
#include "globals.h"
#include "extension-chor.h"

using std::endl;
using std::cerr;

extern PetriNet PN;				// introduced in main.c
extern CFGBlock * CFG;				// introduced in cfg.cc

#line  85 "ast-system-unpk.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void
impl_abstract_phylum::unparse(printer_function opf, uview uv)
{
    printer_functor_function_wrapper pf(opf);
    do_unparse(pf, uv);
}

// Everything given as a pointer is expected to have an unparse-method (we
// believe it's a phylum), unless there's a specialisation for it

void
unparse(abstract_phylum kc_p, printer_functor kc_printer, uview kc_current_view)
{
    kc_p->unparse(kc_printer, kc_current_view);
}

void
unparse(void *kc_p, printer_functor kc_printer, uview kc_current_view)
{
    // MPi: 20020628 there shouldn't be any left
    assertionFailed("Unparse called for untyped pointer");
    // MPi: cast should be unnecessary, but there are still void*
    reinterpret_cast<impl_abstract_phylum*>(kc_p)->unparse(kc_printer, kc_current_view);
}

void
unparse(int kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_char_t kc_string[200];
    kc_print_integer(kc_string, kc_v);
    kc_printer(kc_string, kc_current_view);
}

void
unparse(double kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_char_t kc_string[200];
    kc_print_real(kc_string, kc_v);
    kc_printer(kc_string, kc_current_view);
}

void
unparse(kc_char_t *kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_printer(kc_v, kc_current_view);
}

void
unparse(kc_string_t kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_printer(kc_v.c_str(), kc_current_view);
}

#line  148 "ast-system-unpk.cc"
void
impl_abstract_phylum::default_unparse(printer_functor kc_printer, uview kc_current_view)
{
    register int no_sons = operator_info[prod_sel()].no_sons;
    for (int i=0; i < no_sons; i++)
    subphylum(i)->unparse(kc_printer, kc_current_view);
}

void
impl_casestring__Str::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(name, kc_printer, kc_current_view);
}

void
impl_nocasestring_NoCaseStr::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(name, kc_printer, kc_current_view);
}

void
impl_integer__Int::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(value, kc_printer, kc_current_view);
}

void
impl_real__Real::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(value, kc_printer, kc_current_view);
}

void
impl_voidptr__VoidPtr::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(pointer, kc_printer, kc_current_view);
}


#line  188 "ast-system-unpk.cc"
void
impl_tProcess_Process::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 60 "ast-to-visualization.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 60 "ast-to-visualization.k"
		const tPartner_list b = this->tPartner_list_1;
#line 60 "ast-to-visualization.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 60 "ast-to-visualization.k"
		const tVariable_list c = this->tVariable_list_1;
#line 60 "ast-to-visualization.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 60 "ast-to-visualization.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 60 "ast-to-visualization.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 60 "ast-to-visualization.k"
		const activity i = this->activity_1;
#line 60 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 63 "ast-to-visualization.k"

		globals::visArcs = "";
		(*output) << "digraph N {" << endl;
		(*output) << " graph [fontname=\"Helvetica\" label=\"";
		(*output) << "Visualization of the BPEL-Process generated from " << globals::filename << "\"]" << endl;
		(*output) << "compound = true;" << endl;
		globals::ASTEmap[_id->value]->visConnection = "Process_Start";

#line  223 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 72 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Process activity\";" << endl;  

#line  234 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 76 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[i->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[i->id]->secVisConnection;
		(*output) << "}" << endl;    

		unsigned int linkId;
		unsigned int source;
		unsigned int target;
		for(set<string>::iterator names = globals::ASTE_linkNames.begin(); names != globals::ASTE_linkNames.end(); names++)
		{
		    linkId = globals::ASTE_linkIdMap[(*names)];

		    source = globals::ASTEmap[linkId]->sourceActivity;
		    target = globals::ASTEmap[linkId]->targetActivity;

		    globals::visArcs += globals::ASTEmap[source]->visConnection + " -> " + globals::ASTEmap[target]->secVisConnection + "["; 
		    if (globals::ASTEmap[target]->structured())
		    {
			globals::visArcs += "lhead=";
			globals::visArcs += "cluster";          
			globals::visArcs += toString(target);          
			globals::visArcs += " ";          
		    } 
		    if (globals::ASTEmap[source]->structured())
		    {
			globals::visArcs += "ltail=";
			globals::visArcs += "cluster";          
			globals::visArcs += toString(source);          
		    }
		    globals::visArcs += "];\n";
		}
		(*output) << globals::visArcs;
		(*output) << "}" << endl;

#line  271 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 59 "ast-postprocess.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 59 "ast-postprocess.k"
		const tPartner_list b = this->tPartner_list_1;
#line 59 "ast-postprocess.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 59 "ast-postprocess.k"
		const tVariable_list c = this->tVariable_list_1;
#line 59 "ast-postprocess.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 59 "ast-postprocess.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 59 "ast-postprocess.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 59 "ast-postprocess.k"
		const activity i = this->activity_1;
#line 59 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 61 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = myid;
		myself->parentActivityId = myid;
		globals::PPcurrentScope = myid;


		myself->checkAttributes();
		myself->hasEH = (string(g->op_name()) == "EventHandlers");


		assert(globals::ASTEmap[e->id] != NULL);
		assert(globals::ASTEmap[g->id] != NULL);
		assert(globals::ASTEmap[i->id] != NULL);
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[g->id]->parentActivityId = myid;
		globals::ASTEmap[i->id]->parentActivityId = myid;

		myself->enclosedFH = e->id;

#line  323 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(messageExchange, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 90 "ast-postprocess.k"


		bool callableFH = false;
		for ( set< string >::iterator fault = globals::ASTEmap[ e->id ]->catches.begin(); fault != globals::ASTEmap[ e->id ]->catches.end(); fault++)
		{
		    string faultName = fault->substr( fault->find_first_of( "|" ) + 1 );
		    faultName = faultName.substr( 0, faultName.find_first_of( "|" ) );
		    if (faultName.find_first_of(":") < faultName.npos)
		    {
			faultName = faultName.substr( faultName.find_first_of(":") + 1 );
		    }
		    if ( myself->possiblyTriggeredFaults.find( faultName ) != myself->possiblyTriggeredFaults.end() )
		    {

			callableFH = true;
		    }
		}
		if ( globals::ASTEmap[ e->id ]->hasCatchAll && ! myself->possiblyTriggeredFaults.empty() )
		{
		    callableFH = true;
		}

		globals::ASTEmap[ e->id ]->callable = callableFH;


		assert(globals::ASTEmap[i->id] != NULL);
		myself->enclosedSourceLinks = globals::ASTEmap[i->id]->enclosedSourceLinks;
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks );
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[g->id]->enclosedSourceLinks );

		myself->enclosedTargetLinks = globals::ASTEmap[i->id]->enclosedTargetLinks;
		myself->enclosedTargetLinks = setUnion( myself->enclosedTargetLinks, globals::ASTEmap[e->id]->enclosedTargetLinks );
		myself->enclosedTargetLinks = setUnion( myself->enclosedTargetLinks, globals::ASTEmap[g->id]->enclosedTargetLinks );

		set< unsigned int > innerIds = globals::ASTEmap[ i->id ]->enclosedActivities;
		innerIds.insert( i->id );
		set< unsigned int > faultIds = globals::ASTEmap[ e->id ]->enclosedActivities;
		faultIds.insert( e->id );






		if (globals::ASTE_startActivities.empty())
		{
		    SAerror(15, "", myself->attributes["referenceLine"]);
		}
		else
		{
		    for ( set< unsigned int >::iterator it = globals::ASTE_startActivities.begin(); it != globals::ASTE_startActivities.end(); it++ )
		    {
			for ( int i = 2; i < globals::ASTEid; i++ )
			{
			    if (globals::ASTEmap[i] != NULL)
			    {
				activityRelationType type = activityRelation( i, *it );
				if ( (type == AR_BEFORE || type == AR_CONCURRENT) &&
				    (
					globals::ASTEmap[i]->activityTypeName() == "pick" ||
					globals::ASTEmap[i]->activityTypeName() == "reply" ||
					globals::ASTEmap[i]->activityTypeName() == "invoke" ||      
					globals::ASTEmap[i]->activityTypeName() == "empty" ||     
					globals::ASTEmap[i]->activityTypeName() == "receive" ||      
					globals::ASTEmap[i]->activityTypeName() == "wait" ||      
					globals::ASTEmap[i]->activityTypeName() == "assign" ||      
					globals::ASTEmap[i]->activityTypeName() == "throw" ||      
					globals::ASTEmap[i]->activityTypeName() == "exit" ||      
					globals::ASTEmap[i]->activityTypeName() == "rethrow" ||      
					globals::ASTEmap[i]->activityTypeName() == "if" ||      
					globals::ASTEmap[i]->activityTypeName() == "while" ||      
					globals::ASTEmap[i]->activityTypeName() == "foreach" ||      
					globals::ASTEmap[i]->activityTypeName() == "repeatUntil"
				    ) &&      
				    globals::ASTEmap[i]->isStartActivity == false )
				{
				    SAerror( 56, globals::ASTEmap[i]->activityTypeName(), globals::ASTEmap[i]->attributes["referenceLine"] );
				}
			    }
			}
		    }
		}




		bool linksOK = true;
		for(map<string, unsigned int>::iterator it = globals::ASTE_linkIdMap.begin(); it != globals::ASTE_linkIdMap.end(); it++)
		{
		    if ( it-> first != "" )
		    {
			assert(globals::ASTEmap[it->second] != NULL);

			if ((globals::ASTEmap[it->second]->targetActivity == 0) || (globals::ASTEmap[it->second]->sourceActivity == 0))
			{
			    SAerror(66, it->first, globals::ASTEmap[it->second]->attributes["referenceLine"]);
			    linksOK = false;
			}


			if (linksOK)
			{
			    assert(globals::ASTEmap[globals::ASTEmap[it->second]->sourceActivity] != NULL);
			    assert(globals::ASTEmap[globals::ASTEmap[it->second]->targetActivity] != NULL);
			    set<unsigned int> otherSources = globals::ASTEmap[globals::ASTEmap[it->second]->sourceActivity]->sourceLinks;
			    set<unsigned int> otherTargets = globals::ASTEmap[globals::ASTEmap[it->second]->targetActivity]->targetLinks;
			    set<unsigned int> jointLinks = setIntersection(otherSources, otherTargets);
			    jointLinks.erase(it->second);

			    if (jointLinks.size() > 0)
			    SAerror(67, "`" + it->first + "' and <link> `" + globals::ASTEmap[*(jointLinks.begin())]->attributes["name"] + "'", globals::ASTEmap[it->second]->attributes["referenceLine"]);
			}
		    }
		}



		set<string> reallySharedCorrelationSets;
		if (globals::ASTE_startActivities.size() > 1)
		{
		    for (set<unsigned int>::iterator it = globals::ASTE_startActivities.begin(); it != globals::ASTE_startActivities.end(); it++)
		    {
			if (it == globals::ASTE_startActivities.begin())
			reallySharedCorrelationSets = globals::ASTEmap[*it]->sharedCorrelationSets;
			else
			reallySharedCorrelationSets = setIntersection(reallySharedCorrelationSets, globals::ASTEmap[*it]->sharedCorrelationSets);

			if (reallySharedCorrelationSets.empty())
			{
			    SAerror(57, "", globals::ASTEmap[*it]->attributes["referenceLine"]);
			    break;
			}
		    }
		}




		if (linksOK)
		{
		    assert(myself->enclosedSourceLinks.size() == globals::ASTE_linkNames.size());
		    assert(myself->enclosedTargetLinks.size() == globals::ASTE_linkNames.size());
		}



		globals::ASTE_correlationSetNames.clear(); 
		globals::ASTE_partnerLinkNames.clear();    
		globals::ASTE_startActivities.clear();	

#line  483 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 62 "ast-to-cfg.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 62 "ast-to-cfg.k"
		const tPartner_list b = this->tPartner_list_1;
#line 62 "ast-to-cfg.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 62 "ast-to-cfg.k"
		const tVariable_list c = this->tVariable_list_1;
#line 62 "ast-to-cfg.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 62 "ast-to-cfg.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 62 "ast-to-cfg.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 62 "ast-to-cfg.k"
		const activity i = this->activity_1;
#line 62 "ast-to-cfg.k"
		const integer j = this->integer_1;
#line 63 "ast-to-cfg.k"


		globals::cfgMap = map<std::string, CFGBlock *>();
		sources = map<std::string, CFGBlock *>();
		targets = map<std::string, CFGBlock *>();


		trace(TRACE_DEBUG, "[CFG] Process\n");
		CFGBlock* firstBlock = new CFGBlock(CFGProcess, this->id, "Process_begin"); 
		CFGBlock* lastBlock  = new CFGBlock(CFGProcess, this->id, "Process_end");


		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		CFG = firstBlock;
		globals::cfgMap[toString(this->id)] = CFG; 

#line  527 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 82 "ast-to-cfg.k"


		CFGBlock *fhFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock *fhLast  = globals::cfgMap.find(toString(e->id))->second->lastBlock;


		connectBlocks(firstBlock, fhFirst);
		connectBlocks(fhLast, lastBlock);

#line  539 "ast-system-unpk.cc"
		kc::unparse(g, kc_printer, kc_current_view);
#line 102 "ast-to-cfg.k"

		CFGBlock * ehFirst = globals::cfgMap.find(toString(g->id))->second->firstBlock;
		CFGBlock * ehLast  = globals::cfgMap.find(toString(g->id))->second->lastBlock;

		connectBlocks(firstBlock, ehFirst);
		connectBlocks(ehLast, lastBlock);


#line  550 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 111 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(i->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(i->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  560 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 62 "ast-to-xml.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 62 "ast-to-xml.k"
		const tPartner_list b = this->tPartner_list_1;
#line 62 "ast-to-xml.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 62 "ast-to-xml.k"
		const tVariable_list c = this->tVariable_list_1;
#line 62 "ast-to-xml.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 62 "ast-to-xml.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 62 "ast-to-xml.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 62 "ast-to-xml.k"
		const activity i = this->activity_1;
#line 62 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 63 "ast-to-xml.k"
		inup(); 
#line  587 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<process id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 63 "ast-to-xml.k"
		listAttributes( _id ); 
#line  593 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 65 "ast-to-xml.k"
		if (a->length() == 0) 
#line  597 "ast-system-unpk.cc"
		{
		}
#line 67 "ast-to-xml.k"
		else 
#line  602 "ast-system-unpk.cc"
		{
#line 68 "ast-to-xml.k"
		    inup(); 
#line  606 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<partnerLinks>\n"), kc_current_view); }
		    kc::unparse(a, kc_printer, kc_current_view);
#line 68 "ast-to-xml.k"
		    indown(); 
#line  611 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</partnerLinks>\n"), kc_current_view); }
		}
#line 70 "ast-to-xml.k"
		if (b->length() == 0) 
#line  616 "ast-system-unpk.cc"
		{
		}
#line 72 "ast-to-xml.k"
		else 
#line  621 "ast-system-unpk.cc"
		{
#line 73 "ast-to-xml.k"
		    inup(); 
#line  625 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<partners>\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 73 "ast-to-xml.k"
		    indown(); 
#line  630 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</partners>\n"), kc_current_view); }
		}
#line 75 "ast-to-xml.k"
		if (c->length() == 0) 
#line  635 "ast-system-unpk.cc"
		{
		}
#line 77 "ast-to-xml.k"
		else 
#line  640 "ast-system-unpk.cc"
		{
#line 78 "ast-to-xml.k"
		    inup(); 
#line  644 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<variables>\n"), kc_current_view); }
		    kc::unparse(c, kc_printer, kc_current_view);
#line 78 "ast-to-xml.k"
		    indown(); 
#line  649 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</variables>\n"), kc_current_view); }
		}
#line 80 "ast-to-xml.k"
		if (d->length() == 0) 
#line  654 "ast-system-unpk.cc"
		{
		}
#line 82 "ast-to-xml.k"
		else 
#line  659 "ast-system-unpk.cc"
		{
#line 83 "ast-to-xml.k"
		    inup(); 
#line  663 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<correlationSets>\n"), kc_current_view); }
		    kc::unparse(d, kc_printer, kc_current_view);
#line 83 "ast-to-xml.k"
		    indown(); 
#line  668 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</correlationSets>\n"), kc_current_view); }
		}
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
#line 85 "ast-to-xml.k"
		indown(); 
#line  676 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</process>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 169 "ast-to-petrinet.k"
		PProcess(this, kc_current_view_base);


		globals::ASTE_scopeNames.clear(); 
#line  689 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 169 "ast-to-petrinet.k"
		PProcess(this, kc_current_view_base);


		globals::ASTE_scopeNames.clear(); 
#line  701 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  706 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  719 "ast-system-unpk.cc"
void
impl_activity_activityScope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  725 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  738 "ast-system-unpk.cc"
void
impl_activity_activityFlow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  744 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  757 "ast-system-unpk.cc"
void
impl_activity_activityPick::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  763 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  776 "ast-system-unpk.cc"
void
impl_activity_activityForEach::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  782 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  795 "ast-system-unpk.cc"
void
impl_activity_activityRepeatUntil::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  801 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  814 "ast-system-unpk.cc"
void
impl_activity_activityWhile::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  820 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  833 "ast-system-unpk.cc"
void
impl_activity_activityIf::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  839 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  852 "ast-system-unpk.cc"
void
impl_activity_activitySequence::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  858 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  871 "ast-system-unpk.cc"
void
impl_activity_activityCompensate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  877 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  890 "ast-system-unpk.cc"
void
impl_activity_activityRethrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  896 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  909 "ast-system-unpk.cc"
void
impl_activity_activityThrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  915 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  928 "ast-system-unpk.cc"
void
impl_activity_activityExit::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  934 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  947 "ast-system-unpk.cc"
void
impl_activity_activityWait::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  953 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  966 "ast-system-unpk.cc"
void
impl_activity_activityOpaqueActivity::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  972 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  985 "ast-system-unpk.cc"
void
impl_activity_activityEmpty::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  991 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1004 "ast-system-unpk.cc"
void
impl_activity_activityValidate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1010 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1023 "ast-system-unpk.cc"
void
impl_activity_activityAssign::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1029 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1042 "ast-system-unpk.cc"
void
impl_activity_activityInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1048 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1061 "ast-system-unpk.cc"
void
impl_activity_activityReply::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1067 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1080 "ast-system-unpk.cc"
void
impl_activity_activityReceive::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1086 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_activity_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1106 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (activity_list iterator_ = this; iterator_->activity_list_1 != 0; iterator_ = iterator_->activity_list_1)
		    iterator_->activity_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_activity_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1124 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tPartnerLink_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1143 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tPartnerLink_list iterator_ = this; iterator_->tPartnerLink_list_1 != 0; iterator_ = iterator_->tPartnerLink_list_1)
		    iterator_->tPartnerLink_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tPartnerLink_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1161 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1173 "ast-system-unpk.cc"
void
impl_tPartnerLink_PartnerLink::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 117 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 248 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 250 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();


		if(globals::WSDLInfo.partnerLinkTypes[myself->attributes["partnerLinkType"]] != NULL)
		globals::WSDLInfo.partnerLinkTypes[myself->attributes["partnerLinkType"]]->correctOrder(myself);

		myself->definePartnerLink();



#line  1209 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 93 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 94 "ast-to-xml.k"
		in(); 
#line  1220 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<partnerLink id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 94 "ast-to-xml.k"
		listAttributes( _id ); 
#line  1226 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  1232 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tPartner_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1252 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tPartner_list iterator_ = this; iterator_->tPartner_list_1 != 0; iterator_ = iterator_->tPartner_list_1)
		    iterator_->tPartner_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tPartner_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1270 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1282 "ast-system-unpk.cc"
void
impl_tPartner_Partner::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 126 "ast-to-visualization.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 126 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 275 "ast-postprocess.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 275 "ast-postprocess.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 102 "ast-to-xml.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 102 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 103 "ast-to-xml.k"
		inup(); 
#line  1317 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<partner id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 103 "ast-to-xml.k"
		indown(); 
#line  1324 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</partner>\n"), kc_current_view); }
	    }
	    break;
	}

#line  1330 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1343 "ast-system-unpk.cc"
void
impl_tFaultHandlers_FaultHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 135 "ast-to-visualization.k"
		const tCatch_list a = this->tCatch_list_1;
#line 135 "ast-to-visualization.k"
		const tCatchAll b = this->tCatchAll_1;
#line 135 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 137 "ast-to-visualization.k"
		if (! (globals::ASTEmap[_id->value]->isUserDefined) && globals::hideStandardHandlers) 
#line  1359 "ast-system-unpk.cc"
		{
		}
#line 139 "ast-to-visualization.k"
		else 
#line  1364 "ast-system-unpk.cc"
		{
#line 141 "ast-to-visualization.k"

		    (*output) << "subgraph cluster" << toString(_id->value) << " { label = \"FaultHandlers\";" << endl;  
		    if ( !globals::ASTEmap[_id->value]->callable )
		    {
			(*output) << "\tcolor = grey70;" << endl;
			(*output) << "\tfillcolor = grey80;" << endl;
			(*output) << "\tfontcolor = grey60;" << endl;
		    }

#line  1376 "ast-system-unpk.cc"
		    kc::unparse(a, kc_printer, kc_current_view);
		    kc::unparse(b, kc_printer, kc_current_view);
#line 151 "ast-to-visualization.k"

		    (*output) << "}" << endl;    

#line  1383 "ast-system-unpk.cc"
		}
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 284 "ast-postprocess.k"
		const tCatch_list a = this->tCatch_list_1;
#line 284 "ast-postprocess.k"
		const tCatchAll b = this->tCatchAll_1;
#line 284 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 286 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;
		myself->hasCatchAll = (string(b->op_name()) == "CatchAll");





		{
#line 301 "ast-postprocess.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1417 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 301 "ast-postprocess.k"
			    {
#line 302 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 302 "ast-postprocess.k"
#line 301 "ast-postprocess.k"
				    const tCatch branch = kc_selvar_0_1;
#line 301 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 302 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid; 
				    globals::ASTEmap[branch->id]->parentActivityId = myid;
				    globals::ASTEmap[branch->id]->parentScopeId = myself->parentScopeId;
				    globals::ASTEmap[innerActivity->id]->controlFlow = FHCF;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  1441 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1446 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 301 "ast-postprocess.k"

#line  1451 "ast-system-unpk.cc"
		    }
		}
#line 310 "ast-postprocess.k"



		{
#line 313 "ast-postprocess.k"
		    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(b);
#line 316 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 316 "ast-postprocess.k"
#line 315 "ast-postprocess.k"
			const activity c = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 315 "ast-postprocess.k"
			const integer _id = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->integer_1;
#line 316 "ast-postprocess.k"

			assert(globals::ASTEmap[c->id] != NULL);

			globals::ASTEmap[b->id]->parentActivityId = myid;
			globals::ASTEmap[c->id]->controlFlow = FHCF;
			globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;

#line  1476 "ast-system-unpk.cc"
		    } else
		    {
#line 324 "ast-postprocess.k"
#line 324 "ast-postprocess.k"


			if (a->length() == 0)
			SAerror(80, "", toInt(globals::ASTEmap[myself->parentScopeId]->attributes["referenceLine"]));

#line  1486 "ast-system-unpk.cc"
		    }
		}
#line 330 "ast-postprocess.k"

#line  1491 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 332 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		{
#line 337 "ast-postprocess.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1504 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 337 "ast-postprocess.k"
			    {
#line 338 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 338 "ast-postprocess.k"
#line 337 "ast-postprocess.k"
				    const tCatch branch = kc_selvar_0_1;
#line 337 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 337 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->integer_1;
#line 338 "ast-postprocess.k"

				    {
#line 339 "ast-postprocess.k"
					tCatch_list kc_fe_selvar_1 =  a;

#line  1527 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
					    ) {
					    tCatch kc_selvar_1_1 = kc_fe_selvar_1->tCatch_1;
					    {
#line 339 "ast-postprocess.k"
						{
#line 340 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_Catch)) {
#line 340 "ast-postprocess.k"
#line 339 "ast-postprocess.k"
							const tCatch otherbranch = kc_selvar_1_1;
#line 339 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->activity_1;
#line 339 "ast-postprocess.k"
							const integer _id3 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->integer_1;
#line 340 "ast-postprocess.k"

							assert(_id2 != NULL);
							assert(_id3 != NULL);
							if ( _id2->value < _id3->value )
							{
							    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );
							}

#line  1553 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  1558 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 339 "ast-postprocess.k"

#line  1563 "ast-system-unpk.cc"
					}
				    }
#line 348 "ast-postprocess.k"

#line  1568 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1573 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 337 "ast-postprocess.k"

#line  1578 "ast-system-unpk.cc"
		    }
		}
#line 349 "ast-postprocess.k"

		{
#line 350 "ast-postprocess.k"
		    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(b);
#line 353 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 353 "ast-postprocess.k"
#line 352 "ast-postprocess.k"
			const activity c = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 352 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->integer_1;
#line 353 "ast-postprocess.k"

			{
#line 354 "ast-postprocess.k"
			    tCatch_list kc_fe_selvar_1 =  a;

#line  1599 "ast-system-unpk.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
				) {
				tCatch kc_selvar_1_1 = kc_fe_selvar_1->tCatch_1;
				{
#line 354 "ast-postprocess.k"
				    {
#line 355 "ast-postprocess.k"
					if ((kc_selvar_1_1->prod_sel() == sel_Catch)) {
#line 355 "ast-postprocess.k"
#line 354 "ast-postprocess.k"
					    const tCatch otherbranch = kc_selvar_1_1;
#line 354 "ast-postprocess.k"
					    const activity secondActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->activity_1;
#line 354 "ast-postprocess.k"
					    const integer _id3 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->integer_1;
#line 355 "ast-postprocess.k"

					    assert(_id2 != NULL);
					    assert(_id3 != NULL);
					    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );

#line  1622 "ast-system-unpk.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1627 "ast-system-unpk.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 354 "ast-postprocess.k"

#line  1632 "ast-system-unpk.cc"
			    }
			}
#line 360 "ast-postprocess.k"

#line  1637 "ast-system-unpk.cc"
		    } else
		    {
#line 362 "ast-postprocess.k"
#line 362 "ast-postprocess.k"


#line  1644 "ast-system-unpk.cc"
		    }
		}
#line 365 "ast-postprocess.k"


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  1653 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    if ((this->tCatchAll_1->prod_sel() == sel_CatchAll)) {
#line 135 "ast-to-cfg.k"
		const tFaultHandlers This = this/**/;
#line 135 "ast-to-cfg.k"
		const tCatch_list a = this->tCatch_list_1;
#line 135 "ast-to-cfg.k"
		const tCatchAll catchAll = this->tCatchAll_1;
#line 135 "ast-to-cfg.k"
		const activity b = phylum_cast<const impl_tCatchAll_CatchAll*>(this->tCatchAll_1)->activity_1;
#line 135 "ast-to-cfg.k"
		const integer c = phylum_cast<const impl_tCatchAll_CatchAll*>(this->tCatchAll_1)->integer_1;
#line 135 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 136 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] FaultHandler (user defined)\n");
		CFGBlock* firstBlock = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_begin"); 
		CFGBlock* lastBlock  = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  1682 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 146 "ast-to-cfg.k"

		{
#line 147 "ast-to-cfg.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1690 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 147 "ast-to-cfg.k"
			    {
#line 148 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 148 "ast-to-cfg.k"
#line 147 "ast-to-cfg.k"
				    const activity catchBlock = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 148 "ast-to-cfg.k"

				    CFGBlock * catchIt = new CFGBlock(CFGCatch, kc_selvar_0_1->id, "Catch");
				    CFGBlock * innerFirst = globals::cfgMap.find(toString(catchBlock->id))->second->firstBlock;
				    CFGBlock * innerLast  = globals::cfgMap.find(toString(catchBlock->id))->second->lastBlock;

				    connectBlocks(firstBlock, catchIt);
				    connectBlocks(catchIt, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  1713 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1718 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 147 "ast-to-cfg.k"

#line  1723 "ast-system-unpk.cc"
		    }
		}
#line 157 "ast-to-cfg.k"

#line  1728 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 159 "ast-to-cfg.k"

		CFGBlock * catchAllBlock = new CFGBlock(CFGCatchAll, catchAll->id, "CatchAll");
		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(firstBlock, catchAllBlock);
		connectBlocks(catchAllBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  1740 "ast-system-unpk.cc"
	    } else
		if ((this->tCatchAll_1->prod_sel() == sel_NoCatchAll)) {
#line 170 "ast-to-cfg.k"
		const tFaultHandlers This = this/**/;
#line 170 "ast-to-cfg.k"
		const tCatch_list a = this->tCatch_list_1;
#line 170 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 171 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] FaultHandler (user defined, no catchAll)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  1759 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 181 "ast-to-cfg.k"

		{
#line 182 "ast-to-cfg.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1767 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 182 "ast-to-cfg.k"
			    {
#line 183 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 183 "ast-to-cfg.k"
#line 182 "ast-to-cfg.k"
				    const activity catchBlock = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 183 "ast-to-cfg.k"

				    CFGBlock * catchIt = new CFGBlock(CFGCatch, kc_selvar_0_1->id, "Catch");
				    CFGBlock * innerFirst = globals::cfgMap.find(toString(catchBlock->id))->second->firstBlock;
				    CFGBlock * innerLast  = globals::cfgMap.find(toString(catchBlock->id))->second->lastBlock;

				    connectBlocks(firstBlock, catchIt);
				    connectBlocks(catchIt, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  1790 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1795 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 182 "ast-to-cfg.k"

#line  1800 "ast-system-unpk.cc"
		    }
		}
#line 192 "ast-to-cfg.k"

#line  1805 "ast-system-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 111 "ast-to-xml.k"
		const tCatch_list a = this->tCatch_list_1;
#line 111 "ast-to-xml.k"
		const tCatchAll b = this->tCatchAll_1;
#line 111 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 112 "ast-to-xml.k"
		inup(); 
#line  1821 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<faultHandlers id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" callable=\""), kc_current_view); }
#line 112 "ast-to-xml.k"
		*output << globals::ASTEmap[ _id->value ]->callable; 
#line  1827 "ast-system-unpk.cc"
			{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 112 "ast-to-xml.k"
		indown(); 
#line  1833 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</faultHandlers>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 190 "ast-to-petrinet.k"
		PFaultHandlers(this, kc_current_view_base); 
#line  1843 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  1848 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1862 "ast-system-unpk.cc"
void
impl_tFaultHandlers_volatile_standardFaultHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1868 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCatch_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1888 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCatch_list iterator_ = this; iterator_->tCatch_list_1 != 0; iterator_ = iterator_->tCatch_list_1)
		    iterator_->tCatch_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCatch_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1906 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1918 "ast-system-unpk.cc"
void
impl_tCatch_Catch::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 158 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 158 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 160 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Catch\";" << endl;  

#line  1934 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 164 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  1940 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 373 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 373 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 375 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();


		if (globals::ASTEmap[globals::PPcurrentScope]->attributes["exitOnStandardFault"] == "yes")
		{
		    if ( myself->attributes["faultName"] == "ambiguousReceive" ||
			myself->attributes["faultName"] == "completionConditionFailure" ||
			myself->attributes["faultName"] == "conflictingReceive" ||
			myself->attributes["faultName"] == "conflictingRequest" ||
			myself->attributes["faultName"] == "correlationViolation" ||
			myself->attributes["faultName"] == "invalidBranchCondition" ||
			myself->attributes["faultName"] == "invalidExpressionValue" ||
			myself->attributes["faultName"] == "invalidVariables" ||
			myself->attributes["faultName"] == "joinFailurea" ||
			myself->attributes["faultName"] == "mismatchedAssignmentFailurei" ||
			myself->attributes["faultName"] == "missingReply" ||
			myself->attributes["faultName"] == "missingRequest" ||
			myself->attributes["faultName"] == "scopeInitializationFailure" ||
			myself->attributes["faultName"] == "selectionFailure" ||
			myself->attributes["faultName"] == "subLanguageExecutionFaultx" ||
			myself->attributes["faultName"] == "uninitializedPartnerRole" ||
			myself->attributes["faultName"] == "uninitializedVariablez" ||
			myself->attributes["faultName"] == "unsupportedReference" ||
			myself->attributes["faultName"] == "xsltInvalidSourcel" ||
			myself->attributes["faultName"] == "xsltStylesheetNotFound" )

		    SAerror( 3, myself->attributes["faultName"], myself->attributes["referenceLine"]);
		}


		if (myself->attributes["faultVariable"] != "")
		{
		    globals::ASTE_variableNames.insert(toString(globals::PPcurrentScope) + "." + myself->attributes["faultVariable"]);
		    if (myself->attributes["faultMessageType"] != "")
		    globals::ASTE_variableMap[(toString(globals::PPcurrentScope) + "." + myself->attributes["faultVariable"])] = myself->attributes["faultMessageType"];
		}

#line  1995 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 419 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		globals::ASTEmap[a->id]->parentActivityId = myid; 


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00071( myid );

#line  2015 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 115 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 115 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 116 "ast-to-xml.k"
		inup(); 
#line  2028 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<catch id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 116 "ast-to-xml.k"
		listAttributes( _id ); 
#line  2034 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 116 "ast-to-xml.k"
		indown(); 
#line  2039 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</catch>\n"), kc_current_view); }
	    }
	    break;
	}

#line  2045 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2058 "ast-system-unpk.cc"
void
impl_tCatchAll_NoCatchAll::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2064 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  2076 "ast-system-unpk.cc"
void
impl_tCatchAll_CatchAll::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 170 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 170 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 172 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"CatchAll\";" << endl;  

#line  2092 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 176 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  2098 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 439 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 439 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 441 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;

#line  2117 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 449 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		globals::ASTEmap[a->id]->parentActivityId = myid; 


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00071( myid );

#line  2137 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 119 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 119 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 120 "ast-to-xml.k"
		inup(); 
#line  2150 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<catchAll id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 120 "ast-to-xml.k"
		listAttributes( _id ); 
#line  2156 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 120 "ast-to-xml.k"
		indown(); 
#line  2161 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</catchAll>\n"), kc_current_view); }
	    }
	    break;
	}

#line  2167 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2180 "ast-system-unpk.cc"
void
impl_tTerminationHandler_TerminationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 260 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 260 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 262 "ast-to-visualization.k"
		if (! (globals::ASTEmap[_id->value]->isUserDefined) && globals::hideStandardHandlers) 
#line  2194 "ast-system-unpk.cc"
		{
		}
#line 264 "ast-to-visualization.k"
		else 
#line  2199 "ast-system-unpk.cc"
		{
#line 266 "ast-to-visualization.k"

		    (*output) << "subgraph cluster" << toString(_id->value) << " { label = \"TerminationHandler\";" << endl;  
		    if ( !globals::ASTEmap[_id->value]->callable )
		    {
			(*output) << "\tcolor = grey70;" << endl;
			(*output) << "\tfillcolor = grey80;" << endl;
			(*output) << "\tfontcolor = grey60;" << endl;
		    }

#line  2211 "ast-system-unpk.cc"
		    kc::unparse(a, kc_printer, kc_current_view);
#line 276 "ast-to-visualization.k"

		    (*output) << "}" << endl;    

#line  2217 "ast-system-unpk.cc"
		}
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 757 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 757 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 759 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;



		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;
		globals::ASTEmap[a->id]->controlFlow = THCF;
		globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;

#line  2247 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 777 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00071( myid );


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  2266 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 290 "ast-to-cfg.k"
		const activity a = this->activity_1;
#line 290 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 291 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] TerminationHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGTerminationHandler, this->id, "TerminationHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGTerminationHandler, this->id, "TerminationHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  2287 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 301 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(a->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(a->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  2297 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 170 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 170 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 171 "ast-to-xml.k"
		inup(); 
#line  2310 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<terminationHandler id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 171 "ast-to-xml.k"
		indown(); 
#line  2317 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</terminationHandler>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 194 "ast-to-petrinet.k"
		PTerminationHandler(this, kc_current_view_base); 
#line  2327 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2332 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2345 "ast-system-unpk.cc"
void
impl_tTerminationHandler_volatile_standardTerminationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2351 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2364 "ast-system-unpk.cc"
void
impl_tCompensationHandler_CompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 232 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 232 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 234 "ast-to-visualization.k"
		if (! (globals::ASTEmap[_id->value]->isUserDefined) && globals::hideStandardHandlers) 
#line  2378 "ast-system-unpk.cc"
		{
		}
#line 236 "ast-to-visualization.k"
		else 
#line  2383 "ast-system-unpk.cc"
		{
#line 238 "ast-to-visualization.k"

		    (*output) << "subgraph cluster" << toString(_id->value) << " { label = \"CompensationHandler\";" << endl;  
		    if ( !globals::ASTEmap[_id->value]->callable )
		    {
			(*output) << "\tcolor = grey70;" << endl;
			(*output) << "\tfillcolor = grey80;" << endl;
			(*output) << "\tfontcolor = grey60;" << endl;
		    }

#line  2395 "ast-system-unpk.cc"
		    kc::unparse(a, kc_printer, kc_current_view);
#line 248 "ast-to-visualization.k"

		    (*output) << "}" << endl;    

#line  2401 "ast-system-unpk.cc"
		}
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 682 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 682 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 684 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;



		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;
		globals::ASTEmap[a->id]->controlFlow = CHCF;
		globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;

#line  2431 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 702 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00070( myid );










		vector<unsigned int> ancestors = myself->ancestorActivities();
		if (myself->isUserDefined && ancestors.size() > 1)
		{
		    unsigned int i = 1;
		    while(i < ancestors.size())
		    {
			string ancestor = globals::ASTEmap[ancestors[i]]->activityTypeName();
			if (ancestor == "catch" ||
			    ancestor == "catchAll" ||
			    ancestor == "terminationHandler" ||
			    ancestor == "compensationHandler")
			{
			    SAerror(79, ancestor);
			    break;
			}
			i++;
		    }
		}


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  2481 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 263 "ast-to-cfg.k"
		const activity a = this->activity_1;
#line 263 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 264 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] CompensationHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGCompensationHandler, this->id, "CompensationHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGCompensationHandler, this->id, "CompensationHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  2502 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 274 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(a->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(a->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  2512 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 161 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 161 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 162 "ast-to-xml.k"
		inup(); 
#line  2525 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensationHandler id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" callable=\""), kc_current_view); }
#line 162 "ast-to-xml.k"
		*output << globals::ASTEmap[ _id->value ]->callable; 
#line  2531 "ast-system-unpk.cc"
			{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 162 "ast-to-xml.k"
		indown(); 
#line  2536 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensationHandler>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 198 "ast-to-petrinet.k"
		PCompensationHandler(this, kc_current_view_base); 
#line  2546 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2551 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2564 "ast-system-unpk.cc"
void
impl_tCompensationHandler_volatile_standardCompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2570 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2583 "ast-system-unpk.cc"
void
impl_tEventHandlers_EventHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 191 "ast-to-visualization.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 191 "ast-to-visualization.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 191 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 193 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"EventHandlers\";" << endl;  

#line  2601 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 197 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  2608 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 491 "ast-postprocess.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 491 "ast-postprocess.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 491 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 493 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;



		if (a->length() == 0 && b->length() == 0)
		SAerror(83, "", toInt(globals::ASTEmap[myself->parentScopeId]->attributes["referenceLine"]));


		{
#line 509 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  a;

#line  2642 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 509 "ast-postprocess.k"
			    {
#line 510 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 510 "ast-postprocess.k"
#line 509 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 509 "ast-postprocess.k"
				    const tCorrelation_list _cor = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 509 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 509 "ast-postprocess.k"
				    const activity _act = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 509 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 510 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;
				    globals::ASTEmap[_id2->value]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id2->value]->max_occurrences = myself->max_occurrences;


#line  2672 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2677 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 509 "ast-postprocess.k"

#line  2682 "ast-system-unpk.cc"
		    }
		}
#line 518 "ast-postprocess.k"
		{
#line 518 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  b;

#line  2690 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 518 "ast-postprocess.k"
			    {
#line 519 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 519 "ast-postprocess.k"
#line 518 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 518 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 518 "ast-postprocess.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 519 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id3->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id3->value]->max_occurrences = myself->max_occurrences;

#line  2715 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2720 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 518 "ast-postprocess.k"

#line  2725 "ast-system-unpk.cc"
		    }
		}
#line 526 "ast-postprocess.k"

#line  2730 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 528 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  2741 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 200 "ast-to-cfg.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 200 "ast-to-cfg.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 200 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 201 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] EventHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGPick, this->id, "EventHandler_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGPick, this->id, "EventHandler_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;









		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  2773 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 221 "ast-to-cfg.k"

		int i = 1;
		{
#line 223 "ast-to-cfg.k"
		    tOnMessage_list kc_fe_selvar_1 =  a;

#line  2783 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 223 "ast-to-cfg.k"
			    {
#line 224 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 224 "ast-to-cfg.k"
#line 223 "ast-to-cfg.k"
				    const tOnMessage message = kc_selvar_0_1;
#line 223 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 224 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onMessageBlock = new CFGBlock(CFGOnMessage, message->id, "OnMessage_" + toString(i++)); 
				    onMessageBlock->channel_name = globals::ASTEmap[message->id]->channelName;

				    connectBlocks(firstBlock, onMessageBlock);
				    connectBlocks(onMessageBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  2809 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2814 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 223 "ast-to-cfg.k"

#line  2819 "ast-system-unpk.cc"
		    }
		}
#line 234 "ast-to-cfg.k"
		i = 1; 
		{
#line 235 "ast-to-cfg.k"
		    tOnAlarm_list kc_fe_selvar_1 =  b;

#line  2828 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 235 "ast-to-cfg.k"
			    {
#line 236 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 236 "ast-to-cfg.k"
#line 235 "ast-to-cfg.k"
				    const tOnAlarm alarm = kc_selvar_0_1;
#line 235 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 236 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onAlarmBlock = new CFGBlock(CFGOnAlarm, alarm->id, "OnAlarm_" + toString(i++)); 

				    connectBlocks(firstBlock, onAlarmBlock);
				    connectBlocks(onAlarmBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  2853 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2858 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 235 "ast-to-cfg.k"

#line  2863 "ast-system-unpk.cc"
		    }
		}
#line 244 "ast-to-cfg.k"


#line  2869 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 132 "ast-to-xml.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 132 "ast-to-xml.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 132 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 133 "ast-to-xml.k"
		inup(); 
#line  2884 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<eventHandlers id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 133 "ast-to-xml.k"
		indown(); 
#line  2892 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</eventHandlers>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 202 "ast-to-petrinet.k"
		PEventHandlers(this, kc_current_view_base); 
#line  2902 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 202 "ast-to-petrinet.k"
		PEventHandlers(this, kc_current_view_base); 
#line  2911 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2916 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2929 "ast-system-unpk.cc"
void
impl_tEventHandlers_emptyEventHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 187 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 474 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 476 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  2960 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 249 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 250 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] EventHandler (implicit)\n");
		CFGBlock * block = new CFGBlock(CFGEventHandler, this->id, "implicitEventHandler"); 
		globals::cfgMap[toString(this->id)] = block;
		trace(TRACE_DEBUG, "[CFG] ~EventHandler (implicit)\n");

#line  2976 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 128 "ast-to-xml.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}

#line  2989 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tOnMessage_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3009 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tOnMessage_list iterator_ = this; iterator_->tOnMessage_list_1 != 0; iterator_ = iterator_->tOnMessage_list_1)
		    iterator_->tOnMessage_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tOnMessage_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3027 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3039 "ast-system-unpk.cc"
void
impl_tOnMessage_OnMessage::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 203 "ast-to-visualization.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 203 "ast-to-visualization.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 203 "ast-to-visualization.k"
		const activity c = this->activity_1;
#line 203 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 205 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"OnMessage\";" << endl;  

#line  3059 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 209 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  3067 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 538 "ast-postprocess.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 538 "ast-postprocess.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 538 "ast-postprocess.k"
		const activity c = this->activity_1;
#line 538 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 540 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;
		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		myself->checkAttributes();

		myself->checkPartnerLink();

		myself->checkMessageExchange();

		globals::ASTE_IMAs.insert(myid);

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}


		if (b->length() != 0 && myself->attributes["variable"] != "")
		SAerror(63, "", myself->attributes["referenceLine"]);


		if (globals::wsdl_filename != "")
		{
		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["myRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <onMessage>"),myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->channelName = myself->createChannel();



		assert(globals::ASTEmap[c->id] != NULL);
		globals::ASTEmap[c->id]->parentActivityId = myid;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if(globals::ASTEmap[myself->parentActivityId]->activityTypeName() == "eventHandlers")
		{
		    if(max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		    {
			myself->max_occurrences = max_loops * myself-> max_occurrences;
		    } 
		    else
		    {
			myself->max_occurrences = UINT_MAX;
		    }
		}

		globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;





		{
#line 610 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  a;

#line  3157 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 610 "ast-postprocess.k"
			    {
#line 611 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 611 "ast-postprocess.k"
#line 610 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 610 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 611 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  3178 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  3183 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 610 "ast-postprocess.k"

#line  3188 "ast-system-unpk.cc"
		    }
		}
#line 616 "ast-postprocess.k"

#line  3193 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 618 "ast-postprocess.k"


		assert(globals::ASTEmap[c->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[c->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[c->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  3208 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 136 "ast-to-xml.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 136 "ast-to-xml.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 136 "ast-to-xml.k"
		const activity c = this->activity_1;
#line 136 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 137 "ast-to-xml.k"
		inup(); 
#line  3225 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<onMessage id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 137 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3231 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 139 "ast-to-xml.k"
		if (a->length() == 0) 
#line  3235 "ast-system-unpk.cc"
		{
		}
#line 141 "ast-to-xml.k"
		else 
#line  3240 "ast-system-unpk.cc"
		{
#line 142 "ast-to-xml.k"
		    inup(); 
#line  3244 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<correlations>\n"), kc_current_view); }
		    kc::unparse(a, kc_printer, kc_current_view);
#line 142 "ast-to-xml.k"
		    indown(); 
#line  3249 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</correlations>\n"), kc_current_view); }
		}
#line 144 "ast-to-xml.k"
		if (b->length() == 0) 
#line  3254 "ast-system-unpk.cc"
		{
		}
#line 146 "ast-to-xml.k"
		else 
#line  3259 "ast-system-unpk.cc"
		{
#line 147 "ast-to-xml.k"
		    inup(); 
#line  3263 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<fromParts>\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 147 "ast-to-xml.k"
		    indown(); 
#line  3268 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</fromParts>\n"), kc_current_view); }
		}
		kc::unparse(c, kc_printer, kc_current_view);
#line 149 "ast-to-xml.k"
		indown(); 
#line  3274 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</onMessage>\n"), kc_current_view); }
	    }
	    break;
	}

#line  3280 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tOnAlarm_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3300 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tOnAlarm_list iterator_ = this; iterator_->tOnAlarm_list_1 != 0; iterator_ = iterator_->tOnAlarm_list_1)
		    iterator_->tOnAlarm_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tOnAlarm_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3318 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3330 "ast-system-unpk.cc"
void
impl_tOnAlarm_OnAlarm::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 215 "ast-to-visualization.k"
		const tRepeatEvery a = this->tRepeatEvery_1;
#line 215 "ast-to-visualization.k"
		const activity b = this->activity_1;
#line 215 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 217 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"OnAlarm\";" << endl;  

#line  3348 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 221 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  3354 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 631 "ast-postprocess.k"
		const tRepeatEvery b = this->tRepeatEvery_1;
#line 631 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 631 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 633 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;
		assert(globals::ASTEmap[myself->parentActivityId] != NULL);

		if(string(b->op_name())=="RepeatEvery")
		{
		    myself->cyclic=true;
		    globals::ASTEmap[a->id]->max_occurrences = UINT_MAX;
		} 
		else
		{

		    unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		    if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		    globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences * max_loops;
		    else
		    globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;
		}


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;

#line  3398 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 664 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  3411 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 152 "ast-to-xml.k"
		const tRepeatEvery a = this->tRepeatEvery_1;
#line 152 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 152 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 153 "ast-to-xml.k"
		inup(); 
#line  3426 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<onAlarm"), kc_current_view); }
#line 153 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3430 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 153 "ast-to-xml.k"
		indown(); 
#line  3435 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</onAlarm>\n"), kc_current_view); }
	    }
	    break;
	}

#line  3441 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3454 "ast-system-unpk.cc"
void
impl_tRepeatEvery_RepeatEvery::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3460 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3473 "ast-system-unpk.cc"
void
impl_tRepeatEvery_emptyRepeatEvery::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3479 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tVariable_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3499 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tVariable_list iterator_ = this; iterator_->tVariable_list_1 != 0; iterator_ = iterator_->tVariable_list_1)
		    iterator_->tVariable_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tVariable_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3517 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3529 "ast-system-unpk.cc"
void
impl_tVariable_Variable::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 288 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 804 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 806 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineVariable();

#line  3558 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 179 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 180 "ast-to-xml.k"
		in(); 
#line  3569 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<variable id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 180 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3575 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3581 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tMessageExchange_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3601 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tMessageExchange_list iterator_ = this; iterator_->tMessageExchange_list_1 != 0; iterator_ = iterator_->tMessageExchange_list_1)
		    iterator_->tMessageExchange_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tMessageExchange_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3619 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3631 "ast-system-unpk.cc"
void
impl_tMessageExchange_MessageExchange::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 824 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 826 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineMessageExchange();

#line  3652 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  3657 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCorrelationSet_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3677 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCorrelationSet_list iterator_ = this; iterator_->tCorrelationSet_list_1 != 0; iterator_ = iterator_->tCorrelationSet_list_1)
		    iterator_->tCorrelationSet_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCorrelationSet_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3695 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3707 "ast-system-unpk.cc"
void
impl_tCorrelationSet_CorrelationSet::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 297 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 844 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 846 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineCorrelationSet();

#line  3736 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 188 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 189 "ast-to-xml.k"
		in(); 
#line  3747 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<correlationSet"), kc_current_view); }
#line 189 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3751 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3757 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCorrelation_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3777 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCorrelation_list iterator_ = this; iterator_->tCorrelation_list_1 != 0; iterator_ = iterator_->tCorrelation_list_1)
		    iterator_->tCorrelation_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCorrelation_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3795 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3807 "ast-system-unpk.cc"
void
impl_tCorrelation_Correlation::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 306 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 864 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 866 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		string correlationSetName = myself->checkCorrelationSet();


		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		if (globals::ASTEmap[myself->parentActivityId]->isStartActivity &&
		    myself->attributes["initiate"] == "join")
		{
		    globals::ASTEmap[myself->parentActivityId]->sharedCorrelationSets.insert(correlationSetName);
		}

#line  3844 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 197 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 198 "ast-to-xml.k"
		in(); 
#line  3855 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<correlation"), kc_current_view); }
#line 198 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3859 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3865 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tToPart_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3885 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tToPart_list iterator_ = this; iterator_->tToPart_list_1 != 0; iterator_ = iterator_->tToPart_list_1)
		    iterator_->tToPart_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tToPart_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3903 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3915 "ast-system-unpk.cc"
void
impl_tToPart_ToPart::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 314 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 892 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 894 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();

#line  3942 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 205 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 206 "ast-to-xml.k"
		in(); 
#line  3953 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<toPart"), kc_current_view); }
#line 206 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3957 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3963 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tFromPart_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3983 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tFromPart_list iterator_ = this; iterator_->tFromPart_list_1 != 0; iterator_ = iterator_->tFromPart_list_1)
		    iterator_->tFromPart_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tFromPart_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  4001 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  4013 "ast-system-unpk.cc"
void
impl_tFromPart_FromPart::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 318 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 905 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 907 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();

#line  4040 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 209 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 210 "ast-to-xml.k"
		in(); 
#line  4051 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<fromPart"), kc_current_view); }
#line 210 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4055 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  4061 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4074 "ast-system-unpk.cc"
void
impl_tReceive_Receive::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 344 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 344 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 344 "ast-to-visualization.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 344 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 346 "ast-to-visualization.k"

		(*output) << "receive" << toString(_id->value) << " [shape=rectangle style=filled label=\"receive\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "receive" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "receive" + toString(_id->value);

#line  4099 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1042 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1042 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 1042 "ast-postprocess.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 1042 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1044 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->checkMessageExchange();
		globals::ASTE_IMAs.insert(myid);




		if (c->length() != 0 && myself->attributes["variable"] != "")
		SAerror(55, "", myself->attributes["referenceLine"]);


		if (globals::wsdl_filename != "")
		{

		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["myRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <receive>"), myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->checkPartnerLink();

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}

		myself->channelName = myself->createChannel();
		myself->variableName = myself->checkVariable("variable");

		{
#line 1090 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  4165 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 1090 "ast-postprocess.k"
			    {
#line 1091 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 1091 "ast-postprocess.k"
#line 1090 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 1090 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 1091 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  4186 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4191 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 1090 "ast-postprocess.k"

#line  4196 "ast-system-unpk.cc"
		    }
		}
#line 1096 "ast-postprocess.k"

#line  4201 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1098 "ast-postprocess.k"

		if (myself->isStartActivity)
		{
		    globals::ASTE_startActivities.insert(myid);


		    if (!globals::ASTEmap[myself->parentActivityId]->checkAncestors() || !myself->targetLinks.empty())
		    SAerror(56, "<receive>", myself->attributes["referenceLine"]);
		}

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4217 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 408 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 408 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 408 "ast-to-cfg.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 408 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 409 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Receive\n");
		CFGBlock * block = new CFGBlock(CFGReceive, this->id, "Receive"); 


		block->channel_name = globals::ASTEmap[d->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4242 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 218 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 218 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 218 "ast-to-xml.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 218 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 219 "ast-to-xml.k"
		inup(); 
#line  4260 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<receive id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 219 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4266 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 219 "ast-to-xml.k"
		indown(); 
#line  4273 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</receive>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 81 "ast-to-petrinet.k"
		PReceive(this, kc_current_view_base); 
#line  4283 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 81 "ast-to-petrinet.k"
		PReceive(this, kc_current_view_base); 
#line  4292 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4297 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4310 "ast-system-unpk.cc"
void
impl_tReply_Reply::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 362 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 362 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 362 "ast-to-visualization.k"
		const tToPart_list c = this->tToPart_list_1;
#line 362 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 364 "ast-to-visualization.k"

		(*output) << "reply" << toString(_id->value) << " [shape=rectangle style=filled label=\"reply\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "reply" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "reply" + toString(_id->value);

#line  4335 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1118 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1118 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 1118 "ast-postprocess.k"
		const tToPart_list c = this->tToPart_list_1;
#line 1118 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1120 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->checkMessageExchange();




		if (globals::wsdl_filename != "")
		{
		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["myRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <reply>"), myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->checkPartnerLink();

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}


		if (c->length() != 0 && myself->attributes["variable"] != "")
		SAerror(59, "", myself->attributes["referenceLine"]);

		myself->channelName = myself->createChannel();
		myself->variableName = myself->checkVariable("variable");

		{
#line 1164 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  4399 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 1164 "ast-postprocess.k"
			    {
#line 1165 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 1165 "ast-postprocess.k"
#line 1164 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 1164 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 1165 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  4420 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4425 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 1164 "ast-postprocess.k"

#line  4430 "ast-system-unpk.cc"
		    }
		}
#line 1170 "ast-postprocess.k"

#line  4435 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1172 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4442 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 427 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 427 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 427 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 427 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 428 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Reply\n");
		CFGBlock * block = new CFGBlock(CFGReply, this->id, "Reply"); 


		block->channel_name = globals::ASTEmap[d->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4467 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 227 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 227 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 227 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 227 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 228 "ast-to-xml.k"
		inup(); 
#line  4485 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<reply id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 228 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4491 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 228 "ast-to-xml.k"
		indown(); 
#line  4498 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</reply>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 85 "ast-to-petrinet.k"
		PReply(this, kc_current_view_base); 
#line  4508 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 85 "ast-to-petrinet.k"
		PReply(this, kc_current_view_base); 
#line  4517 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4522 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4535 "ast-system-unpk.cc"
void
impl_tInvoke_volatile_annotatedInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  4541 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4554 "ast-system-unpk.cc"
void
impl_tInvoke_AsynchronousInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 393 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 393 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 393 "ast-to-visualization.k"
		const tToPart_list c = this->tToPart_list_1;
#line 393 "ast-to-visualization.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 393 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 395 "ast-to-visualization.k"

		(*output) << "invoke" << toString(_id->value) << " [shape=rectangle style=filled label=\"invoke\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "invoke" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "invoke" + toString(_id->value);

#line  4581 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 389 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 389 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 389 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 389 "ast-to-cfg.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 389 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 390 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Invoke\n");
		CFGBlock * block = new CFGBlock(CFGInvoke, this->id, "Invoke");


		block->channel_name = globals::ASTEmap[e->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4608 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 240 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 240 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 240 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 240 "ast-to-xml.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 240 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 241 "ast-to-xml.k"
		inup(); 
#line  4628 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<invoke id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 241 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4634 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 241 "ast-to-xml.k"
		indown(); 
#line  4642 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</invoke>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 73 "ast-to-petrinet.k"
		PAsynchronousInvoke(this, kc_current_view_base); 
#line  4652 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 73 "ast-to-petrinet.k"
		PAsynchronousInvoke(this, kc_current_view_base); 
#line  4661 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4666 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4679 "ast-system-unpk.cc"
void
impl_tInvoke_SynchronousInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 380 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 380 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 380 "ast-to-visualization.k"
		const tToPart_list c = this->tToPart_list_1;
#line 380 "ast-to-visualization.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 380 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 382 "ast-to-visualization.k"

		(*output) << "invoke" << toString(_id->value) << " [shape=rectangle style=filled label=\"invoke\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "invoke" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "invoke" + toString(_id->value);

#line  4706 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 376 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 376 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 376 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 376 "ast-to-cfg.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 376 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 377 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Invoke\n");
		CFGBlock * block = new CFGBlock(CFGInvoke, this->id, "Invoke");


		block->channel_name = globals::ASTEmap[e->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4733 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 236 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 236 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 236 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 236 "ast-to-xml.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 236 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 237 "ast-to-xml.k"
		inup(); 
#line  4753 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<invoke id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 237 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4759 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 237 "ast-to-xml.k"
		indown(); 
#line  4767 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</invoke>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 77 "ast-to-petrinet.k"
		PSynchronousInvoke(this, kc_current_view_base); 
#line  4777 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 77 "ast-to-petrinet.k"
		PSynchronousInvoke(this, kc_current_view_base); 
#line  4786 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4791 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4804 "ast-system-unpk.cc"
void
impl_tInvoke_volatile_Invoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 973 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 973 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 973 "ast-postprocess.k"
		const tToPart_list c = this->tToPart_list_1;
#line 973 "ast-postprocess.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 973 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 975 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		if (c->length() != 0 && myself->attributes["inputVariable"] != "")
		SAerror(51, "", myself->attributes["referenceLine"]);


		if (d->length() != 0 && myself->attributes["outputVariable"] != "")
		SAerror(52, "", myself->attributes["referenceLine"]);

		if (globals::wsdl_filename != "")
		{

		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["partnerRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <invoke>"),myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->checkPartnerLink();

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}

		myself->channelName = myself->createChannel((myself->attributes["outputVariable"] != ""));
		myself->inputVariableName = myself->checkVariable("inputVariable");
		myself->outputVariableName = myself->checkVariable("outputVariable");

		{
#line 1023 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  4875 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 1023 "ast-postprocess.k"
			    {
#line 1024 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 1024 "ast-postprocess.k"
#line 1023 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 1023 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 1024 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  4896 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4901 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 1023 "ast-postprocess.k"

#line  4906 "ast-system-unpk.cc"
		    }
		}
#line 1029 "ast-postprocess.k"

#line  4911 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1031 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4918 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4923 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4936 "ast-system-unpk.cc"
void
impl_tAssign_Assign::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 411 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 411 "ast-to-visualization.k"
		const tCopy_list b = this->tCopy_list_1;
#line 411 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 413 "ast-to-visualization.k"

		(*output) << "assign" << toString(_id->value) << " [shape=rectangle style=filled label=\"assign\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "assign" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "assign" + toString(_id->value);

#line  4959 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1183 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1183 "ast-postprocess.k"
		const tCopy_list b = this->tCopy_list_1;
#line 1183 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1185 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  4984 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1197 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4991 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 446 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 446 "ast-to-cfg.k"
		const tCopy_list b = this->tCopy_list_1;
#line 446 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 447 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Assign\n");
		CFGBlock * firstBlock = new CFGBlock(CFGAssign, this->id, "Assign_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGAssign, this->id, "Assign_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 459 "ast-to-cfg.k"
		    tCopy_list kc_fe_selvar_1 =  b;

#line  5021 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCopy_list
			) {
			tCopy kc_selvar_0_1 = kc_fe_selvar_1->tCopy_1;
			{
#line 459 "ast-to-cfg.k"
			    {
#line 460 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Copy)) {
#line 460 "ast-to-cfg.k"
#line 459 "ast-to-cfg.k"
				    const tFrom from = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tFrom_1;
#line 459 "ast-to-cfg.k"
				    const tTo to = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tTo_1;
#line 460 "ast-to-cfg.k"




				    CFGBlock * fromBlock = new CFGBlock(CFGFrom, from->id, "From_" + toString(i));
				    CFGBlock * toBlock   = new CFGBlock(CFGTo,   to->id, "To_" + toString(i++));
				    connectBlocks(last,fromBlock);
				    connectBlocks(fromBlock, toBlock);
				    last = toBlock;

#line  5047 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  5052 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCopy_list_1;
#line 459 "ast-to-cfg.k"

#line  5057 "ast-system-unpk.cc"
		    }
		}
#line 469 "ast-to-cfg.k"

		connectBlocks(last, lastBlock);

#line  5064 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 249 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 249 "ast-to-xml.k"
		const tCopy_list b = this->tCopy_list_1;
#line 249 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 250 "ast-to-xml.k"
		inup(); 
#line  5080 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<assign id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 250 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5086 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 250 "ast-to-xml.k"
		indown(); 
#line  5092 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</assign>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 89 "ast-to-petrinet.k"
		PAssign(this, kc_current_view_base); 
#line  5102 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 89 "ast-to-petrinet.k"
		PAssign(this, kc_current_view_base); 
#line  5111 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5116 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCopy_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  5136 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCopy_list iterator_ = this; iterator_->tCopy_list_1 != 0; iterator_ = iterator_->tCopy_list_1)
		    iterator_->tCopy_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCopy_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  5154 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  5166 "ast-system-unpk.cc"
void
impl_tCopy_Copy::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 424 "ast-to-visualization.k"
		const tFrom a = this->tFrom_1;
#line 424 "ast-to-visualization.k"
		const tTo b = this->tTo_1;
#line 424 "ast-to-visualization.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1203 "ast-postprocess.k"
		const tFrom a = this->tFrom_1;
#line 1203 "ast-postprocess.k"
		const tTo b = this->tTo_1;
#line 1203 "ast-postprocess.k"
		const integer c = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 253 "ast-to-xml.k"
		const tFrom a = this->tFrom_1;
#line 253 "ast-to-xml.k"
		const tTo b = this->tTo_1;
#line 253 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 254 "ast-to-xml.k"
		inup(); 
#line  5210 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<copy id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 254 "ast-to-xml.k"
		indown(); 
#line  5218 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</copy>\n"), kc_current_view); }
	    }
	    break;
	}

#line  5224 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5237 "ast-system-unpk.cc"
void
impl_tFrom_From::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 428 "ast-to-visualization.k"
		const integer a = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1207 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1209 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);


		if (myself->attributes["has_literal"] == "")
		{
		    if(myself->attributes["has_expression"] == "")
		    {
			if (myself->attributes["variable"] == "")
			{
			    if (myself->attributes["endpointReference"] == "")
			    {
				if (! (myself->attributes["property"] == "" && myself->attributes["partnerLink"] == ""
					&& myself->attributes["expressionLanguage"] == "" && myself->attributes["has_query"] == ""
					&& myself->attributes["part"] == ""))
				SAerror(32, "from", myself->attributes["referenceLine"]);
			    }
			    else
			    {
				if (! (myself->attributes["property"] == "" && myself->attributes["partnerLink"] != ""
					&& myself->attributes["expressionLanguage"] == "" && myself->attributes["has_query"] == ""
					&& myself->attributes["part"] == ""))
				SAerror(32, "from", myself->attributes["referenceLine"]);
			    }
			}
			else
			{
			    if (! (myself->attributes["endpointReference"] == "" && myself->attributes["property"] != "" 
				    && myself->attributes["partnerLink"] == "" && myself->attributes["expressionLanguage"] == ""
				    && myself->attributes["has_query"] == "" && myself->attributes["part"] == "")
				&&
				! (myself->attributes["endpointReference"] == "" && myself->attributes["property"] == "" 
				    && myself->attributes["partnerLink"] == "" && myself->attributes["expressionLanguage"] == "")
			    )
			    SAerror(32, "from", myself->attributes["referenceLine"]);           
			}
		    }
		    else
		    {
			if (! (myself->attributes["has_query"] == "" && myself->attributes["variable"] == "" 
				&& myself->attributes["endpointReference"] == "" && myself->attributes["property"] == "" 
				&& myself->attributes["partnerLink"] == ""&& myself->attributes["part"] == ""))
			SAerror(32, "from", myself->attributes["referenceLine"]);
		    }
		}
		else
		{
		    if (! (myself->attributes["has_query"] == "" && myself->attributes["has_expression"] == ""
			    && myself->attributes["variable"] == "" && myself->attributes["endpointReference"] == ""
			    && myself->attributes["property"] == "" && myself->attributes["partnerLink"] == ""
			    && myself->attributes["expressionLanguage"] == "" && myself->attributes["part"] == ""))
		    SAerror(32, "from", myself->attributes["referenceLine"]);
		}


		if (myself->attributes["endpointReference"] == "myRole")
		if(globals::ASTEmap[globals::ASTE_partnerLinks[myself->attributes["partnerLink"]]]->attributes["myRole"] == "")
		SAerror(35, myself->attributes["partnerLink"], myself->attributes["referenceLine"]);


		if (myself->attributes["endpointReference"] == "partnerRole")
		if(globals::ASTEmap[globals::ASTE_partnerLinks[myself->attributes["partnerLink"]]]->attributes["partnerRole"] == "")
		SAerror(36, myself->attributes["partnerLink"], myself->attributes["referenceLine"]);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->checkPartnerLink();
		myself->variableName = myself->checkVariable("variable");

#line  5330 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 257 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 258 "ast-to-xml.k"
		in(); 
#line  5341 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<from />\n"), kc_current_view); }
	    }
	    break;
	}

#line  5347 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5360 "ast-system-unpk.cc"
void
impl_tTo_To::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 432 "ast-to-visualization.k"
		const integer b = this->integer_1;
		kc::unparse(b, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1285 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1287 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		if(myself->attributes["has_expression"] == "")
		{
		    if (myself->attributes["variable"] == "")
		    {
			if (! (myself->attributes["property"] == "" && myself->attributes["expressionLanguage"] == "" 
				&& myself->attributes["has_query"] == "" && myself->attributes["part"] == ""))
			SAerror(32, "to", myself->attributes["referenceLine"]);
		    }
		    else
		    {
			if (! (myself->attributes["property"] != "" && myself->attributes["part"] == ""
				&& myself->attributes["partnerLink"] == "" && myself->attributes["expressionLanguage"] == ""
				&& myself->attributes["has_query"] == "")
			    &&
			    ! (myself->attributes["expressionLanguage"] == "" && myself->attributes["property"] == "" 
				&& myself->attributes["partnerLink"] == "")
			)
			SAerror(32, "to", myself->attributes["referenceLine"]);           
		    }
		}
		else
		{
		    if (! (myself->attributes["has_query"] == "" && myself->attributes["variable"] == "" 
			    && myself->attributes["part"] == "" && myself->attributes["property"] == "" 
			    && myself->attributes["partnerLink"] == ""))
		    SAerror(32, "to", myself->attributes["referenceLine"]);
		}


		if (myself->attributes["partnerLink"] != "")
		if(globals::ASTEmap[globals::ASTE_partnerLinks[myself->attributes["partnerLink"]]]->attributes["partnerRole"] == "")
		SAerror(37, myself->attributes["partnerLink"], myself->attributes["referenceLine"]);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->checkPartnerLink();
		myself->variableName = myself->checkVariable("variable");

#line  5425 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 261 "ast-to-xml.k"
		const integer b = this->integer_1;
#line 262 "ast-to-xml.k"
		in(); 
#line  5436 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<to />\n"), kc_current_view); }
	    }
	    break;
	}

#line  5442 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5455 "ast-system-unpk.cc"
void
impl_tValidate_Validate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 441 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 441 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 443 "ast-to-visualization.k"

		(*output) << "validate" << toString(_id->value) << " [shape=rectangle style=filled label=\"validate\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "validate" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "validate" + toString(_id->value);

#line  5476 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1340 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1340 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1342 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5499 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1354 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5505 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 332 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 332 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 333 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Validate\n");
		CFGBlock * block = new CFGBlock(CFGValidate, this->id, "Validate"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5523 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 270 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 270 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 271 "ast-to-xml.k"
		inup(); 
#line  5537 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<validate id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 271 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5543 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 271 "ast-to-xml.k"
		indown(); 
#line  5548 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</validate>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 93 "ast-to-petrinet.k"
		PValidate(this, kc_current_view_base); 
#line  5558 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 93 "ast-to-petrinet.k"
		PValidate(this, kc_current_view_base); 
#line  5567 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5572 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5585 "ast-system-unpk.cc"
void
impl_tEmpty_Empty::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 458 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 458 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 460 "ast-to-visualization.k"

		(*output) << "empty" << toString(_id->value) << " [shape=rectangle style=filled label=\"empty\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "empty" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "empty" + toString(_id->value);

#line  5606 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 923 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 923 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 925 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5629 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 937 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5635 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 346 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 346 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 347 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Empty\n");
		CFGBlock * block = new CFGBlock(CFGEmpty, this->id, "Empty"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5653 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 278 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 278 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 279 "ast-to-xml.k"
		inup(); 
#line  5667 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<empty id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 279 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5673 "ast-system-unpk.cc"
#line 280 "ast-to-xml.k"

		{
#line 281 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 283 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 283 "ast-to-xml.k"
#line 283 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 283 "ast-to-xml.k"
			*output << " />";  indown(); *output << endl; 
#line  5686 "ast-system-unpk.cc"
				} else
		    {
#line 284 "ast-to-xml.k"
#line 284 "ast-to-xml.k"
			*output << ">\n"; 
#line  5692 "ast-system-unpk.cc"
		    }
		}
#line 286 "ast-to-xml.k"

#line  5697 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 288 "ast-to-xml.k"

		{
#line 289 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 291 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 291 "ast-to-xml.k"
#line 291 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 291 "ast-to-xml.k"

#line  5711 "ast-system-unpk.cc"
		    } else
		    {
#line 292 "ast-to-xml.k"
#line 292 "ast-to-xml.k"
			indown(); *output << "</empty>\n"; 
#line  5717 "ast-system-unpk.cc"
		    }
		}
#line 294 "ast-to-xml.k"

#line  5722 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 65 "ast-to-petrinet.k"
		PEmpty(this, kc_current_view_base); 
#line  5731 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 65 "ast-to-petrinet.k"
		PEmpty(this, kc_current_view_base); 
#line  5740 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5745 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5758 "ast-system-unpk.cc"
void
impl_tOpaqueActivity_OpaqueActivity::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 326 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 326 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 328 "ast-to-visualization.k"

		(*output) << "opaqueActivity" << toString(_id->value) << " [shape=rectangle style=filled label=\"opaqueActivity\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "opaqueActivity" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "opaqueActivity" + toString(_id->value);

#line  5779 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 948 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 948 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 950 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5802 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 962 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5808 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 361 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 361 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 362 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] OpaqueActivity\n");
		CFGBlock * block = new CFGBlock(CFGOpaqueActivity, this->id, "OpaqueActivity"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5826 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 303 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 303 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 304 "ast-to-xml.k"
		inup(); 
#line  5840 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<opaqueActivity id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 304 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5846 "ast-system-unpk.cc"
#line 305 "ast-to-xml.k"

		{
#line 306 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 308 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 308 "ast-to-xml.k"
#line 308 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 308 "ast-to-xml.k"
			*output << " />";  indown(); *output << endl; 
#line  5859 "ast-system-unpk.cc"
				} else
		    {
#line 309 "ast-to-xml.k"
#line 309 "ast-to-xml.k"
			*output << ">\n"; 
#line  5865 "ast-system-unpk.cc"
		    }
		}
#line 311 "ast-to-xml.k"

#line  5870 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 313 "ast-to-xml.k"

		{
#line 314 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 316 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 316 "ast-to-xml.k"
#line 316 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 316 "ast-to-xml.k"

#line  5884 "ast-system-unpk.cc"
		    } else
		    {
#line 317 "ast-to-xml.k"
#line 317 "ast-to-xml.k"
			indown(); *output << "</opaqueActivity>\n"; 
#line  5890 "ast-system-unpk.cc"
		    }
		}
#line 319 "ast-to-xml.k"

#line  5895 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 69 "ast-to-petrinet.k"
		POpaqueActivity(this, kc_current_view_base); 
#line  5904 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 69 "ast-to-petrinet.k"
		POpaqueActivity(this, kc_current_view_base); 
#line  5913 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5918 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5931 "ast-system-unpk.cc"
void
impl_tWait_Wait::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 476 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 476 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 478 "ast-to-visualization.k"

		(*output) << "wait" << toString(_id->value) << " [shape=rectangle style=filled label=\"wait\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "wait" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "wait" + toString(_id->value);

#line  5952 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1365 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1365 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1367 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5975 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1379 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5981 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 482 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 482 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 483 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Wait\n");
		CFGBlock * block = new CFGBlock(CFGWait, this->id, "Wait"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5999 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 328 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 328 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 329 "ast-to-xml.k"
		inup(); 
#line  6013 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<wait id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 329 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6019 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 329 "ast-to-xml.k"
		indown(); 
#line  6024 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</wait>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 97 "ast-to-petrinet.k"
		PWait(this, kc_current_view_base); 
#line  6034 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 97 "ast-to-petrinet.k"
		PWait(this, kc_current_view_base); 
#line  6043 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6048 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6061 "ast-system-unpk.cc"
void
impl_tExit_Exit::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 494 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 494 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 496 "ast-to-visualization.k"

		(*output) << "exit" << toString(_id->value) << " [shape=rectangle style=filled label=\"exit\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "exit" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "exit" + toString(_id->value);

#line  6082 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1588 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1588 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1590 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  6105 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1602 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6116 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 560 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 560 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 561 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Exit\n");
		CFGBlock * block = new CFGBlock(CFGExit, this->id, "Exit"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6134 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 337 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 337 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 338 "ast-to-xml.k"
		inup(); 
#line  6148 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<exit id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 338 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6154 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 338 "ast-to-xml.k"
		indown(); 
#line  6159 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</exit>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 109 "ast-to-petrinet.k"
		PExit(this, kc_current_view_base); 
#line  6169 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 109 "ast-to-petrinet.k"
		PExit(this, kc_current_view_base); 
#line  6178 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6183 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6196 "ast-system-unpk.cc"
void
impl_tThrow_Throw::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 512 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 512 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 514 "ast-to-visualization.k"

		(*output) << "throw" << toString(_id->value) << " [shape=rectangle style=filled label=\"throw\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "throw" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "throw" + toString(_id->value);

#line  6217 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1390 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1390 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1392 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		globals::ASTEmap[ myself->parentScopeId ]->enterFault( myself->attributes[ "faultName" ] );

#line  6241 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1405 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6252 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 498 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 498 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 499 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Throw\n");
		CFGBlock * block = new CFGBlock(CFGThrow, this->id, "Throw"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6270 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 346 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 346 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 347 "ast-to-xml.k"
		inup(); 
#line  6284 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<throw id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 347 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6290 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 347 "ast-to-xml.k"
		indown(); 
#line  6295 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</throw>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 101 "ast-to-petrinet.k"
		PThrow(this, kc_current_view_base); 
#line  6305 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 101 "ast-to-petrinet.k"
		PThrow(this, kc_current_view_base); 
#line  6314 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6319 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6332 "ast-system-unpk.cc"
void
impl_tRethrow_Rethrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 530 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 530 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 532 "ast-to-visualization.k"

		(*output) << "rethrow" << toString(_id->value) << " [shape=rectangle style=filled label=\"rethrow\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "rethrow" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "rethrow" + toString(_id->value);

#line  6353 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1421 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1421 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1423 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();
		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    assert(globals::ASTEmap[*it] != NULL);
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(6, "", myself->attributes["referenceLine"]);

#line  6393 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1452 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  6399 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 513 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 513 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 514 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Rethrow\n");
		CFGBlock * block = new CFGBlock(CFGRethrow, this->id, "Rhrow"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6417 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 355 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 355 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 356 "ast-to-xml.k"
		inup(); 
#line  6431 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<rethrow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 356 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6437 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 356 "ast-to-xml.k"
		indown(); 
#line  6442 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</rethrow>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 105 "ast-to-petrinet.k"
		PRethrow(this, kc_current_view_base); 
#line  6452 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6457 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6470 "ast-system-unpk.cc"
void
impl_tCompensate_CompensateScope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 562 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 562 "ast-to-visualization.k"
		const casestring b = this->casestring_1;
#line 562 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 564 "ast-to-visualization.k"

		(*output) << "compensateScope" << toString(_id->value) << " [shape=rectangle style=filled label=\"compensateScope\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "compensateScope" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "compensateScope" + toString(_id->value);

#line  6493 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1521 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1521 "ast-postprocess.k"
		const casestring b = this->casestring_1;
#line 1521 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1523 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;



		if (myself->attributes["target"] == "")
		myself->attributes["target"] = string(b->name);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();
		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers" ||
			globals::ASTEmap[*it]->activityTypeName() == "compensationHandler" ||
			globals::ASTEmap[*it]->activityTypeName() == "terminationHandler")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(7, "", myself->attributes["referenceLine"]);



		if (globals::ASTE_scopeNames[myself->attributes["target"]] == 0)
		SAerror(78, myself->attributes["target"], myself->attributes["referenceLine"]);
		else if (globals::ASTEmap[myself->parentScopeId]->enclosedScopes.find(globals::ASTE_scopeNames[myself->attributes["target"]]) == globals::ASTEmap[myself->parentScopeId]->enclosedScopes.end())
		SAerror(77, myself->attributes["target"], myself->attributes["referenceLine"]);

		globals::ASTEmap[ 
		globals::ASTEmap[ 
		*(globals::ASTEmap[myself->parentScopeId]->enclosedScopes.find(globals::ASTE_scopeNames[myself->attributes["target"]])) 
		]->enclosedCH 
		]->callable = true;

#line  6555 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1572 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6566 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 544 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 544 "ast-to-cfg.k"
		const casestring name = this->casestring_1;
#line 544 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 545 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] CompensateScope\n");
		CFGBlock * block = new CFGBlock(CFGCompensateScope, this->id, "CompensateScope"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6586 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 368 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 368 "ast-to-xml.k"
		const casestring b = this->casestring_1;
#line 368 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 369 "ast-to-xml.k"
		inup(); 
#line  6602 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensateScope id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" target=\""), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 369 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6610 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 369 "ast-to-xml.k"
		indown(); 
#line  6615 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensateScope>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 117 "ast-to-petrinet.k"
		PCompensateScope(this, kc_current_view_base); 
#line  6625 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 117 "ast-to-petrinet.k"
		PCompensateScope(this, kc_current_view_base); 
#line  6634 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6639 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6652 "ast-system-unpk.cc"
void
impl_tCompensate_Compensate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 548 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 548 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 550 "ast-to-visualization.k"

		(*output) << "compensate" << toString(_id->value) << " [shape=rectangle style=filled label=\"compensate\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "compensate" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "compensate" + toString(_id->value);

#line  6673 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1463 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1463 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1465 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();

		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers" ||
			globals::ASTEmap[*it]->activityTypeName() == "compensationHandler" ||
			globals::ASTEmap[*it]->activityTypeName() == "terminationHandler")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(8, "", myself->attributes["referenceLine"]);


		globals::ASTEmap[myself->parentActivityId]->hasCompensate = true;
		for (set< unsigned int >::iterator scope =  globals::ASTEmap[myself->parentActivityId]->enclosedScopes.begin();
		    scope != globals::ASTEmap[myself->parentActivityId]->enclosedScopes.begin(); 
		    scope++)
		{
		    globals::ASTEmap[ globals::ASTEmap[ *scope ]->enclosedCH ]->callable = true;
		}

#line  6724 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1505 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6735 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 529 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 529 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 530 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Compensate\n");
		CFGBlock * block = new CFGBlock(CFGCompensate, this->id, "Compensate"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6753 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 364 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 364 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 365 "ast-to-xml.k"
		inup(); 
#line  6767 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensate id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 365 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6773 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 365 "ast-to-xml.k"
		indown(); 
#line  6778 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensate>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 113 "ast-to-petrinet.k"
		PCompensate(this, kc_current_view_base); 
#line  6788 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 113 "ast-to-petrinet.k"
		PCompensate(this, kc_current_view_base); 
#line  6797 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6802 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6815 "ast-system-unpk.cc"
void
impl_tSequence_Sequence::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 580 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 580 "ast-to-visualization.k"
		const activity_list b = this->activity_list_1;
#line 580 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 582 "ast-to-visualization.k"


		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Sequence\";" << endl;  

#line  6834 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 587 "ast-to-visualization.k"


		bool startlist=true;
		bool laststructured = false;
		int lastid = 0;   
		{
#line 592 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  6847 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 592 "ast-to-visualization.k"
			    {
				{
#line 593 "ast-to-visualization.k"
#line 592 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 593 "ast-to-visualization.k"

				    if (startlist)
				    {
					startlist=false;
					globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    else
				    {

					globals::visArcs += globals::ASTEmap[_id->value]->visConnection + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
					if (globals::ASTEmap[innerActivity->id]->structured())
					{
					    globals::visArcs += "lhead=";
					    globals::visArcs += "cluster";          
					    globals::visArcs += toString(innerActivity->id);          
					    globals::visArcs += " ";          
					}
					if (laststructured)
					{
					    globals::visArcs += "ltail=";
					    globals::visArcs += "cluster";          
					    globals::visArcs += toString(lastid);          
					}
					globals::visArcs += "];\n";
				    }
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					lastid = innerActivity->id;
					laststructured = true;
				    }
				    else
				    laststructured = false;

				    globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;

#line  6895 "ast-system-unpk.cc"
				}
			    }

#line  6899 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 592 "ast-to-visualization.k"

#line  6904 "ast-system-unpk.cc"
		    }
		}
#line 628 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  6910 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1950 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1950 "ast-postprocess.k"
		const activity_list b = this->activity_list_1;
#line 1950 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1952 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		{
#line 1968 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  6944 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1968 "ast-postprocess.k"
			    {
				{
#line 1969 "ast-postprocess.k"
#line 1968 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1969 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  6963 "ast-system-unpk.cc"
				}
			    }

#line  6967 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1968 "ast-postprocess.k"

#line  6972 "ast-system-unpk.cc"
		    }
		}
#line 1975 "ast-postprocess.k"

#line  6977 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1977 "ast-postprocess.k"



		int activityCount = 1;
		{
#line 1981 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  6989 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1981 "ast-postprocess.k"
			    {
				{
#line 1982 "ast-postprocess.k"
#line 1981 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1982 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);

				    bool before = true;
				    {
#line 1986 "ast-postprocess.k"
					activity_list kc_fe_selvar_1 =  b;

#line  7010 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
					    ) {
					    activity kc_selvar_1_1 = kc_fe_selvar_1->activity_1;
					    {
#line 1986 "ast-postprocess.k"
						{
						    {
#line 1987 "ast-postprocess.k"
#line 1986 "ast-postprocess.k"
							const activity innerActivity2 = kc_selvar_1_1;
#line 1987 "ast-postprocess.k"

							if ( innerActivity2->id == innerActivity->id)
							{
							    before == false;
							}
							else if (before == true)
							{
							    enterConsecutiveActivities( innerActivity2->id, innerActivity->id );
							}

#line  7033 "ast-system-unpk.cc"
						    }
						}

#line  7037 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1986 "ast-postprocess.k"

#line  7042 "ast-system-unpk.cc"
					}
				    }
#line 1997 "ast-postprocess.k"


				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);


				    if (globals::ASTEmap[innerActivity->id]->isStartActivity && activityCount++ > 1)
				    SAerror(56, "<" + globals::ASTEmap[innerActivity->id]->activityTypeName() + ">", globals::ASTEmap[innerActivity->id]->attributes["referenceLine"]);

#line  7055 "ast-system-unpk.cc"
				}
			    }

#line  7059 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1981 "ast-postprocess.k"

#line  7064 "ast-system-unpk.cc"
		    }
		}
#line 2006 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7073 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 778 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 778 "ast-to-cfg.k"
		const activity_list b = this->activity_list_1;
#line 778 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 779 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Sequence\n");
		CFGBlock * firstBlock = new CFGBlock(CFGSequence, this->id, "Sequence_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGSequence, this->id, "Sequence_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7097 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 790 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		{
#line 792 "ast-to-cfg.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  7106 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 792 "ast-to-cfg.k"
			    {
				{
#line 793 "ast-to-cfg.k"
#line 792 "ast-to-cfg.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 793 "ast-to-cfg.k"

				    CFGBlock * current = globals::cfgMap.find(toString(innerActivity->id))->second;

				    connectBlocks(last, current->firstBlock);
				    last = current->lastBlock;

#line  7125 "ast-system-unpk.cc"
				}
			    }

#line  7129 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 792 "ast-to-cfg.k"

#line  7134 "ast-system-unpk.cc"
		    }
		}
#line 798 "ast-to-cfg.k"

		connectBlocks(last, lastBlock);

#line  7141 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 802 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Sequence\n");

#line  7147 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 377 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 377 "ast-to-xml.k"
		const activity_list b = this->activity_list_1;
#line 377 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 378 "ast-to-xml.k"
		inup(); 
#line  7162 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sequence id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 378 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7168 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 378 "ast-to-xml.k"
		indown(); 
#line  7174 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sequence>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 139 "ast-to-petrinet.k"
		PSequence(this, kc_current_view_base); 
#line  7184 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 139 "ast-to-petrinet.k"
		PSequence(this, kc_current_view_base); 
#line  7193 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  7198 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  7211 "ast-system-unpk.cc"
void
impl_tIf_If::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 638 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 638 "ast-to-visualization.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 638 "ast-to-visualization.k"
		const tElse c = this->tElse_1;
#line 638 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 640 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"If\";" << endl;  
		(*output) << "if" << toString(_id->value) << " [shape=diamond style=filled label=\"\"];" << endl;
		globals::ASTEmap[_id->value]->secVisConnection = "if" + toString(_id->value);

#line  7233 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 646 "ast-to-visualization.k"

		int middle = 0;

		{
#line 649 "ast-to-visualization.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7245 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 649 "ast-to-visualization.k"
			    {
#line 650 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 650 "ast-to-visualization.k"
#line 649 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 650 "ast-to-visualization.k"

				    middle += 1;

#line  7262 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7267 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 649 "ast-to-visualization.k"

#line  7272 "ast-system-unpk.cc"
		    }
		}
#line 653 "ast-to-visualization.k"

		{
#line 654 "ast-to-visualization.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 657 "ast-to-visualization.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 657 "ast-to-visualization.k"
#line 656 "ast-to-visualization.k"
			const tElse c = kc_selvar_0_1;
#line 656 "ast-to-visualization.k"
			const activity innerActivity = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 656 "ast-to-visualization.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 657 "ast-to-visualization.k"

			middle += 1;

#line  7293 "ast-system-unpk.cc"
		    } else
			kc_no_default_in_with( "", __LINE__, __FILE__ );
		}
#line 661 "ast-to-visualization.k"

		middle = middle/2 + (middle % 2);
		int childcounter=1;

		{
#line 665 "ast-to-visualization.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7306 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 665 "ast-to-visualization.k"
			    {
#line 666 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 666 "ast-to-visualization.k"
#line 665 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 666 "ast-to-visualization.k"

				    globals::visArcs += "if" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					globals::visArcs += "lhead=";
					globals::visArcs += "cluster";          
					globals::visArcs += toString(innerActivity->id);          
					globals::visArcs += " ";          
				    }
				    globals::visArcs += "];\n";

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter+=1;

#line  7337 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7342 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 665 "ast-to-visualization.k"

#line  7347 "ast-system-unpk.cc"
		    }
		}
#line 682 "ast-to-visualization.k"

		{
#line 683 "ast-to-visualization.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 686 "ast-to-visualization.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 686 "ast-to-visualization.k"
#line 685 "ast-to-visualization.k"
			const tElse c = kc_selvar_0_1;
#line 685 "ast-to-visualization.k"
			const activity innerActivity = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 685 "ast-to-visualization.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 686 "ast-to-visualization.k"

			globals::visArcs += "if" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
			if (globals::ASTEmap[innerActivity->id]->structured())
			{
			    globals::visArcs += "lhead=";
			    globals::visArcs += "cluster";          
			    globals::visArcs += toString(innerActivity->id);          
			    globals::visArcs += " ";          
			}
			globals::visArcs += "];\n";

			if (childcounter<=middle)
			{
			    globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
			}

#line  7381 "ast-system-unpk.cc"
		    } else
		    {
#line 702 "ast-to-visualization.k"
#line 702 "ast-to-visualization.k"


#line  7388 "ast-system-unpk.cc"
		    }
		}
#line 705 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  7395 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1719 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1719 "ast-postprocess.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 1719 "ast-postprocess.k"
		const tElse c = this->tElse_1;
#line 1719 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1721 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);


		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		globals::if_branches[myid] = 1;




		{
#line 1742 "ast-postprocess.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7436 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 1742 "ast-postprocess.k"
			    {
#line 1743 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 1743 "ast-postprocess.k"
#line 1742 "ast-postprocess.k"
				    const tElseIf branch = kc_selvar_0_1;
#line 1742 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 1742 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->integer_1;
#line 1743 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

				    globals::if_branches[myid]++;

#line  7462 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7467 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 1742 "ast-postprocess.k"

#line  7472 "ast-system-unpk.cc"
		    }
		}
#line 1751 "ast-postprocess.k"


		{
#line 1753 "ast-postprocess.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 1756 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 1756 "ast-postprocess.k"
#line 1755 "ast-postprocess.k"
			const tElse c = kc_selvar_0_1;
#line 1755 "ast-postprocess.k"
			const activity d = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 1755 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 1756 "ast-postprocess.k"

			assert(globals::ASTEmap[d->id] != NULL);
			globals::ASTEmap[d->id]->parentActivityId = myid;
			globals::ASTEmap[d->id]->controlFlow = myself->controlFlow;
			globals::ASTEmap[d->id]->max_occurrences = myself->max_occurrences;

#line  7497 "ast-system-unpk.cc"
		    } else
		    {
#line 1762 "ast-postprocess.k"
#line 1762 "ast-postprocess.k"

#line  7503 "ast-system-unpk.cc"
		    }
		}
#line 1764 "ast-postprocess.k"

#line  7508 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 1766 "ast-postprocess.k"


		{
#line 1768 "ast-postprocess.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7519 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 1768 "ast-postprocess.k"
			    {
#line 1769 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 1769 "ast-postprocess.k"
#line 1768 "ast-postprocess.k"
				    const tElseIf branch = kc_selvar_0_1;
#line 1768 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 1768 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->integer_1;
#line 1769 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);

#line  7542 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7547 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 1768 "ast-postprocess.k"

#line  7552 "ast-system-unpk.cc"
		    }
		}
#line 1774 "ast-postprocess.k"

		{
#line 1775 "ast-postprocess.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 1778 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 1778 "ast-postprocess.k"
#line 1777 "ast-postprocess.k"
			const tElse c = kc_selvar_0_1;
#line 1777 "ast-postprocess.k"
			const activity d = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 1777 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 1778 "ast-postprocess.k"

			assert(globals::ASTEmap[d->id] != NULL);
			myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[d->id]->enclosedSourceLinks);
			myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[d->id]->enclosedTargetLinks);

#line  7575 "ast-system-unpk.cc"
		    } else
		    {
#line 1783 "ast-postprocess.k"
#line 1783 "ast-postprocess.k"

#line  7581 "ast-system-unpk.cc"
		    }
		}
#line 1785 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7590 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    if ((this->tElse_1->prod_sel() == sel_Else)) {
#line 610 "ast-to-cfg.k"
		const tIf This = this/**/;
#line 610 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 610 "ast-to-cfg.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 610 "ast-to-cfg.k"
		const activity c = phylum_cast<const impl_tElse_Else*>(this->tElse_1)->activity_1;
#line 610 "ast-to-cfg.k"
		const integer d = phylum_cast<const impl_tElse_Else*>(this->tElse_1)->integer_1;
#line 610 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 611 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] If\n");
		CFGBlock * firstBlock = new CFGBlock(CFGIf, this->id, "If_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGIf, this->id, "If_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7620 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 623 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 626 "ast-to-cfg.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7631 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 626 "ast-to-cfg.k"
			    {
#line 627 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 627 "ast-to-cfg.k"
#line 626 "ast-to-cfg.k"
				    const tElseIf elseIfBranch = kc_selvar_0_1;
#line 626 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 627 "ast-to-cfg.k"

				    CFGBlock * elseIfBlock = new CFGBlock(CFGElseIf, This->id, "ElseIf_" + toString(i));

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(last, elseIfBlock);
				    connectBlocks(elseIfBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

				    last = elseIfBlock;	    
				    i++;

#line  7660 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7665 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 626 "ast-to-cfg.k"

#line  7670 "ast-system-unpk.cc"
		    }
		}
#line 639 "ast-to-cfg.k"

		CFGBlock * elseBlock = new CFGBlock(CFGElse, this->id, "Else");
		CFGBlock * innerFirst = globals::cfgMap.find(toString(c->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(c->id))->second->lastBlock;

		connectBlocks(last, elseBlock);
		connectBlocks(elseBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  7683 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    } else
		if ((this->tElse_1->prod_sel() == sel_NoElse)) {
#line 652 "ast-to-cfg.k"
		const tIf This = this/**/;
#line 652 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 652 "ast-to-cfg.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 652 "ast-to-cfg.k"
		const integer _id = phylum_cast<const impl_tElse_NoElse*>(this->tElse_1)->integer_1;
#line 652 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 653 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] If\n");
		CFGBlock * firstBlock = new CFGBlock(CFGIf, this->id, "If_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGIf, this->id, "If_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7708 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 664 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 667 "ast-to-cfg.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7718 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 667 "ast-to-cfg.k"
			    {
#line 668 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 668 "ast-to-cfg.k"
#line 667 "ast-to-cfg.k"
				    const tElseIf elseIfBranch = kc_selvar_0_1;
#line 667 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 668 "ast-to-cfg.k"

				    CFGBlock * elseIfBlock = new CFGBlock(CFGElseIf, This->id, "ElseIf_" + toString(i));

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(last, elseIfBlock);
				    connectBlocks(elseIfBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

				    last = elseIfBlock;	    
				    i++;

#line  7747 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7752 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 667 "ast-to-cfg.k"

#line  7757 "ast-system-unpk.cc"
		    }
		}
#line 680 "ast-to-cfg.k"










		connectBlocks(last, lastBlock);

#line  7773 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tElseIf_list_1->prod_sel() == sel_ConstElseIf_list) && ((this->tElseIf_list_1)->tElseIf_1->prod_sel() == sel_ElseIf)) {
#line 386 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 386 "ast-to-xml.k"
		const activity b = phylum_cast<const impl_tElseIf_ElseIf*>((this->tElseIf_list_1)->tElseIf_1)->activity_1;
#line 386 "ast-to-xml.k"
		const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>((this->tElseIf_list_1)->tElseIf_1)->integer_1;
#line 386 "ast-to-xml.k"
		const tElseIf_list c = (this->tElseIf_list_1)->tElseIf_list_1;
#line 386 "ast-to-xml.k"
		const tElse d = this->tElse_1;
#line 386 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 387 "ast-to-xml.k"
		inup(); 
#line  7796 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<if id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 387 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7802 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 387 "ast-to-xml.k"

#line  7806 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 387 "ast-to-xml.k"
		indown(); 
#line  7813 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</if>\n"), kc_current_view); }
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 151 "ast-to-petrinet.k"
		PIf(this, kc_current_view_base); 
#line  7824 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 151 "ast-to-petrinet.k"
		PIf(this, kc_current_view_base); 
#line  7833 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  7838 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tElseIf_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  7859 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tElseIf_list iterator_ = this; iterator_->tElseIf_list_1 != 0; iterator_ = iterator_->tElseIf_list_1)
		    iterator_->tElseIf_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tElseIf_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  7878 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  7891 "ast-system-unpk.cc"
void
impl_tElseIf_ElseIf::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 711 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 711 "ast-to-visualization.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1793 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 1793 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1795 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  7924 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1805 "ast-postprocess.k"

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7932 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 390 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 390 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 391 "ast-to-xml.k"
		inup(); 
#line  7945 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<elseif id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 391 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7951 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 391 "ast-to-xml.k"
		indown(); 
#line  7956 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</elseif>\n"), kc_current_view); }
	    }
	    break;
	}

#line  7962 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  7975 "ast-system-unpk.cc"
void
impl_tElse_NoElse::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1832 "ast-postprocess.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}

#line  7989 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8002 "ast-system-unpk.cc"
void
impl_tElse_Else::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 716 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 716 "ast-to-visualization.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1813 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 1813 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1815 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;

#line  8034 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1824 "ast-postprocess.k"

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  8042 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 394 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 394 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 395 "ast-to-xml.k"
		inup(); 
#line  8055 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<else id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 395 "ast-to-xml.k"
		indown(); 
#line  8062 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</else>\n"), kc_current_view); }
	    }
	    break;
	}

#line  8068 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8081 "ast-system-unpk.cc"
void
impl_tWhile_While::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 725 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 725 "ast-to-visualization.k"
		const activity b = this->activity_1;
#line 725 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 727 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"While\";" << endl;  

#line  8099 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 731 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[b->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[b->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  8108 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1839 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1839 "ast-postprocess.k"
		const activity b = this->activity_1;
#line 1839 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1841 "ast-postprocess.k"


		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		assert(globals::ASTEmap[b->id] != NULL);
		globals::ASTEmap[b->id]->parentActivityId = myid;
		globals::ASTEmap[b->id]->controlFlow = myself->controlFlow;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		globals::ASTEmap[b->id]->max_occurrences = myself->max_occurrences * max_loops;
		else
		globals::ASTEmap[b->id]->max_occurrences = UINT_MAX;

		myself->max_loops = max_loops;

#line  8152 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1872 "ast-postprocess.k"


		assert(globals::ASTEmap[b->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[b->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[b->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  8168 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 701 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 701 "ast-to-cfg.k"
		const activity b = this->activity_1;
#line 701 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 702 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] While\n");
		CFGBlock * block = new CFGBlock(CFGWhile, this->id, "While"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  8188 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 709 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(block, innerFirst);
		connectBlocks(innerLast, block);

#line  8198 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 403 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 403 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 403 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 404 "ast-to-xml.k"
		inup(); 
#line  8214 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<while id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 404 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8220 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 404 "ast-to-xml.k"
		indown(); 
#line  8226 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</while>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 131 "ast-to-petrinet.k"
		PWhile(this, kc_current_view_base); 
#line  8236 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 131 "ast-to-petrinet.k"
		PWhile(this, kc_current_view_base); 
#line  8245 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  8250 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8263 "ast-system-unpk.cc"
void
impl_tRepeatUntil_RepeatUntil::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 744 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 744 "ast-to-visualization.k"
		const activity b = this->activity_1;
#line 744 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 746 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"RepeatUntil\";" << endl;  

#line  8281 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 750 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[b->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[b->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  8290 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1895 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1895 "ast-postprocess.k"
		const activity b = this->activity_1;
#line 1895 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1897 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		assert(globals::ASTEmap[b->id] != NULL);
		globals::ASTEmap[b->id]->parentActivityId = myid;
		globals::ASTEmap[b->id]->controlFlow = myself->controlFlow;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		globals::ASTEmap[b->id]->max_occurrences = myself->max_occurrences * max_loops;
		else
		globals::ASTEmap[b->id]->max_occurrences = UINT_MAX;

		myself->max_loops = max_loops;

#line  8333 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1927 "ast-postprocess.k"


		assert(globals::ASTEmap[b->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[b->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[b->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  8349 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 749 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 749 "ast-to-cfg.k"
		const activity b = this->activity_1;
#line 749 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 750 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] RepeatUntil\n");
		CFGBlock * repeat = new CFGBlock(CFGRepeatUntil, this->id, "Repeat"); 
		CFGBlock * until = new CFGBlock(CFGRepeatUntil, this->id, "Until"); 

		repeat->firstBlock = until->firstBlock = repeat;
		repeat->lastBlock  = until->lastBlock  = until;

		globals::cfgMap[toString(this->id)] = repeat; 

#line  8373 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 761 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(repeat, innerFirst);
		connectBlocks(innerLast, until);
		connectBlocks(until, repeat);

#line  8384 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 412 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 412 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 412 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 413 "ast-to-xml.k"
		inup(); 
#line  8400 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<repeatUntil id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 413 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8406 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 413 "ast-to-xml.k"
		indown(); 
#line  8412 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</repeatUntil>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 135 "ast-to-petrinet.k"
		PRepeatUntil(this, kc_current_view_base); 
#line  8422 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 135 "ast-to-petrinet.k"
		PRepeatUntil(this, kc_current_view_base); 
#line  8431 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  8436 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8449 "ast-system-unpk.cc"
void
impl_tForEach_ForEach::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 763 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 763 "ast-to-visualization.k"
		const casestring b = this->casestring_1;
#line 763 "ast-to-visualization.k"
		const casestring c = this->casestring_2;
#line 763 "ast-to-visualization.k"
		const casestring d = this->casestring_3;
#line 763 "ast-to-visualization.k"
		const tScope e = this->tScope_1;
#line 763 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 765 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"ForEach\";" << endl;  

#line  8473 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 769 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[e->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[e->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  8481 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2119 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 2119 "ast-postprocess.k"
		const casestring b = this->casestring_1;
#line 2119 "ast-postprocess.k"
		const casestring c = this->casestring_2;
#line 2119 "ast-postprocess.k"
		const casestring d = this->casestring_3;
#line 2119 "ast-postprocess.k"
		const tScope e = this->tScope_1;
#line 2119 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 2121 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);    

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();



		myself->checkVariable("counterName");


		assert(globals::ASTEmap[e->id] != NULL);
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[e->id]->controlFlow = myself->controlFlow;


		unsigned int startCounter = toUInt(b->name);
		unsigned int finalCounter = toUInt(c->name);
		unsigned int completion = toUInt(d->name);

		if (startCounter != UINT_MAX && finalCounter != UINT_MAX)
		{
		    if (startCounter >= finalCounter)
		    {
			string error = "constant <finalCounterValue> `" + toString(finalCounter) +
			"' less or equal than constant <startCounterValue> `" + toString(startCounter) + "'";
			SAerror(74, error, myself->attributes["referenceLine"]);
		    }
		    else
		    {
			if (myself->attributes["hu:maxloops"] != "")
			cerr << "ignoring attribute `hu:maxloops'" << endl; 
			globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences * (finalCounter - startCounter);
			myself->max_loops = (finalCounter - startCounter);
		    }

		    if ((completion != UINT_MAX) && ((completion > (finalCounter-startCounter))))
		    SAerror(75, "", myself->attributes["referenceLine"]);
		}
		else
		{

		    if ((globals::choreography_filename != "") && (string(b->name) == "opaque") && (string(c->name) == "opaque"))
		    {

			myself->max_loops = globals::BPEL4ChorInfo.forEach_count(myid);
		    }
		    else
		    {

			unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
			if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
			globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences * max_loops;
			else
			globals::ASTEmap[e->id]->max_occurrences = UINT_MAX;

			myself->max_loops = max_loops;
		    }
		}

#line  8566 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
#line 2187 "ast-postprocess.k"


		{
#line 2189 "ast-postprocess.k"
		    tScope kc_selvar_0_1 = phylum_cast<tScope>(e);
#line 2192 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Scope)) {
#line 2192 "ast-postprocess.k"
#line 2191 "ast-postprocess.k"
			const tScope e = kc_selvar_0_1;
#line 2191 "ast-postprocess.k"
			const tVariable_list _variables = phylum_cast<const impl_tScope_Scope*>(kc_selvar_0_1)->tVariable_list_1;
#line 2191 "ast-postprocess.k"
			const tMessageExchange_list messageExchange = phylum_cast<const impl_tScope_Scope*>(kc_selvar_0_1)->tMessageExchange_list_1;
#line 2192 "ast-postprocess.k"

			{
#line 2193 "ast-postprocess.k"
			    tVariable_list kc_fe_selvar_1 =  _variables;

#line  8590 "ast-system-unpk.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstVariable_list
				) {
				tVariable kc_selvar_1_1 = kc_fe_selvar_1->tVariable_1;
				{
#line 2193 "ast-postprocess.k"
				    {
#line 2194 "ast-postprocess.k"
					if ((kc_selvar_1_1->prod_sel() == sel_Variable)) {
#line 2194 "ast-postprocess.k"
#line 2193 "ast-postprocess.k"
					    const tVariable variable = kc_selvar_1_1;
#line 2193 "ast-postprocess.k"
					    const integer _id2 = phylum_cast<const impl_tVariable_Variable*>(kc_selvar_1_1)->integer_1;
#line 2194 "ast-postprocess.k"

					    assert(_id2 != NULL);
					    assert(globals::ASTEmap[_id2->value] != NULL);
					    if (globals::ASTEmap[_id2->value]->attributes["name"] == globals::ASTEmap[_id->value]->attributes["counterName"])
					    SAerror(76, globals::ASTEmap[_id2->value]->attributes["name"], globals::ASTEmap[_id2->value]->attributes["referenceLine"]);

#line  8612 "ast-system-unpk.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  8617 "ast-system-unpk.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tVariable_list_1;
#line 2193 "ast-postprocess.k"

#line  8622 "ast-system-unpk.cc"
			    }
			}
#line 2199 "ast-postprocess.k"


#line  8628 "ast-system-unpk.cc"
		    } else
			kc_no_default_in_with( "", __LINE__, __FILE__ );
		}
#line 2202 "ast-postprocess.k"


		assert(globals::ASTEmap[e->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[e->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  8645 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 725 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 725 "ast-to-cfg.k"
		const casestring b = this->casestring_1;
#line 725 "ast-to-cfg.k"
		const casestring c = this->casestring_2;
#line 725 "ast-to-cfg.k"
		const casestring d = this->casestring_3;
#line 725 "ast-to-cfg.k"
		const tScope e = this->tScope_1;
#line 725 "ast-to-cfg.k"
		const integer f = this->integer_1;
#line 726 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ForEach\n");
		CFGBlock * block = new CFGBlock(CFGForEach, this->id, "ForEach"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  8671 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 733 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(e->id))->second->lastBlock;

		connectBlocks(block, innerFirst);
		connectBlocks(innerLast, block);

#line  8681 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 421 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 421 "ast-to-xml.k"
		const casestring b = this->casestring_1;
#line 421 "ast-to-xml.k"
		const casestring c = this->casestring_2;
#line 421 "ast-to-xml.k"
		const casestring d = this->casestring_3;
#line 421 "ast-to-xml.k"
		const tScope e = this->tScope_1;
#line 421 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 422 "ast-to-xml.k"
		inup(); 
#line  8703 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<foreach id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 422 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8709 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 424 "ast-to-xml.k"
		inup(); 
#line  8714 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<startCounterValue>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 424 "ast-to-xml.k"
		indown(); 
#line  8719 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</startCounterValue>\n"), kc_current_view); }
#line 425 "ast-to-xml.k"
		inup(); 
#line  8723 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<finalCounterValue>\n"), kc_current_view); }
		kc::unparse(c, kc_printer, kc_current_view);
#line 425 "ast-to-xml.k"
		indown(); 
#line  8728 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</finalCounterValue>\n"), kc_current_view); }
#line 426 "ast-to-xml.k"
		inup(); 
#line  8732 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<completionCondition>\n"), kc_current_view); }
		kc::unparse(d, kc_printer, kc_current_view);
#line 426 "ast-to-xml.k"
		indown(); 
#line  8737 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</completionCondition>\n"), kc_current_view); }
		kc::unparse(e, kc_printer, kc_current_view);
#line 428 "ast-to-xml.k"
		indown(); 
#line  8742 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</repeatUntil>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 155 "ast-to-petrinet.k"
		PForEach(this, kc_current_view_base); 
#line  8752 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 155 "ast-to-petrinet.k"
		PForEach(this, kc_current_view_base); 
#line  8761 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  8766 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8779 "ast-system-unpk.cc"
void
impl_tPick_Pick::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 782 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 782 "ast-to-visualization.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 782 "ast-to-visualization.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 782 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 784 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Pick\";" << endl;  
		(*output) << "pick" << toString(_id->value) << " [shape=diamond style=filled label=\"?\"];" << endl;
		globals::ASTEmap[_id->value]->secVisConnection = "pick" + toString(_id->value);

#line  8801 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 790 "ast-to-visualization.k"

		int middle = 0;
		{
#line 792 "ast-to-visualization.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  8812 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 792 "ast-to-visualization.k"
			    {
#line 793 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 793 "ast-to-visualization.k"
#line 792 "ast-to-visualization.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 792 "ast-to-visualization.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 792 "ast-to-visualization.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 792 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 792 "ast-to-visualization.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 793 "ast-to-visualization.k"

				    middle+=1;

#line  8837 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8842 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 792 "ast-to-visualization.k"

#line  8847 "ast-system-unpk.cc"
		    }
		}
#line 796 "ast-to-visualization.k"
		{
#line 796 "ast-to-visualization.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  8855 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 796 "ast-to-visualization.k"
			    {
#line 797 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 797 "ast-to-visualization.k"
#line 796 "ast-to-visualization.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 796 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 796 "ast-to-visualization.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 797 "ast-to-visualization.k"

				    middle+=1;

#line  8876 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8881 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 796 "ast-to-visualization.k"

#line  8886 "ast-system-unpk.cc"
		    }
		}
#line 800 "ast-to-visualization.k"

		middle = middle/2 + (middle % 2);
		int childcounter = 1;

		{
#line 804 "ast-to-visualization.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  8898 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 804 "ast-to-visualization.k"
			    {
#line 805 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 805 "ast-to-visualization.k"
#line 804 "ast-to-visualization.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 804 "ast-to-visualization.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 804 "ast-to-visualization.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 804 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 804 "ast-to-visualization.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 805 "ast-to-visualization.k"

				    globals::visArcs += "pick" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					globals::visArcs += "lhead=";
					globals::visArcs += "cluster";          
					globals::visArcs += toString(innerActivity->id);          
					globals::visArcs += " ";          
				    }
				    globals::visArcs += "];\n";

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  8937 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8942 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 804 "ast-to-visualization.k"

#line  8947 "ast-system-unpk.cc"
		    }
		}
#line 822 "ast-to-visualization.k"
		{
#line 822 "ast-to-visualization.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  8955 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 822 "ast-to-visualization.k"
			    {
#line 823 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 823 "ast-to-visualization.k"
#line 822 "ast-to-visualization.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 822 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 822 "ast-to-visualization.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 823 "ast-to-visualization.k"

				    globals::visArcs += "pick" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					globals::visArcs += "lhead=";
					globals::visArcs += "cluster";          
					globals::visArcs += toString(innerActivity->id);          
					globals::visArcs += " ";          
				    }
				    globals::visArcs += "];\n";

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  8990 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8995 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 822 "ast-to-visualization.k"

#line  9000 "ast-system-unpk.cc"
		    }
		}
#line 840 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  9006 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2019 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 2019 "ast-postprocess.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 2019 "ast-postprocess.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 2019 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 2021 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		{
#line 2037 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  9042 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 2037 "ast-postprocess.k"
			    {
#line 2038 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 2038 "ast-postprocess.k"
#line 2037 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 2037 "ast-postprocess.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 2037 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 2037 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 2037 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 2038 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id2->value]->max_occurrences = myself->max_occurrences;

#line  9071 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9076 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2037 "ast-postprocess.k"

#line  9081 "ast-system-unpk.cc"
		    }
		}
#line 2045 "ast-postprocess.k"
		{
#line 2045 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9089 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 2045 "ast-postprocess.k"
			    {
#line 2046 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 2046 "ast-postprocess.k"
#line 2045 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 2045 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 2045 "ast-postprocess.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 2046 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id3->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id3->value]->max_occurrences = myself->max_occurrences;

#line  9114 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9119 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 2045 "ast-postprocess.k"

#line  9124 "ast-system-unpk.cc"
		    }
		}
#line 2053 "ast-postprocess.k"

#line  9129 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 2055 "ast-postprocess.k"

		if (myself->isStartActivity)
		{
		    globals::ASTE_startActivities.insert(myid);


		    if (c->length() != 0)
		    SAerror(62, "", myself->attributes["referenceLine"]);


		    if (!globals::ASTEmap[myself->parentActivityId]->checkAncestors() || !myself->targetLinks.empty())
		    SAerror(56, "<pick>", myself->attributes["referenceLine"]);
		}


		{
#line 2070 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  9153 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 2070 "ast-postprocess.k"
			    {
#line 2071 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 2071 "ast-postprocess.k"
#line 2070 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 2070 "ast-postprocess.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 2070 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 2070 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 2070 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 2071 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);

				    {
#line 2076 "ast-postprocess.k"
					tOnMessage_list kc_fe_selvar_1 =  b;

#line  9184 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
					    ) {
					    tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
					    {
#line 2076 "ast-postprocess.k"
						{
#line 2077 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 2077 "ast-postprocess.k"
#line 2076 "ast-postprocess.k"
							const tOnMessage otherbranch = kc_selvar_1_1;
#line 2076 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 2076 "ast-postprocess.k"
							const integer _id3 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->integer_1;
#line 2077 "ast-postprocess.k"

							assert(_id2 != NULL);
							assert(_id3 != NULL);
							if (_id2->value < _id3->value)
							{
							    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );
							}

#line  9210 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  9215 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2076 "ast-postprocess.k"

#line  9220 "ast-system-unpk.cc"
					}
				    }
#line 2085 "ast-postprocess.k"

#line  9225 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9230 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2070 "ast-postprocess.k"

#line  9235 "ast-system-unpk.cc"
		    }
		}
#line 2086 "ast-postprocess.k"
		{
#line 2086 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9243 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 2086 "ast-postprocess.k"
			    {
#line 2087 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 2087 "ast-postprocess.k"
#line 2086 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 2086 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 2087 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);

				    {
#line 2092 "ast-postprocess.k"
					tOnMessage_list kc_fe_selvar_1 =  b;

#line  9268 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
					    ) {
					    tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
					    {
#line 2092 "ast-postprocess.k"
						{
#line 2093 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 2093 "ast-postprocess.k"
#line 2092 "ast-postprocess.k"
							const tOnMessage otherbranch = kc_selvar_1_1;
#line 2092 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 2093 "ast-postprocess.k"

							enterConflictingActivities( globals::ASTEmap[ innerActivity->id ]->enclosedActivities, globals::ASTEmap[ secondActivity->id ]->enclosedActivities );

#line  9287 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  9292 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2092 "ast-postprocess.k"

#line  9297 "ast-system-unpk.cc"
					}
				    }
#line 2096 "ast-postprocess.k"

				    {
#line 2097 "ast-postprocess.k"
					tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9306 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
					    ) {
					    tOnAlarm kc_selvar_1_1 = kc_fe_selvar_1->tOnAlarm_1;
					    {
#line 2097 "ast-postprocess.k"
						{
#line 2098 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnAlarm)) {
#line 2098 "ast-postprocess.k"
#line 2097 "ast-postprocess.k"
							const tOnAlarm otherbranch = kc_selvar_1_1;
#line 2097 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_1_1)->activity_1;
#line 2098 "ast-postprocess.k"

							if (innerActivity->id < secondActivity->id)
							{
							    enterConflictingActivities( globals::ASTEmap[ innerActivity->id ]->enclosedActivities, globals::ASTEmap[ secondActivity->id ]->enclosedActivities );
							}

#line  9328 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  9333 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 2097 "ast-postprocess.k"

#line  9338 "ast-system-unpk.cc"
					}
				    }
#line 2104 "ast-postprocess.k"

#line  9343 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9348 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 2086 "ast-postprocess.k"

#line  9353 "ast-system-unpk.cc"
		    }
		}
#line 2105 "ast-postprocess.k"


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  9363 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 813 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 813 "ast-to-cfg.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 813 "ast-to-cfg.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 813 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 814 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Pick\n");
		CFGBlock * firstBlock = new CFGBlock(CFGPick, this->id, "Pick_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGPick, this->id, "Pick_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  9389 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 826 "ast-to-cfg.k"

		int i = 1;
		{
#line 828 "ast-to-cfg.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  9399 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 828 "ast-to-cfg.k"
			    {
#line 829 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 829 "ast-to-cfg.k"
#line 828 "ast-to-cfg.k"
				    const tOnMessage message = kc_selvar_0_1;
#line 828 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 829 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onMessageBlock = new CFGBlock(CFGOnMessage, message->id, "OnMessage_" + toString(i++)); 
				    onMessageBlock->channel_name = globals::ASTEmap[message->id]->channelName;

				    connectBlocks(firstBlock, onMessageBlock);
				    connectBlocks(onMessageBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  9425 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9430 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 828 "ast-to-cfg.k"

#line  9435 "ast-system-unpk.cc"
		    }
		}
#line 838 "ast-to-cfg.k"

		i = 1; 
		{
#line 840 "ast-to-cfg.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9445 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 840 "ast-to-cfg.k"
			    {
#line 841 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 841 "ast-to-cfg.k"
#line 840 "ast-to-cfg.k"
				    const tOnAlarm alarm = kc_selvar_0_1;
#line 840 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 841 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onAlarmBlock = new CFGBlock(CFGOnAlarm, alarm->id, "OnAlarm_" + toString(i++)); 

				    connectBlocks(firstBlock, onAlarmBlock);
				    connectBlocks(onAlarmBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  9470 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9475 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 840 "ast-to-cfg.k"

#line  9480 "ast-system-unpk.cc"
		    }
		}
#line 849 "ast-to-cfg.k"


#line  9486 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 436 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 436 "ast-to-xml.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 436 "ast-to-xml.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 436 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 437 "ast-to-xml.k"
		inup(); 
#line  9504 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<pick id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 437 "ast-to-xml.k"
		listAttributes( _id ); 
#line  9510 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 437 "ast-to-xml.k"
		indown(); 
#line  9517 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</pick>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 147 "ast-to-petrinet.k"
		PPick(this, kc_current_view_base); 
#line  9527 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 147 "ast-to-petrinet.k"
		PPick(this, kc_current_view_base); 
#line  9536 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  9541 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  9554 "ast-system-unpk.cc"
void
impl_tFlow_Flow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    if ((this->tLink_list_1->prod_sel() == sel_NiltLink_list)) {
#line 850 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 850 "ast-to-visualization.k"
		const activity_list c = this->activity_list_1;
#line 850 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 852 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Flow\";" << endl;  

#line  9572 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 856 "ast-to-visualization.k"

		int middle = 0;
		{
#line 858 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9582 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 858 "ast-to-visualization.k"
			    {
				{
#line 859 "ast-to-visualization.k"
#line 858 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 859 "ast-to-visualization.k"

				    middle+=1;

#line  9598 "ast-system-unpk.cc"
				}
			    }

#line  9602 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 858 "ast-to-visualization.k"

#line  9607 "ast-system-unpk.cc"
		    }
		}
#line 862 "ast-to-visualization.k"
		middle = middle/2 + (middle % 2);
		int childcounter = 1;
		{
#line 864 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9617 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 864 "ast-to-visualization.k"
			    {
				{
#line 865 "ast-to-visualization.k"
#line 864 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 865 "ast-to-visualization.k"

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[innerActivity->id]->secVisConnection;
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  9638 "ast-system-unpk.cc"
				}
			    }

#line  9642 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 864 "ast-to-visualization.k"

#line  9647 "ast-system-unpk.cc"
		    }
		}
#line 873 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  9653 "ast-system-unpk.cc"
	    } else
	    {
#line 878 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 878 "ast-to-visualization.k"
		const tLink_list b = this->tLink_list_1;
#line 878 "ast-to-visualization.k"
		const activity_list c = this->activity_list_1;
#line 878 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 880 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Flow\";" << endl;  

#line  9668 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 884 "ast-to-visualization.k"

		int middle = 0;
		{
#line 886 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9679 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 886 "ast-to-visualization.k"
			    {
				{
#line 887 "ast-to-visualization.k"
#line 886 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 887 "ast-to-visualization.k"

				    middle+=1;

#line  9695 "ast-system-unpk.cc"
				}
			    }

#line  9699 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 886 "ast-to-visualization.k"

#line  9704 "ast-system-unpk.cc"
		    }
		}
#line 890 "ast-to-visualization.k"
		middle = middle/2 + (middle % 2);
		int childcounter = 1;    

		{
#line 893 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9715 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 893 "ast-to-visualization.k"
			    {
				{
#line 894 "ast-to-visualization.k"
#line 893 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 894 "ast-to-visualization.k"

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[innerActivity->id]->secVisConnection;
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  9736 "ast-system-unpk.cc"
				}
			    }

#line  9740 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 893 "ast-to-visualization.k"

#line  9745 "ast-system-unpk.cc"
		    }
		}
#line 902 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  9751 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1618 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1618 "ast-postprocess.k"
		const tLink_list b = this->tLink_list_1;
#line 1618 "ast-postprocess.k"
		const activity_list c = this->activity_list_1;
#line 1618 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1620 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		{
#line 1637 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9788 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1637 "ast-postprocess.k"
			    {
				{
#line 1638 "ast-postprocess.k"
#line 1637 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1638 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  9807 "ast-system-unpk.cc"
				}
			    }

#line  9811 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1637 "ast-postprocess.k"

#line  9816 "ast-system-unpk.cc"
		    }
		}
#line 1644 "ast-postprocess.k"
		{
#line 1644 "ast-postprocess.k"
		    tLink_list kc_fe_selvar_1 =  b;

#line  9824 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstLink_list
			) {
			tLink kc_selvar_0_1 = kc_fe_selvar_1->tLink_1;
			{
#line 1644 "ast-postprocess.k"
			    {
				{
#line 1645 "ast-postprocess.k"
#line 1644 "ast-postprocess.k"
				    const tLink link = kc_selvar_0_1;
#line 1645 "ast-postprocess.k"

				    assert(globals::ASTEmap[link->id] != NULL);
				    globals::ASTEmap[ link->id ]->parentActivityId = myid;
				    globals::ASTEmap[ myid ]->enclosedActivities.insert( link->id );

#line  9842 "ast-system-unpk.cc"
				}
			    }

#line  9846 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tLink_list_1;
#line 1644 "ast-postprocess.k"

#line  9851 "ast-system-unpk.cc"
		    }
		}
#line 1650 "ast-postprocess.k"

#line  9856 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 1652 "ast-postprocess.k"


		unsigned int startActivityId = 0;

		{
#line 1656 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9869 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1656 "ast-postprocess.k"
			    {
				{
#line 1657 "ast-postprocess.k"
#line 1656 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1657 "ast-postprocess.k"


				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);


				    if (globals::ASTEmap[innerActivity->id]->isStartActivity)
				    startActivityId = innerActivity->id;

#line  9892 "ast-system-unpk.cc"
				}
			    }

#line  9896 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1656 "ast-postprocess.k"

#line  9901 "ast-system-unpk.cc"
		    }
		}
#line 1667 "ast-postprocess.k"


		if (startActivityId != 0)
		{
		    {
#line 1671 "ast-postprocess.k"
			activity_list kc_fe_selvar_1 =  c;

#line  9913 "ast-system-unpk.cc"
			while(
				kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			    ) {
			    activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			    {
#line 1671 "ast-postprocess.k"
				{
				    {
#line 1672 "ast-postprocess.k"
#line 1671 "ast-postprocess.k"
					const activity innerActivity = kc_selvar_0_1;
#line 1672 "ast-postprocess.k"

					assert(globals::ASTEmap[innerActivity->id] != NULL);

					if (!globals::ASTEmap[innerActivity->id]->isStartActivity &&
					    globals::ASTEmap[innerActivity->id]->targetLinks.empty())
					{
					    SAerror(56, "<" + globals::ASTEmap[startActivityId]->activityTypeName() + ">", globals::ASTEmap[startActivityId]->attributes["referenceLine"]);
					    break;
					}

#line  9936 "ast-system-unpk.cc"
				    }
				}

#line  9940 "ast-system-unpk.cc"
			    }
			    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1671 "ast-postprocess.k"

#line  9945 "ast-system-unpk.cc"
			}
		    }
#line 1682 "ast-postprocess.k"
		}




		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  9958 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 576 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 576 "ast-to-cfg.k"
		const tLink_list b = this->tLink_list_1;
#line 576 "ast-to-cfg.k"
		const activity_list c = this->activity_list_1;
#line 576 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 577 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Flow\n");
		CFGBlock * firstBlock = new CFGBlock(CFGFlow, this->id, "Flow_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGFlow, this->id, "Flow_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  9984 "ast-system-unpk.cc"
		kc::unparse(c, kc_printer, kc_current_view);
#line 588 "ast-to-cfg.k"

		{
#line 589 "ast-to-cfg.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9992 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 589 "ast-to-cfg.k"
			    {
				{
#line 590 "ast-to-cfg.k"
#line 589 "ast-to-cfg.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 590 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(firstBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  10012 "ast-system-unpk.cc"
				}
			    }

#line  10016 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 589 "ast-to-cfg.k"

#line  10021 "ast-system-unpk.cc"
		    }
		}
#line 596 "ast-to-cfg.k"


#line  10027 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 599 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Flow\n");

#line  10033 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tLink_list_1->prod_sel() == sel_NiltLink_list)) {
#line 445 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 445 "ast-to-xml.k"
		const activity_list c = this->activity_list_1;
#line 445 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 446 "ast-to-xml.k"
		inup(); 
#line  10048 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<flow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 446 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10054 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 446 "ast-to-xml.k"
		indown(); 
#line  10060 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</flow>\n"), kc_current_view); }
	    } else
	    {
#line 449 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 449 "ast-to-xml.k"
		const tLink_list b = this->tLink_list_1;
#line 449 "ast-to-xml.k"
		const activity_list c = this->activity_list_1;
#line 449 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 450 "ast-to-xml.k"
		inup(); 
#line  10074 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<flow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 450 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10080 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 450 "ast-to-xml.k"
		inup(); 
#line  10085 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<links>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 450 "ast-to-xml.k"
		indown(); 
#line  10090 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</links>\n"), kc_current_view); }
		kc::unparse(c, kc_printer, kc_current_view);
#line 450 "ast-to-xml.k"
		indown(); 
#line  10095 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</flow>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 143 "ast-to-petrinet.k"
		PFlow(this, kc_current_view_base); 
#line  10105 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 143 "ast-to-petrinet.k"
		PFlow(this, kc_current_view_base); 
#line  10114 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  10119 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tLink_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  10139 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tLink_list iterator_ = this; iterator_->tLink_list_1 != 0; iterator_ = iterator_->tLink_list_1)
		    iterator_->tLink_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tLink_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  10157 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  10169 "ast-system-unpk.cc"
void
impl_tLink_Link::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 907 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1694 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1696 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->linkName = myself->defineLink();

		globals::ASTE_linkIdMap[ myself->linkName ] = myid;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  10203 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 453 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 454 "ast-to-xml.k"
		in(); 
#line  10214 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<link id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 454 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10220 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  10226 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  10239 "ast-system-unpk.cc"
void
impl_tScope_Scope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 916 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 916 "ast-to-visualization.k"
		const tVariable_list b = this->tVariable_list_1;
#line 916 "ast-to-visualization.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 916 "ast-to-visualization.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 916 "ast-to-visualization.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 916 "ast-to-visualization.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 916 "ast-to-visualization.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 916 "ast-to-visualization.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 916 "ast-to-visualization.k"
		const activity i = this->activity_1;
#line 916 "ast-to-visualization.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 916 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 918 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value+1000) << " { label = \"Scope\";" << endl;  

#line  10273 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 922 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Scope Activity\";" << endl;  

#line  10285 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 926 "ast-to-visualization.k"

		(*output) << "}" << endl;    

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[i->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[i->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  10295 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2222 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 2222 "ast-postprocess.k"
		const tVariable_list b = this->tVariable_list_1;
#line 2222 "ast-postprocess.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 2222 "ast-postprocess.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 2222 "ast-postprocess.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 2222 "ast-postprocess.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 2222 "ast-postprocess.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 2222 "ast-postprocess.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 2222 "ast-postprocess.k"
		const activity i = this->activity_1;
#line 2222 "ast-postprocess.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 2222 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 2224 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);
		a->parentId = myid;




		myself->parentScopeId = globals::PPcurrentScope;


		globals::PPcurrentScope = myid;

		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		assert(globals::ASTEmap[myself->parentScopeId] != NULL);
		myself->checkAttributes();

		for ( std::set<unsigned int>::iterator peerScope = globals::ASTEmap[myself->parentScopeId]->enclosedScopes.begin(); 
		    peerScope != globals::ASTEmap[myself->parentScopeId]->enclosedScopes.end(); 
		    peerScope++)
		{
		    globals::ASTEmap[*peerScope]->peerScopes.insert(myid);
		    globals::ASTEmap[myid]->peerScopes.insert(*peerScope);
		}




		if (myself->controlFlow == POSITIVECF)
		globals::ASTEmap[myself->parentScopeId]->enclosedScopes.insert(myid);

		myself->hasEH = (string(f->op_name()) == "EventHandlers");



		assert(globals::ASTEmap[c->id] != NULL);
		assert(globals::ASTEmap[d->id] != NULL);
		assert(globals::ASTEmap[e->id] != NULL);
		assert(globals::ASTEmap[f->id] != NULL);
		assert(globals::ASTEmap[i->id] != NULL);
		globals::ASTEmap[c->id]->parentActivityId = myid;
		globals::ASTEmap[d->id]->parentActivityId = myid;
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[f->id]->parentActivityId = myid;
		globals::ASTEmap[i->id]->parentActivityId = myid;

		myself->enclosedFH = c->id;
		myself->enclosedCH = d->id;

		globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[d->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[f->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[i->id]->max_occurrences = myself->max_occurrences;


		if (myself->attributes["name"] != "")
		{

		    if (globals::ASTE_scopeNames[myself->attributes["name"]] != 0)
		    SAerror(92, myself->attributes["name"], myself->attributes["referenceLine"]);

		    globals::ASTE_scopeNames[myself->attributes["name"]] = myid;
		}


		if (myself->attributes["isolated"] == "yes" &&
		    globals::ASTEmap[myself->parentScopeId]->findIsolatedAncestor())
		SAerror(91, "", myself->attributes["referenceLine"]);

#line  10397 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(messageExchange, kc_printer, kc_current_view);
		kc::unparse(j, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
#line 2299 "ast-postprocess.k"


		bool callableFH = false;
		for ( set< string >::iterator fault = globals::ASTEmap[ c->id ]->catches.begin(); fault != globals::ASTEmap[ c->id ]->catches.end(); fault++)
		{
		    string faultName = fault->substr( fault->find_first_of( "|" ) + 1 );
		    faultName = faultName.substr( 0, faultName.find_first_of( "|" ) );
		    if (faultName.find_first_of(":") < faultName.npos)
		    {
			faultName = faultName.substr( faultName.find_first_of(":") + 1 );
		    }

		    if ( myself->possiblyTriggeredFaults.find( faultName ) != myself->possiblyTriggeredFaults.end() )
		    {
			callableFH = true;


		    }
		}
		if ( globals::ASTEmap[ c->id ]->hasCatchAll && ! myself->possiblyTriggeredFaults.empty() )
		{
		    callableFH = true;
		}

		globals::ASTEmap[ c->id ]->callable = callableFH;

		set< unsigned int > innerIds = globals::ASTEmap[ i->id ]->enclosedActivities;
		innerIds.insert( i->id );
		set< unsigned int > faultIds = globals::ASTEmap[ c->id ]->enclosedActivities;
		faultIds.insert( c->id );
		set< unsigned int > compIds = globals::ASTEmap[ d->id ]->enclosedActivities;
		compIds.insert( d->id );

		enterConflictingActivities( innerIds, faultIds );
		enterConflictingActivities( faultIds, compIds );


		globals::ASTEmap[d->id]->enclosedScopes = myself->enclosedScopes;


		assert(globals::ASTEmap[i->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[i->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[c->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[d->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[f->id]->enclosedSourceLinks);

		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[i->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[c->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[d->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[e->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[f->id]->enclosedTargetLinks);



		globals::PPcurrentScope = myself->parentScopeId;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );



		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(120, "", myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  10476 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 860 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 860 "ast-to-cfg.k"
		const tVariable_list b = this->tVariable_list_1;
#line 860 "ast-to-cfg.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 860 "ast-to-cfg.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 860 "ast-to-cfg.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 860 "ast-to-cfg.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 860 "ast-to-cfg.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 860 "ast-to-cfg.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 860 "ast-to-cfg.k"
		const activity i = this->activity_1;
#line 860 "ast-to-cfg.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 860 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 861 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Scope\n");
		CFGBlock * firstBlock = new CFGBlock(CFGScope, this->id, "Scope_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGScope, this->id, "Scope_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  10516 "ast-system-unpk.cc"
		kc::unparse(c, kc_printer, kc_current_view);
#line 872 "ast-to-cfg.k"

		CFGBlock * fhFirst = globals::cfgMap.find(toString(c->id))->second->firstBlock;
		CFGBlock * fhLast  = globals::cfgMap.find(toString(c->id))->second->lastBlock;

		connectBlocks(firstBlock, fhFirst);
		connectBlocks(fhLast, lastBlock);


#line  10527 "ast-system-unpk.cc"
		kc::unparse(d, kc_printer, kc_current_view);
#line 881 "ast-to-cfg.k"

		CFGBlock * chFirst = globals::cfgMap.find(toString(d->id))->second->firstBlock;
		CFGBlock * chLast  = globals::cfgMap.find(toString(d->id))->second->lastBlock;

		connectBlocks(firstBlock, chFirst);
		connectBlocks(chLast, lastBlock);


#line  10538 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 890 "ast-to-cfg.k"

		CFGBlock * thFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock * thLast  = globals::cfgMap.find(toString(e->id))->second->lastBlock;

		connectBlocks(firstBlock, thFirst);
		connectBlocks(thLast, lastBlock);


#line  10549 "ast-system-unpk.cc"
		kc::unparse(f, kc_printer, kc_current_view);
#line 899 "ast-to-cfg.k"

		CFGBlock * ehFirst = globals::cfgMap.find(toString(f->id))->second->firstBlock;
		CFGBlock * ehLast  = globals::cfgMap.find(toString(f->id))->second->lastBlock;

		connectBlocks(firstBlock, ehFirst);
		connectBlocks(ehLast, lastBlock);


#line  10560 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 908 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(i->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(i->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  10570 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 916 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Scope\n");

#line  10576 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 462 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 462 "ast-to-xml.k"
		const tVariable_list b = this->tVariable_list_1;
#line 462 "ast-to-xml.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 462 "ast-to-xml.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 462 "ast-to-xml.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 462 "ast-to-xml.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 462 "ast-to-xml.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 462 "ast-to-xml.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 462 "ast-to-xml.k"
		const activity i = this->activity_1;
#line 462 "ast-to-xml.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 462 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 463 "ast-to-xml.k"
		inup(); 
#line  10607 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<scope id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 463 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10613 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 467 "ast-to-xml.k"
		if (b->length() == 0) 
#line  10618 "ast-system-unpk.cc"
		{
		}
#line 469 "ast-to-xml.k"
		else 
#line  10623 "ast-system-unpk.cc"
		{
#line 470 "ast-to-xml.k"
		    inup(); 
#line  10627 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<variables id=\""), kc_current_view); }
		    kc::unparse(_id, kc_printer, kc_current_view);
		    { kc_printer(kc_t("\">\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 470 "ast-to-xml.k"
		    indown(); 
#line  10634 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</variables>\n"), kc_current_view); }
		}
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
#line 474 "ast-to-xml.k"
		indown(); 
#line  10645 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</scope>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 176 "ast-to-petrinet.k"
		PScope(this, kc_current_view_base); 
#line  10655 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 176 "ast-to-petrinet.k"
		PScope(this, kc_current_view_base); 
#line  10664 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  10669 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  10682 "ast-system-unpk.cc"
void
impl_standardElements_NoStandardElements::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  10688 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  10700 "ast-system-unpk.cc"
void
impl_standardElements_StandardElements::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 941 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 942 "ast-to-visualization.k"
		const tSource_list a = this->tSource_list_1;
#line 942 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 943 "ast-to-visualization.k"
		const tTarget_list a = this->tTarget_list_1;
#line 943 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
	    {
#line 944 "ast-to-visualization.k"
		const tTarget_list a = this->tTarget_list_1;
#line 944 "ast-to-visualization.k"
		const tSource_list b = this->tSource_list_1;
#line 944 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2374 "ast-postprocess.k"
		const tTarget_list a = this->tTarget_list_1;
#line 2374 "ast-postprocess.k"
		const tSource_list b = this->tSource_list_1;
#line 2374 "ast-postprocess.k"
		const joinCondition _joinCondition = this->joinCondition_1;
#line 2376 "ast-postprocess.k"

		assert(globals::ASTEmap[this->parentId] != NULL);
		this->suppressJF = (globals::ASTEmap[this->parentId]->attributes["suppressJoinFailure"] == "yes");


		_joinCondition->parentId = this->parentId;

#line  10750 "ast-system-unpk.cc"
		kc::unparse(_joinCondition, kc_printer, kc_current_view);
#line 2384 "ast-postprocess.k"

		unsigned int linkCount = 0;
		{
#line 2386 "ast-postprocess.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  10759 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 2386 "ast-postprocess.k"
			    {
				{
#line 2387 "ast-postprocess.k"
#line 2386 "ast-postprocess.k"
				    const tTarget targetLink = kc_selvar_0_1;
#line 2387 "ast-postprocess.k"

				    assert(globals::ASTEmap[targetLink->id] != NULL);
				    globals::ASTEmap[targetLink->id]->controlFlow = globals::ASTEmap[this->parentId]->controlFlow;
				    globals::ASTEmap[targetLink->id]->parentActivityId = this->parentId;


				    globals::joinCondition_links[globals::ASTEmap[targetLink->id]->attributes["linkName"]] = ++linkCount; 

#line  10780 "ast-system-unpk.cc"
				}
			    }

#line  10784 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 2386 "ast-postprocess.k"

#line  10789 "ast-system-unpk.cc"
		    }
		}
#line 2395 "ast-postprocess.k"

		{
#line 2396 "ast-postprocess.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  10798 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 2396 "ast-postprocess.k"
			    {
				{
#line 2397 "ast-postprocess.k"
#line 2396 "ast-postprocess.k"
				    const tSource sourceLink = kc_selvar_0_1;
#line 2397 "ast-postprocess.k"

				    assert(globals::ASTEmap[sourceLink->id] != NULL);
				    globals::ASTEmap[sourceLink->id]->controlFlow = globals::ASTEmap[this->parentId]->controlFlow;
				    globals::ASTEmap[sourceLink->id]->parentActivityId = this->parentId;

#line  10816 "ast-system-unpk.cc"
				}
			    }

#line  10820 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 2396 "ast-postprocess.k"

#line  10825 "ast-system-unpk.cc"
		    }
		}
#line 2402 "ast-postprocess.k"











		unsigned int assignments = (unsigned int)pow(2.0, a->length());
		for (unsigned int assignment = 0; assignment < assignments; assignment++)
		{

		    for (unsigned int link = 0; link < linkCount; link++)
		    {
			if (((assignment >> link) % 2) == 0) 
			globals::joinCondition_linkStatus[link] = true;
			else
			globals::joinCondition_linkStatus[link] = false;
		    }


		    _joinCondition->unparse(pseudoPrinter, evaluation);


		    {
#line 2429 "ast-postprocess.k"
			joinCondition kc_selvar_0_1 = phylum_cast<joinCondition>(_joinCondition);
#line 2432 "ast-postprocess.k"
			if ((kc_selvar_0_1->prod_sel() == sel_userDefinedJoinCondition)) {
#line 2432 "ast-postprocess.k"
#line 2431 "ast-postprocess.k"
			    const joinCondition _joinCondition = kc_selvar_0_1;
#line 2431 "ast-postprocess.k"
			    const expression _exp = phylum_cast<const impl_joinCondition_userDefinedJoinCondition*>(kc_selvar_0_1)->expression_1;
#line 2432 "ast-postprocess.k"
			    globals::joinCondition_result[_joinCondition->parentId][assignment] = _exp->value; 
#line  10868 "ast-system-unpk.cc"
			    	} else
			{
#line 2433 "ast-postprocess.k"
#line 2433 "ast-postprocess.k"

#line  10874 "ast-system-unpk.cc"
			}
		    }
#line 2435 "ast-postprocess.k"
		}


		globals::joinCondition_links.clear();
		globals::joinCondition_linkStatus.clear();


#line  10885 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 2443 "ast-postprocess.k"


		set<string> targetLinks;
		{
#line 2446 "ast-postprocess.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  10896 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 2446 "ast-postprocess.k"
			    {
				{
#line 2447 "ast-postprocess.k"
#line 2446 "ast-postprocess.k"
				    const tTarget targetLink = kc_selvar_0_1;
#line 2447 "ast-postprocess.k"


				    string linkName = globals::ASTEmap[targetLink->id]->linkName;
				    if (targetLinks.find(linkName) != targetLinks.end())
				    SAerror(69, "<" + globals::ASTEmap[this->parentId]->activityTypeName() + "> must not use <link> `" +
					linkName + "'", globals::ASTEmap[globals::ASTE_linkIdMap[linkName]]->attributes["referenceLine"]);
				    else
				    targetLinks.insert(linkName);

#line  10918 "ast-system-unpk.cc"
				}
			    }

#line  10922 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 2446 "ast-postprocess.k"

#line  10927 "ast-system-unpk.cc"
		    }
		}
#line 2456 "ast-postprocess.k"

		set<string> sourceLinks;
		{
#line 2458 "ast-postprocess.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  10937 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 2458 "ast-postprocess.k"
			    {
				{
#line 2459 "ast-postprocess.k"
#line 2458 "ast-postprocess.k"
				    const tSource sourceLink = kc_selvar_0_1;
#line 2459 "ast-postprocess.k"


				    string linkName = globals::ASTEmap[sourceLink->id]->linkName;
				    if (sourceLinks.find(linkName) != sourceLinks.end())
				    SAerror(68, "<" + globals::ASTEmap[this->parentId]->activityTypeName() + "> must not use <link> `" +
					linkName + "'", globals::ASTEmap[globals::ASTE_linkIdMap[linkName]]->attributes["referenceLine"]);
				    else
				    sourceLinks.insert(linkName);

#line  10959 "ast-system-unpk.cc"
				}
			    }

#line  10963 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 2458 "ast-postprocess.k"

#line  10968 "ast-system-unpk.cc"
		    }
		}
#line 2468 "ast-postprocess.k"


#line  10974 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 927 "ast-to-cfg.k"
		const standardElements This = this/**/;
#line 927 "ast-to-cfg.k"
		const tTarget_list a = this->tTarget_list_1;
#line 927 "ast-to-cfg.k"
		const tSource_list b = this->tSource_list_1;
#line 927 "ast-to-cfg.k"
		const joinCondition jc = this->joinCondition_1;
#line 929 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(This->parentId))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(This->parentId))->second->lastBlock;
		{
#line 932 "ast-to-cfg.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  10997 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 932 "ast-to-cfg.k"
			    {
				{
#line 933 "ast-to-cfg.k"
#line 932 "ast-to-cfg.k"
				    const tTarget link = kc_selvar_0_1;
#line 933 "ast-to-cfg.k"

				    trace(TRACE_DEBUG, "[CFG] Target\n");



				    CFGBlock * target = new CFGBlock(CFGTarget, link->id, "Target_" + globals::ASTEmap[link->id]->linkName);

				    targets["Source_" + globals::ASTEmap[link->id]->linkName] = target;









				    connectBlocks(target, innerFirst->firstBlock);
				    innerFirst->firstBlock = target;
				    target->lastBlock = innerLast->lastBlock;

#line  11031 "ast-system-unpk.cc"
				}
			    }

#line  11035 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 932 "ast-to-cfg.k"

#line  11040 "ast-system-unpk.cc"
		    }
		}
#line 954 "ast-to-cfg.k"

		{
#line 955 "ast-to-cfg.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  11049 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 955 "ast-to-cfg.k"
			    {
				{
#line 956 "ast-to-cfg.k"
#line 955 "ast-to-cfg.k"
				    const tSource link = kc_selvar_0_1;
#line 956 "ast-to-cfg.k"

				    trace(TRACE_DEBUG, "[CFG] Source\n");



				    CFGBlock * source = new CFGBlock(CFGSource, link->id, "Source_" + globals::ASTEmap[link->id]->linkName);

				    sources["Target_" + globals::ASTEmap[link->id]->linkName] = source;













				    connectBlocks(innerLast->lastBlock, source);
				    innerLast->lastBlock = innerFirst->lastBlock = source;

				    innerFirst->firstBlock->lastBlock = source;
				    trace(TRACE_DEBUG, "[CFG] ~Source\n");


#line  11090 "ast-system-unpk.cc"
				}
			    }

#line  11094 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 955 "ast-to-cfg.k"

#line  11099 "ast-system-unpk.cc"
		    }
		}
#line 984 "ast-to-cfg.k"



#line  11106 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 482 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 483 "ast-to-xml.k"
		const tSource_list a = this->tSource_list_1;
#line 483 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 483 "ast-to-xml.k"
		inup(); 
#line  11123 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sources>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 483 "ast-to-xml.k"
		indown(); 
#line  11128 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sources>\n"), kc_current_view); }
	    } else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 484 "ast-to-xml.k"
		const tTarget_list a = this->tTarget_list_1;
#line 484 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 484 "ast-to-xml.k"
		inup(); 
#line  11138 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<targets>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 484 "ast-to-xml.k"
		indown(); 
#line  11143 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</targets>\n"), kc_current_view); }
	    } else
	    {
#line 485 "ast-to-xml.k"
		const tTarget_list a = this->tTarget_list_1;
#line 485 "ast-to-xml.k"
		const tSource_list b = this->tSource_list_1;
#line 485 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 485 "ast-to-xml.k"
		inup(); 
#line  11155 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<targets>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 485 "ast-to-xml.k"
		indown(); 
#line  11160 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</targets>\n"), kc_current_view); }
#line 485 "ast-to-xml.k"
		inup(); 
#line  11164 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sources>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 485 "ast-to-xml.k"
		indown(); 
#line  11169 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sources>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 215 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 216 "ast-to-petrinet.k"
		P_LinkWrapper0(this, kc_current_view_base); 
#line  11181 "ast-system-unpk.cc"
			} else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 219 "ast-to-petrinet.k"
		const tSource_list a = this->tSource_list_1;
#line 219 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 220 "ast-to-petrinet.k"
		P_LinkWrapper1(this, kc_current_view_base); 
#line  11190 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 223, this))) {
#line 223 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 223 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 223 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 224 "ast-to-petrinet.k"
		P_LinkWrapper2(this, kc_current_view_base); 
#line  11201 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 227, this))) {
#line 227 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 227 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 227 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 228 "ast-to-petrinet.k"
		P_LinkWrapper3(this, kc_current_view_base); 
#line  11212 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 231, this))) {
#line 231 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 231 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 231 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 231 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 232 "ast-to-petrinet.k"
		P_LinkWrapper4(this, kc_current_view_base); 
#line  11225 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 235, this))) {
#line 235 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 235 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 235 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 235 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 236 "ast-to-petrinet.k"
		P_LinkWrapper5(this, kc_current_view_base); 
#line  11238 "ast-system-unpk.cc"
			} else
		    goto kc_unparsing_default;
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 215 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 216 "ast-to-petrinet.k"
		P_LinkWrapper0(this, kc_current_view_base); 
#line  11250 "ast-system-unpk.cc"
			} else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 219 "ast-to-petrinet.k"
		const tSource_list a = this->tSource_list_1;
#line 219 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 220 "ast-to-petrinet.k"
		P_LinkWrapper1(this, kc_current_view_base); 
#line  11259 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 223, this))) {
#line 223 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 223 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 223 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 224 "ast-to-petrinet.k"
		P_LinkWrapper2(this, kc_current_view_base); 
#line  11270 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 227, this))) {
#line 227 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 227 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 227 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 228 "ast-to-petrinet.k"
		P_LinkWrapper3(this, kc_current_view_base); 
#line  11281 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 231, this))) {
#line 231 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 231 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 231 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 231 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 232 "ast-to-petrinet.k"
		P_LinkWrapper4(this, kc_current_view_base); 
#line  11294 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 235, this))) {
#line 235 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 235 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 235 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 235 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 236 "ast-to-petrinet.k"
		P_LinkWrapper5(this, kc_current_view_base); 
#line  11307 "ast-system-unpk.cc"
			} else
		    goto kc_unparsing_default;
	    break;
	}

#line  11313 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tTarget_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  11334 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tTarget_list iterator_ = this; iterator_->tTarget_list_1 != 0; iterator_ = iterator_->tTarget_list_1)
		    iterator_->tTarget_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tTarget_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  11353 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  11366 "ast-system-unpk.cc"
void
impl_tTarget_Target::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 946 "ast-to-visualization.k"
		const integer a = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2473 "ast-postprocess.k"
		const integer a = this->integer_1;
#line 2475 "ast-postprocess.k"

		ASTE *myself = globals::ASTEmap[this->id];
		assert(myself != NULL);

		myself->checkAttributes();
		myself->linkName = myself->checkLink();



		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		unsigned int linkId = globals::ASTE_linkIdMap[ myself->linkName ];
		globals::ASTEmap[myself->parentActivityId]->enclosedTargetLinks.insert(linkId);
		globals::ASTEmap[myself->parentActivityId]->targetLinks.insert(linkId);


		assert(globals::ASTEmap[linkId] != NULL);
		if (globals::ASTEmap[linkId]->targetActivity != 0) 
		{
		    SAerror(66, myself->attributes["linkName"], myself->attributes["referenceLine"]);
		}
		else
		{
		    globals::ASTEmap[linkId]->targetActivity = myself->parentActivityId;
		}

		if ( myself->attributes["suppressJoinFailure"]  == "no" )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( "joinFailure" );
		}

#line  11415 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 487 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 488 "ast-to-xml.k"
		in(); 
#line  11426 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<target"), kc_current_view); }
#line 488 "ast-to-xml.k"
		listAttributes( a ); 
#line  11430 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  11436 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tSource_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  11456 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tSource_list iterator_ = this; iterator_->tSource_list_1 != 0; iterator_ = iterator_->tSource_list_1)
		    iterator_->tSource_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tSource_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  11474 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  11486 "ast-system-unpk.cc"
void
impl_tSource_Source::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 950 "ast-to-visualization.k"
		const integer a = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2508 "ast-postprocess.k"
		const integer a = this->integer_1;
#line 2510 "ast-postprocess.k"

		ASTE *myself = globals::ASTEmap[this->id];
		assert(myself != NULL);

		myself->checkAttributes();
		myself->linkName = myself->checkLink();




		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		unsigned int linkId = globals::ASTE_linkIdMap[ myself->linkName ];
		globals::ASTEmap[myself->parentActivityId]->enclosedSourceLinks.insert(linkId);
		globals::ASTEmap[myself->parentActivityId]->sourceLinks.insert(linkId);


		assert(globals::ASTEmap[linkId] != NULL);
		if (globals::ASTEmap[linkId]->sourceActivity != 0)
		{
		    SAerror(66, myself->attributes["linkName"], myself->attributes["referenceLine"]);
		}
		else
		{
		    globals::ASTEmap[linkId]->sourceActivity = myself->parentActivityId;
		}

#line  11531 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 491 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 492 "ast-to-xml.k"
		in(); 
#line  11542 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<source"), kc_current_view); }
#line 492 "ast-to-xml.k"
		listAttributes( a ); 
#line  11546 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  11552 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11565 "ast-system-unpk.cc"
void
impl_joinCondition_userDefinedJoinCondition::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2539 "ast-postprocess.k"
		const expression _exp = this->expression_1;
#line 2541 "ast-postprocess.k"
		_exp->parentId = this->parentId; 
#line  11577 "ast-system-unpk.cc"
		kc::unparse(_exp, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  11583 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11596 "ast-system-unpk.cc"
void
impl_joinCondition_standardJoinCondition::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  11602 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  11614 "ast-system-unpk.cc"
void
impl_expression_Disjunction::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2601 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2601 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
#line 2605 "ast-postprocess.k"
		this->value = (_exp1->value || _exp2->value); 
#line  11630 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2553 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2553 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
#line 2555 "ast-postprocess.k"
		_exp1->parentId = _exp2->parentId = this->parentId; 
#line  11643 "ast-system-unpk.cc"
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  11650 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11663 "ast-system-unpk.cc"
void
impl_expression_Conjunction::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2593 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2593 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
#line 2597 "ast-postprocess.k"
		this->value = (_exp1->value && _exp2->value); 
#line  11679 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2546 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2546 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
#line 2548 "ast-postprocess.k"
		_exp1->parentId = _exp2->parentId = this->parentId; 
#line  11692 "ast-system-unpk.cc"
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  11699 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11712 "ast-system-unpk.cc"
void
impl_expression_Term::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2569 "ast-postprocess.k"
		const casestring _linkname = this->casestring_1;
#line 2571 "ast-postprocess.k"


		string linkname_string = string(_linkname->name);
		if (linkname_string[0] == '$')
		linkname_string = linkname_string.substr(1, linkname_string.length() -1);



		if (globals::joinCondition_links[linkname_string] == 0)
		{
		    assert(globals::ASTEmap[this->parentId] != NULL);
		    SAerror(73, linkname_string, globals::ASTEmap[this->parentId]->attributes["referenceLine"]);
		}
		else
		{

		    this->value = globals::joinCondition_linkStatus[globals::joinCondition_links[linkname_string] -1];
		}

#line  11742 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2560 "ast-postprocess.k"
		const casestring _linkname = this->casestring_1;
	    }
	    break;
	}

#line  11755 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


} // namespace kc
