/*
  Copyright (C) 2006-2007 Werner Dittmann

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * Authors: Werner Dittmann <Werner.Dittmann@t-online.de>
 */
#include <stdint.h>
/**
 *
 */
//                            1
//                   123456789012345
char *clientId =    "GNUccRTP    "; // must be 12 chars
char *zrtpVersion = "0.09";	// must be 4 chars
/**
 *
 */
char *HelloMsg =    "Hello   ";
char *HelloAckMsg = "HelloACK";
char *CommitMsg =   "Commit  ";
char *DHPart1Msg =  "DHPart1 ";
char *DHPart2Msg =  "DHPart2 ";
char *Confirm1Msg = "Confirm1";
char *Confirm2Msg = "Confirm2";
char *Conf2AckMsg = "Conf2ACK";
char *ErrorMsg =    "Error   ";
char *ErrorAckMsg = "ErrorACK";
char *GoClearMsg =  "GoClear ";
char *ClearAckMsg = "ClearACK";

/**
 *
 */
char *responder = "Responder";
char *initiator = "Initiator";
char *iniMasterKey = "Initiator SRTP master key";
char *iniMasterSalt = "Initiator SRTP master salt";
char *respMasterKey = "Responder SRTP master key";
char *respMasterSalt = "Responder SRTP master salt";

char *iniHmacKey = "Initiator HMAC key";
char *respHmacKey = "Responder HMAC key";
char *retainedSec = "retained secret";

char* iniZrtpKey = "Initiator ZRTP key";
char* respZrtpKey = "Responder ZRTP key";

char* sasString = "SAS";

char* KDFString = "ZRTP-HMAC-KDF";

/**
 * The arrays are sorted: the most secure / best algorithm is first in the
 * array. If we add an algorithm here then we need to adjust the corresponding
 * value in ZrtpTextData.h as well.
 */
char *supportedHashes[] =  {"S256"};

char *supportedCipher[] =  {"AES2",
                            "AES1"};

char *supportedPubKey[] =  {"DH4k",
                            "DH3k"};

char *supportedSASType[] = {"B32 "};

char *supportedAuthLen[] = {"HS32",
                            "HS80"};
