/* LocaleInformation_sq.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_sq extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "ALL";

  private static final String currenciesDisplayNameValues = "ALL";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "ALL";

  private static final String currenciesSymbolValues = "Lek";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Shk",
    "Mar",
    "Pri",
    "Maj",
    "Qer",
    "Kor",
    "Gsh",
    "Sht",
    "Tet",
    "N\u00ebn",
    "Dhj",
    null,
  };

  private static final String[] months = {
    "janar",
    "shkurt",
    "mars",
    "prill",
    "maj",
    "qershor",
    "korrik",
    "gusht",
    "shtator",
    "tetor",
    "n\u00ebntor",
    "dhjetor",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Die",
    "H\u00ebn",
    "Mar",
    "M\u00ebr",
    "Enj",
    "Pre",
    "Sht",
  };

  private static final String[] weekdays = {
    null,
    "e diel",
    "e h\u00ebn\u00eb",
    "e mart\u00eb",
    "e m\u00ebrkur\u00eb",
    "e enjte",
    "e premte",
    "e shtun\u00eb",
  };

  private static final String[] eras = {
    "p.e.r.",
    "n.e.r.",
  };

  private static final String[] ampms = {
    "PD",
    "MD",
  };

  private static final String territoriesKeys = "TJ|TH|TG|GY|TD|GW|GT|GR|GQ|SZ|SY|GN|GM|ST|GH|SP|GE|SO|SL|GA|SK|SI|SG|SE|SC|SB|SA|FR|FM|RW|RU|FJ|FI|RO|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|DK|DJ|PT|DE|PL|PH|PG|CZ|CY|CV|CU|CR|CO|CN|CM|CL|CI|CH|CG|CF|CA|BY|BW|BT|NZ|BO|BN|BH|BG|BE|NO|ZW|NL|BA|NI|NG|AZ|ZM|AU|NA|AT|AR|MZ|AO|MY|MX|AM|MW|AL|MV|ZA|MT|MR|AG|AF|AE|AD|MN|MK|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LI|LB|KZ|KW|KR|KP|KN|KM|KI|KH|KG|KE|JP|JO|JM|VE|VC|VA|IT|IS|IQ|UY|IN|IL|US|IE|ID|UA|HU|HR|TZ|TW|TT|TR|TN";

  private static final String territoriesValues = "Taxhikistan|Tajland\u00eb|Togo|Guajana|\u00c7ad|Guine Bisau|Guatemal\u00eb|Greqi|Guineja Ekuatoriale|Svaziland\u00eb|Siri|Guine|Gambi|Sao Tome e Prinsipe|Gan\u00eb|Serbi\u00eb|Gjeorgji|Somali|Siera Leone|Gjabon|Sllovaki|Slloveni|Singapor|Suedi|Sishel|Ishujt Solomon|Arabia Saudite|Franc\u00eb|Mikronezi|Ruanda|Rusi|Fixhi|Finland\u00eb|Rumani|Etiopi|Spanj\u00eb|Eritre|Saharaja Per\u00ebndimore|Egjipt|Estoni|Ekuator|Algjeri|Katar|Republika Dominikan\u00eb|Paraguaj|Dominik\u00eb|Danimark\u00eb|Xhibuti|Portugali|Gjermani|Poloni|Filipine|Papua Guineja e Re|Republika e \u00c7ekis\u00eb|Qipro|Kap Verde|Kub\u00eb|Kosta Rika|Kolumbi|Kin\u00eb|Kamerun|Kili|Bregu i Fildisht\u00eb|Zvic\u00ebr|Kongo|Republika Qendrore e Afrik\u00ebs|Kanada|Bjellorusi|Botsvana|Butan|Zelanda e Re|Bolivi|Brunej|Bahrein|Bullgari|Belgjik\u00eb|Norvegji|Zimbabve|Vendet e Ul\u00ebta|Bosnja dhe Hercegovina|Nikaragua|Nigeri|Azerbajxhan|Zambi|Australi|Namibi|Austri|Argjentin\u00eb|Mozambik|Angol\u00eb|Malajzi|Meksik\u00eb|Armeni|Malavi|Shqip\u00ebria|Maldivit|Afrika e Jugut|Malt\u00eb|Mauritani|Antigua e Barbuda|Afganistan|Emiratet Arabe te Bashkuara|Andorr\u00eb|Mongoli|Maqedoni|Ishujt Marshall|Madagaskar|Moldavi|Monako|Maroko|Jemen|Libi|Letoni|Luksemburg|Lituani|Lesoto|Liberi|Liht\u00ebnshtajn|Liban|Kazakistan|Kuvajt|Koreja e Jugut|Koreja e Veriut|Saint Kitts e Nevis|Komore|Qiribati|Kamboxhi|Kirgistan|Kenia|Japoni|Jordani|Xhamajk\u00eb|Venezuel\u00eb|Saint Vincent e Grenadinet|Vatikan|Itali|Island\u00eb|Irak|Uruguaj|Indi|Izrael|Shtetet e Bashkuara t\u00eb Amerik\u00ebs|Irland\u00eb|Indonezi|Ukrain\u00eb|Hungari|Kroaci|Tanzani|Tajvan|Trinidad e Tobago|Turqi|Tunisi";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "sq";

  private static final String languagesValues = "shqipe";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "yy-MM-dd" },
    { "mediumDateFormat", "yyyy-MM-dd" },
    { "longDateFormat", "dd MMMM yyyy" },
    { "fullDateFormat", "EEEE, dd MMMM yyyy" },
    { "shortTimeFormat", "h.mm.a" },
    { "mediumTimeFormat", "h:mm:ss.a" },
    { "longTimeFormat", "h.mm.ss.a z" },
    { "fullTimeFormat", "h.mm.ss.a z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
