/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_DII
    Description : GNU/EDMA Dynamic Invocation Interface
    Author      : David Martnez Oliviera
    Date        : June, 19th, 2003
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
  ----------------------------------------------------------------
  Misc Notes:
    - Output parameters are passed from a C application as a pointer
      so... in order to mantain type-safelty we must provide special
      functions for output parameters -> Take a look to how CORBA does it
    - At this moment output parameters can be used faking the method
      signature
    - Extra parameter information are not being used, even built.
      This extra information will be useful for adding new features:
      * Named Parameters
      * Default values
      * Copy values mantained by the DII manager
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/

/*
***************************************************
  EDMA Header Files
***************************************************
*/
#include <stdlib.h>
#include <string.h> 
#include <edma.h>

#define IN_PARAM      0
#define OUT_PARAM     1
#define INOUT_PARAM   2


/*
***************************************************
  Private Data Struct for class EDMA_DII
***************************************************
*/

/* FIXME: This should evolve to a CORBA-like Type-code/DynAny system */
typedef struct _priv_param_info_t
{
  EPChar       name;
  EUint32      flags;
  EChar        in_val[8];   /* 64 bits to hold input value */
  EChar        out_val[8];  /* 64 bits to hold output value*/
} _PARAM_INFO;

typedef struct
{
	OBJID		target_obj;
	EPChar		method;
	EPChar		signature;
	EDMAT_BUFFER	arg_info;
	EDMAT_BUFFER	vargs_in;
	EDMAT_BUFFER	vargs_out;
        ESint32		num_params; /* Number of parameters in current request */
        ESint32		current_param; /* Current offset in signature for type checking*/
}DtEDMA_DII;
/*
***************************************************
  Method Declaration for class EDMA_DII
***************************************************
*/
 
ESint32 EDMAPROC
EDMA_DIIrequestOZZ(OBJID IdObj, OBJID id, EPChar method_name, EPChar method_sig)
{
  DtEDMA_DII	*m;

  m = (DtEDMA_DII *) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "[DII_Request] Method: %s signature %s",
		   method_name, method_sig);

  /* Remove old data if any */
  edma_buffer_free (&m->arg_info);
  edma_buffer_free (&m->vargs_in);
  edma_buffer_free (&m->vargs_out);

  /* Allocate space for 16 parameters */
  edma_buffer_alloc (&m->vargs_in, sizeof(ESint32)  * 16);
  memset (m->vargs_in.dat, 0, sizeof(ESint32) * 16);

  edma_buffer_alloc (&m->vargs_out, sizeof(ESint32)  * 16);
  memset (m->vargs_out.dat, 0, sizeof(ESint32) * 16);

  m->num_params = m->current_param = 0;
  m->target_obj = id;

  edma_wprop3 (IdObj, "method", method_name);
  edma_wprop3 (IdObj, "signature", method_sig);
  return 0;
}

ESint32 EDMAPROC
_add_cannonical_int_param (OBJID IdObj, EPVoid val, ESint32 flags, EPChar signature)
{
  DtEDMA_DII	*m;
  EPChar        p;

  m = (DtEDMA_DII *) edma_get_data_ref (IdObj);

  if (signature[0] == 'Z')
    edma_printf_obj (IdObj, "[DII_add_canonical_int] Param %d Value: %s "
		     "Flags:%d Param Signature: %s", 
		     m->num_params + 1, val, flags, signature);
  else 
    {
      if (signature[0] == 's')
	edma_printf_obj (IdObj, "[DII_add_canonical_int] Param %d Value: 0x%p "
			 "Flags:%d Param Signature: %s", 
			 m->num_params + 1, val, flags, signature);
      
      else
	edma_printf_obj (IdObj, "[DII_add_canonical_int] Param %d Value: '%d' "
			 "Flags:%d Param Signature: %s", 
			 m->num_params + 1, val, flags, signature);
    }

  /* TODO: Check signature */
  if ((strncmp (m->signature + m->current_param, signature, strlen(signature))) != 0)
    {
      edma_printf_obj (IdObj, "ERROR: Type mismatch: Type %s not valid for parameter %d" 
		       " on method '%s%s'.", 
		       signature, m->num_params, m->method, m->signature);
      return -1;
    }

  /* Store value */
  p = (EPChar)m->vargs_in.dat + (sizeof(int) * m->num_params);

  *((int *)p) = (int)val;   /* Copy sizeof(int) bytes */

  m->num_params++; /* We count in sizeof(int) base*/
  m->current_param += strlen(signature); /* Increment signature offset in 3 chars (S32)*/

  return 0;
}

ESint32 EDMAPROC
_add_cannonical_double_param (OBJID IdObj, EReal64 val, ESint32 flags, EPChar signature)
{
  DtEDMA_DII	*m;
  EPChar        p;

  m = (DtEDMA_DII *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "[DII_add_canonical_double] Param %d Value: %lf Flags:%lf Param Signature: %s", 
		   m->num_params + 1, val, flags, signature);

  /* TODO: Check signature */
  if ((strncmp (m->signature + m->current_param, signature, 3)) != 0)
    {
      edma_printf_obj (IdObj, "ERROR: Type mismatch: Type %s not valid for parameter %d" 
		       " on method '%s%s'.", 
		       m->num_params, m->method, m->signature);
      return -1;
    }

  /* Store value */
  if ((strncmp (signature, "R64", 3)) == 0)
    {
      p = (EPChar)m->vargs_in.dat + (sizeof(int) * m->num_params);

      *((EReal64 *)p) = val;   /* Copy sizeof(int) bytes */
      m->num_params+=2; /* We count 2 sizeof(int) -> double are 64 bits long */
    }
  else
    {
      p = (EPChar)m->vargs_in.dat + (sizeof(int) * m->num_params);
      //p[m->num_params] = val; /* Copy sizeof(int) bytes */
      *((EReal32 *)p) = val;   /* Copy sizeof(int) bytes */
      m->num_params++;
    }


  m->current_param += strlen(signature); /* Increment signature offset in 3 chars (S32)*/

  return 0;
}


ESint32 EDMAPROC
EDMA_DIIadd_sint32_paramS32S32rS32(OBJID IdObj, ESint32 val, ESint32 flags)
{
  /*DtEDMA_DII	*m;*/

  /*m = (DtEDMA_DII *) edma_get_data_ref (IdObj);*/

  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "S32");
}


ESint32 EDMAPROC
EDMA_DIIadd_uint32_paramU32S32rS32(OBJID IdObj, EUint32 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "U32");
}


ESint32 EDMAPROC
EDMA_DIIadd_sint16_paramS16S32rS32(OBJID IdObj, ESint16 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)(ESint32)val, flags, "S16");
}


ESint32 EDMAPROC
EDMA_DIIadd_uint16_paramU16S32rS32(OBJID IdObj, EUint16 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)(EUint32)val, flags, "U16");
}


ESint32 EDMAPROC
EDMA_DIIadd_sint8_paramS8S32rS32(OBJID IdObj, ESint8 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)(ESint32)val, flags, "S8");
}


ESint32 EDMAPROC
EDMA_DIIadd_uint8_paramU8S32rS32(OBJID IdObj, EUint8 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)(EUint32)val, flags, "U8");
}


ESint32 EDMAPROC
EDMA_DIIadd_strz_paramZS32rS32(OBJID IdObj, EPChar val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "Z");
}


ESint32 EDMAPROC
EDMA_DIIadd_obj_paramOS32rS32(OBJID IdObj, OBJID val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "O");
}


ESint32 EDMAPROC
EDMA_DIIadd_r32_paramR32S32rS32(OBJID IdObj, EReal64 val, ESint32 flags)
{
  return _add_cannonical_double_param (IdObj, val, flags, "R32");
}


ESint32 EDMAPROC
EDMA_DIIadd_r64_paramR64S64rS32(OBJID IdObj, EReal64 val, ESint32 flags)
{
  return _add_cannonical_double_param (IdObj, (EReal64)val, flags, "R64");
}

ESint32 EDMAPROC
EDMA_DIIadd_sint32_out_paramsS32S32rS32(OBJID IdObj, EPSint32 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "sS32");
}


ESint32 EDMAPROC
EDMA_DIIadd_uint32_out_paramsU32S32rS32(OBJID IdObj, EPUint32 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "sU32");
}


ESint32 EDMAPROC
EDMA_DIIadd_sint16_out_paramsS16S32rS32(OBJID IdObj, EPSint16 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "sS16");
}


ESint32 EDMAPROC
EDMA_DIIadd_uint16_out_paramsU16S32rS32(OBJID IdObj, EPUint16 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "sU16");
}


ESint32 EDMAPROC
EDMA_DIIadd_sint8_out_paramsS8S32rS32(OBJID IdObj, EPSint8 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "sS8");
}


ESint32 EDMAPROC
EDMA_DIIadd_uint8_out_paramsU8S32rS32(OBJID IdObj, EPUint8 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "sU8");
}


ESint32 EDMAPROC
EDMA_DIIadd_strz_out_paramsZS32rS32(OBJID IdObj, EPChar *val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "sZ");
}


ESint32 EDMAPROC
EDMA_DIIadd_obj_out_paramsOS32rS32(OBJID IdObj, OBJID *val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "sO");
}


ESint32 EDMAPROC
EDMA_DIIadd_r32_out_paramsR32S32rS32(OBJID IdObj, EPReal32 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "sR32");
}


ESint32 EDMAPROC
EDMA_DIIadd_r64_out_paramsR64S64rS32(OBJID IdObj, EPReal64 val, ESint32 flags)
{
  return _add_cannonical_int_param (IdObj, (EPVoid)val, flags, "sR64");
}



ESint32 EDMAPROC
EDMA_DIIinvokeZrS32(OBJID IdObj, EPChar misc)
{
  DtEDMA_DII	*m;

  m = (DtEDMA_DII *) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "[DII_Invoke] Invoking Method %s#%s", m->method, m->signature);

  edma_met3_pargs (m->target_obj, m->method, m->signature, 1, m->vargs_in.dat);

  return 0;
}


ESint32 EDMAPROC
EDMA_DIIget_resultArS32(OBJID IdObj, EDMAT_BUFFER buf)
{
  DtEDMA_DII	*m;

  m = (DtEDMA_DII *) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "[DII_GetResult] Getting Results");
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
