#! /bin/sh
#
# gnulib-version.sh -- creates gnulib-version.c (from ../import-gnulib.config)
# Copyright (C) 2007 Free Software Foundation, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

me="$(basename $0)"
topsrcdir="$1"
srcdir="$2"
configfile="$3"

outfile="${srcdir}"/gnulib-version.c
outfiletmp=gnulib-version.c.new

source $configfile

if [ -z "$gnulib_version" ]
then
    echo "Error: There should be a gnulib_version setting in $configfile, but there is not." >&2
    exit 1
fi


cat > "${outfiletmp}" <<EOF
/* This file is automatically generated by ${me} and simply records which version of gnulib we used. */
const char * const gnulib_version = "$gnulib_version";
EOF

if test -f "$outfile"; then
    if diff "${outfile}" "${outfiletmp}"  ; then
      # nothing to do
      rm "${outfiletmp}"
      exit 0
    else
      echo "Replacing ${outfile} with ${outfiletmp}..."
    fi
    # During distcheck, the directory containing the file may well
    # be read-only, so rather than try to delete a file from a 
    # read-only directory, we overwrite the old copy.
    chmod +w "${outfile}" 
else
    echo "${outfile} does not exist at all, we need to create it."
fi
# Turn off noclobber if it is on.
( set +C; cat "${outfiletmp}" > "${outfile}" )
rm "${outfiletmp}"