// 2007-02-04  Edward Smith-Rowland <3dw4rd@verizon.net>
//
// Copyright (C) 2007-2013 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  ellint_1


//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/

#include <tr1/cmath>
#if defined(__TEST_DEBUG)
#include <iostream>
#define VERIFY(A) \
if (!(A)) \
  { \
    std::cout << "line " << __LINE__ \
      << "  max_abs_frac = " << max_abs_frac \
      << std::endl; \
  }
#else
#include <testsuite_hooks.h>
#endif
#include "../testcase.h"


// Test data for k=-0.90000000000000002.
testcase_ellint_1<double> data001[] = {
  { -0.0000000000000000, -0.90000000000000002, 0.0000000000000000 },
  { 0.17525427376115027, -0.90000000000000002, 0.17453292519943295 },
  { 0.35492464591297446, -0.90000000000000002, 0.34906585039886590 },
  { 0.54388221416157134, -0.90000000000000002, 0.52359877559829882 },
  { 0.74797400423532523, -0.90000000000000002, 0.69813170079773179 },
  { 0.97463898451966458, -0.90000000000000002, 0.87266462599716477 },
  { 1.2334463254523440, -0.90000000000000002, 1.0471975511965976 },
  { 1.5355247765594910, -0.90000000000000002, 1.2217304763960306 },
  { 1.8882928567775124, -0.90000000000000002, 1.3962634015954636 },
  { 2.2805491384227703, -0.90000000000000002, 1.5707963267948966 },
};

// Test function for k=-0.90000000000000002.
template <typename Tp>
void test001()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data001)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data001[i].k), Tp(data001[i].phi));
      const Tp f0 = data001[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=-0.80000000000000004.
testcase_ellint_1<double> data002[] = {
  { -0.0000000000000000, -0.80000000000000004, 0.0000000000000000 },
  { 0.17510154241338902, -0.80000000000000004, 0.17453292519943295 },
  { 0.35365068839779390, -0.80000000000000004, 0.34906585039886590 },
  { 0.53926804409084561, -0.80000000000000004, 0.52359877559829882 },
  { 0.73587926028070383, -0.80000000000000004, 0.69813170079773179 },
  { 0.94770942970071170, -0.80000000000000004, 0.87266462599716477 },
  { 1.1789022995388239, -0.80000000000000004, 1.0471975511965976 },
  { 1.4323027881876009, -0.80000000000000004, 1.2217304763960306 },
  { 1.7069629739121674, -0.80000000000000004, 1.3962634015954636 },
  { 1.9953027776647296, -0.80000000000000004, 1.5707963267948966 },
};

// Test function for k=-0.80000000000000004.
template <typename Tp>
void test002()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data002)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data002[i].k), Tp(data002[i].phi));
      const Tp f0 = data002[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=-0.69999999999999996.
testcase_ellint_1<double> data003[] = {
  { -0.0000000000000000, -0.69999999999999996, 0.0000000000000000 },
  { 0.17496737466916720, -0.69999999999999996, 0.17453292519943295 },
  { 0.35254687535677925, -0.69999999999999996, 0.34906585039886590 },
  { 0.53536740275997130, -0.69999999999999996, 0.52359877559829882 },
  { 0.72603797651684465, -0.69999999999999996, 0.69813170079773179 },
  { 0.92698296348313458, -0.69999999999999996, 0.87266462599716477 },
  { 1.1400447527693316, -0.69999999999999996, 1.0471975511965976 },
  { 1.3657668117194071, -0.69999999999999996, 1.2217304763960306 },
  { 1.6024686895959159, -0.69999999999999996, 1.3962634015954636 },
  { 1.8456939983747236, -0.69999999999999996, 1.5707963267948966 },
};

// Test function for k=-0.69999999999999996.
template <typename Tp>
void test003()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data003)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data003[i].k), Tp(data003[i].phi));
      const Tp f0 = data003[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=-0.59999999999999998.
testcase_ellint_1<double> data004[] = {
  { -0.0000000000000000, -0.59999999999999998, 0.0000000000000000 },
  { 0.17485154362988362, -0.59999999999999998, 0.17453292519943295 },
  { 0.35160509865544326, -0.59999999999999998, 0.34906585039886590 },
  { 0.53210652578446160, -0.59999999999999998, 0.52359877559829882 },
  { 0.71805304664485670, -0.59999999999999998, 0.69813170079773179 },
  { 0.91082759030195970, -0.59999999999999998, 0.87266462599716477 },
  { 1.1112333229323361, -0.59999999999999998, 1.0471975511965976 },
  { 1.3191461190365270, -0.59999999999999998, 1.2217304763960306 },
  { 1.5332022105084773, -0.59999999999999998, 1.3962634015954636 },
  { 1.7507538029157526, -0.59999999999999998, 1.5707963267948966 },
};

// Test function for k=-0.59999999999999998.
template <typename Tp>
void test004()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data004)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data004[i].k), Tp(data004[i].phi));
      const Tp f0 = data004[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=-0.50000000000000000.
testcase_ellint_1<double> data005[] = {
  { -0.0000000000000000, -0.50000000000000000, 0.0000000000000000 },
  { 0.17475385514035785, -0.50000000000000000, 0.17453292519943295 },
  { 0.35081868470101585, -0.50000000000000000, 0.34906585039886590 },
  { 0.52942862705190585, -0.50000000000000000, 0.52359877559829882 },
  { 0.71164727562630326, -0.50000000000000000, 0.69813170079773179 },
  { 0.89824523594227768, -0.50000000000000000, 0.87266462599716477 },
  { 1.0895506700518851, -0.50000000000000000, 1.0471975511965976 },
  { 1.2853005857432933, -0.50000000000000000, 1.2217304763960306 },
  { 1.4845545520549484, -0.50000000000000000, 1.3962634015954636 },
  { 1.6857503548125963, -0.50000000000000000, 1.5707963267948966 },
};

// Test function for k=-0.50000000000000000.
template <typename Tp>
void test005()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data005)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data005[i].k), Tp(data005[i].phi));
      const Tp f0 = data005[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=-0.40000000000000002.
testcase_ellint_1<double> data006[] = {
  { -0.0000000000000000, -0.40000000000000002, 0.0000000000000000 },
  { 0.17467414669441531, -0.40000000000000002, 0.17453292519943295 },
  { 0.35018222772483443, -0.40000000000000002, 0.34906585039886590 },
  { 0.52729015917508748, -0.40000000000000002, 0.52359877559829882 },
  { 0.70662374407341255, -0.40000000000000002, 0.69813170079773179 },
  { 0.88859210497602170, -0.40000000000000002, 0.87266462599716477 },
  { 1.0733136290471379, -0.40000000000000002, 1.0471975511965976 },
  { 1.2605612170157061, -0.40000000000000002, 1.2217304763960306 },
  { 1.4497513956433437, -0.40000000000000002, 1.3962634015954636 },
  { 1.6399998658645112, -0.40000000000000002, 1.5707963267948966 },
};

// Test function for k=-0.40000000000000002.
template <typename Tp>
void test006()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data006)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data006[i].k), Tp(data006[i].phi));
      const Tp f0 = data006[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=-0.30000000000000004.
testcase_ellint_1<double> data007[] = {
  { -0.0000000000000000, -0.30000000000000004, 0.0000000000000000 },
  { 0.17461228653000102, -0.30000000000000004, 0.17453292519943295 },
  { 0.34969146102798415, -0.30000000000000004, 0.34906585039886590 },
  { 0.52565822873726320, -0.30000000000000004, 0.52359877559829882 },
  { 0.70284226512408532, -0.30000000000000004, 0.69813170079773179 },
  { 0.88144139195111182, -0.30000000000000004, 0.87266462599716477 },
  { 1.0614897067260523, -0.30000000000000004, 1.0471975511965976 },
  { 1.2428416824174218, -0.30000000000000004, 1.2217304763960306 },
  { 1.4251795877015925, -0.30000000000000004, 1.3962634015954636 },
  { 1.6080486199305126, -0.30000000000000004, 1.5707963267948966 },
};

// Test function for k=-0.30000000000000004.
template <typename Tp>
void test007()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data007)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data007[i].k), Tp(data007[i].phi));
      const Tp f0 = data007[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=-0.19999999999999996.
testcase_ellint_1<double> data008[] = {
  { -0.0000000000000000, -0.19999999999999996, 0.0000000000000000 },
  { 0.17456817290292811, -0.19999999999999996, 0.17453292519943295 },
  { 0.34934315932086801, -0.19999999999999996, 0.34906585039886590 },
  { 0.52450880529443988, -0.19999999999999996, 0.52359877559829882 },
  { 0.70020491009844910, -0.19999999999999996, 0.69813170079773179 },
  { 0.87651006649967955, -0.19999999999999996, 0.87266462599716477 },
  { 1.0534305870298994, -0.19999999999999996, 1.0471975511965976 },
  { 1.2308975521670784, -0.19999999999999996, 1.2217304763960306 },
  { 1.4087733584990738, -0.19999999999999996, 1.3962634015954636 },
  { 1.5868678474541664, -0.19999999999999996, 1.5707963267948966 },
};

// Test function for k=-0.19999999999999996.
template <typename Tp>
void test008()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data008)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data008[i].k), Tp(data008[i].phi));
      const Tp f0 = data008[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=-0.099999999999999978.
testcase_ellint_1<double> data009[] = {
  { -0.0000000000000000, -0.099999999999999978, 0.0000000000000000 },
  { 0.17454173353063665, -0.099999999999999978, 0.17453292519943295 },
  { 0.34913506721468085, -0.099999999999999978, 0.34906585039886590 },
  { 0.52382550016538953, -0.099999999999999978, 0.52359877559829882 },
  { 0.69864700854177031, -0.099999999999999978, 0.69813170079773179 },
  { 0.87361792586964870, -0.099999999999999978, 0.87266462599716477 },
  { 1.0487386319621685, -0.099999999999999978, 1.0471975511965976 },
  { 1.2239913752078757, -0.099999999999999978, 1.2217304763960306 },
  { 1.3993423113684049, -0.099999999999999978, 1.3962634015954636 },
  { 1.5747455615173562, -0.099999999999999978, 1.5707963267948966 },
};

// Test function for k=-0.099999999999999978.
template <typename Tp>
void test009()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data009)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data009[i].k), Tp(data009[i].phi));
      const Tp f0 = data009[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=0.0000000000000000.
testcase_ellint_1<double> data010[] = {
  { -0.0000000000000000, 0.0000000000000000, 0.0000000000000000 },
  { 0.17453292519943295, 0.0000000000000000, 0.17453292519943295 },
  { 0.34906585039886584, 0.0000000000000000, 0.34906585039886590 },
  { 0.52359877559829882, 0.0000000000000000, 0.52359877559829882 },
  { 0.69813170079773179, 0.0000000000000000, 0.69813170079773179 },
  { 0.87266462599716477, 0.0000000000000000, 0.87266462599716477 },
  { 1.0471975511965976, 0.0000000000000000, 1.0471975511965976 },
  { 1.2217304763960304, 0.0000000000000000, 1.2217304763960306 },
  { 1.3962634015954631, 0.0000000000000000, 1.3962634015954636 },
  { 1.5707963267948966, 0.0000000000000000, 1.5707963267948966 },
};

// Test function for k=0.0000000000000000.
template <typename Tp>
void test010()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data010)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data010[i].k), Tp(data010[i].phi));
      const Tp f0 = data010[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=0.10000000000000009.
testcase_ellint_1<double> data011[] = {
  { -0.0000000000000000, 0.10000000000000009, 0.0000000000000000 },
  { 0.17454173353063665, 0.10000000000000009, 0.17453292519943295 },
  { 0.34913506721468085, 0.10000000000000009, 0.34906585039886590 },
  { 0.52382550016538953, 0.10000000000000009, 0.52359877559829882 },
  { 0.69864700854177031, 0.10000000000000009, 0.69813170079773179 },
  { 0.87361792586964870, 0.10000000000000009, 0.87266462599716477 },
  { 1.0487386319621685, 0.10000000000000009, 1.0471975511965976 },
  { 1.2239913752078757, 0.10000000000000009, 1.2217304763960306 },
  { 1.3993423113684049, 0.10000000000000009, 1.3962634015954636 },
  { 1.5747455615173562, 0.10000000000000009, 1.5707963267948966 },
};

// Test function for k=0.10000000000000009.
template <typename Tp>
void test011()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data011)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data011[i].k), Tp(data011[i].phi));
      const Tp f0 = data011[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=0.19999999999999996.
testcase_ellint_1<double> data012[] = {
  { -0.0000000000000000, 0.19999999999999996, 0.0000000000000000 },
  { 0.17456817290292811, 0.19999999999999996, 0.17453292519943295 },
  { 0.34934315932086801, 0.19999999999999996, 0.34906585039886590 },
  { 0.52450880529443988, 0.19999999999999996, 0.52359877559829882 },
  { 0.70020491009844910, 0.19999999999999996, 0.69813170079773179 },
  { 0.87651006649967955, 0.19999999999999996, 0.87266462599716477 },
  { 1.0534305870298994, 0.19999999999999996, 1.0471975511965976 },
  { 1.2308975521670784, 0.19999999999999996, 1.2217304763960306 },
  { 1.4087733584990738, 0.19999999999999996, 1.3962634015954636 },
  { 1.5868678474541664, 0.19999999999999996, 1.5707963267948966 },
};

// Test function for k=0.19999999999999996.
template <typename Tp>
void test012()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data012)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data012[i].k), Tp(data012[i].phi));
      const Tp f0 = data012[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=0.30000000000000004.
testcase_ellint_1<double> data013[] = {
  { -0.0000000000000000, 0.30000000000000004, 0.0000000000000000 },
  { 0.17461228653000102, 0.30000000000000004, 0.17453292519943295 },
  { 0.34969146102798415, 0.30000000000000004, 0.34906585039886590 },
  { 0.52565822873726320, 0.30000000000000004, 0.52359877559829882 },
  { 0.70284226512408532, 0.30000000000000004, 0.69813170079773179 },
  { 0.88144139195111182, 0.30000000000000004, 0.87266462599716477 },
  { 1.0614897067260523, 0.30000000000000004, 1.0471975511965976 },
  { 1.2428416824174218, 0.30000000000000004, 1.2217304763960306 },
  { 1.4251795877015925, 0.30000000000000004, 1.3962634015954636 },
  { 1.6080486199305126, 0.30000000000000004, 1.5707963267948966 },
};

// Test function for k=0.30000000000000004.
template <typename Tp>
void test013()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data013)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data013[i].k), Tp(data013[i].phi));
      const Tp f0 = data013[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=0.39999999999999991.
testcase_ellint_1<double> data014[] = {
  { -0.0000000000000000, 0.39999999999999991, 0.0000000000000000 },
  { 0.17467414669441531, 0.39999999999999991, 0.17453292519943295 },
  { 0.35018222772483443, 0.39999999999999991, 0.34906585039886590 },
  { 0.52729015917508748, 0.39999999999999991, 0.52359877559829882 },
  { 0.70662374407341255, 0.39999999999999991, 0.69813170079773179 },
  { 0.88859210497602170, 0.39999999999999991, 0.87266462599716477 },
  { 1.0733136290471379, 0.39999999999999991, 1.0471975511965976 },
  { 1.2605612170157061, 0.39999999999999991, 1.2217304763960306 },
  { 1.4497513956433437, 0.39999999999999991, 1.3962634015954636 },
  { 1.6399998658645112, 0.39999999999999991, 1.5707963267948966 },
};

// Test function for k=0.39999999999999991.
template <typename Tp>
void test014()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data014)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data014[i].k), Tp(data014[i].phi));
      const Tp f0 = data014[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=0.50000000000000000.
testcase_ellint_1<double> data015[] = {
  { -0.0000000000000000, 0.50000000000000000, 0.0000000000000000 },
  { 0.17475385514035785, 0.50000000000000000, 0.17453292519943295 },
  { 0.35081868470101585, 0.50000000000000000, 0.34906585039886590 },
  { 0.52942862705190585, 0.50000000000000000, 0.52359877559829882 },
  { 0.71164727562630326, 0.50000000000000000, 0.69813170079773179 },
  { 0.89824523594227768, 0.50000000000000000, 0.87266462599716477 },
  { 1.0895506700518851, 0.50000000000000000, 1.0471975511965976 },
  { 1.2853005857432933, 0.50000000000000000, 1.2217304763960306 },
  { 1.4845545520549484, 0.50000000000000000, 1.3962634015954636 },
  { 1.6857503548125963, 0.50000000000000000, 1.5707963267948966 },
};

// Test function for k=0.50000000000000000.
template <typename Tp>
void test015()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data015)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data015[i].k), Tp(data015[i].phi));
      const Tp f0 = data015[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=0.60000000000000009.
testcase_ellint_1<double> data016[] = {
  { -0.0000000000000000, 0.60000000000000009, 0.0000000000000000 },
  { 0.17485154362988362, 0.60000000000000009, 0.17453292519943295 },
  { 0.35160509865544326, 0.60000000000000009, 0.34906585039886590 },
  { 0.53210652578446160, 0.60000000000000009, 0.52359877559829882 },
  { 0.71805304664485670, 0.60000000000000009, 0.69813170079773179 },
  { 0.91082759030195970, 0.60000000000000009, 0.87266462599716477 },
  { 1.1112333229323366, 0.60000000000000009, 1.0471975511965976 },
  { 1.3191461190365270, 0.60000000000000009, 1.2217304763960306 },
  { 1.5332022105084775, 0.60000000000000009, 1.3962634015954636 },
  { 1.7507538029157526, 0.60000000000000009, 1.5707963267948966 },
};

// Test function for k=0.60000000000000009.
template <typename Tp>
void test016()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data016)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data016[i].k), Tp(data016[i].phi));
      const Tp f0 = data016[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=0.69999999999999996.
testcase_ellint_1<double> data017[] = {
  { -0.0000000000000000, 0.69999999999999996, 0.0000000000000000 },
  { 0.17496737466916720, 0.69999999999999996, 0.17453292519943295 },
  { 0.35254687535677925, 0.69999999999999996, 0.34906585039886590 },
  { 0.53536740275997130, 0.69999999999999996, 0.52359877559829882 },
  { 0.72603797651684465, 0.69999999999999996, 0.69813170079773179 },
  { 0.92698296348313458, 0.69999999999999996, 0.87266462599716477 },
  { 1.1400447527693316, 0.69999999999999996, 1.0471975511965976 },
  { 1.3657668117194071, 0.69999999999999996, 1.2217304763960306 },
  { 1.6024686895959159, 0.69999999999999996, 1.3962634015954636 },
  { 1.8456939983747236, 0.69999999999999996, 1.5707963267948966 },
};

// Test function for k=0.69999999999999996.
template <typename Tp>
void test017()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data017)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data017[i].k), Tp(data017[i].phi));
      const Tp f0 = data017[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=0.80000000000000004.
testcase_ellint_1<double> data018[] = {
  { -0.0000000000000000, 0.80000000000000004, 0.0000000000000000 },
  { 0.17510154241338902, 0.80000000000000004, 0.17453292519943295 },
  { 0.35365068839779390, 0.80000000000000004, 0.34906585039886590 },
  { 0.53926804409084561, 0.80000000000000004, 0.52359877559829882 },
  { 0.73587926028070383, 0.80000000000000004, 0.69813170079773179 },
  { 0.94770942970071170, 0.80000000000000004, 0.87266462599716477 },
  { 1.1789022995388239, 0.80000000000000004, 1.0471975511965976 },
  { 1.4323027881876009, 0.80000000000000004, 1.2217304763960306 },
  { 1.7069629739121674, 0.80000000000000004, 1.3962634015954636 },
  { 1.9953027776647296, 0.80000000000000004, 1.5707963267948966 },
};

// Test function for k=0.80000000000000004.
template <typename Tp>
void test018()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data018)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data018[i].k), Tp(data018[i].phi));
      const Tp f0 = data018[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for k=0.89999999999999991.
testcase_ellint_1<double> data019[] = {
  { -0.0000000000000000, 0.89999999999999991, 0.0000000000000000 },
  { 0.17525427376115027, 0.89999999999999991, 0.17453292519943295 },
  { 0.35492464591297446, 0.89999999999999991, 0.34906585039886590 },
  { 0.54388221416157123, 0.89999999999999991, 0.52359877559829882 },
  { 0.74797400423532501, 0.89999999999999991, 0.69813170079773179 },
  { 0.97463898451966458, 0.89999999999999991, 0.87266462599716477 },
  { 1.2334463254523438, 0.89999999999999991, 1.0471975511965976 },
  { 1.5355247765594910, 0.89999999999999991, 1.2217304763960306 },
  { 1.8882928567775117, 0.89999999999999991, 1.3962634015954636 },
  { 2.2805491384227699, 0.89999999999999991, 1.5707963267948966 },
};

// Test function for k=0.89999999999999991.
template <typename Tp>
void test019()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data019)
                         / sizeof(testcase_ellint_1<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::ellint_1(Tp(data019[i].k), Tp(data019[i].phi));
      const Tp f0 = data019[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

int main(int, char**)
{
  test001<double>();
  test002<double>();
  test003<double>();
  test004<double>();
  test005<double>();
  test006<double>();
  test007<double>();
  test008<double>();
  test009<double>();
  test010<double>();
  test011<double>();
  test012<double>();
  test013<double>();
  test014<double>();
  test015<double>();
  test016<double>();
  test017<double>();
  test018<double>();
  test019<double>();
  return 0;
}
