/*
 * Copyright (c) 2018-2020, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*
 * ZynqMP system level PM-API functions for pin control.
 */

#ifndef PM_API_PINCTRL_H
#define PM_API_PINCTRL_H

#include "pm_common.h"

#define FUNCTION_NAME_LEN		U(16)
#define GROUPS_PAYLOAD_LEN		U(12)
#define NUM_GROUPS_PER_RESP		U(6)
#define END_OF_FUNCTION			"END_OF_FUNCTION"
#define END_OF_GROUPS			-1
#define PINCTRL_GRP_RESERVED		-2

//pinctrl function ids
enum {
	PINCTRL_FUNC_CAN0,
	PINCTRL_FUNC_CAN1,
	PINCTRL_FUNC_ETHERNET0,
	PINCTRL_FUNC_ETHERNET1,
	PINCTRL_FUNC_ETHERNET2,
	PINCTRL_FUNC_ETHERNET3,
	PINCTRL_FUNC_GEMTSU0,
	PINCTRL_FUNC_GPIO0,
	PINCTRL_FUNC_I2C0,
	PINCTRL_FUNC_I2C1,
	PINCTRL_FUNC_MDIO0,
	PINCTRL_FUNC_MDIO1,
	PINCTRL_FUNC_MDIO2,
	PINCTRL_FUNC_MDIO3,
	PINCTRL_FUNC_QSPI0,
	PINCTRL_FUNC_QSPI_FBCLK,
	PINCTRL_FUNC_QSPI_SS,
	PINCTRL_FUNC_SPI0,
	PINCTRL_FUNC_SPI1,
	PINCTRL_FUNC_SPI0_SS,
	PINCTRL_FUNC_SPI1_SS,
	PINCTRL_FUNC_SDIO0,
	PINCTRL_FUNC_SDIO0_PC,
	PINCTRL_FUNC_SDIO0_CD,
	PINCTRL_FUNC_SDIO0_WP,
	PINCTRL_FUNC_SDIO1,
	PINCTRL_FUNC_SDIO1_PC,
	PINCTRL_FUNC_SDIO1_CD,
	PINCTRL_FUNC_SDIO1_WP,
	PINCTRL_FUNC_NAND0,
	PINCTRL_FUNC_NAND0_CE,
	PINCTRL_FUNC_NAND0_RB,
	PINCTRL_FUNC_NAND0_DQS,
	PINCTRL_FUNC_TTC0_CLK,
	PINCTRL_FUNC_TTC0_WAV,
	PINCTRL_FUNC_TTC1_CLK,
	PINCTRL_FUNC_TTC1_WAV,
	PINCTRL_FUNC_TTC2_CLK,
	PINCTRL_FUNC_TTC2_WAV,
	PINCTRL_FUNC_TTC3_CLK,
	PINCTRL_FUNC_TTC3_WAV,
	PINCTRL_FUNC_UART0,
	PINCTRL_FUNC_UART1,
	PINCTRL_FUNC_USB0,
	PINCTRL_FUNC_USB1,
	PINCTRL_FUNC_SWDT0_CLK,
	PINCTRL_FUNC_SWDT0_RST,
	PINCTRL_FUNC_SWDT1_CLK,
	PINCTRL_FUNC_SWDT1_RST,
	PINCTRL_FUNC_PMU0,
	PINCTRL_FUNC_PCIE0,
	PINCTRL_FUNC_CSU0,
	PINCTRL_FUNC_DPAUX0,
	PINCTRL_FUNC_PJTAG0,
	PINCTRL_FUNC_TRACE0,
	PINCTRL_FUNC_TRACE0_CLK,
	PINCTRL_FUNC_TESTSCAN0,
	END_FUNCTION,
};

#define MAX_FUNCTION (unsigned int)(END_FUNCTION)

// pinctrl pin numbers
enum {
	PINCTRL_PIN_0,
	PINCTRL_PIN_1,
	PINCTRL_PIN_2,
	PINCTRL_PIN_3,
	PINCTRL_PIN_4,
	PINCTRL_PIN_5,
	PINCTRL_PIN_6,
	PINCTRL_PIN_7,
	PINCTRL_PIN_8,
	PINCTRL_PIN_9,
	PINCTRL_PIN_10,
	PINCTRL_PIN_11,
	PINCTRL_PIN_12,
	PINCTRL_PIN_13,
	PINCTRL_PIN_14,
	PINCTRL_PIN_15,
	PINCTRL_PIN_16,
	PINCTRL_PIN_17,
	PINCTRL_PIN_18,
	PINCTRL_PIN_19,
	PINCTRL_PIN_20,
	PINCTRL_PIN_21,
	PINCTRL_PIN_22,
	PINCTRL_PIN_23,
	PINCTRL_PIN_24,
	PINCTRL_PIN_25,
	PINCTRL_PIN_26,
	PINCTRL_PIN_27,
	PINCTRL_PIN_28,
	PINCTRL_PIN_29,
	PINCTRL_PIN_30,
	PINCTRL_PIN_31,
	PINCTRL_PIN_32,
	PINCTRL_PIN_33,
	PINCTRL_PIN_34,
	PINCTRL_PIN_35,
	PINCTRL_PIN_36,
	PINCTRL_PIN_37,
	PINCTRL_PIN_38,
	PINCTRL_PIN_39,
	PINCTRL_PIN_40,
	PINCTRL_PIN_41,
	PINCTRL_PIN_42,
	PINCTRL_PIN_43,
	PINCTRL_PIN_44,
	PINCTRL_PIN_45,
	PINCTRL_PIN_46,
	PINCTRL_PIN_47,
	PINCTRL_PIN_48,
	PINCTRL_PIN_49,
	PINCTRL_PIN_50,
	PINCTRL_PIN_51,
	PINCTRL_PIN_52,
	PINCTRL_PIN_53,
	PINCTRL_PIN_54,
	PINCTRL_PIN_55,
	PINCTRL_PIN_56,
	PINCTRL_PIN_57,
	PINCTRL_PIN_58,
	PINCTRL_PIN_59,
	PINCTRL_PIN_60,
	PINCTRL_PIN_61,
	PINCTRL_PIN_62,
	PINCTRL_PIN_63,
	PINCTRL_PIN_64,
	PINCTRL_PIN_65,
	PINCTRL_PIN_66,
	PINCTRL_PIN_67,
	PINCTRL_PIN_68,
	PINCTRL_PIN_69,
	PINCTRL_PIN_70,
	PINCTRL_PIN_71,
	PINCTRL_PIN_72,
	PINCTRL_PIN_73,
	PINCTRL_PIN_74,
	PINCTRL_PIN_75,
	PINCTRL_PIN_76,
	PINCTRL_PIN_77,
	END_PINS,
};

#define MAX_PIN (unsigned int)(END_PINS)

// pinctrl group ids
enum  {
	PINCTRL_GRP_ETHERNET0_0,
	PINCTRL_GRP_ETHERNET1_0,
	PINCTRL_GRP_ETHERNET2_0,
	PINCTRL_GRP_ETHERNET3_0,
	PINCTRL_GRP_GEMTSU0_0,
	PINCTRL_GRP_GEMTSU0_1,
	PINCTRL_GRP_GEMTSU0_2,
	PINCTRL_GRP_MDIO0_0,
	PINCTRL_GRP_MDIO1_0,
	PINCTRL_GRP_MDIO1_1,
	PINCTRL_GRP_MDIO2_0,
	PINCTRL_GRP_MDIO3_0,
	PINCTRL_GRP_QSPI0_0,
	PINCTRL_GRP_QSPI_SS,
	PINCTRL_GRP_QSPI_FBCLK,
	PINCTRL_GRP_SPI0_0,
	PINCTRL_GRP_SPI0_0_SS0,
	PINCTRL_GRP_SPI0_0_SS1,
	PINCTRL_GRP_SPI0_0_SS2,
	PINCTRL_GRP_SPI0_1,
	PINCTRL_GRP_SPI0_1_SS0,
	PINCTRL_GRP_SPI0_1_SS1,
	PINCTRL_GRP_SPI0_1_SS2,
	PINCTRL_GRP_SPI0_2,
	PINCTRL_GRP_SPI0_2_SS0,
	PINCTRL_GRP_SPI0_2_SS1,
	PINCTRL_GRP_SPI0_2_SS2,
	PINCTRL_GRP_SPI0_3,
	PINCTRL_GRP_SPI0_3_SS0,
	PINCTRL_GRP_SPI0_3_SS1,
	PINCTRL_GRP_SPI0_3_SS2,
	PINCTRL_GRP_SPI0_4,
	PINCTRL_GRP_SPI0_4_SS0,
	PINCTRL_GRP_SPI0_4_SS1,
	PINCTRL_GRP_SPI0_4_SS2,
	PINCTRL_GRP_SPI0_5,
	PINCTRL_GRP_SPI0_5_SS0,
	PINCTRL_GRP_SPI0_5_SS1,
	PINCTRL_GRP_SPI0_5_SS2,
	PINCTRL_GRP_SPI1_0,
	PINCTRL_GRP_SPI1_0_SS0,
	PINCTRL_GRP_SPI1_0_SS1,
	PINCTRL_GRP_SPI1_0_SS2,
	PINCTRL_GRP_SPI1_1,
	PINCTRL_GRP_SPI1_1_SS0,
	PINCTRL_GRP_SPI1_1_SS1,
	PINCTRL_GRP_SPI1_1_SS2,
	PINCTRL_GRP_SPI1_2,
	PINCTRL_GRP_SPI1_2_SS0,
	PINCTRL_GRP_SPI1_2_SS1,
	PINCTRL_GRP_SPI1_2_SS2,
	PINCTRL_GRP_SPI1_3,
	PINCTRL_GRP_SPI1_3_SS0,
	PINCTRL_GRP_SPI1_3_SS1,
	PINCTRL_GRP_SPI1_3_SS2,
	PINCTRL_GRP_SPI1_4,
	PINCTRL_GRP_SPI1_4_SS0,
	PINCTRL_GRP_SPI1_4_SS1,
	PINCTRL_GRP_SPI1_4_SS2,
	PINCTRL_GRP_SPI1_5,
	PINCTRL_GRP_SPI1_5_SS0,
	PINCTRL_GRP_SPI1_5_SS1,
	PINCTRL_GRP_SPI1_5_SS2,
	PINCTRL_GRP_SDIO0_0,
	PINCTRL_GRP_SDIO0_1,
	PINCTRL_GRP_SDIO0_2,
	PINCTRL_GRP_SDIO0_4BIT_0_0,
	PINCTRL_GRP_SDIO0_4BIT_0_1,
	PINCTRL_GRP_SDIO0_4BIT_1_0,
	PINCTRL_GRP_SDIO0_4BIT_1_1,
	PINCTRL_GRP_SDIO0_4BIT_2_0,
	PINCTRL_GRP_SDIO0_4BIT_2_1,
	PINCTRL_GRP_SDIO0_1BIT_0_0,
	PINCTRL_GRP_SDIO0_1BIT_0_1,
	PINCTRL_GRP_SDIO0_1BIT_0_2,
	PINCTRL_GRP_SDIO0_1BIT_0_3,
	PINCTRL_GRP_SDIO0_1BIT_0_4,
	PINCTRL_GRP_SDIO0_1BIT_0_5,
	PINCTRL_GRP_SDIO0_1BIT_0_6,
	PINCTRL_GRP_SDIO0_1BIT_0_7,
	PINCTRL_GRP_SDIO0_1BIT_1_0,
	PINCTRL_GRP_SDIO0_1BIT_1_1,
	PINCTRL_GRP_SDIO0_1BIT_1_2,
	PINCTRL_GRP_SDIO0_1BIT_1_3,
	PINCTRL_GRP_SDIO0_1BIT_1_4,
	PINCTRL_GRP_SDIO0_1BIT_1_5,
	PINCTRL_GRP_SDIO0_1BIT_1_6,
	PINCTRL_GRP_SDIO0_1BIT_1_7,
	PINCTRL_GRP_SDIO0_1BIT_2_0,
	PINCTRL_GRP_SDIO0_1BIT_2_1,
	PINCTRL_GRP_SDIO0_1BIT_2_2,
	PINCTRL_GRP_SDIO0_1BIT_2_3,
	PINCTRL_GRP_SDIO0_1BIT_2_4,
	PINCTRL_GRP_SDIO0_1BIT_2_5,
	PINCTRL_GRP_SDIO0_1BIT_2_6,
	PINCTRL_GRP_SDIO0_1BIT_2_7,
	PINCTRL_GRP_SDIO0_0_PC,
	PINCTRL_GRP_SDIO0_0_CD,
	PINCTRL_GRP_SDIO0_0_WP,
	PINCTRL_GRP_SDIO0_1_PC,
	PINCTRL_GRP_SDIO0_1_CD,
	PINCTRL_GRP_SDIO0_1_WP,
	PINCTRL_GRP_SDIO0_2_PC,
	PINCTRL_GRP_SDIO0_2_CD,
	PINCTRL_GRP_SDIO0_2_WP,
	PINCTRL_GRP_SDIO1_0,
	PINCTRL_GRP_SDIO1_4BIT_0_0,
	PINCTRL_GRP_SDIO1_4BIT_0_1,
	PINCTRL_GRP_SDIO1_4BIT_1_0,
	PINCTRL_GRP_SDIO1_1BIT_0_0,
	PINCTRL_GRP_SDIO1_1BIT_0_1,
	PINCTRL_GRP_SDIO1_1BIT_0_2,
	PINCTRL_GRP_SDIO1_1BIT_0_3,
	PINCTRL_GRP_SDIO1_1BIT_0_4,
	PINCTRL_GRP_SDIO1_1BIT_0_5,
	PINCTRL_GRP_SDIO1_1BIT_0_6,
	PINCTRL_GRP_SDIO1_1BIT_0_7,
	PINCTRL_GRP_SDIO1_1BIT_1_0,
	PINCTRL_GRP_SDIO1_1BIT_1_1,
	PINCTRL_GRP_SDIO1_1BIT_1_2,
	PINCTRL_GRP_SDIO1_1BIT_1_3,
	PINCTRL_GRP_SDIO1_0_PC,
	PINCTRL_GRP_SDIO1_0_CD,
	PINCTRL_GRP_SDIO1_0_WP,
	PINCTRL_GRP_SDIO1_1_PC,
	PINCTRL_GRP_SDIO1_1_CD,
	PINCTRL_GRP_SDIO1_1_WP,
	PINCTRL_GRP_NAND0_0,
	PINCTRL_GRP_NAND0_0_CE,
	PINCTRL_GRP_NAND0_0_RB,
	PINCTRL_GRP_NAND0_0_DQS,
	PINCTRL_GRP_NAND0_1_CE,
	PINCTRL_GRP_NAND0_1_RB,
	PINCTRL_GRP_NAND0_1_DQS,
	PINCTRL_GRP_CAN0_0,
	PINCTRL_GRP_CAN0_1,
	PINCTRL_GRP_CAN0_2,
	PINCTRL_GRP_CAN0_3,
	PINCTRL_GRP_CAN0_4,
	PINCTRL_GRP_CAN0_5,
	PINCTRL_GRP_CAN0_6,
	PINCTRL_GRP_CAN0_7,
	PINCTRL_GRP_CAN0_8,
	PINCTRL_GRP_CAN0_9,
	PINCTRL_GRP_CAN0_10,
	PINCTRL_GRP_CAN0_11,
	PINCTRL_GRP_CAN0_12,
	PINCTRL_GRP_CAN0_13,
	PINCTRL_GRP_CAN0_14,
	PINCTRL_GRP_CAN0_15,
	PINCTRL_GRP_CAN0_16,
	PINCTRL_GRP_CAN0_17,
	PINCTRL_GRP_CAN0_18,
	PINCTRL_GRP_CAN1_0,
	PINCTRL_GRP_CAN1_1,
	PINCTRL_GRP_CAN1_2,
	PINCTRL_GRP_CAN1_3,
	PINCTRL_GRP_CAN1_4,
	PINCTRL_GRP_CAN1_5,
	PINCTRL_GRP_CAN1_6,
	PINCTRL_GRP_CAN1_7,
	PINCTRL_GRP_CAN1_8,
	PINCTRL_GRP_CAN1_9,
	PINCTRL_GRP_CAN1_10,
	PINCTRL_GRP_CAN1_11,
	PINCTRL_GRP_CAN1_12,
	PINCTRL_GRP_CAN1_13,
	PINCTRL_GRP_CAN1_14,
	PINCTRL_GRP_CAN1_15,
	PINCTRL_GRP_CAN1_16,
	PINCTRL_GRP_CAN1_17,
	PINCTRL_GRP_CAN1_18,
	PINCTRL_GRP_CAN1_19,
	PINCTRL_GRP_UART0_0,
	PINCTRL_GRP_UART0_1,
	PINCTRL_GRP_UART0_2,
	PINCTRL_GRP_UART0_3,
	PINCTRL_GRP_UART0_4,
	PINCTRL_GRP_UART0_5,
	PINCTRL_GRP_UART0_6,
	PINCTRL_GRP_UART0_7,
	PINCTRL_GRP_UART0_8,
	PINCTRL_GRP_UART0_9,
	PINCTRL_GRP_UART0_10,
	PINCTRL_GRP_UART0_11,
	PINCTRL_GRP_UART0_12,
	PINCTRL_GRP_UART0_13,
	PINCTRL_GRP_UART0_14,
	PINCTRL_GRP_UART0_15,
	PINCTRL_GRP_UART0_16,
	PINCTRL_GRP_UART0_17,
	PINCTRL_GRP_UART0_18,
	PINCTRL_GRP_UART1_0,
	PINCTRL_GRP_UART1_1,
	PINCTRL_GRP_UART1_2,
	PINCTRL_GRP_UART1_3,
	PINCTRL_GRP_UART1_4,
	PINCTRL_GRP_UART1_5,
	PINCTRL_GRP_UART1_6,
	PINCTRL_GRP_UART1_7,
	PINCTRL_GRP_UART1_8,
	PINCTRL_GRP_UART1_9,
	PINCTRL_GRP_UART1_10,
	PINCTRL_GRP_UART1_11,
	PINCTRL_GRP_UART1_12,
	PINCTRL_GRP_UART1_13,
	PINCTRL_GRP_UART1_14,
	PINCTRL_GRP_UART1_15,
	PINCTRL_GRP_UART1_16,
	PINCTRL_GRP_UART1_17,
	PINCTRL_GRP_UART1_18,
	PINCTRL_GRP_I2C0_0,
	PINCTRL_GRP_I2C0_1,
	PINCTRL_GRP_I2C0_2,
	PINCTRL_GRP_I2C0_3,
	PINCTRL_GRP_I2C0_4,
	PINCTRL_GRP_I2C0_5,
	PINCTRL_GRP_I2C0_6,
	PINCTRL_GRP_I2C0_7,
	PINCTRL_GRP_I2C0_8,
	PINCTRL_GRP_I2C0_9,
	PINCTRL_GRP_I2C0_10,
	PINCTRL_GRP_I2C0_11,
	PINCTRL_GRP_I2C0_12,
	PINCTRL_GRP_I2C0_13,
	PINCTRL_GRP_I2C0_14,
	PINCTRL_GRP_I2C0_15,
	PINCTRL_GRP_I2C0_16,
	PINCTRL_GRP_I2C0_17,
	PINCTRL_GRP_I2C0_18,
	PINCTRL_GRP_I2C1_0,
	PINCTRL_GRP_I2C1_1,
	PINCTRL_GRP_I2C1_2,
	PINCTRL_GRP_I2C1_3,
	PINCTRL_GRP_I2C1_4,
	PINCTRL_GRP_I2C1_5,
	PINCTRL_GRP_I2C1_6,
	PINCTRL_GRP_I2C1_7,
	PINCTRL_GRP_I2C1_8,
	PINCTRL_GRP_I2C1_9,
	PINCTRL_GRP_I2C1_10,
	PINCTRL_GRP_I2C1_11,
	PINCTRL_GRP_I2C1_12,
	PINCTRL_GRP_I2C1_13,
	PINCTRL_GRP_I2C1_14,
	PINCTRL_GRP_I2C1_15,
	PINCTRL_GRP_I2C1_16,
	PINCTRL_GRP_I2C1_17,
	PINCTRL_GRP_I2C1_18,
	PINCTRL_GRP_I2C1_19,
	PINCTRL_GRP_TTC0_0_CLK,
	PINCTRL_GRP_TTC0_0_WAV,
	PINCTRL_GRP_TTC0_1_CLK,
	PINCTRL_GRP_TTC0_1_WAV,
	PINCTRL_GRP_TTC0_2_CLK,
	PINCTRL_GRP_TTC0_2_WAV,
	PINCTRL_GRP_TTC0_3_CLK,
	PINCTRL_GRP_TTC0_3_WAV,
	PINCTRL_GRP_TTC0_4_CLK,
	PINCTRL_GRP_TTC0_4_WAV,
	PINCTRL_GRP_TTC0_5_CLK,
	PINCTRL_GRP_TTC0_5_WAV,
	PINCTRL_GRP_TTC0_6_CLK,
	PINCTRL_GRP_TTC0_6_WAV,
	PINCTRL_GRP_TTC0_7_CLK,
	PINCTRL_GRP_TTC0_7_WAV,
	PINCTRL_GRP_TTC0_8_CLK,
	PINCTRL_GRP_TTC0_8_WAV,
	PINCTRL_GRP_TTC1_0_CLK,
	PINCTRL_GRP_TTC1_0_WAV,
	PINCTRL_GRP_TTC1_1_CLK,
	PINCTRL_GRP_TTC1_1_WAV,
	PINCTRL_GRP_TTC1_2_CLK,
	PINCTRL_GRP_TTC1_2_WAV,
	PINCTRL_GRP_TTC1_3_CLK,
	PINCTRL_GRP_TTC1_3_WAV,
	PINCTRL_GRP_TTC1_4_CLK,
	PINCTRL_GRP_TTC1_4_WAV,
	PINCTRL_GRP_TTC1_5_CLK,
	PINCTRL_GRP_TTC1_5_WAV,
	PINCTRL_GRP_TTC1_6_CLK,
	PINCTRL_GRP_TTC1_6_WAV,
	PINCTRL_GRP_TTC1_7_CLK,
	PINCTRL_GRP_TTC1_7_WAV,
	PINCTRL_GRP_TTC1_8_CLK,
	PINCTRL_GRP_TTC1_8_WAV,
	PINCTRL_GRP_TTC2_0_CLK,
	PINCTRL_GRP_TTC2_0_WAV,
	PINCTRL_GRP_TTC2_1_CLK,
	PINCTRL_GRP_TTC2_1_WAV,
	PINCTRL_GRP_TTC2_2_CLK,
	PINCTRL_GRP_TTC2_2_WAV,
	PINCTRL_GRP_TTC2_3_CLK,
	PINCTRL_GRP_TTC2_3_WAV,
	PINCTRL_GRP_TTC2_4_CLK,
	PINCTRL_GRP_TTC2_4_WAV,
	PINCTRL_GRP_TTC2_5_CLK,
	PINCTRL_GRP_TTC2_5_WAV,
	PINCTRL_GRP_TTC2_6_CLK,
	PINCTRL_GRP_TTC2_6_WAV,
	PINCTRL_GRP_TTC2_7_CLK,
	PINCTRL_GRP_TTC2_7_WAV,
	PINCTRL_GRP_TTC2_8_CLK,
	PINCTRL_GRP_TTC2_8_WAV,
	PINCTRL_GRP_TTC3_0_CLK,
	PINCTRL_GRP_TTC3_0_WAV,
	PINCTRL_GRP_TTC3_1_CLK,
	PINCTRL_GRP_TTC3_1_WAV,
	PINCTRL_GRP_TTC3_2_CLK,
	PINCTRL_GRP_TTC3_2_WAV,
	PINCTRL_GRP_TTC3_3_CLK,
	PINCTRL_GRP_TTC3_3_WAV,
	PINCTRL_GRP_TTC3_4_CLK,
	PINCTRL_GRP_TTC3_4_WAV,
	PINCTRL_GRP_TTC3_5_CLK,
	PINCTRL_GRP_TTC3_5_WAV,
	PINCTRL_GRP_TTC3_6_CLK,
	PINCTRL_GRP_TTC3_6_WAV,
	PINCTRL_GRP_TTC3_7_CLK,
	PINCTRL_GRP_TTC3_7_WAV,
	PINCTRL_GRP_TTC3_8_CLK,
	PINCTRL_GRP_TTC3_8_WAV,
	PINCTRL_GRP_SWDT0_0_CLK,
	PINCTRL_GRP_SWDT0_0_RST,
	PINCTRL_GRP_SWDT0_1_CLK,
	PINCTRL_GRP_SWDT0_1_RST,
	PINCTRL_GRP_SWDT0_2_CLK,
	PINCTRL_GRP_SWDT0_2_RST,
	PINCTRL_GRP_SWDT0_3_CLK,
	PINCTRL_GRP_SWDT0_3_RST,
	PINCTRL_GRP_SWDT0_4_CLK,
	PINCTRL_GRP_SWDT0_4_RST,
	PINCTRL_GRP_SWDT0_5_CLK,
	PINCTRL_GRP_SWDT0_5_RST,
	PINCTRL_GRP_SWDT0_6_CLK,
	PINCTRL_GRP_SWDT0_6_RST,
	PINCTRL_GRP_SWDT0_7_CLK,
	PINCTRL_GRP_SWDT0_7_RST,
	PINCTRL_GRP_SWDT0_8_CLK,
	PINCTRL_GRP_SWDT0_8_RST,
	PINCTRL_GRP_SWDT0_9_CLK,
	PINCTRL_GRP_SWDT0_9_RST,
	PINCTRL_GRP_SWDT0_10_CLK,
	PINCTRL_GRP_SWDT0_10_RST,
	PINCTRL_GRP_SWDT0_11_CLK,
	PINCTRL_GRP_SWDT0_11_RST,
	PINCTRL_GRP_SWDT0_12_CLK,
	PINCTRL_GRP_SWDT0_12_RST,
	PINCTRL_GRP_SWDT1_0_CLK,
	PINCTRL_GRP_SWDT1_0_RST,
	PINCTRL_GRP_SWDT1_1_CLK,
	PINCTRL_GRP_SWDT1_1_RST,
	PINCTRL_GRP_SWDT1_2_CLK,
	PINCTRL_GRP_SWDT1_2_RST,
	PINCTRL_GRP_SWDT1_3_CLK,
	PINCTRL_GRP_SWDT1_3_RST,
	PINCTRL_GRP_SWDT1_4_CLK,
	PINCTRL_GRP_SWDT1_4_RST,
	PINCTRL_GRP_SWDT1_5_CLK,
	PINCTRL_GRP_SWDT1_5_RST,
	PINCTRL_GRP_SWDT1_6_CLK,
	PINCTRL_GRP_SWDT1_6_RST,
	PINCTRL_GRP_SWDT1_7_CLK,
	PINCTRL_GRP_SWDT1_7_RST,
	PINCTRL_GRP_SWDT1_8_CLK,
	PINCTRL_GRP_SWDT1_8_RST,
	PINCTRL_GRP_SWDT1_9_CLK,
	PINCTRL_GRP_SWDT1_9_RST,
	PINCTRL_GRP_SWDT1_10_CLK,
	PINCTRL_GRP_SWDT1_10_RST,
	PINCTRL_GRP_SWDT1_11_CLK,
	PINCTRL_GRP_SWDT1_11_RST,
	PINCTRL_GRP_SWDT1_12_CLK,
	PINCTRL_GRP_SWDT1_12_RST,
	PINCTRL_GRP_GPIO0_0,
	PINCTRL_GRP_GPIO0_1,
	PINCTRL_GRP_GPIO0_2,
	PINCTRL_GRP_GPIO0_3,
	PINCTRL_GRP_GPIO0_4,
	PINCTRL_GRP_GPIO0_5,
	PINCTRL_GRP_GPIO0_6,
	PINCTRL_GRP_GPIO0_7,
	PINCTRL_GRP_GPIO0_8,
	PINCTRL_GRP_GPIO0_9,
	PINCTRL_GRP_GPIO0_10,
	PINCTRL_GRP_GPIO0_11,
	PINCTRL_GRP_GPIO0_12,
	PINCTRL_GRP_GPIO0_13,
	PINCTRL_GRP_GPIO0_14,
	PINCTRL_GRP_GPIO0_15,
	PINCTRL_GRP_GPIO0_16,
	PINCTRL_GRP_GPIO0_17,
	PINCTRL_GRP_GPIO0_18,
	PINCTRL_GRP_GPIO0_19,
	PINCTRL_GRP_GPIO0_20,
	PINCTRL_GRP_GPIO0_21,
	PINCTRL_GRP_GPIO0_22,
	PINCTRL_GRP_GPIO0_23,
	PINCTRL_GRP_GPIO0_24,
	PINCTRL_GRP_GPIO0_25,
	PINCTRL_GRP_GPIO0_26,
	PINCTRL_GRP_GPIO0_27,
	PINCTRL_GRP_GPIO0_28,
	PINCTRL_GRP_GPIO0_29,
	PINCTRL_GRP_GPIO0_30,
	PINCTRL_GRP_GPIO0_31,
	PINCTRL_GRP_GPIO0_32,
	PINCTRL_GRP_GPIO0_33,
	PINCTRL_GRP_GPIO0_34,
	PINCTRL_GRP_GPIO0_35,
	PINCTRL_GRP_GPIO0_36,
	PINCTRL_GRP_GPIO0_37,
	PINCTRL_GRP_GPIO0_38,
	PINCTRL_GRP_GPIO0_39,
	PINCTRL_GRP_GPIO0_40,
	PINCTRL_GRP_GPIO0_41,
	PINCTRL_GRP_GPIO0_42,
	PINCTRL_GRP_GPIO0_43,
	PINCTRL_GRP_GPIO0_44,
	PINCTRL_GRP_GPIO0_45,
	PINCTRL_GRP_GPIO0_46,
	PINCTRL_GRP_GPIO0_47,
	PINCTRL_GRP_GPIO0_48,
	PINCTRL_GRP_GPIO0_49,
	PINCTRL_GRP_GPIO0_50,
	PINCTRL_GRP_GPIO0_51,
	PINCTRL_GRP_GPIO0_52,
	PINCTRL_GRP_GPIO0_53,
	PINCTRL_GRP_GPIO0_54,
	PINCTRL_GRP_GPIO0_55,
	PINCTRL_GRP_GPIO0_56,
	PINCTRL_GRP_GPIO0_57,
	PINCTRL_GRP_GPIO0_58,
	PINCTRL_GRP_GPIO0_59,
	PINCTRL_GRP_GPIO0_60,
	PINCTRL_GRP_GPIO0_61,
	PINCTRL_GRP_GPIO0_62,
	PINCTRL_GRP_GPIO0_63,
	PINCTRL_GRP_GPIO0_64,
	PINCTRL_GRP_GPIO0_65,
	PINCTRL_GRP_GPIO0_66,
	PINCTRL_GRP_GPIO0_67,
	PINCTRL_GRP_GPIO0_68,
	PINCTRL_GRP_GPIO0_69,
	PINCTRL_GRP_GPIO0_70,
	PINCTRL_GRP_GPIO0_71,
	PINCTRL_GRP_GPIO0_72,
	PINCTRL_GRP_GPIO0_73,
	PINCTRL_GRP_GPIO0_74,
	PINCTRL_GRP_GPIO0_75,
	PINCTRL_GRP_GPIO0_76,
	PINCTRL_GRP_GPIO0_77,
	PINCTRL_GRP_USB0_0,
	PINCTRL_GRP_USB1_0,
	PINCTRL_GRP_PMU0_0,
	PINCTRL_GRP_PMU0_1,
	PINCTRL_GRP_PMU0_2,
	PINCTRL_GRP_PMU0_3,
	PINCTRL_GRP_PMU0_4,
	PINCTRL_GRP_PMU0_5,
	PINCTRL_GRP_PMU0_6,
	PINCTRL_GRP_PMU0_7,
	PINCTRL_GRP_PMU0_8,
	PINCTRL_GRP_PMU0_9,
	PINCTRL_GRP_PMU0_10,
	PINCTRL_GRP_PMU0_11,
	PINCTRL_GRP_PCIE0_0,
	PINCTRL_GRP_PCIE0_1,
	PINCTRL_GRP_PCIE0_2,
	PINCTRL_GRP_PCIE0_3,
	PINCTRL_GRP_PCIE0_4,
	PINCTRL_GRP_PCIE0_5,
	PINCTRL_GRP_PCIE0_6,
	PINCTRL_GRP_PCIE0_7,
	PINCTRL_GRP_CSU0_0,
	PINCTRL_GRP_CSU0_1,
	PINCTRL_GRP_CSU0_2,
	PINCTRL_GRP_CSU0_3,
	PINCTRL_GRP_CSU0_4,
	PINCTRL_GRP_CSU0_5,
	PINCTRL_GRP_CSU0_6,
	PINCTRL_GRP_CSU0_7,
	PINCTRL_GRP_CSU0_8,
	PINCTRL_GRP_CSU0_9,
	PINCTRL_GRP_CSU0_10,
	PINCTRL_GRP_CSU0_11,
	PINCTRL_GRP_DPAUX0_0,
	PINCTRL_GRP_DPAUX0_1,
	PINCTRL_GRP_DPAUX0_2,
	PINCTRL_GRP_DPAUX0_3,
	PINCTRL_GRP_PJTAG0_0,
	PINCTRL_GRP_PJTAG0_1,
	PINCTRL_GRP_PJTAG0_2,
	PINCTRL_GRP_PJTAG0_3,
	PINCTRL_GRP_PJTAG0_4,
	PINCTRL_GRP_PJTAG0_5,
	PINCTRL_GRP_TRACE0_0,
	PINCTRL_GRP_TRACE0_0_CLK,
	PINCTRL_GRP_TRACE0_1,
	PINCTRL_GRP_TRACE0_1_CLK,
	PINCTRL_GRP_TRACE0_2,
	PINCTRL_GRP_TRACE0_2_CLK,
	PINCTRL_GRP_TESTSCAN0_0,
};

// pinctrl config parameters
enum {
	PINCTRL_CONFIG_SLEW_RATE,
	PINCTRL_CONFIG_BIAS_STATUS,
	PINCTRL_CONFIG_PULL_CTRL,
	PINCTRL_CONFIG_SCHMITT_CMOS,
	PINCTRL_CONFIG_DRIVE_STRENGTH,
	PINCTRL_CONFIG_VOLTAGE_STATUS,
	PINCTRL_CONFIG_MAX,
};

// pinctrl slew rate
#define	PINCTRL_SLEW_RATE_FAST 0U
#define	PINCTRL_SLEW_RATE_SLOW 1U

// pinctrl bias status
#define	PINCTRL_BIAS_DISABLE 0U
#define	PINCTRL_BIAS_ENABLE 1U

// pinctrl pull control
#define	PINCTRL_BIAS_PULL_DOWN 0U
#define	PINCTRL_BIAS_PULL_UP 1U

// pinctrl schmitt cmos type
#define PINCTRL_INPUT_TYPE_CMOS 0U
#define	PINCTRL_INPUT_TYPE_SCHMITT 1U

//pinctrl drive strength values
#define	PINCTRL_DRIVE_STRENGTH_2MA 0U
#define	PINCTRL_DRIVE_STRENGTH_4MA 1U
#define	PINCTRL_DRIVE_STRENGTH_8MA 2U
#define	PINCTRL_DRIVE_STRENGTH_12MA 3U

void pm_api_pinctrl_get_function_name(unsigned int fid, char *name);
enum pm_ret_status pm_api_pinctrl_get_function_groups(unsigned int fid,
						      unsigned int index,
						      uint16_t *groups);
enum pm_ret_status pm_api_pinctrl_get_pin_groups(unsigned int pin,
						 unsigned int index,
						 uint16_t *groups);
enum pm_ret_status pm_api_pinctrl_get_num_pins(unsigned int *npins);
enum pm_ret_status pm_api_pinctrl_get_num_functions(unsigned int *nfuncs);
enum pm_ret_status pm_api_pinctrl_get_num_func_groups(unsigned int fid,
						      unsigned int *ngroups);
#endif /* PM_API_PINCTRL_H */
