/* -*-C++-*-
*******************************************************************************
*
* File:         t1.cc
* Description:  
*
*******************************************************************************
*/

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <GrTestSource.h>
#include <GrTestSink.h>
#include <GrTestSkippingSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TextTestResult.h>

class SigProcTest : public CppUnit::TestCase {
private:
  VrSource<unsigned long>	*src;
  VrSink<unsigned long>		*sink;
  VrMultiTask			*m;
  const static double	sf = 1e6;

public:
  void  setUp () {
    // all tests require different setup
  }

  void tearDown (){
    m->stop ();
    delete m;
    delete src;
    delete sink;
  }

  void registerTests (CppUnit::TestSuite *suite)
  {
    suite->addTest (new CppUnit::TestCaller<SigProcTest>("test1", &SigProcTest::test1, *this));
    suite->addTest (new CppUnit::TestCaller<SigProcTest>("test2", &SigProcTest::test2, *this));
    suite->addTest (new CppUnit::TestCaller<SigProcTest>("test3", &SigProcTest::test3, *this));
    suite->addTest (new CppUnit::TestCaller<SigProcTest>("test4", &SigProcTest::test4, *this));
    suite->addTest (new CppUnit::TestCaller<SigProcTest>("test5", &SigProcTest::test5, *this));
    suite->addTest (new CppUnit::TestCaller<SigProcTest>("test6", &SigProcTest::test6, *this));
  }

  void loop (){
    for (int i = 0; i < 10; i ++)
      m->process ();
  }

  void setUp_common (VrSource<unsigned long> *src, VrSink<unsigned long> *sink)
  {
    m = new VrMultiTask ();
    m->add (sink);
    NWO_CONNECT (src, sink);
    m->start ();
  }
  
  void	setUp_test1 () {
    src = new GrTestSource (sf, false);
    sink = new GrTestSink (false);
    setUp_common (src, sink);
  }

  void	setUp_test2 () {
    src = new GrTestSource (sf, true);
    sink = new GrTestSink (false);
    setUp_common (src, sink);
  }

  void setUp_skipping (bool sync_src, bool sync_sink)
  {
    src = new GrTestSource (sf, sync_src);
    sink = new GrTestSkippingSink (sync_sink);
    setUp_common (src, sink);
  }

  void	setUp_test3 () { setUp_skipping (false, false); }
  void	setUp_test4 () { setUp_skipping (false, true);  }
  void	setUp_test5 () { setUp_skipping (true, false);  }
  void	setUp_test6 () { setUp_skipping (true, true);   }

  void test1 (){ setUp_test1 ();    loop ();  }
  void test2 (){ setUp_test2 ();    loop ();  }
  void test3 (){ setUp_test3 ();    loop ();  }
  void test4 (){ setUp_test4 ();    loop ();  }
  void test5 (){ setUp_test5 ();    loop ();  }
  void test6 (){ setUp_test6 ();    loop ();  }

};

int 
main (int argc, char **argv)
{
  
  CppUnit::TestSuite	  suite;
  CppUnit::TextTestResult result;
  SigProcTest		  t;

  t.registerTests (&suite);
  
  suite.run (&result);
  std::cout << result << std::endl;

  return result.wasSuccessful () ? 0 : 1;
}
