/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.IntegerStack;
import gnu.jel.Library;
import gnu.jel.LocalField;
import gnu.jel.LocalMethod;
import gnu.jel.OP;
import gnu.jel.TableKeeper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFile
implements Cloneable {
    private int poolEntries = 1;
    private ByteArrayOutputStream constPoolData;
    private DataOutputStream constPool;
    private HashMap<Object, Integer> Items = new HashMap();
    private HashMap<String, Integer> UTFs = new HashMap();
    private int nMethods = 0;
    private int nMethodsPatch;
    private byte[] text;
    int tsize = 0;
    private boolean isInterface;
    private IntegerStack[] cstk = new IntegerStack[6];
    private int startCodeAttr = 0;
    private int startCode = 0;
    private static final byte[] prologue = new byte[]{-54, -2, -70, -66, 0, 3, 0, 45};
    private LocalMethod currMethod = null;
    int[] paramsVars = null;
    private int cW = 0;
    private int mW = 0;
    private static final Class[] specialClasses = (Class[])TableKeeper.getTable("specialClasses");
    private static final Member[] specialMethods;
    private IntegerStack branchStack = new IntegerStack();
    int currJump = 0;
    private boolean iNJ = false;

    void write(int n) {
        try {
            this.text[this.tsize++] = (byte)n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[] byArray = new byte[this.text.length << 1];
            System.arraycopy(this.text, 0, byArray, 0, this.tsize - 1);
            this.text = byArray;
            this.text[this.tsize - 1] = (byte)n;
        }
    }

    void writeShort(int n) {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    void writeInt(int n) {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public ClassFile(int n, String string, Class<?> clazz, Class[] classArray, LocalField[] localFieldArray) {
        int n2;
        this.constPoolData = new ByteArrayOutputStream();
        this.constPool = new DataOutputStream(this.constPoolData);
        this.text = new byte[256];
        for (n2 = 0; n2 < 6; ++n2) {
            this.cstk[n2] = new IntegerStack();
        }
        try {
            int n3;
            this.getUTFIndex(string);
            this.isInterface = (n & 0x200) > 0;
            this.writeShort(n | 0x20);
            ++this.poolEntries;
            this.constPool.write(7);
            this.constPool.writeShort(1);
            this.writeShort(2);
            this.writeShort(this.getIndex(clazz, 9));
            n2 = classArray == null ? 0 : classArray.length;
            this.writeShort(n2);
            for (n3 = 0; n3 < n2; ++n3) {
                this.writeShort(this.getIndex(classArray[n3], 9));
            }
            n3 = localFieldArray == null ? 0 : localFieldArray.length;
            this.writeShort(n3);
            for (int i = 0; i < n3; ++i) {
                LocalField localField = localFieldArray[i];
                this.writeShort(localField.getModifiers());
                this.writeShort(this.getUTFIndex(localField.getName()));
                this.writeShort(this.getUTFIndex(Library.getSignature(localField.getType())));
                this.writeShort(0);
            }
            this.nMethodsPatch = this.tsize;
            this.writeShort(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ClassFile clone() {
        ClassFile classFile = null;
        try {
            classFile = (ClassFile)super.clone();
            classFile.Items = new HashMap<Object, Integer>(classFile.Items);
            classFile.UTFs = new HashMap<String, Integer>(classFile.UTFs);
            classFile.paramsVars = (int[])classFile.paramsVars.clone();
            classFile.branchStack = classFile.branchStack.copy();
            classFile.cstk = new IntegerStack[6];
            for (int i = 0; i < 6; ++i) {
                classFile.cstk[i] = this.cstk[i].copy();
            }
            classFile.constPoolData = new ByteArrayOutputStream();
            this.constPool.flush();
            this.constPoolData.writeTo(classFile.constPoolData);
            classFile.constPool = new DataOutputStream(classFile.constPoolData);
            classFile.text = (byte[])classFile.text.clone();
        }
        catch (IOException iOException) {
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return classFile;
    }

    public void newMethod(LocalMethod localMethod, Class[] classArray) {
        this.finishMethod();
        ++this.nMethods;
        int n = localMethod.getModifiers();
        if (this.isInterface) {
            n |= 0x400;
        }
        boolean bl = (n & 0x400) > 0;
        this.writeShort(n);
        this.writeShort(this.getUTFIndex(localMethod.getName()));
        this.writeShort(this.getUTFIndex(Library.getSignature(localMethod)));
        int n2 = 0;
        Class<?>[] classArray2 = localMethod.getExceptionTypes();
        if (classArray2 != null) {
            ++n2;
        }
        if (!bl) {
            ++n2;
        }
        this.writeShort(n2);
        if (classArray2 != null) {
            n2 = classArray2.length;
            this.writeShort(this.getUTFIndex("Exceptions"));
            this.writeInt((n2 + 1) * 2);
            this.writeShort(n2);
            for (int i = 0; i < n2; ++i) {
                this.writeShort(this.getIndex(classArray2[i], 9));
            }
        }
        if (!bl) {
            this.startCodeAttr = this.tsize;
            this.writeShort(this.getUTFIndex("Code"));
            this.writeInt(0);
            this.writeShort(0);
            Class<?>[] classArray3 = localMethod.getParameterTypes();
            int n3 = classArray3 == null ? 0 : classArray3.length;
            int n4 = classArray == null ? 0 : classArray.length;
            int n5 = (n & 8) == 0 ? 1 : 0;
            int n6 = n3 + n4 + n5;
            this.paramsVars = new int[n6];
            for (int i = 0; i < this.paramsVars.length; ++i) {
                int n7 = i - n5;
                this.paramsVars[i] = this.cW;
                this.noteStk(-1, i < n5 ? 8 : OP.typeID(n7 < n3 ? classArray3[n7] : classArray[n7 - n3]));
            }
            this.writeShort(this.cW);
            this.cW = 0;
            this.writeInt(0);
            this.startCode = this.tsize;
        }
        this.mW = 0;
        if (!bl) {
            this.currMethod = localMethod;
        }
    }

    private void finishMethod() {
        if (this.currMethod != null) {
            int n = this.tsize;
            this.writeShort(0);
            this.writeShort(0);
            int n2 = this.tsize;
            this.tsize = this.startCodeAttr + 2;
            this.writeInt(n2 - this.startCodeAttr - 6);
            this.tsize = this.startCodeAttr + 6;
            this.writeShort(this.mW);
            this.tsize = this.startCode - 2;
            this.writeShort(n - this.startCode);
            this.tsize = n2;
            this.currMethod = null;
        }
    }

    public byte[] getImage() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.finishMethod();
            int n = this.tsize;
            this.tsize = this.nMethodsPatch;
            this.writeShort(this.nMethods);
            this.tsize = n;
            byteArrayOutputStream.write(prologue);
            byteArrayOutputStream.write(this.poolEntries >>> 8 & 0xFF);
            byteArrayOutputStream.write(this.poolEntries >>> 0 & 0xFF);
            this.constPoolData.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.write(this.text, 0, this.tsize);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void noteStk(int n, int n2) {
        if (n >= 0 && n != 9) {
            --this.cW;
            if ((n & 0xFFFFFFFD) == 5) {
                --this.cW;
            }
        }
        if (n2 >= 0 && n2 != 9) {
            ++this.cW;
            if ((n2 & 0xFFFFFFFD) == 5) {
                ++this.cW;
            }
            if (this.cW > this.mW) {
                this.mW = this.cW;
            }
        }
    }

    public final void codeB(long l) {
        while (l != 0L) {
            this.write((byte)(l & 0xFFL));
            l >>>= 8;
        }
    }

    public final void codeM(Member member) {
        int n = member.getModifiers();
        if (Library.isField(member)) {
            if ((n & 8) > 0) {
                this.code(178L);
            } else {
                this.code(180L);
            }
            this.writeShort(this.getIndex(member, 12));
        } else {
            boolean bl = false;
            int n2 = 10;
            if (member instanceof Constructor) {
                this.code(183L);
                ++n2;
            } else if ((n & 8) > 0) {
                this.code(184L);
            } else {
                Class<?> clazz = member.getDeclaringClass();
                bl = clazz != null && clazz.isInterface();
                if (bl) {
                    this.code(185L);
                } else {
                    this.code(182L);
                }
            }
            this.writeShort(this.getIndex(member, n2));
            if (bl) {
                this.writeShort(1 + ((Method)member).getParameterTypes().length << 8);
            }
        }
    }

    public final void code(long l) {
        while (l != 0L) {
            char c = (char)(l & 0xFFL);
            switch (c - 228) {
                case 0: {
                    this.code(244L);
                    this.branchStack.push(this.cW);
                    break;
                }
                case 1: {
                    int n;
                    this.code(59386L);
                    this.cW = n = this.branchStack.pop();
                    this.code(3991728807L);
                    break;
                }
                case 2: {
                    this.code(15723002L);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.cstk[c - 228].pop();
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.cstk[c - 231].push(this.cstk[c - 234].size());
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    int n = 0;
                    IntegerStack integerStack = this.cstk[c - 234];
                    IntegerStack integerStack2 = this.cstk[c - 237];
                    if (integerStack.size() > 0) {
                        n = integerStack.peek();
                    }
                    while (integerStack2.size() > n) {
                        int n2;
                        int n3 = this.tsize;
                        this.tsize = n2 = integerStack2.pop();
                        this.writeShort(n3 - n2 + 1);
                        this.tsize = n3;
                    }
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    this.cstk[c - 240].push(this.tsize);
                    this.writeShort(0);
                    break;
                }
                case 15: {
                    this.currJump = (int)((l >>>= 8) & 0xFFL);
                    break;
                }
                case 16: 
                case 17: {
                    int n = c - 244;
                    this.code(249L);
                    if (this.iNJ ^ n == 0) {
                        this.currJump = (this.currJump - 1 ^ 1) + 1;
                    }
                    this.iNJ = false;
                    this.code(62208 + this.currJump);
                    this.code(15396336 + (n << 16) + ((n ^ 1) << 8) + n);
                    break;
                }
                case 18: 
                case 19: {
                    this.cstk[c - 243].pop();
                    break;
                }
                case 20: {
                    this.code(15198441L);
                    break;
                }
                case 21: {
                    if (this.currJump != 0) break;
                    this.noteStk(0, -1);
                    this.currJump = 157;
                    break;
                }
                case 22: {
                    int n = 0;
                    if (this.currJump == 0) {
                        int n4 = 0;
                        if (this.cstk[3].size() > 0) {
                            n4 = this.cstk[3].peek();
                        }
                        int n5 = 0;
                        if (this.cstk[4].size() > 0) {
                            n5 = this.cstk[4].peek();
                        }
                        int n6 = n = this.cstk[0].size() == n4 && this.cstk[1].size() == n5 ? 1 : 0;
                    }
                    if (n != 0) break;
                    this.code(228L);
                    this.codeLDC(Boolean.TRUE, 0);
                    this.code(229L);
                    this.codeLDC(Boolean.FALSE, 0);
                    this.code(230L);
                    break;
                }
                case 23: {
                    this.code(15395820L);
                    break;
                }
                case 24: {
                    this.code(249L);
                    IntegerStack.swap(this.cstk[1], this.cstk[4].pop(), this.cstk[0], this.cstk[3].pop());
                    this.cstk[5].pop();
                    this.iNJ = !this.iNJ;
                    break;
                }
                case 25: {
                    this.writeShort(this.getIndex(specialClasses[(int)((l >>>= 8) & 0xFFL)], 9));
                    break;
                }
                case 26: {
                    this.codeM(specialMethods[(int)((l >>>= 8) & 0xFFL)]);
                    break;
                }
                default: {
                    this.write(c);
                }
            }
            l >>>= 8;
        }
    }

    public final void codeLDC(Object object, int n) {
        int n2 = 0;
        boolean bl = false;
        int n3 = -1;
        switch (n) {
            case 0: {
                n3 = (Boolean)object != false ? 1 : 0;
            }
            case 2: {
                if (n3 < 0) {
                    n3 = ((Character)object).charValue();
                }
            }
            case 1: 
            case 3: 
            case 4: {
                if (n3 < 0) {
                    n3 = ((Number)object).intValue();
                }
                if (n3 >= -1 && n3 <= 5) {
                    n2 = n3 + 3;
                    break;
                }
                if (n3 < -128 || n3 > 127) break;
                n2 = 0x10 | (n3 & 0xFF) << 8;
                break;
            }
            case 5: {
                long l = (Long)object;
                if (((l | 1L) ^ 1L) == 0L) {
                    n2 = 9 + (int)l;
                    break;
                }
                if (l < -1L || l > 5L) break;
                n2 = 34051 + (int)l;
                break;
            }
            case 6: {
                float f = ((Float)object).floatValue();
                if (f == 0.0f) {
                    n2 = 11;
                    break;
                }
                if (f == 1.0f) {
                    n2 = 12;
                    break;
                }
                if (f != 2.0f) break;
                n2 = 13;
                break;
            }
            case 7: {
                double d = (Double)object;
                if (d == 0.0) {
                    n2 = 14;
                    break;
                }
                if (d != 1.0) break;
                n2 = 15;
                break;
            }
            case 8: {
                if (object != null) break;
                n2 = 1;
                break;
            }
            case 10: {
                bl = true;
            }
            case 11: {
                n2 = 0;
                n = 8;
                break;
            }
        }
        if (n2 == 0) {
            int n4;
            boolean bl2;
            boolean bl3 = bl2 = n == 5 || n == 7;
            if (bl) {
                this.code(2191928458683L);
                this.noteStk(-1, 10);
                n4 = this.getIndex(object.toString(), n);
            } else {
                n4 = this.getIndex(object, n);
            }
            if (!bl2 && n4 <= 255) {
                this.write(18);
                this.write(n4);
            } else {
                int n5 = 19;
                if (bl2) {
                    ++n5;
                }
                this.write(n5);
                this.writeShort(n4);
            }
        } else {
            this.codeB(n2);
        }
        this.noteStk(-1, n);
        if (bl) {
            this.code(2302L);
            this.noteStk(11, -1);
        }
    }

    int getUTFIndex(String string) {
        Integer n = this.UTFs.get(string);
        if (n == null) {
            n = new Integer(this.poolEntries++);
            try {
                this.constPool.write(1);
                this.constPool.writeUTF(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.UTFs.put(string, n);
        }
        return n;
    }

    private int typeID(Object object) {
        int n = OP.typeIDObject(object);
        if (n < 8) {
            return n;
        }
        if (object instanceof String) {
            return 8;
        }
        if (object instanceof Class) {
            return 9;
        }
        if (object instanceof Member) {
            return 10;
        }
        return -1;
    }

    private final int getIndex(Object object) {
        return this.getIndex(object, this.typeID(object));
    }

    public int getIndex(Object object, int n) {
        Integer n2 = this.Items.get(object);
        if (n2 == null) {
            int n3 = -1;
            try {
                int n4 = -1;
                switch (n) {
                    case 0: {
                        n4 = (Boolean)object != false ? 1 : 0;
                    }
                    case 2: {
                        if (n4 < 0) {
                            n4 = ((Character)object).charValue();
                        }
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        if (n4 < 0) {
                            n4 = ((Number)object).intValue();
                        }
                        n3 = this.poolEntries++;
                        this.constPool.write(3);
                        this.constPool.writeInt(n4);
                        break;
                    }
                    case 5: {
                        n3 = this.poolEntries;
                        this.constPool.write(5);
                        this.constPool.writeLong((Long)object);
                        this.poolEntries += 2;
                        break;
                    }
                    case 6: {
                        n3 = this.poolEntries++;
                        this.constPool.write(4);
                        this.constPool.writeFloat(((Float)object).floatValue());
                        break;
                    }
                    case 7: {
                        n3 = this.poolEntries;
                        this.constPool.write(6);
                        this.constPool.writeDouble((Double)object);
                        this.poolEntries += 2;
                        break;
                    }
                    case 8: {
                        int n5 = this.getUTFIndex((String)object);
                        n3 = this.poolEntries++;
                        this.constPool.write(8);
                        this.constPool.writeShort(n5);
                        break;
                    }
                    case 9: {
                        String string = Library.toHistoricalForm(((Class)object).getName());
                        int n6 = this.getUTFIndex(string);
                        n3 = this.poolEntries++;
                        this.constPool.write(7);
                        this.constPool.writeShort(n6);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        Member member = (Member)object;
                        Class<?> clazz = member.getDeclaringClass();
                        int n7 = Library.isField(member) ? 9 : (clazz != null && clazz.isInterface() ? 11 : 10);
                        n3 = this.writeMemberRef(member, n7);
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            n2 = new Integer(n3);
            this.Items.put(object, n2);
        }
        return n2;
    }

    private int writeMemberRef(Member member, int n) throws IOException {
        int n2 = this.getUTFIndex(member instanceof Constructor ? "<init>" : member.getName());
        int n3 = this.getUTFIndex(Library.getSignature(member));
        Class<?> clazz = member.getDeclaringClass();
        int n4 = clazz == null ? 2 : this.getIndex(clazz, 9);
        int n5 = this.poolEntries++;
        this.constPool.write(12);
        this.constPool.writeShort(n2);
        this.constPool.writeShort(n3);
        int n6 = this.poolEntries++;
        this.constPool.write(n);
        this.constPool.writeShort(n4);
        this.constPool.writeShort(n5);
        return n6;
    }

    static {
        char[][] cArray = (char[][])TableKeeper.getTable("specialMds");
        String[] stringArray = (String[])TableKeeper.getTable("specialMdsN");
        specialMethods = new Member[cArray.length];
        Class clazz = null;
        String string = null;
        Class[] classArray = null;
        int n = 0;
        try {
            block7: for (n = 0; n < cArray.length; ++n) {
                int n2 = cArray[n][0] % 100;
                clazz = specialClasses[n2];
                string = stringArray[cArray[n][1]];
                classArray = new Class[cArray[n].length - 2];
                for (int i = 0; i < classArray.length; ++i) {
                    classArray[i] = specialClasses[cArray[n][2 + i]];
                }
                switch (cArray[n][0] / 100) {
                    case 0: {
                        ClassFile.specialMethods[n] = clazz.getMethod(string, classArray);
                        continue block7;
                    }
                    case 1: {
                        ClassFile.specialMethods[n] = clazz.getConstructor(classArray);
                        continue block7;
                    }
                    case 2: {
                        ClassFile.specialMethods[n] = clazz.getField(string);
                        continue block7;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

