
(defun tes-mode ()
  (interactive)
  (fundamental-mode)
  (setq major-mode 'tes-mode)
  (setq mode-name "TES")
  (local-set-key "\t" 'd-latex--tab-key)
  (local-set-key [(return)] 'd-latex--tes-enter)
  (local-set-key [(meta control \\)] 'd-latex--meta-control-backslash)
  (d-font-lock-add-end
   '(
     ("\\\\hrule\\>"         0 'bold nil)
     ("\\\\hspace\\>"        0 'bold nil)
     ("\\\\thispagestyle\\>" 0 'bold nil)
     ("\\\\usepackage\\>"    0 'bold nil)
     ("\\\\thispagestyle\\>" 0 'bold nil)
     ("\\\\\\(color\\|phantom\\|pagebreak\\|vspace\\|hypersetup\\|scalebox\\|includegraphics\\|linewidth\\)\\>" 0 'bold nil)
     ("\\(\\<m4_dnl\\>\\)\\(.*\\)$" (1 'd-face-m4-dnl t) (2 'font-lock-comment-face t))
     ("\\\\color{\\(red\\)}"   1 'fg:lightred nil)
     ("\\\\color{\\(green\\)}" 1 'fg:lightgreen nil)
     ("\\\\color{\\(blue\\)}"  1 'fg:lightblue nil)
     ("@node \\(.*$\\)"    1 'font-lock-function-name-face nil)
     ("@chapter \\(.*$\\)" 1 'font-lock-function-name-face nil)
     ("@section \\(.*$\\)" 1 'font-lock-function-name-face nil)
     ("@\\*"                 0 'fg:lightred nil)
     ))
  )

(defun d-latex--tes-enter ()
  (interactive)
  (insert "\n"))

(provide 'tes-mode)

