/* -*-c-*- -------------- mixgtk_input.c :
 * Implementation of the functions declared in mixgtk_input.h
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "01/04/01 15:24:36 jose"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "mixgtk_widgets.h"
#include "mixgtk_input.h"

enum {
  MSG_, SIGN_, B1_, B2_, B3_, B4_, B5_, DEC_, RESET_, OK_, SIZE_
};

static const gchar *WGT_NAMES_[SIZE_] = {
  "word_label",  "word_sign", "word_b1", "word_b2", "word_b3",
  "word_b4", "word_b5", "word_decimal",  "word_reset", "word_ok"
};

static GtkDialog *dialog_ = NULL;
static GtkWidget *childs_[SIZE_];
static input_callback_t callback_;
static gpointer data_;

/* init */
void
mixgtk_input_init (void)
{
  dialog_ = NULL;
}

static void
init_dialog_ (void)
{
  gint k;
  
  dialog_ = GTK_DIALOG (mixgtk_widget_factory_get_dialog (MIXGTK_WORD_DIALOG));
  g_assert (dialog_ != NULL);
  for (k = 0; k < SIZE_; ++k)
    {
      childs_[k] = mixgtk_widget_factory_get_child_by_name
	(MIXGTK_WORD_DIALOG, WGT_NAMES_[k]);
      g_assert (childs_[k] != NULL);
    }
}

static void
set_word_ (mix_word_t word)
{
  enum {SIZE = 50};
  static gchar BUFFER[SIZE] = {0};
  gint k;
  gint val = mix_word_magnitude (word);
  gboolean neg = mix_word_is_negative (word);
  snprintf (BUFFER, SIZE, "%s%d", neg ? "-" : "", val);
  gtk_entry_set_text (GTK_ENTRY (childs_[DEC_]), BUFFER);
  gtk_entry_set_text (GTK_ENTRY (childs_[SIGN_]), neg ? "-" : "+");
  for (k = 1; k < 6; ++k)
    {
      mix_byte_t b = mix_word_get_byte (word, k);
      snprintf (BUFFER, SIZE, "%d", (int)b);
      gtk_entry_set_text (GTK_ENTRY (childs_[SIGN_ + k]), BUFFER);
    }
}


/* get a word */
void
mixgtk_input_word (const gchar *message, mix_word_t def,
		   input_callback_t cb, gpointer data)
{
  if (!dialog_) init_dialog_ ();
  gtk_label_set_text (GTK_LABEL (childs_[MSG_]), message);
  set_word_ (def);
  callback_ = cb;
  data_ = data;
  gtk_widget_show (childs_[B1_]);
  gtk_widget_show (childs_[B2_]);
  gtk_widget_show (childs_[B3_]);
  gtk_widget_show (GTK_WIDGET (dialog_));
}

/* get a short */
void
mixgtk_input_short (const gchar *message, mix_short_t def,
		    input_callback_t cb, gpointer data)
{
  gtk_label_set_text (GTK_LABEL (childs_[MSG_]), message);
  set_word_ (mix_word_to_short_fast (def));
  callback_ = cb;
  data_ = data;
  gtk_widget_show (GTK_WIDGET (dialog_));
  gtk_widget_hide (childs_[B1_]);
  gtk_widget_hide (childs_[B2_]);
  gtk_widget_hide (childs_[B3_]);
}

#include <gdk/gdkkeysyms.h>

/* dec and bytes input handler */
gboolean
on_word_dec_key_press (GtkWidget *dec, GdkEvent *event, gpointer *data)
{
  GdkEventKey *key = (GdkEventKey *)event;
  if (key->string && strlen (key->string) > 0 && !iscntrl (key->string[0]))
    {
      gchar *text = gtk_entry_get_text (GTK_ENTRY (childs_[DEC_]));
      gint val = atoi (text);
      set_word_ (mix_word_new (val));
    }
  return FALSE;
}

gboolean
on_word_byte_key_press (GtkWidget *widget, GdkEvent *event, gpointer *data)
{
  GdkEventKey *key = (GdkEventKey *)event;
  if (key->string && strlen (key->string) > 0 && !iscntrl (key->string[0]))
    {
      mix_byte_t bytes[5];
      gint k;
      gchar *s;
      mix_word_t w;
      
      for (k = 0; k < 5; ++k)
	{
	  gchar *text = gtk_entry_get_text (GTK_ENTRY (childs_[B1_ + k]));
	  bytes[k] = mix_byte_new (atoi (text));
	}
      w = mix_bytes_to_word (bytes, 5);
      s = gtk_entry_get_text (GTK_ENTRY (childs_[SIGN_]));
      if (s && s[0] == '-') mix_word_reverse_sign (w);
      set_word_ (w);
    }
  return FALSE;
}

gboolean
on_word_sign_key_press (GtkWidget *widget, GdkEvent *event, gpointer *data)
{
  GdkEventKey *key = (GdkEventKey *)event;
  if (key->string && strlen (key->string) > 0 && !iscntrl (key->string[0]))
    {
      gchar s = key->string[0];
      gchar *txt = gtk_entry_get_text (GTK_ENTRY (childs_[SIGN_]));
      gchar c = txt ? txt[0] : '+';
      if ( (s == '+' || s == '-') && s != c)
	{
	  mix_word_t w =  
	    mix_word_new (atoi
			  (gtk_entry_get_text (GTK_ENTRY (childs_[DEC_]))));
	  set_word_ (mix_word_negative (w));
	}
    }
  return FALSE;
}

void
on_word_ok_clicked (GtkWidget *widget, gpointer *data)
{
  const gchar *text = gtk_entry_get_text (GTK_ENTRY (childs_[DEC_]));
  mix_word_t w = mix_word_new (atoi (text));
  callback_ (w, data_);
  gtk_widget_hide (GTK_WIDGET (dialog_));
}

void
on_word_cancel_clicked (GtkWidget *widget, gpointer *data)
{
  gtk_widget_hide (GTK_WIDGET (dialog_));
}

void
on_word_reset_clicked (GtkWidget *w, gpointer *data)
{
  set_word_ (MIX_WORD_ZERO);
}
