/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "CommandManager.h"


CommandManager::CommandManager(void)
{
}


CommandManager::~CommandManager(void)
{
}

#ifdef WIN32
CommandManager::ACTIONKEY CommandManager::readKey(){
	
	if (GetKeyState(VK_RIGHT)& 0x80)
	{
		return RIGHT;		
	}
	if (GetKeyState(VK_LEFT)& 0x80)
	{
		return LEFT;
	}
	if (GetKeyState(VK_UP)& 0x80)
	{
		return UP;
	}	
	if (GetKeyState(VK_DOWN)& 0x80)
	{
		return DOWN;
	}
	if (GetKeyState(VK_SPACE)& 0x80)
	{
		return ACTION;
	}
	if (GetKeyState(VK_RETURN)& 0x80)
	{
		return RETURN;
	}
	if (GetKeyState(VK_ESCAPE)& 0x80)
	{
		return ESCAPE;
	}
	if (GetKeyState(VK_BACK)& 0x80)
	{
		return BACKSPAPE;
	}
	
	if (GetKeyState(0x41)& 0x80)
	{
		return A;
	}
	if (GetKeyState(0x42)& 0x80)
	{
		return B;
	}
	if (GetKeyState(0x43)& 0x80)
	{
		return C;
	}
	if (GetKeyState(0x44)& 0x80)
	{
		return D;
	}
	if (GetKeyState(0x45)& 0x80)
	{
		return E;
	}
	if (GetKeyState(0x46)& 0x80)
	{
		return F;
	}
	if (GetKeyState(0x47)& 0x80)
	{
		return G;
	}
	if (GetKeyState(0x48)& 0x80)
	{
		return H;
	}
	if (GetKeyState(0x49)& 0x80)
	{
		return I;
	}
	if (GetKeyState(0x4A)& 0x80)
	{
		return J;
	}
	if (GetKeyState(0x4B)& 0x80)
	{
		return K;
	}
	if (GetKeyState(0x4C)& 0x80)
	{
		return L;
	}
	if (GetKeyState(0x4D)& 0x80)
	{
		return M;
	}
	if (GetKeyState(0x4E)& 0x80)
	{
		return N;
	}
	if (GetKeyState(0x4F)& 0x80)
	{
		return O;
	}
	if (GetKeyState(0x50)& 0x80)
	{
		return P;
	}
	if (GetKeyState(0x51)& 0x80)
	{
		return Q;
	}
	if (GetKeyState(0x52)& 0x80)
	{
		return R;
	}
	if (GetKeyState(0x53)& 0x80)
	{
		return S;
	}
	if (GetKeyState(0x54)& 0x80)
	{
		return T;
	}
	if (GetKeyState(0x55)& 0x80)
	{
		return U;
	}
	if (GetKeyState(0x56)& 0x80)
	{
		return V;
	}
	if (GetKeyState(0x57)& 0x80)
	{
		return W;
	}
	if (GetKeyState(0x58)& 0x80)
	{
		return X;
	}
	if (GetKeyState(0x59)& 0x80)
	{
		return Y;
	}
	if (GetKeyState(0x5A)& 0x80)
	{
		return Z;
	}
	return NOACTION;

}
#else
#include <stdio.h>
#include <cstdlib>
#include <iostream>
 #include <termios.h>
  #include <sys/types.h>
    #include <sys/stat.h>
    #include <unistd.h>

static struct termios   save_termios;
static int              term_saved;

int tty_raw(int fd) {       /* RAW! mode */
    struct termios  buf;

    if (tcgetattr(fd, &save_termios) < 0) /* get the original state */
        return -1;

    buf = save_termios;

    buf.c_lflag &= ~(ECHO | ICANON | IEXTEN | ISIG);
                    /* echo off, canonical mode off, extended input
                       processing off, signal chars off */

    buf.c_iflag &= ~(BRKINT | ICRNL | ISTRIP | IXON);
                    /* no SIGINT on BREAK, CR-toNL off, input parity
                       check off, don't strip the 8th bit on input,
                       ouput flow control off */

    buf.c_cflag &= ~(CSIZE | PARENB);
                    /* clear size bits, parity checking off */

    buf.c_cflag |= CS8;
                    /* set 8 bits/char */

    buf.c_oflag &= ~(OPOST);
                    /* output processing off */

    buf.c_cc[VMIN] = 1;  /* 1 byte at a time */
    buf.c_cc[VTIME] = 0; /* no timer on input */

    if (tcsetattr(fd, TCSAFLUSH, &buf) < 0)
        return -1;

    term_saved = 1;

    return 0;
}


int tty_reset(int fd) { /* set it to normal! */
    if (term_saved)
        if (tcsetattr(fd, TCSAFLUSH, &save_termios) < 0)
            return -1;

    return 0;
}

int mygetch(void)
{
struct termios oldt,
newt;
int ch;
tcgetattr( STDIN_FILENO, &oldt );
newt = oldt;
newt.c_lflag &= ~( ICANON | ECHO );
tcsetattr( STDIN_FILENO, TCSANOW, &newt );
ch = getchar();
tcsetattr( STDIN_FILENO, TCSANOW, &oldt );
return ch;
}

CommandManager::ACTIONKEY CommandManager::readKey(int Prekey){
	
	//stdin
	
	unsigned char c2[5] ;
	c2[0]=0 ;
	c2[1]=0 ;
	c2[2]=0 ;
	c2[3]=0 ;
	c2[4]=0 ;
	// Set terminal to raw mode 
	tty_raw(fileno(stdin)) ;
	
	read(fileno(stdin), &c2[0], 5);
	
	 // Echo input:
	tty_reset(fileno(stdin)) ;

	if (Prekey<0)
	{
	
		switch (c2[0])
		{
			case 3:
				exit(0);
			case 'a':
				return A;
			case 'b':
				return B;
			case 'c':
				return C;
			case 'd':
				return D;
			case 'e':
				return E;
			case 'f':
				return F;
			case 'g':
				return G;
			case 'h':
				return H;
			case 'i':
				return I;
			case 'j':
				return J;
			case 'k':
				return K;
			case 'l':
				return L;
			case 'm':
				return M;
			case 'n':
				return N;
			case 'o':
				return O;
			case 'p':
				return P;
			case 'q':
				return Q;
			case 'r':
				return R;
			case 's':
				return S;
			case 't':
				return T;
			case 'u':
				return U;
			case 'v':
				return V;
			case 'w':
				return W;
			case 'x':
				return X;
			case 'y':
				return Y;
			case 'z':
				return Z;
			case 13:
				return RETURN;
			case 32:
				return ACTION;
			
			case 127:
				return BACKSPAPE;
			case 65:
					return UP;
				case 66:
					return DOWN;
				case 67:
					return RIGHT;
				case 68:
					return LEFT;
				case 91:
					return NOACTION;
			case 38:
				return ESCAPE;
			case 27:
				//if ((int)c2[1]==0)
				//	return ESCAPE;
				if ((int)c2[1]==91&&(int)c2[2]==65)
					return UP;
				if ((int)c2[1]==91&&(int)c2[2]==66)
					return DOWN;
				if ((int)c2[1]==91&&(int)c2[2]==68)
					return LEFT;
				if ((int)c2[1]==91&&(int)c2[2]==67)
					return RIGHT;

			default: 
				//std::cout<<"DDDDDDDDDDDDDd="<<(int)c2[0]<<":"<<(int)c2[1]<<":"<<(int)c2[2]<<":"<<(int)c2[3]<<std::endl;
				break;
		}
	}
	
	return NOACTION;

}
#endif

