/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "GamePersistanceService.h"
#include <sstream>
#include <fstream>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <time.h>
#include <stdio.h>
#include <iostream>
#include <vector>
#include <cstdlib>
#include "JSONParser.h"
#include "SessionService.h"
#include "ConfigCentral.h"
#include <stdio.h>
std::string GamePersistanceService::create(std::string username){
  //generate the ID
  time_t seed1 = time(NULL);
  std::srand(seed1);
  int random_variable = std::rand();
  std::stringstream session;
  session <<seed1<<"L"<<random_variable;
  //manage game by user
  
  attachUser(session.str(),username);
   return session.str();
   
}

void mkdirer(std::string path){
  std::string dirName=path;
    DIR* dir =  opendir( dirName.c_str());
   struct dirent *dirp;
    struct stat filestat;
   if (dir == NULL)
   {
      //create it  
      mkdir( dirName.c_str(),S_IRWXU|S_IRGRP|S_IXGRP);
      dir =  opendir( dirName.c_str());
   }
   closedir( dir );
  
}

void saveFile(std::string path,std::string filename,std::string content){
  std::string dirName=path;
    mkdirer(path);
  //append file with game id
   std::string direc=dirName+filename;
   remove (direc.c_str() );
   std::ofstream ofs (direc.c_str(),std::ofstream::in | std::ofstream::out | std::ofstream::app);
   ofs<<content<<std::endl;
   ofs.close();
}

void GamePersistanceService::attachUser(std::string gameId,std::string username)
{
    mkdirer((ConfigCentral::getGamePath()).c_str());
    mkdirer((ConfigCentral::getGamePath()+"/mottidata").c_str());
    mkdirer((ConfigCentral::getGamePath()+"/mottidata/user").c_str());
    saveFile((ConfigCentral::getGamePath()+"/mottidata/user/"+username+"/").c_str(),"game.csv",gameId);
    
}
void GamePersistanceService::save(std::string gameId,std::string json){
    //std::string dirName="mottidata/game/";
    mkdirer((ConfigCentral::getGamePath()+"/mottidata").c_str());
    saveFile((ConfigCentral::getGamePath()+"/mottidata/game/").c_str(),gameId+".csv",json);
    std::cout <<"saved "<<gameId<<std::endl;
}

std::string GamePersistanceService::load(std::string gameId){
  std::string namon=(ConfigCentral::getGamePath()+"/mottidata/game/"+gameId+".csv").c_str();
  std::cout <<"load "<<namon<<std::endl;
    std::ifstream ifs (namon.c_str(), std::ifstream::in);

    std::stringstream content;
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      content<<line<<std::endl;
    }
    ifs.close();
    return content.str();
}

std::vector<std::string> GamePersistanceService::loads(std::string username){
  
    std::string name=(ConfigCentral::getGamePath()+"/mottidata/user/"+username+"/game.csv").c_str();
    std::ifstream ifs (name.c_str(), std::ifstream::in);
    std::vector<std::string> list;
    std::stringstream content;
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      list.push_back(load(line));
    }
    ifs.close();
    return list;
}
  
std::vector<std::string> GamePersistanceService::loads(){
  std::ifstream fin;
  std::string dir=(ConfigCentral::getGamePath()+"/mottidata/game").c_str(), filepath;
  int num;
  DIR *dp;
  struct dirent *dirp;
  struct stat filestat;

  std::vector<std::string> list;
  

  dp = opendir( dir.c_str() );
  if (dp == NULL)
    {
    std::cout << "Error opening " << dir << std::endl;
    return list;
    }

  while ((dirp = readdir( dp )))
    {
    
    filepath =  dirp->d_name;
    // If the file is a directory (or is in some way invalid) we'll skip it 
    if (!stat( filepath.c_str(), &filestat )) continue;
    if (S_ISDIR( filestat.st_mode ))         continue;
    list.push_back(load(filepath.substr(0,filepath.find("."))));
    
    }

  closedir( dp );
  return list;
}


std::string ListGames::internalDispatch(std::string msg,std::string session){
  std::vector<std::string> list=GamePersistanceService::loads();
  std::stringstream ss;
  ss<<"[";
  for (std::vector<std::string>::iterator it=list.begin();it!=list.end();it++)
  {
    std::cout<<*it<<std::endl;
    if (it!=list.begin())
      ss<<",";
    ss<<*it;
  }
  ss<<"]";
  return ss.str();
}

std::string ListMyGames::internalDispatch(std::string msg,std::string session){
  std::string user=SessionService::retrieveUserFromSession(session);
  std::vector<std::string> list=GamePersistanceService::loads(user);
  std::stringstream ss;
  ss<<"[";
  for (std::vector<std::string>::iterator it=list.begin();it!=list.end();it++)
  {
    if (it!=list.begin())
      ss<<",";
    ss<<*it;
  }
  ss<<"]";
  return ss.str();
}

std::string GetGame::internalDispatch(std::string msg,std::string session){
  std::string user=SessionService::retrieveUserFromSession(session);
  std::istringstream  ssJson(msg);
  json_parser::Parser parser(&ssJson);
  try{
    json_parser::Value *val = parser.jValue();
    
    json_parser::Object* my_object = dynamic_cast<json_parser::Object*>(val);
    if (my_object==NULL)
      return "Error casting object";
    json_parser::Value *id=getValue(my_object,"id");
    
    /**
     * change default name 
     */
    return GamePersistanceService::load(id->cleanStr());
    
  } catch (json_parser::ParseError e) {
    std::cerr << "Oops, the json you gave me does not contain JSON data:" << std::endl;
    std::cerr << e.what() << std::endl;
  }
  
  return "Game doesn't exist";
  
  
}

