;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     The data in this file contains enhancments.                    ;;;;;
;;;                                                                    ;;;;;
;;;  Copyright (c) 1984,1987 by William Schelter,University of Texas   ;;;;;
;;;     All rights reserved                                            ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; If you see bogus or missing data here, please tell GJC or JPG.	 ;;;
;;;       (c) Copyright 1982 Massachusetts Institute of Technology       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "MAXIMA")
(macsyma-module trdata)

;;; N.B. This is some data. Boy, does it have subtle effect on the code
;;; produced by TRANSLATE. It should be carefully checked and updated.
;;; Since it is so small, and compiles so quickly it sometimes serves
;;; as a fix (i.e. hack) file. so be careful.


(TRANSL-MODULE TRDATA)

(EVAL-WHEN (COMPILE)
	   (SETQ *DEF%TR-PRODUCES-AUTOLOAD-FILE* NIL))

;; this should go someplace else perhaps.

(DEF-AUTOLOAD-TRANSLATE $romberg $interpolate)

;;; MODEDECLARE(FUNCTION(LENGTH),FIXNUM)

;;I think all this can be done at load time only:--wfs
(eval-when (load)

(MAPC '(LAMBDA (X) (PUTPROP X '$FIXNUM 'FUNCTION-MODE))
      '($LENGTH $NTERMS RANDOM $NROOTS $RANK $POLYSIGN $TIME
		$ARRAY_DIMENSION_N))

;;; MODEDECLARE(FUNCTION(ROMBERG_SUBR),FLOAT)
;;; ROMBERG is a macsyma macro.

(MAPC '(LAMBDA (X) (PUTPROP X '$FLOAT 'FUNCTION-MODE))
      '($ROMBERG_SUBR $INTERPOLATE_SUBR))

;;; Functions of BOOLEAN return VALUE. i.e. PREDICATES

(MAPC '(LAMBDA (X) (PUTPROP X '$BOOLEAN 'FUNCTION-MODE))
      '($ARRAY $BFLOATP $LISTP $MATRIXP $RATNUMP $CONSTANTP
	$ATOM $FREEOF $subvarp $SYMBOLP
	$evenp $oddp $orderlessp $ordergreatp $mapatom
	$INTEGERP $FLOATNUMP $NONSCALARP $NUMBERP $RATP $MEMBER
	$EMPTYP))

;;; MODEDECLARE(TRUE,BOOLEAN)

(MAPC '(LAMBDA (X) (PUTPROP X '$BOOLEAN 'MODE))
      '($TRUE $FALSE $DOALLMXOPS $DOMXMXOPS $DOSCMXOPS $DETOUT
	      $DOTASSOC $DOTDISTRIB $DOTSCRULES $EXPONENTIALIZE
	      $KEEPFLOAT $LISTARITH $LOGSIMP
	      $MAXAPPLYHEIGHT $MAXAPPLYDEPTH $MAPERROR $POWERDISP
	      $SCALARMATRIX $SIMP $TTYOFF $UNDERFLOW $INFEVAL
	      $XAXIS $YAXIS $RATFAC))

(MAPC '(LAMBDA (X) (PUTPROP X (STRIPDOLLAR X) 'LISP-FUNCTION-TO-USE))
      '(%LOG %SIN %COS %TAN %COT %CSC %SEC %ACOT
	     %ASIN %ACOS %ACSC %ASEC
	%SINH %COSH %TANH %COTH %CSCH %SECH %ASINH %ACSCH %ERF))

(MAPC '(LAMBDA (X) (PUTPROP X T 'IMPLIED-QUOTEP))
      '($EVAL $DONE $%I $%PI $%E $%PHI $%GAMMA
	      MQAPPLY ; important for array referencing conventions.
	      ))


;;; The result of a part function never needs simplification.
;;;  $CONS for example has the same property, although it
;;; is not a "PART" function.

;;; ELL has just shown a bug with FIRST and REST interaction with
;;; DEFMATCH and MATCHDECLARE. The extra simplification needed
;;; it seems. LIST mode must be implemented, untill then the
;;; cost of the extra SIMPLFY call is not much compared with the
;;; consing involved. Above all, we must have correct code !!!

(MAPC '(LAMBDA (L) (PUTPROP L t 'TR-NOSIMP))
      '(;$FIRST $REST $LAST
	$PRINT
	$NUM $DENOM $LHS $RHS $PART
	$CONS $REVERSE $ENDCONS $APPEND
	$UNION $INTERSECTION $SETDIFF $SYMDIFF
	$MAPSET $PREDSET |${| $ELEMENTOF
	))

(DEFPROP $REALPART $REALPART LISP-FUNCTION-TO-USE)


(SETQ TRANSL-MODULES '(

TRANSS
TRANSL
TRUTIL
TRANS1
TRANS2
TRANS3
TRANS4
TRANS5
TRANSF
TROPER
TRPRED

MTAGS
MDEFUN
TRANSQ
FCALL
ACALL
TRDATA
MCOMPI
TRMODE
TRHOOK
))

)