/* provide access to the system time
 * (c) 1994/11/02 - 1995/01/14 Erik Schnetter
 */

#include "System/header.h"
#include <sys/times.h>
#include <sys/types.h>
#include <sys/timeb.h>

void get_time (INT* t)
{
  struct timeb tp;
  if (ftime (&tp) == -1) {
    fprintf (stderr, "ftime() system call in C function get_time() failed in file: " __FILE__ ", line: %d\n", __LINE__);
    abort ();
  }
  t[0] = tp.time;		/* seconds since the epoch */
  t[1] = tp.millitm;		/* milliseconds since last second began */
  t[2] = tp.timezone;		/* minutes of time westward from Greenwich */
  t[3] = tp.dstflag;		/* currently daylight saving time? */
}

void wait_for_time (INT secs, INT millis)
{
  sleep (secs);
  usleep (millis*1000);
}
