#!/bin/bash

echo "Processing version:" $1

if [ "$1" = "-h" ]; then
  echo "Usage:"
  echo "    tools/0install.sh stable|unstable version-nr"
  echo "Example:"
  echo "    tools/0install.sh stable 3.18.0"
  exit 0;
fi

if [ "$1" != "stable" ]; then
  if [ "$1" != "unstable" ]; then
    echo "Param 1 must be 'stable' or 'unstable'";
    exit 1;
  fi
fi

VERSION=$2
DIST=$1
TARBALL=solfege-$VERSION.tar.gz
TF=solfege-$VERSION.tar

if test ! -e $TARBALL ; then
   echo "File solfege-$VERSION.tar.gz does not exist"
   exit -1
fi

if test -e solfege-$VERSION ; then
    echo "Directory solfege-$VERSION exists"
    exit -1
fi

tar zxf solfege-$VERSION.tar.gz
cd solfege-$VERSION
pwd
./configure --prefix=`pwd`/0install
make install
cd 0install
tar --gzip --create --file=../../solfege-0install-$VERSION.tar.gz .

