BEGIN;
SET search_path TO auditor;
DROP FUNCTION IF EXISTS auditor_do_get_auditor_progress;
CREATE FUNCTION auditor_do_get_auditor_progress(
  IN in_keys TEXT[])
RETURNS SETOF INT8
LANGUAGE plpgsql
AS $$
DECLARE
  ini_key TEXT;
  my_off INT8;
BEGIN
  FOREACH ini_key IN ARRAY in_keys
  LOOP
    SELECT progress_offset
      INTO my_off
      FROM auditor_progress
      WHERE progress_key=ini_key;
    IF FOUND
    THEN
      RETURN NEXT my_off;
    ELSE
      RETURN NEXT NULL;
    END IF;
  END LOOP;
END $$;
COMMENT ON FUNCTION auditor_do_get_auditor_progress(TEXT[])
  IS 'Finds all progress offsets associated with the array of keys given as the argument and returns them in order';
DROP FUNCTION IF EXISTS auditor_do_get_balance;
CREATE OR REPLACE FUNCTION auditor_do_get_balance(
  IN in_keys TEXT[])
RETURNS SETOF taler_amount
LANGUAGE plpgsql
AS $$
DECLARE
  my_key TEXT;
  my_rec RECORD;
  my_val taler_amount;
BEGIN
  FOREACH my_key IN ARRAY in_keys
  LOOP
    SELECT (ab.balance_value).val
          ,(ab.balance_value).frac
      INTO my_rec
      FROM auditor_balances ab
      WHERE balance_key=my_key;
    IF FOUND
    THEN
        my_val.val = my_rec.val;
        my_val.frac = my_rec.frac;
        RETURN NEXT my_val;
    ELSE
        RETURN NEXT NULL;
    END IF;
  END LOOP;
END $$;
COMMENT ON FUNCTION auditor_do_get_balance(TEXT[])
  IS 'Finds all balances associated with the array of keys given as the argument and returns them in order';
COMMIT;
