/* getkey.c generated by valac 0.56.17, the Vala compiler
 * generated from getkey.vala, do not modify */

/* Getting and ungetting key strokes

   Copyright (c) 1997-2021 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */
/* Standard pauses in ds */

#include <glib.h>
#include <glib-object.h>

#define GETKEY_DEFAULT -1
#define GETKEY_DELAYED 2000
#define MAX_RESYNC_MS 500
#define KBD_NOKEY ((Keystroke) G_MAXUINT)
#define refresh_wait ((gint64) (MAX_RESYNC_MS * 1000))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef guint Keystroke;
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())

VALA_EXTERN Keystroke _last_key;
Keystroke _last_key = 0U;
VALA_EXTERN Flags thisflag;
VALA_EXTERN gint64 next_refresh;
gint64 next_refresh = (gint64) 0;
VALA_EXTERN gint64 now;
gint64 now = 0LL;

VALA_EXTERN Keystroke lastkey (void);
VALA_EXTERN Keystroke getkeystroke (gint delay);
VALA_EXTERN Keystroke term_getkey (gint delay);
VALA_EXTERN GType flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void add_key_to_cmd (Keystroke key);
VALA_EXTERN Keystroke getkey (gint delay);
VALA_EXTERN void term_redisplay (void);
VALA_EXTERN void term_refresh (void);
VALA_EXTERN Keystroke getkey_unfiltered (gint mode);
VALA_EXTERN guint term_getkey_unfiltered (gint delay);
VALA_EXTERN void waitkey (void);
VALA_EXTERN void ungetkey (Keystroke key);
VALA_EXTERN void pushkey (Keystroke key);
VALA_EXTERN void term_ungetkey (Keystroke key);
VALA_EXTERN void remove_key_from_cmd (void);

Keystroke
lastkey (void)
{
	Keystroke result;
#line 32 "src/getkey.vala"
	result = _last_key;
#line 32 "src/getkey.vala"
	return result;
#line 93 "getkey.c"
}

Keystroke
getkeystroke (gint delay)
{
	gboolean _tmp0_ = FALSE;
	Keystroke result;
#line 40 "src/getkey.vala"
	_last_key = term_getkey (delay);
#line 42 "src/getkey.vala"
	if (_last_key != KBD_NOKEY) {
#line 42 "src/getkey.vala"
		_tmp0_ = (thisflag & FLAGS_DEFINING_MACRO) == FLAGS_DEFINING_MACRO;
#line 107 "getkey.c"
	} else {
#line 42 "src/getkey.vala"
		_tmp0_ = FALSE;
#line 111 "getkey.c"
	}
#line 42 "src/getkey.vala"
	if (_tmp0_) {
#line 43 "src/getkey.vala"
		add_key_to_cmd (_last_key);
#line 117 "getkey.c"
	}
#line 45 "src/getkey.vala"
	result = _last_key;
#line 45 "src/getkey.vala"
	return result;
#line 123 "getkey.c"
}

Keystroke
getkey (gint delay)
{
	Keystroke keycode = 0U;
	gboolean _tmp0_ = FALSE;
	Keystroke result;
#line 58 "src/getkey.vala"
	keycode = getkeystroke (0);
#line 60 "src/getkey.vala"
	now = g_get_monotonic_time ();
#line 62 "src/getkey.vala"
	if (keycode == KBD_NOKEY) {
#line 62 "src/getkey.vala"
		_tmp0_ = TRUE;
#line 140 "getkey.c"
	} else {
#line 62 "src/getkey.vala"
		_tmp0_ = now >= next_refresh;
#line 144 "getkey.c"
	}
#line 62 "src/getkey.vala"
	if (_tmp0_) {
#line 63 "src/getkey.vala"
		term_redisplay ();
#line 64 "src/getkey.vala"
		term_refresh ();
#line 65 "src/getkey.vala"
		next_refresh = now + refresh_wait;
#line 154 "getkey.c"
	}
#line 68 "src/getkey.vala"
	if (keycode == KBD_NOKEY) {
#line 69 "src/getkey.vala"
		keycode = getkeystroke (delay);
#line 160 "getkey.c"
	}
#line 71 "src/getkey.vala"
	result = keycode;
#line 71 "src/getkey.vala"
	return result;
#line 166 "getkey.c"
}

Keystroke
getkey_unfiltered (gint mode)
{
	Keystroke key = 0U;
	Keystroke result;
#line 75 "src/getkey.vala"
	key = (Keystroke) term_getkey_unfiltered (mode);
#line 77 "src/getkey.vala"
	_last_key = key;
#line 78 "src/getkey.vala"
	if ((thisflag & FLAGS_DEFINING_MACRO) == FLAGS_DEFINING_MACRO) {
#line 79 "src/getkey.vala"
		add_key_to_cmd (key);
#line 182 "getkey.c"
	}
#line 81 "src/getkey.vala"
	result = key;
#line 81 "src/getkey.vala"
	return result;
#line 188 "getkey.c"
}

void
waitkey (void)
{
#line 89 "src/getkey.vala"
	ungetkey (getkey (GETKEY_DELAYED));
#line 196 "getkey.c"
}

void
pushkey (Keystroke key)
{
#line 96 "src/getkey.vala"
	term_ungetkey (key);
#line 204 "getkey.c"
}

void
ungetkey (Keystroke key)
{
#line 103 "src/getkey.vala"
	pushkey (key);
#line 105 "src/getkey.vala"
	if ((thisflag & FLAGS_DEFINING_MACRO) == FLAGS_DEFINING_MACRO) {
#line 106 "src/getkey.vala"
		remove_key_from_cmd ();
#line 216 "getkey.c"
	}
}

