//
// chnhash.hxx
//
// Abstract base class for chain hash functions
//
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

#ifndef _CHNHASH_HXX
#define _CHNHASH_HXX

#include <lmisc/ltypes.hxx>

class ChainHash 
{
protected:
  u64 _bitCount;

  int _bitsPerBlock;
  int _bitsInHash;
public:
  ChainHash(const int bitsPerBlock, const int bitsInHash);
  virtual ~ChainHash();

  inline int bitsPerBlock() const { return _bitsPerBlock; }
  inline int bitsInHash() const { return _bitsInHash; }

  virtual void ProcessMiddleBlock(const void* block)=0;
  virtual void ProcessFinalBlock(const void* block, const int size)=0;

  virtual void Compress(const void* iv, const void* block, 
                        void* result) const=0;

  virtual void Reset()=0;

  virtual void ChainVariables(void* buffer) const=0;
};

#endif
