/*
 * (C)opyright 1995 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "var.h"
#include "misc.h"

#ifndef	lint
static	char	sccsid[] = "@(#)prcisco.c	1.3 12/17/95 (C) 1995 Darren Reed";
#endif

static	int	order[] = { VA_ACL, VA_INOUT, VA_ACTION, VA_PROTO,
			    VA_FNET, VA_FMASK, VA_FPORT,
			    VA_TNET, VA_TMASK, VA_TPORT, VA_FLAGS, -1 };
static	int	aclbase = 100;

extern	var_t	*varlist;

typedef	struct	{
	char	*lc_lex;
	char	*lc_cisco;
} lex_cisco_t;

static	lex_cisco_t	t_ports[] = {
	{ "gt", "gt" },
	{ "lt", "lt" },
	{ ">", "gt" },
	{ "<", "lt" },
	{ "!=", "neq" },
	{ "eq", "eq" },
	{ "neq", "neq" },
	{ NULL, NULL }
};


static	char	*lc_pt(pname)
char	*pname;
{
	lex_cisco_t	*lc;

	if (!pname)
		return NULL;
	for (lc = t_ports; lc->lc_lex; lc++)
		if (!strcasecmp(pname, lc->lc_lex))
			return lc->lc_cisco;
	fprintf(stderr, "No cisco equivalent for \"%s\"\n", pname);
	return "";
}


static	char	*genmask(mask)
char	*mask;
{
	struct	in_addr	addr;
	int	i, j;

	if (strchr(mask, '.')) {
		addr.s_addr = inet_addr(mask);
		addr.s_addr = ~addr.s_addr;
		return inet_ntoa(addr);
	}

	i = atoi(mask);
	if (i > 32)
		i = 32;
	for (j = 0; (i > 0); i--)
		j |= 1 << i;
	addr.s_addr = j;
	return inet_ntoa(addr);
}


static	void	printaction(str, opt)
char	*str;
int	opt;
{
	int	bits = 0;

	if (strstr(str, "block"))
		bits |= 1;
	if (strstr(str, "pass"))
		bits |= 2;
	if (strstr(str, "log"))
		bits |= 8;

#ifdef	DEBUG
	printf("printaction(%s,%d) = %#x\n", str, opt, bits);
#endif
	if (!opt)
		if (bits & 1)
			printf(" deny");
		else if (bits & 2)
			printf(" accept");
}


static	void	printinout(inout)
char	*inout;
{
	if (strstr(inout, "in"))
		printf("access-list %d", aclbase);
	else if (strstr(inout, "out"))
		printf("access-list %d", aclbase + 50);
}


void	printcisco(lvl)
int	lvl;
{
	var_t	*v, *v2;
	char	*proto, *pcmp, *s;
	int	i, j, k, lastset = -1, aclbase = 100;

	for (i = 0; i < VA_MAX; ) {
		j = i;
		if ((k = order[i]) == -1)
			break;
		for (v = varlist; v; v = v->va_next) {
			if ((k == VA_ACTION) && v->va_action) {
				printaction(v->va_action, 0);
				lastset = k;
				i++;
				break;
			}

			if ((k == VA_INOUT) && v->va_inout) {
				printinout(v->va_inout);
				lastset = k;
				i++;
				break;
			}

			if ((k == VA_ACL) && v->va_aclnum) {
				aclbase = atoi(v->va_aclnum);
				lastset = k;
				i++;
				break;
			}

			if ((k == VA_LOG) && v->va_action) {
				printaction(v->va_action, 1);
				lastset = k;
				i++;
			}

			if (k == VA_PROTO) {
				if (!(proto = v->va_proto) && !v->va_lvl)
					proto = "ip";
				if (proto) {
					lastset = k;
					printf(" %s", proto);
					i++;
					break;
				}
			}

			if ((k == VA_FHOST || k == VA_FNET) &&
			    (v->va_net[0] || v->va_host[0])) {
				if (v->va_net[0])
					printf(" %s", hostnum(v->va_net[0]));
				else
					printf(" %s 0.0.0.0",
						hostnum(v->va_host[0]));
				v2 = v;
				lastset = k;
				i++;
				break;
			}

			if (((k == VA_FMASK) && v->va_mask[0]) && v2) {
				if ((lastset == VA_FNET) && v2->va_net[0]) {
					printf(" %s", genmask(v->va_mask[0]));
					lastset = k;
					i++;
				}
				v2 = NULL;
				break;
			}

			if ((k == VA_FPORT) && (s = v->va_port1[0])) {
				if (strcasecmp(proto, "udp") &&
				    strcasecmp(proto, "tcp")) {
					synerr("port field & not udp/tcp\n");
					break;
					i++;
				}
				if (v->va_portcmp[0])
					pcmp = lc_pt(v->va_portcmp[0]);
				else
					pcmp = "eq";
				if (!pcmp && v->va_portcmp[0])
					synerr("unsupported operator: %s\n",
						v->va_portcmp[0]);
				else if (!v->va_port2[0]) {
					printf(" %s %d", pcmp,
						portnum(s, proto));
					lastset = k;
					i++;
				} else
					synerr("no port ranges on ciscos %s\n",
						v->va_port2[0]);
				break;
			}

			if ((k == VA_THOST || k == VA_TNET) &&
			    (v->va_net[1] || v->va_host[1])) {
				if (v->va_net[1])
					printf(" %s", hostnum(v->va_net[1]));
				else
					printf(" %s 0.0.0.0",
						hostnum(v->va_host[1]));
				lastset = k;
				i++;
				v2 = v;
				break;
			}

			if (((k == VA_TMASK) && v->va_mask[1]) && v2) {
				if ((lastset == VA_TNET) && v2->va_net[1]) {
					printf("/%s", v->va_mask[1]);
					lastset = k;
					i++;
				}
				v2 = NULL;
				break;
			}

			if ((k == VA_TPORT) && (s = v->va_port1[1])) {
				if (strcasecmp(proto, "udp") &&
				    strcasecmp(proto, "tcp")) {
					synerr("port field & not udp/tcp\n");
					break;
					i++;
				}
				if (v->va_portcmp[1])
					pcmp = lc_pt(v->va_portcmp[1]);
				else
					pcmp = "eq";
				if (!pcmp && v->va_portcmp[1])
					synerr("unsupported operator: %s\n",
						v->va_portcmp[1]);
				else if (!v->va_port2[1]) {
					printf(" %s %d", pcmp,
						portnum(s, proto));
					lastset = k;
					i++;
				} else
					synerr("no port ranges on ciscos %s\n",
						v->va_port2[1]);
				break;
			}
                
			if ((k == VA_FLAGS) && v->va_flags) {
				if (!strcasecmp(v->va_flags, "established")) 
					printf(" established");
				else {
					synerr("unsupported flag on ciscos: %s\n", v->va_flags);
					break;
				}
				lastset = k;
				i++;
				break;
			}
		}
		if (!v) {
			if ((k == VA_FNET) || (k == VA_FHOST))
				printf(" 0.0.0.0 255.255.255.255");
			else if ((k == VA_TNET) || (k == VA_THOST))
				printf(" 0.0.0.0 255.255.255.255");
			v2 = NULL;
		}
		if (i == j)
			i++;
	}
	putchar('\n');
}


emitcisco()
{
	var_t   *v;
	char	*s;
	int	ifn;

	if (!(v = varlist))
		return;
	if (!v->va_iface)
		fprintf(stderr, "No interface defined\n");
	if ((v->va_policy & (VP_ACTION|VP_INOUT)) == (VP_ACTION|VP_INOUT)) {
		printf("access-list %s", strstr(v->va_inout, "in") ? "100" :
								     "150");
		printf(" %s", strstr(v->va_action, "pass") ? "permit" :
							     "deny");
		if ((v->va_policy & VP_PROTOCOL) && v->va_proto)
			printf(" %s", v->va_proto);
		else
			printf(" ip");
		printf(" 0.0.0.0 255.255.255.255 0.0.0.0 255.255.255.255\n");
	}

	for (s = v->va_iface; *s && isalpha(*s); s++)
		;
	if (*s && isdigit(*s)) {
		ifn = atoi(s);
		*s = '\0';
		printf("interface %s %d\n", v->va_iface, ifn);
	}

	if (v->va_aclnum) {
		printf("ip access-group %d in\n", atoi(v->va_aclnum));
		printf("ip access-group %d out\n", atoi(v->va_aclnum) + 50);
	} else {
		printf("ip access-group 100 in\n");
		printf("ip access-group 150 out\n");
	}
	clear_policy(v);
}
