/*
 * (C)opyright 1995 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "var.h"
#include "misc.h"

#ifndef	lint
static	char	sccsid[] = "@(#)prfirew.c	1.1 10/22/95 (C) 1995 Darren Reed";
#endif

static	int	order[] = { VA_INOUT, VA_ACTION, VA_ON, VA_LOG, VA_PROTO,
			    VA_FLAGS, VA_IPOPTS, VA_FNET, VA_FMASK, VA_FPORT,
			    VA_TNET, VA_TMASK, VA_TPORT, -1 };
extern	var_t	*varlist;


static	void	printaction(str, opt)
char	*str;
int	opt;
{
	int	bits = 0;

	if (!opt) {
		if (strstr(str, "block"))
			printf(" reject");
		else if (strstr(str, "pass"))
			printf(" accept");
		else if (strstr(str, "log"))
			printf(" log");
	}
}


static	void	printinout(inout)
char	*inout;
{
	if (strstr(inout, "in"))
		printf("ipfirewall addblocking");
	else if (strstr(inout, "out"))
		printf("ipfirewall addfowarding");
}


static	void	printipopts(opts)
char	*opts;
{
	if (strstr(opts, "frag"))
		printf(" ip_fragment");
	else if (strstr(opts, "ipopts") || strstr(opts, "ip_opt"))
		printf(" ip_option");
	else if (strstr(opts, "rr") || strstr(opts, "ts"))
		printf(" ip_recroute_option");
	else if (strstr(opts, "opts"))
		printf(" ip_misc_option");
}


void	printipfirewall(lvl)
int	lvl;
{
	var_t	*v, *v2;
	char	*s;
	int	i, j, k, lastset = -1;

	for (i = 0; i < VA_MAX; ) {
		j = i;
		if ((k = order[i]) == -1)
			break;
		for (v = varlist; v; v = v->va_next) {
			if ((k == VA_ACTION) && v->va_action) {
				printaction(v->va_action, 0);
				lastset = k;
				i++;;
				break;
			}

			if ((k == VA_INOUT) && v->va_inout) {
				printinout(v->va_inout);
				lastset = k;
				i++;;
				break;
			}

			if ((k == VA_ON) && v->va_iface) {
				printf(" %s", v->va_iface);
				lastset = k;
				i++;;
				break;
			}

			if ((k == VA_LOG) && v->va_action) {
				printaction(v->va_action, 1);
				lastset = k;
				i++;
			}

			if ((k == VA_PROTO) && v->va_proto) {
				printf(" %s", v->va_proto);
				lastset = k;
				i++;
				break;
			}

			if ((k == VA_FHOST || k == VA_FNET) &&
			    (v->va_net[0] || v->va_host[0])) {
				if (v->va_net[0])
					printf(" from %s", v->va_net[0]);
				else
					printf(" from %s/32", v->va_host[0]);
				v2 = v;
				lastset = k;
				i++;
				break;
			}

			if (((k == VA_FMASK) && v->va_mask[0]) && v2) {
				if ((lastset == VA_FNET) && v2->va_net[0]) {
					s = v->va_mask[0];
					printf("%c%s",
						strchr(s, '.') ? ':' : '/', s);
					lastset = k;
					i++;
				}
				v2 = NULL;
				break;
			}

			if ((k == VA_FPORT) && v->va_port1[0]) {
				if (!v->va_port2[0])
					printf(" %s", v->va_port1[0]);
				else
					printf(" %s:%s", v->va_port1[0],
						v->va_port2[0]);
				lastset = k;
				i++;
				break;
			}

			if ((k == VA_THOST || k == VA_TNET) &&
			    (v->va_net[1] || v->va_host[1])) {
				if (v->va_net[1])
					printf(" %s", v->va_net[1]);
				else
					printf(" %s/32", v->va_host[1]);
				lastset = k;
				i++;
				v2 = v;
				break;
			}

			if (((k == VA_TMASK) && v->va_mask[1]) && v2) {
				if ((lastset == VA_TNET) && v2->va_net[1]) {
					s = v->va_mask[1];
					printf("%c%s",
						strchr(s, '.') ? ':' : '/', s);
					lastset = k;
					i++;
				}
				v2 = NULL;
				break;
			}

			if ((k == VA_TPORT) && v->va_port1[1]) {
				if (!v->va_port2[1])
					printf(" %s", v->va_port1[1]);
				else
					printf(" %s:%s", v->va_port1[1],
						v->va_port2[1]);
				lastset = k;
				i++;
				break;
			}

			if ((i == VA_FLAGS) && v->va_flags &&
			    (lastset == VA_PROTO)) {
				if (!strcasecmp(v->va_flags, "opening")) {
					printf(" connection");
					lastset = k;
					i++;
				} else
					synerr("ipfirewall doesn't know %s\n",
						v->va_flags);
				break;
			}

			if ((i == VA_IPOPTS) && v->va_opts) {
				printipopts(v->va_opts);
				lastset = k;
				i++;
				break;
			}
		}
		if (!v) {
			if ((k == VA_FNET) || (k == VA_FHOST))
				printf(" from 0/0");
			else if ((k == VA_TNET) || (k == VA_THOST))
				printf(" to 0/0");
			v2 = NULL;
		}
		if (i == j)
			i++;;
	}
	putchar('\n');
}

emitipfirewall()
{
	var_t	*v;

	if (!(v = varlist) ||
	    ((v->va_policy & (VP_ACTION|VP_INOUT)) != (VP_ACTION|VP_INOUT)))
		return;
	printf("ipfirewall %s", strstr(v->va_inout, "in") ? "addblocking" :
							    "addforwarding");
	printf(" %s", strstr(v->va_action, "pass") ? "accept" : "reject");
	if ((v->va_policy & VP_INTERFACE) && v->va_iface)
		printf(" %s", v->va_iface);
	if ((v->va_policy & VP_PROTOCOL) && v->va_proto)
		printf(" %s", v->va_proto);
	printf(" from 0/0 to 0/0\n");
	clear_policy(v);
}
