/*
 * (C)opyright 1995 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "var.h"
#include "misc.h"

#ifndef	lint
static	char	sccsid[] = "@(#)pripfwa.c	1.3 10/22/95 (C) 1995 Darren Reed";
#endif

extern	var_t	*varlist;


static	void	printaction(str, opt)
char	*str;
int	opt;
{
	int	bits = 0;

	if (strstr(str, "block"))
		bits |= 1;
	if (strstr(str, "pass"))
		bits |= 2;
	if (strstr(str, "log"))
		bits |= 8;

#ifdef	DEBUG
	printf("printaction(%s,%d) = %#x\n", str, opt, bits);
#endif
	if (!opt) {
		if (bits & 1)
			printf("ipfwadm -p deny");
		else if (bits & 2)
			printf("ipfwadm -p accept");
	} else if ((bits & 8) && (bits & 3))
		printf(" -k");
}


static	void	printinout(inout)
char	*inout;
{
	if (strstr(inout, "in") && strstr(inout, "out"))
		printf(" -b");
	else if (strstr(inout, "in"))
		printf(" -B");
	else if (strstr(inout, "out"))
		printf(" -F");
}


void	printipfwadm(lvl)
int	lvl;
{
	var_t	*v, *v2;
	int	i, j, lastset = -1;

	for (i = 0; i < VA_MAX; ) {
		j = i;
		for (v = varlist; v; v = v->va_next) {
			if ((i == VA_ACTION) && v->va_action) {
				printaction(v->va_action, 0);
				lastset = i++;
				break;
			}

			if ((i == VA_INOUT) && v->va_inout) {
				printinout(v->va_inout);
				lastset = i++;
				break;
			}

			if ((i == VA_ON) && v->va_iface) {
				printf(" -I %s", v->va_iface);
				lastset = i++;
				break;
			}

			if ((i == VA_LOG) && v->va_action) {
				printaction(v->va_action, 1);
				lastset = i++;;
			}

			if ((i == VA_PROTO) && v->va_proto) {
				printf(" -P %s", v->va_proto);
				lastset = i++;;
				break;
			}

			if ((i == VA_FHOST || i == VA_FNET) &&
			    (v->va_net[0] || v->va_host[0])) {
				if (v->va_net[0])
					printf(" -S %s", v->va_net[0]);
				else
					printf(" -S %s", v->va_host[0]);
				v2 = v;
				lastset = i++;;
				break;
			}

			if (((i == VA_FMASK) && v->va_mask[0]) && v2) {
				if ((lastset == VA_FNET) && v2->va_net[0]) {
					printf("/%s", v->va_mask[0]);
					lastset = i++;;
				}
				v2 = NULL;
				break;
			}

			if ((i == VA_FPORT) && v->va_port1[0]) {
				if (!v->va_port2[0])
					printf(" %s", v->va_port1[0]);
				else
					printf(" %s:%s", v->va_port1[0],
						v->va_port2[0]);
				lastset = i++;;
				break;
			}

			if ((i == VA_THOST || i == VA_TNET) &&
			    (v->va_net[1] || v->va_host[1])) {
				if (v->va_net[1])
					printf(" -D %s", v->va_net[1]);
				else
					printf(" -D %s", v->va_host[1]);
				lastset = i++;;
				v2 = v;
				break;
			}

			if (((i == VA_TMASK) && v->va_mask[1]) && v2) {
				if ((lastset == VA_TNET) && v2->va_net[1]) {
					printf("/%s", v->va_mask[1]);
					lastset = i++;;
				}
				v2 = NULL;
				break;
			}

			if ((i == VA_TPORT) && v->va_port1[1]) {
				if (!v->va_port2[1])
					printf(" %s", v->va_port1[1]);
				else
					printf(" %s:%s", v->va_port1[1],
						v->va_port2[1]);
				lastset = i++;;
				break;
			}

			if ((i == VA_FLAGS) && v->va_flags) {
				if (!strcasecmp(v->va_flags, "opening"))
					printf(" -y");
				lastset = i++;;
				break;
			}
		}
		if (!v) {
			if ((i == VA_FNET) || (i == VA_FHOST))
				printf(" -S 0.0.0.0");
			else if ((i == VA_TNET) || (i == VA_THOST))
				printf(" -D 0.0.0.0");
			v2 = NULL;
		}
		if (i == j)
			i++;;
	}
	putchar('\n');
}

emitipfwadm()
{
	var_t	*v;

	if (!(v = varlist) ||
	    ((v->va_policy & (VP_ACTION|VP_INOUT)) != (VP_ACTION|VP_INOUT)))
		return;
	printf("ipfwadm %s", strstr(v->va_inout, "in") ? "-B" : "-F");
	printf(" -p %s", strstr(v->va_action, "pass") ? "accept" : "deny");
	if ((v->va_policy & VP_INTERFACE) && v->va_iface)
		printf(" -I %s", v->va_iface);
	if ((v->va_policy & VP_PROTOCOL) && v->va_proto)
		printf(" -P %s", v->va_proto);
	printf(" -S 0.0.0.0 -D 0.0.0.0\n");
	clear_policy(v);
}
