/*
     fc - Filter compiler software for the Drawbridge package
     Copyright (C) 1993 David K. Hess, Douglas Lee Schales, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.
*/
#ifndef __MACROS_H__
#define __MACROS_H__

#define FORBOTH(v,x,y) for(v=x; v==(y) || v==(x) ; v += ((y)-(x)) )
#define NEW(t) (t *)malloc(sizeof(t))

#define hiwd(x) (((x) & 0xffff0000) >> 16)
#define lowd(x) ((x) & 0x0000ffff)
#define hibt(x) (((x) & 0xff00) >> 8)
#define lobt(x) ((x) & 0x00ff)
#define swab(x) ((lobt(x) << 8) | (hibt(x)))
#define ltob(x) ((swab(lowd(x)) << 16) | swab(hiwd(x)))

#endif
