/* constchk.c */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   Version 0.1	1997-07-20 Initial version */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>

/* This program checks whether the compiler puts `const' variables and
   string constants into read-only memory (.text) or not.  Yes, I'm
   paranoid. */

static const char * const pgms[] =
{
  "/usr/bin/dig",
  "/usr/bin/finger",
  "/bin/ping",
  "/usr/bin/traceroute"
};

static char non_const;
static jmp_buf cont;

static void sig_handler (int signo)
{
  longjmp (cont, signo);
}

static void sig_install (int signo)
{
  struct sigaction sa;

  sa.sa_handler = sig_handler;
  sa.sa_flags = 0;
  sigemptyset (&sa.sa_mask);
  if (sigaction (signo, &sa, NULL) != 0)
    {
      perror ("sigaction");
      exit (2);
    }
}

static void foo (char c)
{
  static volatile bar;
  bar = c;
}

static void check (char *p, int is_const)
{
  if (setjmp (cont) != 0)
    {
      puts ("I cannot even READ the object!");
      exit (2);
    }
  foo (*p);

  if (setjmp (cont) != 0)
    {
      if (!is_const)
	{
	  puts ("I cannot even write non-const objects!");
	  exit (2);
	}
      return;
    }
  *p = 0;
  if (is_const)
    {
      puts ("Bad news: Your compiler doesn't put const objects into read-only memory.");
      puts ("Try to compile with GCC.");
      exit (1);
    }
}

int main (void)
{
  puts ("Checking if the compiler puts const objects into read-only memory.");
  fflush (stdout);
  sig_install (SIGSEGV);
  sig_install (SIGBUS);
  check (&non_const, 0);	/* I'm paranoid */
  check ((char *)pgms, 1);
  check (&non_const, 0);	/* I'm paranoid */
  check ((char *)pgms[0], 1);
  puts ("Fine.");
  return 0;
}
