/* tnprintf.c */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   1997-01-04 Initial version
   1997-04-05 Reorganize library
   1997-07-19 Add HAVE_VSNPRINTF, use tn_write() instead of tn_puts() */

#include <stdarg.h>
#include <stdio.h>
#include "firewall.h"
#include "libemtn.h"


void tn_printf (tnconn *t, const char *fmt, ...)
{
  int n;
  va_list arg_ptr;
  static char buf[8192];

  va_start (arg_ptr, fmt);
#ifdef HAVE_VSNPRINTF
  n = vsnprintf (buf, sizeof (buf), fmt, arg_ptr);
#else
  n = vsprintf (buf, fmt, arg_ptr);
#endif
  /* This check is not required for HAVE_VSNPRINTF.  It can't hurt. */
  if (n >= sizeof (buf))
    exit (127);
  va_end (arg_ptr);
  if (n > 0)
    tn_write (t, buf, n);
}
