.\" @(#)identd.8 3.0 980504 Lysator
.\" Copyright (c) 1992-1998 Peter Eriksson, Lysator, Linkoping University.
.\" This manual page is released into the public domain."
.\"
.TH identd 1 "4 May 1998"
.SH NAME
identd, in.identd \- TCP/IP IDENT protocol server
.SH SYNOPSIS
.B [in.]identd [options]
.SH DESCRIPTION
.IX "identd daemon" "" \fLidentd\fP daemon"
.B Identd
is a server which implements the
.SM TCP/IP
proposed standard
.SM IDENT
user identification protocol as specified in the
.SM RFC\s0 1413
document.
.PP
.B identd
operates by looking up specific
.SM TCP/IP
connections and returning the user name of the
process owning the connection.  It can optionally
return other information instead of a user name.
.SH OPTIONS
.TP 10
.B \-h
Display the available command line options.
.TP 10
.B \-V
Displays the version and OS version it was compiled for, and then exit.
.TP 10.
.B \-d
Enables extra debugging messages.

.TP 10
.BR \-C<file>
Directs
.B identd
to parse additional configuration options from the file specified.

.TP 10
.B \-i
May be used when starting the daemon by
.B inetd
with the "nowait" option (see below).
.TP 10
.B \-w
May be used when starting the daemon by
.B inetd
with the "wait" option (see below).
.TP 10
.B \-I
May be used when the daemon is started by
.B init
(see below).
.TP 10
.B \-b
flag may be used to make the daemon run in standalone mode (see below).

.TP 10
.B \-u<user>
Used to specify a user number or name to which the
server should switch to after binding itself to the
.SM TCP/IP
port and opening the kernel devices.
.TP 10
.B \-g<group>
Used to specify a group number or name which the
server should switch to after binding itself to the
.SM TCP/IP
port and opening the kernel devices.
.TP 10
.B \-p<port>
Used to specify an alternative TCP port to bind to, if
running as a standalone daemon or started by
.B init
Can be specified by name or by number. Defaults to the
.SM IDENT
port (113).
.TP 10
.B \-t<limit>
Used to specify the request timeout limit. This is the maximum
number of seconds a server will allow a client connection to be
active before terminating it. It defaults to 120 seconds.

.TP 10
.B \-o
Directs
.B identd
to return OTHER instead of UNIX as the "operating system".
.TP 10
.BR \-E
Enables DES encryption of the returned data (see below for more information).
.TP 10
.B \-n
Directs
.B identd
to always return user numbers instead of user names (for example if you
wish to keep the user names a secret).
.TP 10
.B \-N
Directs
.B identd
to check for a file ".noident" in each home directory for the user which
the daemon is about to return the user name for. It that file exists then
the daemon will give the error
.B HIDDEN-USER
instead of the normal USERID response.
.TP 10
.B \-e
Enables certain non-standard protocol extensions.
.TP 10
.B \-m
Enables 
.B identd
to use a mode of operation that will allow multiple requests to be
processed per session. Each request is specified one per line and
the responses will be returned one per line. The connection will not
be closed until the connecting part closes it's end of the line.
.SH INSTALLATION
The prefered way to start
.B identd
depends on how it was built.
.PP
If it was built with support for
multithreading then it should be started either from
.B init
, as a standalone daemon or from
.B inetd
using the "wait" mode (if your
.B inetd
supports it!)
.PP
If it was built without support for multithreading then it
should be started from
.B inetd
using the normal "nowait" mode for "stream tcp" services. (The main reason
being that it will be single-threaded, so it will only serve
.B one
client connection at a time).
.PP
.B identd
normally will autodetect how it was invoked so there normally is
no need to use the four command line switches (\-i, \-w, \-I, \-b).
.SH ENCRYPTION
DES encryption is only available if the daemon was built with
support for it enabled.
.PP
A DES encryption key (1024 bytes long) should be stored in the
key file (normally
.B /etc/identd.key
) and it should be generated using a cryptographically safe
random generator in order to be really safe.
.PP
The returned token will contain the local and remote IP addresses and
TCP port numbers, the local user's uid number, a timestamp, a
random number, and a checksum - all encrypted using DES. The
encrypted binary information is then encoded in a BASE64 string
(32 characters long) and enclosed in square brackets to produce a
token that is transmitted to the remote client.
.PP
The encrypted token can later be decrypted by the
.B idecrypt
command.
.SH CONFIGURATION
This section about the configuration file has yet to be written.
.SH NOTES
The username (or UID) returned ought to be the login name. However it
(probably, for most architecture implementations) is the "real user ID" as
stored with the process. Thus the UID returned may be different from the
login name for setuid programs (or those running as root) which has done a
.BR setuid (3)
call and their children. For example, it may (should?) be wrong for an
incoming
.B ftpd
; and we are probably interested in the running shell, not the
.B telnetd
for an incoming telnet session. (But of course
.B identd
returns info for outgoing connections, not incoming ones.)
.SH FILES
.TP
.B /etc/identd.conf
Contains the default configuration options for
.B identd.
.TP
.B /etc/identd.pid
Contains (if enabled) the process number of the
.B identd
daemon.
.TP
.B /etc/identd.key
If compiled with
.I DES
encryption enabled, the 1024 first bytes of this file is used to specify
the secret key for encrypting replies.
.SH AVAILABILITY
The daemon is free software. You can redistribute it and/or
modify it as you wish - as long as you don't claim that you wrote
it.
.PP
The source code for the latest version of the daemon can always be
FTP'd from one of the following addresses:
.TP 12
.B Main site:
ftp://ftp.lysator.liu.se/pub/ident/servers/
.TP 12
.B Mirror:
ftp://ftp.uu.net/networking/ident/servers/
.PP
The author can be contacted at:
.TP 12
.B Email:
.B Peter Eriksson <pen@lysator.liu.se>
.SH "SEE ALSO"
.BR authuser (3)
,
.BR inetd.conf (5)
,
.BR idecrypt (8)
