/*
 * The author of this code is John Ioannidis, ji@tla.org,
 * 	(except when noted otherwise).
 *
 * This code was written in Athens, Greece, in November 1995.
 *
 * Copyright (C) 1995, by John Ioannidis.
 *	
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTY. IN PARTICULAR, THE AUTHOR DOES NOT MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

/*
 * HISTORY
 *
 * $Log: ip_esp.h,v $
 * Revision 1.2  1995/11/30  04:35:36  ji
 * Performed cosmetic changes and verified SPIs are endian-proof.
 *
 *
 */

/*
 * Encapsulation Security Payload Processing
 * Per RFC1827 (Atkinson, 1995)
 *
 * Copyright (C) 1995 by John Ioannidis <ji@tla.org>
 *
 */

struct esp
{
	u_long	esp_spi;		/* Security Parameters Index */
	u_char	esp_iv[8];		/* iv[4] may actually be data! */
};

struct espstat
{
	u_long	esps_hdrops;		/* packet shorter than header shows */
	u_long	esps_notdb;
	u_long	esps_badkcr;
	u_long	esps_qfull;
	u_long	esps_noxform;
	u_long	esps_badilen;
	
};

struct espdes_xdata
{
	int	edx_ivlen;		/* 4 or 8 */
	u_char	edx_iv[8];		/* that's enough space */
	u_long	edx_eks[16][2];		/* Key schedule for encryption */
	u_long	edx_dks[16][2];		/* Key schedule for decryption */
};

#define ESP_FLENGTH	12
#define ESP_ULENGTH	20		/* coming from user mode */

#ifdef KERNEL

struct espstat espstat;

void deskey(u_long [16][2], unsigned char *, int);
void des(u_long [16][2], unsigned char *);

#endif

