/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_ah.h,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_ah.h,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * Added definitions for new AH transforms.
 *
 * Revision 0.3  1996/11/20 14:35:48  ji
 * Minor Cleanup.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

/*
 * Authentication Header declarations
 */


#define AH_FLENGTH	8		/* size of fixed part */

#define AHMD5_KMAX	64		/* max 512 bits key */
#define AHSHA1_KMAX	64		/* max 512 bits key */
#define AHMD5_AMAX	8+64		/* optional 64-bit replay counter, and
					   up to 512 bits of authenticator */
struct ah				/* Generic AH header */
{
	__u8	ah_nh;			/* Next header (protocol) */
	__u8	ah_hl;			/* AH length, in 32-bit words */
	__u16	ah_rv;			/* reserved, must be 0 */
	__u32	ah_spi;			/* Security Parameters Index */
	__u8	ah_data[64];		/* Max */
};


struct ahmd5_xdata			/* transform table data */
{
	__u16 amx_klen;		/* Key material length */
	__u16 amx_alen;		/* authenticator length */
	__u8	amx_key[AHMD5_KMAX];	/* Key material */
};

#include "ipsec_md5h.h"

struct ahhmacmd5_edata			/* struct for netlink interface */
{
	__u16	ame_klen;		/* Key material length */
	__u16	ame_alen;		/* authenticator length */
	__u8	ame_replayp;		/* replay protection ? */
	__u8	ame_ooowin;		/* out-of-order window size */
	__u16	ame_x0;			/* filler */
	__u8	ame_key[AHMD5_KMAX];	/* Key material */
};
	
struct ahhmacmd5_xdata			/* struct for xform table */
{
	__u16	amx_alen;		/* length of authenticator, octets  */
	__u8	amx_replayp;		/* 1 if replay prevention active */
	__u8	amx_ooowin;		/* out-of-order window size */
	__u64	amx_bitmap;		/* this&next should be 8 bytes each */
	__u64	amx_lastseq;		/* or just seq if sending!! */
	MD5_CTX	amx_octx;		/* context after H(K XOR opad) */
	MD5_CTX amx_ictx;		/* context after H(K XOR ipad) */
};

#include "ipsec_sha1.h"

struct ahhmacsha1_edata			/* struct for netlink interface */
{
	__u16	ame_klen;		/* Key material length */
	__u16	ame_alen;		/* authenticator length */
	__u8	ame_replayp;		/* replay protection ? */
	__u8	ame_ooowin;		/* out-of-order window size */
	__u16	ame_x0;			/* filler */
	__u8	ame_key[AHSHA1_KMAX];	/* Key material */
};
	
struct ahhmacsha1_xdata			/* struct for xform table */
{
	__u16	amx_alen;		/* length of authenticator, octets  */
	__u8	amx_replayp;		/* 1 if replay prevention active */
	__u8	amx_ooowin;		/* out-of-order window size */
	__u64	amx_bitmap;		/* this&next should be 8 bytes each */
	__u64	amx_lastseq;		/* or just seq if sending!! */
	SHA1_CTX amx_octx;		/* context after H(K XOR opad) */
	SHA1_CTX amx_ictx;		/* context after H(K XOR ipad) */
};

extern struct inet_protocol ah_protocol;

#if defined(__LITTLE_ENDIAN)
static inline unsigned long long
htonq(unsigned long long q)
{
	register unsigned long u, l;
	u = q >> 32;
	l = (unsigned long)q;
	
	return htonl(u) | ((unsigned long long)htonl(l) << 32);
}

#define ntohq(_x) htonq(_x)

#elif defined(__BIG_ENDIAN)

#define htonq(_x) (_x)
#define ntohq(_x) htonq(_x)

#else
#error  "Please fix <asm/byteorder.h>"
#endif                                          

#ifdef DEBUG_IPSEC_AH

extern int debug_ah;

#define DB_AH_PKTRX	0x0001
#define DB_AH_PKTRX2	0x0002
#define DB_AH_DMP	0x0004
#define DB_AH_TDB	0x0010
#define DB_AH_XF	0x0020
#define DB_AH_INAU	0x0040
#define DB_AH_REPLAY	0x0100
#endif
