#!/bin/sh
PATH="/bin:/usr/bin:/usr/etc"
export PATH

# @(#)tune0001.sh 1.7 90/05/03
#
#	Name:		tune0001.sh
#
DESCRIPTION="
#
#			Tune attributes on file system objects
#"
#		This script is intended to set file system object permissions
#		to the values generated during the build process.  The values
#		values generated during the build process may not be the best
#		but they are better than what is on the 4.1FCS tape.
#

set -eu

echo "$DESCRIPTION"

echo "Setting attributes on the following file system objects:"

while read file mode user group type; do
	#
	#	If the object does not exist on this system then skip it.
	#
	if [ ! -d "$file" -a ! -f "$file" ]; then
		continue;
	fi

	echo -n "	$file"

	#
	#	If the object is a symbolic link then do not chmod(1) it.
	#
	if [ "$type" != "symlink" ]; then
		chmod "$mode" "$file"
		#
		#	If the mode has the setgid bit set, then use
		#	symbolic mode to set it.
		#
		if [ "`echo $mode | cut -c2`" = "2" ]; then
			chmod g+s "$file"
		fi

		echo -n " (mode)"
	fi
	chown "$user.$group" "$file"
	echo " (ownership)"
done << EOF
/ 02755 root staff directory
/bin 00777 root staff symlink
/etc 02755 root staff directory
/etc/adm 00777 root staff symlink
/etc/arp 00777 root staff symlink
/etc/chown 00777 root staff symlink
/etc/chroot 00777 root staff symlink
/etc/clri 00777 root staff symlink
/etc/config 00777 root staff symlink
/etc/crash 00777 root staff symlink
/etc/cron 00777 root staff symlink
/etc/dkinfo 00777 root staff symlink
/etc/dmesg 00777 root staff symlink
/etc/dump 00777 root staff symlink
/etc/fastboot 00777 root staff symlink
/etc/fasthalt 00777 root staff symlink
/etc/fsck 00777 root staff symlink
/etc/fuser 00777 root staff symlink
/etc/halt 00777 root staff symlink
/etc/ifconfig 00777 root staff symlink
/etc/install/EXCLUDELIST 00644 root staff file
/etc/install/category.standalone 00644 root staff file
/etc/install/default_client_info 00644 root staff file
/etc/install/default_sys_info 00644 root staff file
/etc/link 00777 root staff symlink
/etc/mkfs 00777 root staff symlink
/etc/mknod 00777 root staff symlink
/etc/mount 00777 root staff symlink
/etc/mount_rfs 00777 root staff symlink
/etc/mtab 00644 root staff file
/etc/motd 00644 root staff file
/etc/aliases.dir 00644 root staff file
/etc/aliases.pag 00644 root staff file
/etc/ncheck 00777 root staff symlink
/etc/newfs 00777 root staff symlink
/etc/pstat 00777 root staff symlink
/etc/rdump 00777 root staff symlink
/etc/reboot 00777 root staff symlink
/etc/renice 00777 root staff symlink
/etc/restore 00777 root staff symlink
/usr/etc/restore 00750 root staff file
/etc/rmt 00777 root staff symlink
/etc/rrestore 00777 root staff symlink
/etc/shutdown 00777 root staff symlink
/etc/spool 00777 root staff symlink
/etc/termcap 00777 root staff symlink
/etc/tmp 00777 root staff symlink
/etc/umount 00777 root staff symlink
/etc/unlink 00777 root staff symlink
/etc/update 00777 root staff symlink
/etc/vipw 00777 root staff symlink
/home 02755 bin staff directory
/lib 00777 root staff symlink
/sys 00777 root staff symlink
/usr 02755 bin staff directory
/usr/5lib 02755 bin staff directory
/usr/adm 00777 root staff symlink
/usr/bin 02755 bin staff directory
/usr/bin/sunview1 02755 bin staff directory
/usr/boot 00777 root staff symlink
/usr/demo 02755 bin staff directory
/usr/diag 02755 bin staff directory
/usr/diag/sundiag 02755 root staff directory
/usr/etc 02755 bin staff directory
/usr/games 02755 bin staff directory
/usr/games/chesstool 00750 bin staff file
/usr/include 02755 bin staff directory
/usr/include/images 02755 bin staff directory
/usr/include/suntool 02755 bin staff directory
/usr/include/sunwindow 02755 bin staff directory
/usr/kvm 02755 bin staff directory
/usr/kvm/i386 00777 root staff symlink
/usr/kvm/iAPX286 00777 root staff symlink
/usr/kvm/m68k 00777 root staff symlink
/usr/kvm/machine 00777 root staff symlink
/usr/kvm/mc68010 00777 root staff symlink
/usr/kvm/mc68020 00777 root staff symlink
/usr/kvm/pdp11 00777 root staff symlink
/usr/kvm/sparc 00777 root staff symlink
/usr/kvm/sun 00777 root staff symlink
/usr/kvm/sun2 00777 root staff symlink
/usr/kvm/sun4 00777 root staff symlink
/usr/kvm/sun4c 00777 root staff symlink
/usr/kvm/crash 02700 root staff file
/usr/kvm/sys 02755 root staff directory
/usr/kvm/sys/conf.common 02755 root staff directory
/usr/kvm/sys/debug 02755 root staff directory
/usr/kvm/sys/krpc 02755 root staff directory
/usr/kvm/sys/lofs 02755 root staff directory
/usr/kvm/sys/m68k 02755 root staff directory
/usr/kvm/sys/mon 02755 root staff directory
/usr/kvm/sys/net 02755 root staff directory
/usr/kvm/sys/netinet 02755 root staff directory
/usr/kvm/sys/nfs 02755 root staff directory
/usr/kvm/sys/os 02755 root staff directory
/usr/kvm/sys/rpc 02755 root staff directory
/usr/kvm/sys/sparc 02755 root staff directory
/usr/kvm/sys/specfs 02755 root staff directory
/usr/kvm/sys/sun 02755 root staff directory
/usr/kvm/sys/sun3 02755 root staff directory
/usr/kvm/sys/sun3/OBJ 02755 root staff directory
/usr/kvm/sys/sun3/conf 02755 root staff directory
/usr/kvm/sys/sun3x 02755 root staff directory
/usr/kvm/sys/sun3x/OBJ 02755 root staff directory
/usr/kvm/sys/sun3x/conf 02755 root staff directory
/usr/kvm/sys/sun4 02755 root staff directory
/usr/kvm/sys/sun4/OBJ 02755 root staff directory
/usr/kvm/sys/sun4/conf 02755 root staff directory
/usr/kvm/sys/sun4c 02755 root staff directory
/usr/kvm/sys/sun4c/OBJ 02755 root staff directory
/usr/kvm/sys/sun4c/conf 02755 root staff directory
/usr/kvm/sys/sundev 02755 root staff directory
/usr/kvm/sys/sunif 02755 root staff directory
/usr/kvm/sys/sunwindow 02755 root staff directory
/usr/kvm/sys/sunwindowdev 02755 root staff directory
/usr/kvm/sys/sys 02755 root staff directory
/usr/kvm/sys/ufs 02755 root staff directory
/usr/kvm/sys/vm 02755 root staff directory
/usr/kvm/u370 00777 root staff symlink
/usr/kvm/u3b 00777 root staff symlink
/usr/kvm/u3b15 00777 root staff symlink
/usr/kvm/u3b2 00777 root staff symlink
/usr/kvm/u3b5 00777 root staff symlink
/usr/kvm/vax 00777 root staff symlink
/usr/lib 02755 bin bin directory
/usr/lib/.sunview 00777 root bin symlink
/usr/lib/defaults 02755 root bin directory
/usr/lib/fonts 02755 bin staff directory
/usr/lib/fonts/fixedwidthfonts 02755 bin staff directory
/usr/lib/fonts/tekfonts 02755 bin staff directory
/usr/lib/lex 00777 root bin symlink
/usr/lib/lint/llib-lsuntool 00644 root staff file
/usr/lib/lint/llib-lsuntool.ln 00644 root staff file
/usr/lib/lint/llib-lsunwindow 00644 root staff file
/usr/lib/lint/llib-lsunwindow.ln 00644 root staff file
/usr/lib/refer 02755 bin bin directory
/usr/lib/rootmenu 00777 root bin symlink
/usr/lib/rootmenu.old 00777 root bin symlink
/usr/lib/shlib.etc 02755 root staff directory
/usr/lib/suntools 00777 root bin symlink
/usr/lib/tabset 00777 root bin symlink
/usr/lib/text_extras_menu 00777 root bin symlink
/usr/lib/textswrc 00777 root bin symlink
/usr/lib/zoneinfo 00777 root bin symlink
/usr/local 02755 bin staff directory
/usr/man 00777 root staff symlink
/usr/mdec 00777 root staff symlink
/usr/net 00777 root staff symlink
/usr/nserve 00777 root staff symlink
/usr/old 02755 bin staff directory
/usr/pub 00777 root staff symlink
/usr/share/lib 02755 root staff directory
/usr/share/lib/me 02755 root staff directory
/usr/share/lib/ms 02755 bin staff directory
/usr/share/lib/tmac 02755 root staff directory
/usr/share/src 02755 bin staff directory
/usr/share/src/sun 02755 bin staff directory
/usr/share/src/sun/sunview1 02755 bin staff directory
/usr/share/src/sun/sunview1/examples 02755 root staff directory
/usr/share/src/sun/sunview1/iconedit 02755 root staff directory
/usr/spool 00777 root staff symlink
/usr/src 00777 root staff symlink
/usr/stand 00777 root staff symlink
/usr/sys 00777 root staff symlink
/usr/tmp 00777 root staff symlink
/usr/ucb 02755 bin staff directory
/usr/ucbinclude 00777 root staff symlink
/usr/ucblib 00777 root staff symlink
/var 02755 bin staff directory
/dev/fd0 00600 root staff file
/dev/fd0a 00600 root staff file
/dev/fd0b 00600 root staff file
/dev/fd0c 00600 root staff file
EOF
