/* listen.c - hardware loopback, connect microphone to speaker
**
** Copyright (C) 1989 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include <sys/signal.h>
#include "libsst.h"

int sst_fd;

main( argc, argv )
int argc;
char *argv[];
    {
    struct audio_ioctl ai;
    int junk;
    int sighandler();

    sst_fd = sst_open( );
    (void) signal( SIGHUP, sighandler );
    (void) signal( SIGINT, sighandler );

    ai.control = AUDIO_MUX_MCR1;
    if ( ioctl( sst_fd, AUDIOGETREG, &ai ) < 0 )
	{
	perror( "GETREG MCR1" );
	exit( 1 );
	}
    ai.data[0] = ( AUDIO_MUX_PORT_BA << 4 ) | AUDIO_MUX_PORT_BA;
    if ( ioctl( sst_fd, AUDIOSETREG, &ai ) < 0 )
	{
	perror( "SETREG MCR1" );
	exit( 1 );
	}

    if ( ioctl( sst_fd, AUDIOREADSTART, &junk ) < 0 )
	{
	perror( "AUDIOREADSTART" );
	exit( 1 );
	}

    for ( ; ; )
	pause( );

    /* NOTREACHED */
    }

int
sighandler( )
    {
    sst_close( sst_fd );
    exit( 1 );
    }
