# This is a version of ~/.sd.tcl modified to support vic video.
# There are two sets of changes:
#
# - vic is used (in nv/ivs compatability mode) instead of nv, ivs
#   or telesia.  vic is also used, of course, in its `native' rtp v2
#   mode for sessions of type "vic".
#
# - the audio startup is modified to establish a 'session bus' between
#   vat & vic for sessions where both audio & video are specified.
#   this allows the 'voice switched' window mode in vic to work.
#
#       -- Van Jacobson & Steve McCanne
#          Tue Nov 29 06:11:41 PST 1994
#
# $Header: VIC.SD.TCL,v 1.6 94/12/05 00:29:05 mccanne Exp $

set ipc_chan 0
proc get_channel { confid } {
        global ipc_tab ipc_chan
        if { [info exists ipc_tab($confid)] } {
                return $ipc_tab($confid)
        }
        incr ipc_chan
        if { $ipc_chan > 300 } {
                set ipc_chan 1
        }
        set ipc_tab($confid) $ipc_chan
        return $ipc_chan
}

proc start_audio {} {
        global sd_sess sd_audio sd_video
        set audiofmt ""
        set packetfmt "-n"
        set mode "-c"
        foreach a $sd_audio(attributes) {
                case $a {
                        fmt:* { set audiofmt [string range $a 4 end] }
                        vt  { set packetfmt "-v" }
                        lecture  { set mode "-l" }
                }
        }
        set confaddr [format "%s/%s/%s/%s/%s" $sd_sess(address) \
                $sd_audio(port) $sd_audio(conf_id) $audiofmt $sd_sess(ttl)]

        global vat
	if {[lsearch $sd_sess(media) video] >= 0} {
		set chan [get_channel $sd_sess(address)/$sd_video(port)]
		exec $vat -I $chan -C $sd_sess(name) $packetfmt $mode $confaddr &
	} else {
		exec $vat -C $sd_sess(name) $packetfmt $mode $confaddr &
	}
}

proc start_video {} {
        global sd_sess sd_video use_ivs
        set videofmt "nv"
        foreach a $sd_video(attributes) {
                case $a {
                        fmt:* { set videofmt [string range $a 4 end] }
                }
        }
        case $videofmt {
                vic { }
		ivs { }
		nv { }
		telesia { set videofmt ivs }
		ivs {
			if { $use_ivs } {
				global ivs
				exec nice $ivs -a -r -T $sd_sess(ttl) \
					$sd_sess(address)/$sd_video(port) &
				return
			}
		}
                jpg {
                        global imm
                        exec nice $imm -p $sd_video(port) -I $sd_sess(address) \
                             -ttl $sd_sess(ttl) -n $sd_sess(name) &
			return
                }
		default {
			puts "sd: unknown video format: $videofmt"
			return
		}
        }
	global vic
	if {[lsearch $sd_sess(media) audio] >= 0} {
		set chan [get_channel $sd_sess(address)/$sd_video(port)]
		exec nice $vic -I $chan -A $videofmt -t $sd_sess(ttl) \
			-C $sd_sess(name) \
			$sd_sess(address)/$sd_video(port) &
	} else {
		exec nice $vic -A $videofmt -t $sd_sess(ttl) \
			-C $sd_sess(name) \
			$sd_sess(address)/$sd_video(port) &
	}
}

set sd_menu(video) "fmt: vic nv ivs jpg"
set vic vic
set use_ivs 1
