# ------------------------------------------------------------------
# "busy" set the cursor to a watch, invokes a command, and then
# restores the cursor.  It handles exceptions properly.
# ------------------------------------------------------------------

proc busy {command} {
    global errorInfo errorCode

    wmbusy . 1
    blt_busy hold .
    foreach i [winfo children .] {
	if { [winfo toplevel $i] != "." } {
	    wmbusy $i 1
	    blt_busy hold $i
	}
    }
    update idletasks

    set code [catch {uplevel $command} retval]

    wmbusy . 0
    blt_busy release .
    foreach i [winfo children .] {  
	if { [winfo toplevel $i] != "." } {
	    wmbusy $i 0
	    blt_busy release $i
	}
    }

    if {$code == 1} { error $retval $errorInfo $errorCode }
    return $retval
}
