#ifndef _GUI_DEFINES_H_
#define _GUI_DEFINES_H_

/* r_type values */
#define R_HFRAME        0  /* first member of horizontal frame or subframe */
#define R_VFRAME        1  /* first member of vertical frame or subframe */
#define R_BUTTON        2  /* button, when just one is needed */
#define R_GROUP         3  /* just a group of objects */
#define R_BGROUP        4  /* a button as a title with a group of objects */
#define R_LGROUP        5  /* a label as a title with a group of objects */
#define R_HSCALE        6  /* horizontal scale control */
#define R_VSCALE        7  /* vertical scale control */
#define R_MENUBAR       8  /* a menu bar */
#define R_CASCADE       9  /* cascading menu option */
#define R_OPTION       10  /* option in a cascading menu */
#define R_HRADIOBOX    11  /* horizontal radio box */
#define R_VRADIOBOX    12  /* vertical radio box */
#define R_TBUTTON      13  /* toggle button for radio box logic */
#define R_COUNTER      14  /* two arrow buttons and a text field */
#define R_ROW          15  /* form with horizontal orientation */
#define R_COLUMN       16  /* form with vertical orientation */
#define R_VBAR         17  /* vertical bar with no labels */
#define R_HBAR         18  /* horizontal bar with no labels */
#define R_VBAR_CHART   19  /* vertical bar with label, min, max, value */
#define R_HBAR_CHART   20  /* horizontal bar with label, min, max, value */
#define R_LABEL        21  /* just a plain ol' label */
#define R_TEXT         22  /* scrolled text widget */
#define R_TFIELD       23  /* an editable text field */
#define R_FSBOX        24  /* file selection box */
#define R_SELBOX       25  /* plain selection box */
#define R_EDITOR       26  /* an editable scrolled text widget */
#define R_SEPARATOR    27  /* visual separator, orientation depends on parent */
#define R_END          -1  /* end of list of resources */

/* file-types for file-selection box */
#define F_REGULAR       1       /* only regular files */
#define F_DIRECTORY     2       /* only directories */
#define F_ANY           3       /* any file type */

/* possible values of call_data in gui_yes_or_no_dialog callback */
#define ANS_YES         "yes"
#define ANS_NO          "no"

/* copied from the pure_rules include file */
#define ST_WHITE        0       /* Nothing happening - virginal */
#define ST_BLUE         1       /* Unhappy - blue - neglected when other
                                   things are busy - imbalance of resources */
#define ST_GREEN        2       /* No problem */
#define ST_AMBER        3       /* Warning level */
#define ST_RED          4       /* Problem that needs fixing */
#define ST_BLACK        5       /* Blackout likely - panic level */
#define ST_USER_COLOR   6       /* user defined colors start here */

#endif
