#! /bin/sh
#
# rlatex.sh
#
# run latex, check for no-errors-but `Label(s) may have changed';
# if so, re-run latex (up to 3 times total)

case $# in
	1) ;;
	*) echo "usage: latex.sh file[.tex]" 1>&2; exit 1;;
esac
case "$1" in
	*.tex) file=`echo "$1" | sed 's/\.tex$//'`;;
	*) file="$1";;
esac

count=
while :; do
	count=${count}i		# this is cheaper than `expr $count + 1`
	case $count in
		i|ii|iii) ;;
		*) echo "Unstable labels?  I cannot go on." 1>&2; exit 10;;
	esac
	if latex "$file"; then
		if grep "Label(s) may have changed" <"$file".log >/dev/null
		then :
		else break
		fi
	else
		exit $?
	fi
done
