#
# Copyright (c) 1987, 1989 University of Maryland
# Department of Computer Science.  All rights reserved.
# Permission to copy for any purpose is hereby granted
# so long as this copyright notice remains intact.
#

rcsid:	.asciz	"$Header: /usr/src/local/tex/local/mctex/lib/RCS/vaxbcopy.s,v 3.1 89/08/22 21:40:54 chris Exp $"

# bcopy (from, to, count) char *from, *to; int count;
#
# Copy "count" bytes from "from" to "to".
# Works even if the regions overlap.

	.align	2
	.globl	_bcopy
_bcopy:
	.word	0x40		# r6
	movl	4(ap),r1	# r1 = from
	movl	8(ap),r3	# r3 = to
	movl	12(ap),r6	# r6 = len
	cmpl	r1,r3
	bgtr	2f		# moving forward, overlap irrelevant
	blss	3f		# moving backward, overlap matters
	ret			# not moving at all
1:
	subl2	r0,r6		# count -= 65535 (bytes moved this time)
	movc3	r0,(r1),(r3)	# r1, r3 magically point to next 65K
2:
	movzwl	$65535,r0
	cmpl	r6,r0		# <= 65535 bytes to move?
	jgtr	1b		# brif not, move 65535 and try again
	movc3	r6,(r1),(r3)	# move up to 65535 bytes
	ret

3:
	addl2	r6,r1		# start at end (from += len)
	addl2	r6,r3		# (to += len)
	movzwl	$65535,r0	# r0 = 65535
	jbr	5f		# enter loop at bottom
4:
	subl2	r0,r6		# count -= 65535 (bytes to move now)
	subl2	r0,r1		# adjust from and to by -65535
	subl2	r0,r3
	movc3	r0,(r1),(r3)	# move the bytes
	movzwl	$65535,r0	# set r0 again
	subl2	r0,r1		# and adjust from and to
	subl2	r0,r3		# (since movc3 added 65535 to them)
5:
	cmpl	r6,r0		# len <= 65535?
	jgtr	4b		# no, do another 65535
	subl2	r6,r1		# yes, just do the last few bytes
	subl2	r6,r3
	movc3	r6,(r1),(r3)	# swoop
	ret
