.\" @(#)ups.man	1.17 20 Jun 1995
.\"
.\" A sequence to switch into the font for example text
.if t .ds Cb \f(CB
.if n .ds Cb \fB
.if t .ds Cr \f(CR
.if n .ds Cr \fB
.\" 
.\"
.\" ####################################
.\" .Sc - print the argument in small caps
.de Sc
\s-2\\$1\s0\\$2
..
.\" ####################################
.\"
.\" ####################################
.\" .Cm - print a menu command caption
.de Cm
\\$3\&\fB\\$1\fP\\$2
..
.\" ####################################
.\" .Ob - print the name of a display area object
.de Ob
\\$3\&\fB\\$1\fP\\$2
..
.\" ####################################
.\"
.\" ####################################
.\" .fX - print the argument in a fixed font
.de fX
\\$3\&\*(Cr\\$1\fP\\$2
..
.\" ####################################
.\"
.\" .En - .IP with Courier heading
.de En
.IP "\*(Cr\\$1\fP \fI\\$2\fP" 20
..
.\" ####################################
.\" .Vs - start example
.de Vs
.in +4m
\*(Cr
.nf
..
.\" ####################################
.\"
.\"
.\"
.\"
.\" ####################################
.\" .Ve - end example
.de Ve
.fi
.ft P
.in -4m
.sp 0.3v
..
.\" ####################################
.\"
.\"
.\" ####################################
.\" String register .Bo - outdented bullet
.ds Bo \h'-1.3n'\(bu
.\"
.\"
.TH UPS 1 "31 May 1995"
.tr *\(** \" make asterisks level with the base line
.SH NAME
ups \- X11 and SunView based source level C debugger
.SH SYNOPSIS
\fBups\fP \fItarget\fP [\fIcorefile\fP|\fIpid\fP] [[:]\fIsrcdir\fP[:\fIsrcdir\fP]]
[\fB-a\fP \fItarget-args\fP]
.SH DESCRIPTION
.I Ups
is a X based source level debugger for the C and Fortran
programming languages.
It supports both run time debugging with breakpoints and post-mortem
debugging from a core file.
On Suns you can attach
.I ups
to a running process.
.I Ups
runs in its own window,
thus not interfering with the target program's I/O.
The
.I ups
window has two major areas \- one showing a structured
document representing the target state, the other showing the source
that is being executed.
.LP
.I Ups
makes heavy use of direct manipulation and feedback.
When you add a breakpoint it is shown as a pseudo C statement 
.fX #stop ) (
in the source display.
The current point of execution is highlighted in the source display
and you can watch it move as you step through loops and function calls.
You can edit in fragments of interpreted C code (including assignments
to variables and calls to target functions).
There are powerful facilities for exploring linked data structures \-
you can recursively expand and collapse structures to follow links.
.LP
.I Ups
is primarily a C debugger,
but it also has support for debugging Fortran 77 and Fortran 90 code.
See the section
.Sc "DEBUGGING FORTRAN CODE"
(near the end of this manual page) for information on Fortran specific
features.
.LP
.I Ups
does not support C++ (yet).
.SH "GETTING STARTED"
This section gives step by step instructions on how to use
.I ups
on a small example C program.
The idea is to get a feel for how to use
.I ups
without getting bogged down in details.
After following the instructions here you should be able to explore
a little on your own and then be ready to have a look at the reference 
material that follows.
.LP
Here is the sample source code:
.Vs
.ps -2
.vs -2
struct argst { char *a_name; struct argst *a_next; };
struct argst *listhead = 0;

void stash(name)
char *name;
{
	struct argst *a;
	char *malloc();

	a = (struct argst *)malloc(sizeof(struct argst));
	a->a_name = name;
	a->a_next = listhead;
	listhead = a;
}

int main()
{
	stash("foo");
	stash("bar");
}
.ps +2
.vs +2
.Ve
We skip error checking code here in the interests of brevity.
Put a copy of the code above into a .c file (e.g. sample.c) 
by cut-and-paste or by snarfing the lines from the file
that contains this manual page.
If you have the source directory of ups around you will find this
code below there in the file
.fX ups/doc/sample.c .
.LP
Assuming you have a copy of the above code in a file and you are sitting
at a workstation or X terminal and have
an X or Sunview session running, here is what you do:
.LP
\*(Bo Compile and link the code with the -g flag to
.IR cc (1)
or
.IR gcc (1).
.IP
The
.B -g
flag directs the compilers to include extra symbol table information
in the object file that is needed by debuggers.
.LP
\*(Bo Give the command
.fX "ups a.out" ' `
(or whatever you called the object file).
After a short pause a window will be created; the details obviously depend on
your window manager.
.IP
This is the simplest way of invoking
.IR ups .
For a complete description of the command line flags and arguments
see \s-2UPS COMMAND LINE ARGUMENTS\s0.
.IP
In the window you should see a display divided into various rectangular
boxes and menus, with two large regions in the upper and lower halves
of the window.
The top region is the 
.I "display area"
\- it contains captions looking roughly like:
.Vs
\*(CrTarget a.out
	a.out
Signals
Environment
Untyped variables
Source files
Functions
Breakpoints
.ft P
.Ve
.IP
In the lower region you should see the start of
.fX main()
displayed.
Note: the layout of the window is explained in detail in a later section.
.LP
\*(Bo Move the mouse cursor over the
.Ob Breakpoints
caption in the upper region, and press and release the left mouse button.
.IP
You should see two things happen: the caption is inverted to show that
it is selected, and a menu appears near the top of the window with the
captions
.Cm "Add new"
.Cm "Remove all"
.Cm "Restore"
and
.Cm "Load from file.
.IP
All the objects in the display area (except
.Ob Functions )
can be selected like this and have their own menus.
Selecting an object (or many objects) and clicking on one of the
commands in its associated menu is the primary way of issuing
commands to
.IR ups .
.LP
\*(Bo Click (press and release) the left mouse button over the
.Cm "Add new"
menu caption.
.IP
You should see a line below the
.Ob Breakpoints
caption looking like:
.Vs
\f(CBFunction:\(sq				line:\fP0
.Ve
.IP
The hollow square represents the editing cursor, which indicates where
typed characters will appear.
(this is actually
displayed as a solid black rectangle on the screen).
.LP
\*(Bo Type
.fX main ' `
.IP
You can use the delete key as you would expect to fix typos.
There are various other useful control characters \- see the
\s-2EDITABLE FIELDS\s0 section for details.
.LP
\*(Bo Press ESC (the escape key).
.IP
This confirms the edit.
You should see the text
.Vs
#stop;
.Ve
appear at the start of main in the source region.
.IP
.I Ups
represents breakpoints as this fragment of pseudo C.
You can edit breakpoints to do things other than just stop (e.g. call a target
function or only stop if a certain condition is true).
This is covered later in this section, and described fully
in the section \s-2ADDING INTERPRETED CODE\s0.
.IP
You can also add breakpoints by pointing at the appropriate line in
the source region \- this is described later in this section.
.LP
\*(Bo Click the left button over the caption
.Cm Start
at the left hand side of the menu just below the display area.
.IP
This menu is the target control menu.
Here is a brief description of what the other commands in this menu
do (these are explained in more detail in the
\s-2CONTROLLING TARGET EXECUTIION\s0 section).
As you have just seen
.Cm Start
starts the target running.
.Cm Step
and
.Cm Next
step execution over single lines of code
.Cm Step "" (
steps into function calls,
.Cm Next
doesn't).
.Cm Cont
makes the target process run until it hits a breakpoint or exits.
.Cm Stop
stops a running target process, and
.Cm Kill
kills off the target process, ready for another run using
.Cm Start .
.IP
You should see the first line of code in
.fX main
highlighted.
This means that execution has stopped just before this line.
If you look at the display area you will also see that a new
line has appeared under the
.Ob Functions
object.
This should look like:
.Vs
main					sample.c:18
.Ve
.IP
This shows that you are stopped at line 18 of 
.fX sample.c
in function
.fX main .
.IP
At this point you are in the usual state for
.IR ups :
you have the target stopped, with the line that is about to be executed
highlighted in the source window and your current position in the
source file shown under the
.Ob Functions
object in the display area.
.LP
\*(Bo Click on
.Cm Step
in the target control menu.
.IP
The source display switches to function
.fX stash ,
which you have just stepped into.
You will also see an extra line under
.Ob Functions
\- the display should look like:
.Vs
main				sample.c:18
stash				sample.c:10
.Ve
.IP
As you can see this is a stack trace, showing you which function called
which starting from main and working inwards towards the function you are
currently stopped in.
.LP
\*(Bo In the source region move the mouse over the `\*(Cra\fP' at the start
of the highlighted line and click the left mouse button.
.IP
You should see a line added to the stack trace, making it look like:
.Vs
main				sample.c:18
stash				sample.c:10
  struct argst *<a>	0x4
.Ve
.IP
This is one of the main strengths of
.IR ups :
to see the type and value of any variable that is visible in the
source window you simply click on its name.
.IP
This is showing that
.fX a
is a variable of type
.fX "struct argst *"
with the value
.fX 4.
Ignore the angle brackets round the `\*(Cra\fP' for now \- they will
be explained later.
This is an uninitialised variable, so the value you see will probably
be different from this.
.IP
You will also notice that the menu near the top of the display area
has changed.
Every object in the display area has an associated menu, which is
displayed when that object is selected.
Ignore the menu for now.
.LP
\*(Bo Click on
.Cm Step
in the target control menu.
.IP
The value displayed for the variable
.fX a
changes to whatever is returned by
.fX malloc .
This shows another key feature of
.I ups 
\- displayed variables remain in the display area as you step through the
program code so you can watch the values change.
.LP
\*(Bo Now click the left mouse button over the displayed line for
the variable
.fX a .
.IP
The line will be inverted to show that it is selected and a menu will
appear as before near the top of the display area.
.LP
.ne 10
\*(Bo Click on
.Cm Expand
in the menu that was produced by the last step.
.IP
You will see an entry added for each member of the structure, giving a
display under the
.Ob Functions
object that looks something like:
.Vs
main				sample.c:18
stash				sample.c:11
  struct argst <a{0}>      0x60c8
    char <a_name{0}>         *NULL
    struct argst *<a_next>   0x0
.Ve
.IP
The member types and values are shown in the same way as the structure
pointer
.fX a ' `
itself.
As before the values are uninitialised, so the values you see will depend
on the exact behaviour of your
.fX malloc
implementation.
.LP
\*(Bo Click on
.Cm Next
in the target menu.
.IP
The highlighting in the source window will move on to the next line,
and the value displayed for the
.fX a_name
field will change.
.IP
This sort of interaction is typical use of
.I ups
\- you expand structures to see members of interest, and then step through
the source code watching how they change.
.LP
\*(Bo Move the mouse over the highlighted source line, press and hold
down the right hand mouse button then release it.
.IP
When you pressed the mouse button you will have seen a popup menu with
the captions
.Cm "Add breakpoint"
and
.Cm "Execute to here" .
You will also have seen an arrow to the left of the menu pointing at the
source line you pressed the mouse over.
.IP
When you release the mouse button a breakpoint is added just before
the source line.
You will see the text
.fX #stop;
appear.
.IP
This is the simplest and most common way of adding breakpoints in
.IR ups .
The normal sequence of actions is:
.RS
.IP \(bu
Type the name of the function you are interested in (or enough of
it to uniquely identify it) and hit ESC (the escape key).
The source of the function is displayed in the source window.
.IP \(bu
Scroll the source to make visible the line where you want to
add a breakpoint.
.IP \(bu
Add a breakpoint by clicking the right mouse button over the source line.
.RE
.LP 
\*(Bo Click on
.Cm Cont
in the target control menu.
.IP
The target continues until it hits a breakpoint.
In this case the target stops in the second call of
.fX stash
from main.
You will notice that in the display area the displayed value of
.fX a_name
has changed.
.LP
\*(Bo Click on
.Cm Cont
again.
.IP
The target continues to completion and exits.
The stack trace and variables disappear from the
display area, and all the target control menu captions except
.Cm Start
are greyed out to indicate that they are unavailable while the target
is stopped.
.LP
We are almost at the end of this example.
These last steps are to show how you can add 
.fX printf
calls (in fact any interpreted C).
The actions we are about to cover are:
.IP \(bu
Editing some interpreted C into a breakpoint.
.IP \(bu
Scrolling the source window to show the other breakpoint and
removing it.
.IP \(bu
Re-running the target to see the effect of the interpreted code.
.LP
\*(Bo Move the mouse over the
.fX #stop; ' `
text that indicates the breakpoint in the
.fX stash
function and click the middle mouse button.
.IP
You should see an editing cursor (a black rectangle) appear.
If it is not at the end of the
.fX #stop; ' `
text then click the middle mouse button further to the right.
.LP
\*(Bo Use the delete key to delete the
.fX #stop; ' `
text.
.LP
\*(Bo Type the following text:
\*(Cr$printf("Setting a->a_name to %s\en", a->a_name);\fP
.IP
.fX $printf
is a built in
.I ups
function with an interface almost identical to printf except that
it sends output to an region in the ups display.
.LP
\*(Bo Hit ESC (the escape key)
.IP
If you haven't made any errors
.I ups
will silently accept the line
and the editing cursor will disappear.
.IP
If you have made a syntax error
.I ups
will beep, give you an error message and put the editing cursor
at the point of the error.
You can then correct the error.
.LP
\*(Bo Press and hold down the left mouse button in the scroll
bar to the left of the source window, and with the mouse button
pressed move the mouse button a few pixels towards the top of
the window.
.IP
You should see the source text scrolling slowly upwards.
The more you move the mouse from the place you first pressed it,
the faster the source scrolls.
.LP
\*(Bo When you see the source of
.Cm Main
appear in the source window release the mouse button.
.IP
The scrolling will stop.
.LP
\*(Bo Click the middle mouse button on the
.fX #stop
at the start of main.
.IP
This displays the editing cursor as before, but if you look in the
display are you will notice that it also selects the corresponding
breakpoint object.
You will see the breakpoint entry highlighted, as well
as a menu with the captions
.Cm Remove ,
.Cm Source
and
.Cm "Save to file"
near the top of the window.
.LP
\*(Bo Click on
.Cm Remove
in the menu
.IP
You will see the breakpoint entry in the display area disappear, along with
the
.fX #stop;
line in the source window.
.LP
\*(Bo
Click on
.Cm Start
in the target control menu.
.IP
You should see a third subregion appear in the display.
This looks similar to the source window, with a controlling menu
above it and a scroll bar on the left hand side.
.IP
This is the
.IR "output region" .
It is where output from the built in function
.fX $printf
appears.
This region appears the first time
.fX $printf
is called by interpreted code.
.IP
You will see that the text
.RS
.Vs
Setting a->a_name to foo
Setting a->a_name to bar
.Ve
.RE
.IP
has appeared.
This was produced by the interpreted code that you added.
.IP
Note that the target ran to completion without stopping.
A breakpoint only stops the target if the pseudo C statement
.fX #stop
is executed.
This lets you add conditional breakpoints simply by putting
an
.fX if
statement around them.
.IP
One final point: you can call target functions (like
.fX stash
in this example) from interpreted breakpoint code.
This is often used to call
.fX printf
in cases where you
.I do
want the debugging output interspersed with the target program's output.
.LP
Here endeth the example.
It certainly hasn't covered all of the features of
.IR ups ,
but hopefully it has given you a feel for the way it works.
Some basic points:
.IP \(bu
The two important areas in the display are the display area (top) and
the source region (bottom).
.IP \(bu
The display area contains captions representing objects of different
types.
.IP \(bu
You can select an object by clicking on it with the left mouse button.
.IP \(bu
Each different object type has an associated menu which appears near
the top of the
.I ups
window when the object is selected.
.IP \(bu
Commands selected from these menus act on the currently selected objects.
.IP \(bu
The source region displays the currently executing source code,
with the line that is about to be executed highlighted.
.IP \(bu
You can add any variable to the display area by clicking on an instance
of it in the source window with the left mouse button.
.IP \(bu
You can add breakpoints by pointing at lines of source.
.IP \(bu
You can edit breakpoints to add
.fX printf
statements and conditional breakpoints.
.IP \(bu
You can expand and collapse structures to explore data structures.
.IP \(bu
Variables remain in the display area as you step through the code
so you can watch the values change.
.LP
The rest of this manual page gives a complete description of
.I ups .
You should probably skim through it at first reading before playing
with
.I ups
on some of your own code for a while.
When you are more familiar with
.I ups
reread these sections in more detail.
.SH "UPS COMMAND LINE ARGUMENTS"
This section gives a complete description of the command line
arguments accepted by
.IR ups .
The command line syntax is:
.IP
\fBups\fP \fItarget\fP [\fIcorefile\fP|\fIpid\fP] [[:]\fIsrcdir\fP[:\fIsrcdir\fP]] [\fB-a\fP \fItarget-args\fP]
.LP
.I Ups
accepts various other flags, but these are mostly to support
maintenance and testing, and are not of interest to the
general user.
You can see a full list of the
.I ups
flags by giving the command
.fX "ups -fullusage" '. `
.LP
The only mandatory argument is the name of the executable file
containing the program to be debugged (the target).
.LP
If a
.I corefile
argument is given it is taken to be the name of
a core image dumped from
.IR target .
If no
.I corefile
argument is given and there is a core image file
called
.fX core ' `
in the directory of the target then that is taken as
the core file.
Old core files, and core files which weren't dumped from the target, are
silently ignored unless you give the name of the core file explicitly
(in which case
.I ups
will use it, but give a warning message).
.LP
If the
.I corefile
argument consists solely of digits,
it is taken to be the process id of the target.
This allows you to attach
.I ups
to an already running process on machines
with the necessary support (currently only Suns).
If you subsequently quit \fIups\fP while still attached in this way,
it detaches from the target, allowing the target to continue.
.LP
By default
.I ups
looks for source files in the directory of the target.
You can specify alternative source directories by giving a list of directories
separated by `:' characters.
An empty initial path (i.e. a leading `:') means the directory of the
target.
On Suns running SunOS 4, the C compiler includes directory paths for
source files, so
.I ups
will normally find source files in other
directories even without the source path argument.
.LP
You can specify the arguments that the target should be invoked with by
giving the
.B -a
option, followed by a single argument.
You can give multiple arguments for the target by enclosing the list of
arguments in single or double quotes.
.I Ups
will itself interpret metacharacters like
.fX * ' `
and
.fX > ' `
\- see
.Sc "TARGET COMMAND LINE ARGUMENTS" .
.SH "LAYOUT OF THE UPS WINDOW"
The
.I ups
window is divided into a number of rectangular regions.
This section gives a brief description of each region.
It won't make much sense unless you are also looking at an
.I ups
window.
.IP \(bu
At the top of the window on the left is the \fItyping line\fP.
On startup a black rectangle known as a \fIediting cursor\fP is shown.
Typed characters appear in this region, and some
.I ups
commands
use the text in this window as an argument (e.g., the command to
search for a regular expression in a source file).
.IP \(bu
Below the typing line is the \fIdynamic menu area\fP.
On startup this area is greyed out.
See
.Sc "THE DISPLAY AREA"
below for a description of the dynamic menu.
.IP \(bu
Below the dynamic menu area is a region where messages from
.I ups
appear (usually with a beep).
.IP \(bu
To the right of the above three regions is a \fImousehole\fP.
This has a representation of the three mouse buttons, and captions
for each button saying what that button will do.
The captions change as you move from region to region, reflecting
the fact that the mouse buttons have different functions in
different regions.
.IP \(bu
Below the preceding four regions is the \fIdisplay area\fP \-
a large region used to display and investigate the current state
of the target.
There is a scroll bar to the left of the display area.
See
.Sc "THE DISPLAY AREA" .
.IP \(bu
Below the display area is the \fItarget menu\fP.
This has a set of commands for controlling target execution.
See
.Sc "CONTROLLING TARGET EXECUTION"
below.
.IP \(bu
Below the target menu is the \fIsource menu\fP, with a set of commands
for managing the source region, which is below this menu.
There is a scroll bar to the left of the source region.
See
.Sc "THE SOURCE REGION"
below.
.SH "THE DISPLAY AREA"
The display area is the large region in the upper half of the
.I ups
window.
Its main use is to show the state of the program when it stopped,
though it is also used for other control functions.
.LP
There are a number of captions in the display area,
like
.Ob Signals ,
.Ob Breakpoints
etc.
These are known as
.I objects .
To select an object, press and release the left mouse button over it.
.LP
Any objects that were previously selected are deselected,
the object is inverted to show that it is selected, and a menu
of commands applicable to that object appears 
in the second of the three slots at the top of the window.
At any time this region of the display either contains a menu
corresponding to a selected object, or is empty (painted a
uniform grey) if there are no objects selected.
.LP
A command selected from the menu (by pressing and releasing the
left mouse button over the caption) is applied to the currently
selected objects.
It is possible to apply a command to a group of objects.
To do this, select a group of objects
by pressing the left mouse button over the
first object and then dragging the mouse over the other objects
you wish to select before releasing the button.
You cannot select objects of different types simultaneously
as each different type of object has its own menu.
Once the first object has been selected, only objects of the
same type will be selected (and highlighted) as the cursor passes
over them.
.LP
The right hand mouse button is used to toggle whether an object
is selected \- clicking it over a selected object deselects
that object, and clicking over an object that isn't selected adds
that object to the selection.
As with the left mouse button, you can drag the mouse with
the right button down to toggle a group of objects.
.LP
Several of the menu commands add new objects to the display.
For example, when you expand an entry in the stack trace
all the local variables for the function it represents
are added to the display (see
.Sc "EXAMINING VARIABLE VALUES"
below).
These new objects can be selected in the same way as the
existing ones, and have an associated menu of commands.
.LP
Once a few objects have been added to the display area,
there is usually not enough room to display all of them
at once.
There is a scroll bar to the left of the display area
which lets you scroll the display area up and down.
To scroll, press and hold down the left mouse button whilst within
the scroll bar, and move the mouse in the direction you
wish the display to move.
The further you move the mouse, the faster the scrolling.
.LP
You can also use the left and right mouse buttons to page up and down
through the display in the same way as with the
.IR xterm (1)
scroll bar.
Clicking the left mouse button in the scroll bar pages the display
down.
Similarly, clicking the right button pages the display up.
The distance paged depends on how far the cursor is from the top of
the scroll bar.
.LP
The black blob in the scroll bar represents the proportion
of the entire display that is currently visible, and the
position of this visible part within the whole display.
For example, if the black blob is one third the height
of the scroll bar, and in the middle, it means that
the total height of the objects is about three times
the height of the display area, and the middle third
is currently being displayed.
.LP
You can use the scroll bar to go directly to a given
point in the display.
Press and release the middle mouse button at a point in the
scroll bar.
The black blob is moved so that it centres around the
point, and the display is moved correspondingly.
.SH "THE SOURCE REGION"
The source region is used to display the source line that the target
is currently stopped at, or more precisely the line that is about to
be executed.
Like the display area, the source region has a scroll bar to the
left of it, which behaves in the same way as the display area
scroll bar.
.LP
Above and to the left of the source region is a box where the name
of the current source file and the current line number is
displayed.
To the right of this is the source region menu with commands
.Cm Back ,
.Cm Search ,
.Cm Up
and 
.Cm Down .
.LP
The 
.Cm Up
and 
.Cm Down
commands step up and down through the target program's call stack.
If you are looking at the source code of the currently executing
function,
.Cm Up
switches the display to show the source of the function that called it.
Repeatedly clicking on
.Cm Up
will take you all the way up the stack to
.fX main
(or
.fX MAIN
for Fortran programs).
Similarly,
.Cm Down
steps one level down in the call stack.
.LP
The 
.Cm Search
command is used to search for regular expressions
(using the same syntax as \fIgrep(1)\fP patterns) in the currently
displayed source file.
First type in the pattern to be searched for (typed characters appear
in the typing line at the top of the window on the left) then
press and hold down the left mouse button over the 
.Cm Search 
caption.
A popup menu appears with the options 
.Cm Backwards
and 
.Cm Forwards .
Move the mouse over the one you want and release the button.
If the pattern is found, the matching text is made visible in the
source region and highlighted.
.LP
You can click the left mouse button on any variable or function name in the
source window to display it.
Variables are added to the display area, as described in
.Sc "EXAMINING VARIABLE VALUES"
below.
If you click on a function name, the source for that function is displayed
(this is similar to the tags facility in 
.I emacs or
.IR vi ).
.I Ups
maintains a stack of where you've been.
After you have clicked on a function name you can use the
.Cm Back
command in the source menu to return to where you were.
.LP
You can also get a function displayed by typing the name into the
typing line at the top of the
.I ups
window.
You do not need to type the whole name \- just enough characters to
uniquely identify the function.
If a function appears by the same name in more than one source file,
you can use the syntax `filename:funcname' to specify which function
you want.
.I Ups
will also understand shell-style globbing (e.g.
.fX *foo_func* ') `
for function and global
variable names, with the restriction that the pattern must match only
a single name.
.LP
Whenever the source region switches to a new source file,
.I ups
checks the last modified time of the source file against
the last modified time of the target object file.
If the source file is newer than the target you get a warning
message and the source code is displayed with foreground and background
colours reversed as a reminder that this source code might not
correspond the object file you are debugging.
.LP
You can select arbitrary text in the source window by dragging the
mouse over it with the left button pressed.
The selected text is highlighted, and can be pasted into other
windows, or other areas in the ups window (such as the typing line).
Note that dragging (press mouse button, move mouse, release) has a
different effect than clicking (pressing and releasing the left mouse
button without moving the mouse).
.SH "EDITABLE FIELDS"
All editable fields in 
.I ups
work in the same way.
To start editing you click the middle mouse button over the editable text.
A black
.I "marker bar"
appears \- characters that you type appear to
the left of this marker bar.
You can reposition the marker bar by clicking in the new position
with the middle mouse button, or by using one of the cursor movement
key sequences described below.
.LP
Clicking the left or right button confirms the edit.
Clicking the middle mouse button outside the editable text area
also confirms the edit.
In both cases the mouse click is then interpreted as normal \- this
means that to confirm an edit you can simply move on to another activity.
The final way to confirm an edit is to type ESC (the escape key).
.LP
To paste the current window system cut buffer, click on the middle
mouse button with the shift key down.
.LP
When you try to confirm an edit
.I ups
checks that the new field value is reasonable.
If not you get an error message and you are left in the edit.
An immediate second attempt to quit abandons the edit and restores the
original field value.
.LP
.I Ups
recognises a subset of the GNU emacs key bindings when editing fields.
In the current version there is no way to customise these key
bindings.
This will be fixed in a future release.
.LP
You can use most of the common emacs key mappings when editing text
(e.g. in the typing line, when adding breakpoints etc).  Here is a
list of the supported mappings
.fX C-x "" (
means CONTROL-x,
.fX M-x
means ALT-X,
.fX UP ,
.fX DOWN ,
.fX LEFT
and
.fX RIGHT
are the arrow keys,
.fX SPC
is the space bar and
.fX DEL
is the delete key):
.RS
.En C-a
Move to start of line
.En C-e
Move to end of line
.En M-m
Move to first non-whitespace character
.En "M-@, M-SPC"
Set mark
.En C-w
Delete text between mark and point
.En "C-p, UP"
Move up a line
.En "C-n, DOWN"
Move down a line
.En "C-b, LEFT"
Move backwards one character
.En "C-f, RIGHT"
Move forward one character
.En M-b
Move backwards one word
.En M-f
Move forward one word
.En "C-j, C-m"
In an editable field, finish the edit.
In the source window, start a new line.
.En ESC
Finish edit, in both editable fields and the source window.
.En C-c
Cancel edit (not an emacs binding).
.En C-k
Delete to end of line
.En C-u
Delete to start of line (not an emacsbinding )
.En C-d
Delete character under cursor
.En M-d
Delete word starting at cursor
.En DEL
Delete character before cursor
.En M-DEL
Delete word before cursor
.En C-y
Paste X selection
.En M->
Move to end of buffer
.En M-<
Move to start of buffer
.RE
.LP
If you run
.I ups
from a terminal (or a terminal emulator like
.I xterm),
it tries to discover what keys you are using for delete and line erase.
If this fails it takes both ^H (backspace) and DEL to mean delete, and ^U
to mean line erase.
.SH "EXAMINING THE TARGET'S STATE"
When the target is stopped at a breakpoint or when
.I ups
has been started with a core file, the target's state is show in the
form of a \fIstack trace\fP in the display area.
This consists of a line for each active function giving the
name of the function, the source line number of the line that
was being executed, and the name of the source file containing the function.
.LP
The stack trace appears under the 
.Ob Functions
object in the display
area.
As an example, consider the following stack trace:
.Vs
\f(CBFunctions\fP
  main		main.c:42
  docmd		commands.c:84
  getline		io.c:21
.fi
.Ve
.LP
In this example, execution in function \fImain\fP reached line 42, at which
point \fImain\fP called \fIdocmd\fP.
In turn, \fIdocmd\fP at line 84 called \fIgetline\fP.
\fIGetline\fP is stopped at line 21 (which is yet to be executed).
.LP
When the target stops, the source of the innermost function is displayed,
with the line that is just about to be executed highlighted (displayed
in reverse video).
To look at the source of other functions in the stack trace:
.IP \(bu
Click the left mouse button over a line in the stack trace.
The line is highlighted, and a menu appears near the top of the
window with the captions 
.Cm Expand ,
.Cm Collapse ,
.Cm "Add expr" ,
and 
.Cm Source .
.IP \(bu
Click on 
.Cm Source
in the menu.
The source corresponding to the selected line in the stack trace
is shown, with the line that is currently executing highlighted.
.LP
In this way you can see exactly where the target is stopped at any
level in the stack.
.SH "EXAMINING VARIABLE VALUES"
There are several ways to find the values of variables.
The simplest and most often used is simply to click with the
left mouse button on the name of a variable in the source region.
A line is added to the display area which looks something like:
.Vs
int <varname>			73
.Ve
.LP
In this example, an integer variable called \fIvarname\fP with a current value
of 73 is shown.  The meaning of the angle brackets around the name is
explained later \- ignore them for now.
.LP
If the variable is local to a function, it is added just below the
line in the stack trace for that function.
If the variable is global, an entry for the source file of the variable
is added below the
.Ob "Source files"
object in the display area and
the variable is displayed below that.
In rare cases
.I ups
does not know the type of the variable, in
which case it is assumed to be an integer and displayed under the
.Ob "Untyped variables"
object.
.LP
Once the variable is added to the display, it remains there until
its function returns (for a local variable) or you explicitly
delete it (see later for how to do this).
This means that you can watch the value change as you control the
execution of the target.
.LP
As well as selecting individual variables to be shown, you can add all
the local variables of an active function to the display.
Select the function in the stack trace whose variables you wish to see, 
and select 
.Cm Expand
from the menu produced.
This will produce a popup menu with the options
.Cm "Like before"
and
.Cm Completely.
The default option is
.Cm "Like before"
- it means to make the display look like it did last time you looked
at the local variables for this function.
If there is no `last time', all the local variables are displayed.
The second
.Cm Expand
option
.Cm Completely ) (
always adds all the function's local variables to the display.
.LP
To remove all the local variables select
.Cm Collapse .
You can subsequently put them back as they were using
.Cm Expand ,
.Cm "Like before" .
If you have saved state enabled, you can do this even after exiting
.I ups
and starting it again.
See the
.Sc "SAVING STATE"
section for details.
.LP
.ne 8
When you use 
.Cm Expand
to add all the local variables of a function,
you may see some lines like this:
.Vs
\u\l'7m'\d    lines 84..93 \u\l'7m'\d
.Ve
.LP
These lines are added for variables declared within inner blocks of a
function.
In this example, there is an inner block starting at line 84 and ending
at line 93 which contains local variable declarations (the line numbers
are sometimes inaccurate because of bad information supplied by some compilers).
If you click the left mouse button over one of these entries, a menu
with the options 
.Cm Expand ,
.Cm Collapse ,
.Cm Add expr"
and 
.Cm Source
is
produced.
Selecting 
.Cm Expand
adds to the display all variables declared in the block.
.Cm Collapse
removes them again, and 
.Cm Source
makes the first line
of the block visible in the source region.
.LP
See the later section
.Sc "CONTROLLING THE DISPLAY OF VARIABLES"
for information on (among other things) how to change the format of a
displayed variable, indirect through pointers, expand structures and unions
and step through the elements of an array.
.SH "CONTROLLING TARGET EXECUTION"
Once you have the target stopped at a breakpoint there are several
ways of controlling its execution.
Most of these are invoked from the \fItarget menu\fP \- the permanent
menu just below the display area.
.LP
The usual way of debugging is to set a breakpoint in the function which
you think is misbehaving and then step through its code one line at a time.
The
.Sc "GETTING STARTED"
section above explains how to set breakpoints
and start the target running.
To step over a line of source, select
.Cm Step
from the target menu.
The code on the highlighted line is executed, and the highlighting
moves on to the next line to be executed.
.LP
The values of variables in the display area are updated every time the
target stops, so you can watch values change as you step through the
code.
On colour displays variables are shown in a different colour if their
values have changed since the last time the target stopped.
.LP
If the line to be executed calls a function,
.Cm Step
takes you to the first line of the called function,
and stepping continues in the function.
If you don't want to step through the code of called functions in this
way, use the
.Cm Next
command.
This behaves like
.Cm Step ,
except that it never steps into called functions.
.LP
Both
.Cm Next
and
.Cm Step
work with respect to the currently displayed source.
If you click on a function in the stack trace and select
.Cm Source
to display its source, a subsequent
.Cm Next
or
.Cm Step
moves to the next line of the displayed source.
This makes it easy to get out of a function that you have stepped into
by accident and don't wish to step all the way through.
Use the
.Cm Source
command to display the source of the calling function, then use
.Cm Next
or
.Cm Step .
.LP
The
.Cm Cont
command in the target menu offers a third way to
control the target \- this command runs the target until it
hits another breakpoint, gets a signal, or exits.
.LP
Finally, you can `drag' execution in the target to a line in the
source file.
Move the mouse cursor over the line you wish to get to, and press
and hold down the right mouse button.
A popup menu appears, with the captions
.Cm "Add breakpoint"
and
.Cm "Execute to here" .
Drag the mouse down so that the
.Cm "Execute to here"
caption is highlighted, and release the button.
The effect of this is to set a temporary breakpoint at the line,
temporarily disable all other breakpoints, and then continue the
target.
You can use this command to move past uninteresting bits of code
without having to set up and remove breakpoints.
.LP
The other command on the popup menu,
.Cm "Add breakpoint" ,
adds a breakpoint at the line of source you pointed at.
Unfortunately, to set a breakpoint at (or execute to) a single statement that
extends over several text lines, you must point at the last
text line.
This is due to limitations in the symbol table information put out
by the compilers.
.LP
You can stop the target running at any time by clicking on
.Cm Stop
in the target control menu.
The target will then stop wherever it is currently executing as if it
had hit a breakpoint.
.LP
The
.Cm Kill
command kills off the current instance target process.
You can then use
.Cm Start
or
.Cm "Execute to here"
to start the target again.
Quitting
.I ups
also kills the target process (unless you attached
.I ups
to a running process, in which case
.I ups
detaches from the process and leaves it to continue unmolested).
.SH "TARGET COMMAND LINE ARGUMENTS"
The second line of the display area shows the command line arguments that
will be given to the target when it is next started.
The arguments shown include the zero'th argument which is initially set to the name
of the target.
.LP
You can specify an initial set of arguments for the target with the
.B -a
option when you start
.IR ups .
If you don't give the
.B -a
option and you are debugging from a core file,
\fIups\fP attempts to extract the command line arguments from the core file.
Otherwise the command line contains no arguments other than the name of the
target.
.LP
\fIUps\fP parses the command line in a similar way to the shell.
It supports Bourne shell type redirection (>, >>, <, >&dig, etc.) as
well as the \fIcsh\fP forms >& and >>&.
\fIUps\fP also understands most \fIcsh\fP
metacharacters \- globbing with `*', `?' and `[xyz]', the `~', `~user' and
`{a,b,c}' shorthands, and quoting with single or double quotes and backslash.
The current version of
.I ups
does not support
.I $var 
type shell variable substitution.
.LP
You can edit the command line at any time to change the command line arguments
(although the changes will only take effect when you next start the target).
.LP
The command name shown is just the zero'th argument and can be edited just
like the other arguments.
This is useful with programs which use the zero'th argument as a sort of
hidden flag.
Changing the command name only affects the arguments given to the target \-
it does not change which program is being debugged.
.SH "CONTROLLING THE DISPLAY OF VARIABLES"
When you add a variable to the display (see
.Sc "EXAMINING VARIABLE VALUES"
above)
it is displayed in a default format.
If you click the left button over the line for the variable, a menu
appears in the top part of the window.
You can use this menu to set the display format for the variable (
.Cm Format )
,
to change the level of indirection for pointers
.Cm * "" (
and
.Cm & ),
to show all the members of structures and unions (
.Cm Expand
and
.Cm Collapse ),
to choose the format variables are displayed in
.Cm Format ,
to duplicate or delete entries for variables (
.Cm Dup
and
.Cm Del )
and to control whether typedefs are used in displayed variables
(
.Cm Decl )
..
.LP
.B
Pointers
.LP
The default for a pointer variable is simply to show the pointer value
in hex.
To take a common example, if you add a variable of type
.fX "pointer to pointer to char"
called
.fX argv
to the display, you will get a line like:
.Vs
char **<argv>		0x7fffe184
.Ve
.LP
The angle brackets separate the type from the value.
In this example, what is shown is the value of argv, which is
of type
.fX "char **" .
.LP
If you now click with the left mouse button on this line, and select
.Cm * ' `
(the leftmost caption) in the variables menu, the format
of the line changes to something like:
.Vs
char *<argv{0}>		0x7fffe1d0
.Ve
.LP
This says that what is shown is the value of
.fX argv[0] ,
which is of type
.fX "char *" .
The braces (`{' and `}') are used to distinguish a dereferenced pointer
from a true array.
.LP
A second click on the
.Cm * ' `
menu option changes the line to:
.Vs
char <argv{0}{0}>		"foo"
.Ve
.LP
This is a special case in
.I ups
\- variables of type
.fX char
are displayed as strings if they are indirected pointers or members of arrays.
.LP
The
.Cm & ' `
menu option is the opposite of
.Cm * ' `
\- it drops
one level of indirection.
You can only use this on indirected pointers.
Use an expression if you want to see the address of a variable (see
.Sc "EXPRESSIONS IN THE DISPLAY AREA"
below).
.LP
.B
Arrays
.LP
Arrays are initially displayed with all subscripts zero.
You can edit the subscript to another value by clicking on it
with the middle mouse button.
A marker bar appears, and you can use the delete key to delete the
old subscript and type a new one.
When you hit ESC, the value of the new array element is shown.
.LP
Often you wish to quickly scan through all the elements of an array.
You can do this using either the arrow key or the `>' and '<' keys.
When editing an array subscript, the '>' key adds one to the
subscript value and displays the new element.
Similarly, the '<' key subtracts one from the subscript value.
Using these keys you can rapidly scan up or down an array.
.LP
.I Emacs
users can use ^P and ^N as synonyms for '<' and '>'.
.I Vi
users can use 'k' and 'j' similarly.
.LP
The arrow (or whatever) keys actually act on the digit to the left of
the cursor, so by moving the cursor left you can step by tens,
hundreds etc.
.LP
.B
Structures
.LP
Note: in this section `structures' also include unions: they are simply
treated as structures with all members having an offset of zero.
.LP
Variables that are structures or pointers to structures are initially
displayed with just the address in hex.
You can use the 
.Cm Expand
command in the variables menu to add
all the members of a structure to the display.
The structure members are indented to make it clear which structure
they belong to.
.LP
If a structure element is itself a structure or a pointer to a structure,
it can be expanded in turn to show all its members.
In this way linked data structures can be explored.
For a more selective way of exploring a linked data structure, see
the
.Sc "EXAMINING LINKED DATA STRUCTURES"
section below.
.LP
To remove all the members of a structure from the display, use the
.Cm Collapse
command in the variables menu.
This has a submenu with the options
.Cm "First level"
and 
.Cm Completely .
The first of these removes all members except expanded ones; the second
recursively collapses all expanded structures below the selected one.
.LP
.B
Changing formats
.LP
By default integer variables are displayed in decimal
and pointer values are shown in hex.
You can change the format with the 
.Cm Format
command in the
variables menu.
The possible formats are signed or unsigned decimal, hex, octal and binary,
as well as `ascii' and `string'.
The `ascii' format displays integers in C character notation (e.g.
the value 65 is displayed as `a').
The `string' format is applicable to variables of type
.fX char
that are indirected pointers or arrays \- it treats the address
as the first character of a NUL terminated string.
.LP
Floating point values are shown in the conventional notation (using the
.I printf
.fX %g
format).
You can use the
.Cm Format
command to display a hex representation of the value (it makes no difference
whether you select signed or unsigned hex from the menu).
This shows in hex the bit pattern used to represent the floating point value.
.LP
.B
Duplicating and deleting entries
.LP
The 
.Cm Delete
command in the variables menu deletes
all selected variables from the display area.
This is useful for tidying up the display by removing variables
that are no longer of interest.
.LP
Sometimes it is useful to have a variable displayed more than
once.
One common case is where you want to see several elements of an
array simultaneously.
The 
.Cm Dup
command in the variables menu duplicates the
entries for all selected variables.
So to see multiple elements of an array, use 
.Cm Dup
to
add an entry for each element you wish to see, then
edit the subscripts separately for each entry.
.LP
.B
Use of typedefs
.LP
If a structure, union or enum has a typedef name then
.I ups
will use it in the display area.
Thus if you have the following in a function:
.Vs
typedef struct foo_s {
	int x;
	int y;
} foo_t;

foo_t *f;
.Ve
then clicking on variable
.fX f
will add a line like:
.Vs
	foo_t *<f>		0x40ec
.Ve
to the display area.
Typedefs are not used if they hide a level of indirection or an
array, or if the typedefed type is not a struct, union or enum.
.LP
If you want to see the non-typedef type for a variable in the display
area, select the variable and press and hold down the left mouse button
over the
.Cm Decl
command in the variables menu.
This produces a popup menu with the captions
.Cm "Use typedefs"
and
.Cm "Ignore typedefs" .
Release the mouse over
.Cm "Ignore typedefs"
and you will be shown the non-typedefed type for all the selected variables.
.SH "CHANGING VARIABLE VALUES"
You can change the value of a displayed variable simply by editing
the displayed value (i.e. by clicking on it with the middle mouse
button and editing in the new value).
This works for C pointers and integral types (including enums), floating
point values and strings.
.LP
You can use any of the integer display formats for the new value
(decimal, hex, octal, binary or ASCII character).
You can use enum constant names for new enum values, and function
names for function pointers.
When editing strings or characters you can use the standard C notation
for special characters
.fX \en ', (`
.fX \eb ', `
.fX \e007 ' `
etc).
.LP
Normally
.fX ups
will not let you edit extra characters into a string as this would
overwrite whatever was stored in memory just after the string.
If space is known to exist (for example if the string is stored
in an array of known size and there are unused bytes) then you can add
as many characters as will fit.
If you know you want to overwrite memory beyond the end of the string
you can force 
.I ups
to accept a long value by putting
.fX >> ' `
before the leading quote character of the string.
.LP
Normally a trailing NUL
.fX \e0 ') ('
is added to the edited string in the normal C way.
If you delete the trailing quote character then this is omitted.
.SH "EXPRESSIONS IN THE DISPLAY AREA"
You can add C expressions as well as variables to the display area.
This is useful if you wish to see what an expression in the source
code evaluates to.
It also allows you to use casts when you know better than the source
code what the type of a given variable is.
.LP
To add an expression, select a function in the stack trace and
click on
.Cm "Add expr"
in the function menu.
A marker bar appears, ready for you to enter an expression.
When you have finished type ESC, and if the expression is legal
the value will be displayed.
If there is an error in the expression you will get an error message
and the marker bar will be repositioned at the point of the error.
.LP
In an expression you can use any variable name, structure tag or typedef
name that is in scope in the function.
If you want to add expressions using a variable in an inner block,
you will have to add the expression to the appropriate inner block.
The easiest way to get the inner block object displayed is to click
on a variable in the inner block in the source region.
Once it is displayed select the block header and click on
.Cm "Add expr"
in its menu.
.LP
You can `bump' numbers in expressions in a similar way to array
subscripts.
Hitting the down arrow (or control-N) over a number while editing an expression
increases the digit to the left of the marker bar and displays
the new value of the expression.
Similarly the up arrow (or control-P) decreases the digit to the left of the
marker bar and redisplays the expression value.
.LP
Expressions are reevaluated like variable values every time the target stops.
They also have the same menu associated with them as variables,
and you can have both expressions and variables in the same selection.
The `*' and `&' menu commands don't work on expressions, but all the others
work as they do on variables.
This means in particular that if you add an expression whose type
is `pointer to struct' (or union) you can use
.Cm Expand
to show the structure elements.
You can also use
.Cm Format
to change the format used to display the expression value.
.LP
You can't call target functions or modify target data in a display
area expression (thus operators like `++' are illegal).
.SH "PASTING EXPRESSIONS FROM THE SOURCE WINDOW"
It is often useful to display the value of an expression in the source.
You could select
.Cm "Add expr"
as described in the previous section,
and cut and paste the expression from the source window.
This works, but there is a quicker way: simply select the text of the
expression in the source window while holding the shift key down (i.e.
press the shift key, then drag the mouse over the desired text).
When you release the mouse button, the selected text is added as an
expression in the display area.
It is OK to drag over multiple lines.
.LP
You will notice that when you first press the left mouse button (with
the shift key pressed), ups highlights some text.
This is its guess as the to expression you would like to paste.
If you are happy with this, release the mouse button without moving
the mouse, and the highlighted text will be added as an expression.
If the highlighted text is not what you want, drag the mouse to make
the selection as described before.
.LP
Pasting expressions from the source window can often fail because of
preprocessor macros which
.I ups
does not understand (e.g.
.fX NULL ).
The correct fix for this is for
.I ups
to understand
.fX #defines ,
but in the interim there is a workaround: if the file
.fX ups-state/repltab
exists below
the current directory ups will apply the substitutions specified
there.  Here is a
.fX repltab
file that would deal with
.fX NULL
and
.fX EOF :
.Vs
	# Repltab for ups
	NULL	0
	EOF	(-1)
.Ve
.LP
Hash comments and blank lines are ignored in the normal way.
Any substitutions will be visible in the pasted expression.
.LP
Ups checks to see if the repltab file has been updated each
time an expression is pasted, so you don't have to restart ups
to it to notice changes.
.SH "ADDING INTERPRETED CODE"
The
.I ups
display area gives a good picture of that state of
a program at any one time.
Often though, you want a record of what happened over a series
of calls of a function.
This is one of the reasons why people still tend to put print statements in code
despite the availability of debuggers and the inconvenience
of recompiling the code.
.LP
To make it easier to add diagnostic output statements,
.I ups
allows you to insert fragments of C code at any breakpoint.
The default breakpoint action \- stopping the target \- is represented
as a fragment of pseudo C code.
This is the
.Vs
#stop;
.Ve
.LP
line that appears in the source region when you add a breakpoint.
.LP
You can change this to a fragment of C code, editing the text
in the usual way by clicking the middle mouse button to
position a marker bar.
You can use the RETURN key to enter multi-line code fragments.
As with other editable fields, you end the edit with ESC.
If there is an error in the code, an error message is given
and the marker is positioned at the point of the error.
.LP
For example, you could change the breakpoint action to:
.Vs
printf("Entered function foo with x = %d\\n", x);
.Ve
.LP
From now on, whenever the target reaches this point in the program,
it will call \fIprintf\fP rather than stopping.
.LP
Note that a breakpoint will not stop the target unless the special
keyword
.fX #stop
is executed.
You can use this to set conditional breakpoints, like:
.Vs
if (i == 72)
	#stop;
.Ve
.LP
or, to use a more sophisticated example:
.Vs
if (strcmp(p->p_name, "foo") == 0)
	#stop;
.Ve
.LP
In the above examples, the function calls (\fIprintf\fP and \fIstrcmp\fP)
are implemented as calls to functions in the target.
You can call any target function from a breakpoint, but in the current
version of
.I ups
all functions are assumed to return
.fX int .
You can often get around this by casting the return value to the correct type.
.LP
One problem with calling functions like
.fX printf
to do diagnostic
output is that the output is mixed up with the normal output of the target
program.
If you want the output kept separate, use the built in
.I ups
function
.fX $printf .
This function creates a new region in the
.I ups
window the first
time it is called, and sends output to that region.
The menu at the top of the region allows you to search for regular
expressions in the output, as well as page through it and clear
all output.
.LP
The
.fX $printf
function takes the same format string as \fIprintf\fP,
with one addition.
The `%v' format string can be used with any variable type, and means
print in the default
.I ups
format for the type.
The `%v' format character will print symbolic names for
.fX enum
values and function pointers (i.e. you will get output like
.fX RED
and
.fX close_callback
rather than
.fX 23
and
.fX 0x5e748 .
In addition `%v' applied to a struct or union pointer will print the
names and values of all the fields of the pointed-to struct or union.
.LP
You can declare your own variables in breakpoint code.
This is useful when you want only want to stop at a breakpoint
after it has been hit a given number of times.
A code fragment to do this would look something like:
.Vs
{
	static int count = 0;

	if (++count == 74)
		#stop;
}
.Ve
.LP
This would stop the target the 74th time the breakpoint was encountered.
Static variables are reinitialised every time the target is started.
Automatic variables are uninitialised and do not preserve their values
between separate executions of breakpoint code.
.LP
You can mix C interpreter variables with real target variables
in expressions in breakpoint code, with some restrictions.
You can assign to target variables, but making
a target pointer point at an interpreter variable will not work,
as interpreter variables do not exist in the target's address space.
On the other hand, the interpreter knows about the target address
space, so you can point interpreter variables at target variables.
.LP
Note that you can only
.I add
interpreted code \- you can't directly affect the flow of control
of the compiled code.
For example adding a
.fX return
statement will
.I not
cause the compiled function to return to the caller.
It is sometimes possible to indirectly affect the flow of control
by judicious changes to variable values.
.LP
You cannot add C interpreter variables to the display; if you click on
a variable in interpreted code it is taken to be a variable from the
target process.
.LP
[ You probably want to skip this paragraph. ]
For people who want to live at the ragged edge, the C interpreter
uses copy-in copy-out semantics when passing interpreter addresses
to the target.
If you pass an argument of type
.fX "pointer to T"
to a compiled target function then the interpreter copies
.fX sizeof(T)
bytes to the target address space and passes a pointer to that copy.
When the target function returns the same number of bytes are copied
back from the target into the interpreter address space.
Similarly when you pass an array, the contents of the array are
copied in and out.
Note that this mechanism does not work in general \- it only copes
with passing an array or a pointer to a single object.
The main motivation for this feature was to make string literals
(e.g. \*(Cr"hello"\fP)
work as expected when passed to target functions like
.fX strcmp .
.SH "EXAMINING LINKED DATA STRUCTURES"
\fIUps\fP has several facilities that are useful for examining linked data
structures.
Firstly, you can expand structures or structure pointers.
By repeatedly expanding structures you can follow down a linked list or tree.
.LP
Often this adds too much information to the display, as you are probably not
interested in all the structure elements.
There is a more selective method of expanding lists and trees which lets
you easily see just the elements you want.
.LP
Suppose you have a structure declaration like this:
.Vs
struct linkst {
	struct linkst *prev, *next;
	int key;
};
.Ve
.LP
Suppose also that you have a variable
.fX linkptr
displayed which is a pointer to this structure.
.LP
If you type in a `.' followed by the name of element, such as
.fX prev ,
that element of any selected structures or structure pointers will be
added to the display and selected when you hit ESC.
.LP
Assume
.fX linkptr
in the example above is displayed and selected.
Typing
.fX .next
followed by ESC will add the
.fX next
field of
.fX linkptr
to the display and select it, and deselect
.fX linkptr .
Typing ESC again will add the next element of the list.
Thus by repeatedly typing ESC you can easily walk down a linked list.
.LP
You can give many structure elements separated by spaces.
Thus the line
.Vs
\&.key .next
.Ve
.LP
would add both fields to the display.
In this way you can walk down a linked list with members of interest
displayed as well as the links.
.LP
One problem with this way of looking at lists is that the indentation
of structure elements tends to make the list wander off the right hand
side of the display area.
To avoid this you can say `@member' rather than `.member'.
The `@' character means do not indent \- this is the only difference
between it and `.'.
Thus to get a nicely laid out list in the example above you could
enter the line:
.Vs
\&.key @next
.Ve
.LP
and keep typing ESC to walk down the list.
.LP
One last wrinkle: if you add `#nnn' to the end of the typing line, where
`nnn' is a decimal number, the effect is as if you had pressed ESC that
number of times.
This is handy if you want to see all of a 500 element linked list without
having to type ESC 500 times.
.LP
In C interpreter code (described in the previous section) you can
scan through a linked list as if it were an array using the
(non-standard)
.fX ->[\fIcount\fP] ' `
\fRoperator.
This is a shorthand for applying the
.fX -> ' `
operator
.I count
times.
You can use the arrow keys (or ^N and ^P) as described in
.Sc "EXPRESSIONS IN THE DISPLAY AREA"
to bump the count parameter up or down and step through a linked list one
element at a time.
.LP
Thus in the example above, adding the following expression to the
display area:
.Vs
linkptr->[0]next
.Ve
would just show the value of
.fX linkptr
(the
.fX ->
operator is being applied zero times).
You can expand the structure and add and delete elements to get the
display set up as you like.
Then you can edit the 
.fX 0 ' `
to
.fX 1 ' `
to see the next element of the list, and so on.
.SH "ENVIRONMENT VARIABLES"
By default the target inherits the same set of environment variables as
.I ups .
You can change this using the
.Ob Environment
object in the display area.
Any changes to the target environment take effect the next time the
target is started.
.LP
Selecting the
.Ob Environment
object produces a menu with the commands
.Cm "Expand" ,
.Cm "Collapse" ,
.Cm "Add entry"
and
.Cm "Reset env" .
The
.Cm Expand
command adds an entry to the display area for each environment variable.
You edit an environment variable name or value by clicking on it in the
normal way with the middle mouse button.
.Cm Collapse
removes all the entries from the display area.
.LP
To add a new entry select
.Cm "Add entry"
from the environment menu and type in the `\fIname=value\fP' string.
.I Ups
will accept any string as an entry, but gives a warning for odd-looking
entries.
.LP
If you wish to abandon any changes you have made to the environment
select
.Cm "Reset env" .
This resets to the environment to the state it was in when
.I ups
was started.
.LP
If you select an individual environment entry you get a menu with
the options
.Cm Hide ,
.Cm Delete
and
.Cm "Append entry" .
The
.Cm Hide
command removes the entry from the display but not from the environment.
This is useful for clearing the display of uninteresting entries.
By contrast the
.Cm Delete
command removes the entry from the environment.
The
.Cm "Append entry"
command allows you to add a new environment variable just after the
one selected; this is useful if you need the environment set in a
particular order.
.LP
.SH "SIGNALS"
When the target gets a signal control returns to
.IR ups .
Depending on the signal and the way you have specified it should be handled,
the target is either stopped or restarted (possibly with a display refresh),
and the signal can either be passed on to the target or ignored.
.LP
Near the top of the main display area is a 
.Ob Signals
object.
Selecting this produces a menu with 
.Cm Expand
and 
.Cm Collapse
as options.
Expanding the signals object produces a list of all signals, with the
current way the signal is handled displayed for each signal.
Selecting a signal produces a menu which lets you change the way it
is handled.
.LP
You can control whether a given signal causes
.I ups
to stop the target,
refresh the display and continue the target or just continue the target
without refreshing the display.
You can also control whether the signal should be passed on to the target.
.LP
You can trim the signals display by selecting the ones you aren't
interested in and clicking on
.Cm Hide
in the signals menu.
This will remove those signals from the display area.
.LP
The
.Cm Next ' `
and
.Cm Step ' `
commands both step over functions called as a
result of a signal.
Breakpoints in signal handling functions work normally.
.SH "X AND SUNVIEW COMMAND LINE FLAGS"
Under SunView
.I ups
recognises the standard SunView tool flags.
These can occur anywhere on the command line.
.LP
Under X
.I ups
recognises most common X11 command line arguments.
The currently recognised flags are:
.TP
.B \-iconic
Start up as an icon rather than as a window.
.TP
.BI \-display " displayname"
Create a window on the named display rather than using the value
of the
.fX DISPLAY
environment variable.
.TP
.BI \-geometry " geometry"
Use the specified X geometry for the window.
.TP
.BI \-name " name"
Use
.I name
rather than the default
.fX ups
as the window and icon name.
This name is also used when fetching X defaults.
.TP
.BI \-fn " fontname"
Use X font
.I fontname
rather than the default.
.TP
.BI \-fg " colorspec"
Use
.I colorspec
(which should be a standard X11 color specification)
as the color of the foreground pixel.
.TP
.BI \-bg " colorspec"
Use
.I colorspec
as the color of the background pixel.
.TP
.B \-rv
Reverse the foreground and background pixel colors.
.LP
These options are available under X and SunView:
.TP
.B \-mono
Force monochrome mode even if when using a color display.
Use this flag to stop
.I ups
interfering with the colormap on pseudocolor displays (e.g. when
you are debugging a program with a colormap related problem).
The flag is also useful on some Sun displays under SunView where
using monochrome significantly increases the display speed.
.TP
.BI \-wn_record " filename"
Record mouse and keyboard events in file
.IR filename .
.TP
.BI \-wn_replay " filename"
Read mouse and keyboard input from file
.I filename
rather than the mouse and keyboard.
The file
.I filename
must have been created with the
.B \-wn_record
flag in a previous session.
.TP
.B \-wn_replay_warp
When replaying events with
.BR \-wn_replay ,
warp the mouse in the 
.I ups
window to reflect the recorded mouse movement events.
.SH "X RESOURCES"
.LP
.I Ups
recognises a number of X defaults.
By default it uses the last pathname component of the name you run
it with as the application name when looking up resources (i.e. if
you run it as `/usr/bin/ups' it will use `ups').
You change the name with the
.B \-name
flag described above.
If it fails to find a resource with the application name,
.I ups
does a lookup using `\*(CrUps\fP' (note the initial upper case letter).
A resource specified as `\*(CrUps.\fP\fIxxx\fP' will thus always be
noticed.
Finally
.I ups
looks in the resource file
.fX /usr/lib/X11/app-defaults/Ups
if a resource is not found anywhere else.
.LP
The current list of recognised resources is:
.TP
.B Font
The name of the normal font.
The default is `fixed'.
.TP
.B MenuFont
The font used for menu captions.
The default is to use the normal font.
.TP
.B SrcFont
The font used for text in the source window.
The default is to use the normal font.
.TP
.B EditFont
The font used for editable text in the source window.
The default is a bold version of the normal font (using the name
formed by replacing
.fX medium
with
.fX bold
in the font name).
If this substitution cannot be made, 
.I ups
tries
.fX -*-fixed-bold-r-normal--15-*-*-*-*-*-*-* .
If this font is unavailable,
.I ups
complains and uses the normal font.
.TP
.B Foreground
The color of the foreground pixel.
The default is whatever the 
.fX BlackPixel
macro returns for the display.
.TP
.B Background
The color of the background pixel.
The default is whatever the 
.fX WhitePixel
macro returns for the display.
.TP
.B ReverseVideo
If this is set (to anything) it has the same effect as the
.B -rv
flag.
.TP
.B Geometry
The size and (optionally) position of the
.I ups
window.
The default is to suggest to the window manager a window 580 pixels wide
by 550 pixels deep at a user-specified position.
Most window managers will of course let you sweep out a window of the
size you require.
.TP
.B EditlinesColor
The color used for editable text in the source window.
The default is yellow.
.TP
.B HighlightColor
The color used to highlight variables in the display area whose
values have changed since the last time the target stopped.
The default is yellow.
.TP
.B MouseholeWidth
The width of the mousehole in pixels.
.TP
.B PermanentMenuWidth
The width of the `Quit' menu in pixels.
.TP
.B ScrollbarWidth
The width of all the scroll bars in pixels.
.TP
.B SrcwinNameWidth
The width in pixels of the box above the source window containing the current
source file name and line number.
.TP
.B SrcwinPercent
The percentage of the window height used for the source window (after
space used by the fixed size regions is subtracted).
The default is 50 (i.e. half).
.TP
.B DisplayAreaPercent
The percentage of the window height used for the display area (after
space used by the fixed size regions is subtracted).
The default is 50 (i.e. half).
If
.B DisplayAreaPercent
and
.B SrcwinPercent
are both set they need not add up to 100 \- the values actually
specify a proportion of the total.
Thus setting both to 20 (or any pair of identical values) results
in a 50-50 split.
.TP
.B OutwinPercent
The percentage of the window height used for the output window
if and when it is added.
The default is 50 (which actually means a third of the total \-
see the note about
.B SrcwinPercent
above.
.TP
.B WantTypedefs
If this is set to `no', then
.I ups
will not attempt to use typedefs in display area variable declarations.
See
.B "Use of typedefs"
in the
.Sc "CONTROLLING THE DISPLAY OF VARIABLES"
section.
.TP
.B TabWidth
The width in characters of a tab character (for use in the source
window).
The default is eight.
.TP
.B UseMono
If this is set to `yes' then
.I ups
will always use mono even on colour displays.
This resource has the same effect as the
.B \-mono
flag (see above).
.SH "DEBUGGING FORTRAN CODE"
.I Ups
has support for debugging code written in Fortran 77 and Fortran 90.
The Fortran 77 support works with most compilers.
The Fortran 90 support has only been tested with the
.I epcf90
compiler running under SunOS 4.1.3.
.LP
The most visible difference with Fortran code is that variable types
are displayed using Fortran rather than C syntax.
Thus a typical stack display might look like:
.Vs
.B Functions
\*(Cr   MAIN
     double precision acctim                   0.0
     integer*4 count                           0
     double precision table(168,10) [1,1]      0.0
     logical dotrace                           .false.
.Ve
.ft R
Variable names will usually be shown in lower case, even if you have
used upper case in the source code.
This transformation is done by the compiler, and
.I ups
has no control over it.
.LP
Notice that there are two sets of subscripts shown for the array
.fX table .
The first set (in round brackets) show the actual size of the array.
The second set shows the subscript of the element that is being
displayed.
These can be edited to show different elements in the same way as with C arrays.
.LP
If the program has any common blocks, these are shown under a
.Ob "Common blocks"
object in the display area.
This can be expanded to show the list of common blocks, and individual
common blocks can be expanded in turn to show the variables.
If a given common block is declared differently in different
functions, each different declaration gets its own entry in the list.
Thus you might see:
.Vs
.B Common blocks
\*(Cr  common /supp_defs/ (as defined in MAIN)
  common /supp_defs/ (as defined in foo)
.Ve
.LP
Fortran 90 user defined types are treated in much the same way as C
structures.
You can recursively expand them to follow linked lists and such.
.LP
If you are using Fortran 90 modules,
.I ups
adds a
.Ob Modules
object to the display area.
You can expand this to show a list of modules.
Module names can be expanded in their turn to show a list of functions
and subroutines defined within the module.
In the current version module variables are not displayed under the
appropriate module heading; instead they appear under a common block
entry.
This will be fixed in a future release.
.LP
There is currently no support for interpreted code under Fortran.
Nor can you add Fortran expressions to the display area.
This will be fixed if and when someone writes a Fortran interpreter
for
.I ups .
.SH "SAVING STATE"
When you quit
.IR ups ,
it normally forgets things like breakpoint locations and the way your
variables are displayed.
This can be a nuisance, especially if you have added interpreted code,
or typed long expressions into the display area.
To preserve these settings,
.I ups
will optionally save state information when you quit it, and reload
this information when you start it again.
This section describes how this state is saved and restored.
.LP
If the directory
.fX ups-state
exists in the current directory, ups
will use it to store state information between sessions.
This includes breakpoint locations
(and the interpreted code, if any), and the state of the
variables display.
.LP
The saved state is used in several ways:
.IP \(bu
After starting ups, you can select
.Cm Restore
from the
.Ob Breakpoints
menu to put breakpoints back as they were
from the previous session. 
Ups tries to put
breakpoints back in the right places, but it can be
defeated by major changes to the source code.
.IP \(bu
The default for the
.Cm Expand
option for stack trace and source file entries is
.Cm "Like before" .
This adds variables as they were in the last time you looked at them.
If the
.fX ups-state
directory exists, the state of the variables display is remembered
across different
.I ups
sessions.
.IP \(bu
When you add a variable the display format (hex, octal
etc) is taken from the way it was last time you
displayed the variable.
.LP
State is saved to the file
.fX ups-state/\fIxxx\fP.state ,
.ft R
where
.I xxx
is the last component of the path of the file you are debugging.  You
can also create the file
.fX ups-state/\fIxxx\fP.config
.ft R
(perhaps by copying
.fX ups-state/\fIxxx\fP.state ).
.ft R
The
.fX .config
file is read at startup by ups, but not written.
Also, breakpoints in the
.fX .config
file are automatically restored on startup.
.LP
In future releases you will be able to use the
.fX .config
file to specify how signals are handled, add environment variable
settings, etc.  Currently the only directive (other than
things specifying breakpoints and saved variable state) is
.fX auto-start
which takes a single argument
.fX yes
or
.fX no .
The line:
.Vs
    auto-start yes
.Ve
in the
.fX \fIxxx\fP.config
.ft R
file means start the target running as
soon as 
.I ups
has started up.
.LP
Ups also looks for saved state in the file
.fX $HOME/.upsrc
and
.fX .upsrc
(in the current directory).
Thus the full set of files is:
.Vs
$HOME/.upsrc
\&.upsrc
ups-state/\fIxxx\fP.config
ups-state/\fIxxx\fP.state
.Ve
.ft R
Files later in the sequence can override earlier settings.
.SH "LOADING AND SAVING BREAKPOINTS"
You can explicitly load and save breakpoints to files.  To save
breakpoints, select one or more in the display area, then
select `save' from the menu.  You will be prompted for a file
name.  If the file already exists you will be asked whether
you want to cancel the save, overwrite the file or append to
it.
.LP
Saved breakpoints can be reloaded by selecting
.Cm Load
from the
.Ob Breakpoints
header menu.
.SH "SEE ALSO"
cc(1), f77(1), ld(1), dbx(1)
.SH BUGS
.LP
On the SPARC you can't step or next through the return statement
of a function returning a struct or union (functions returning
.I pointers
to structs or unions work fine).
This is due to the peculiar and undocumented protocol that the
SPARC uses for returning structs and unions by value.
.LP
On the SPARC you get surprising behaviour if you use in interpreted
code a struct or union that is a formal parameter.
Your interpreted code must be written as if the variable is a
.I pointer
to a struct rather than a struct.
This is again due to the SPARC structure passing protocol.
.LP
The SPARC C compiler emits an inline loop to implement structure
assignmemt for large structs.
Because of the way next and step are implemented in
.I ups
you have to hit
.Cm Next
or
.Cm Step
several times to step over a line containing such a struct assignment.
Workaround: use
.Cm "Execute to here"
to get to the next line.
.LP
If you change a binary while you are debugging it
.I ups
will get very upset (read: will probably core dump with a fatal
error message).
This is unsatisfactory and will be fixed in a future release.
.LP
The
.Cm Step
command does not step into routines from SunOS 4.X shared libraries - it
steps over them as if 
.Cm Next
had been selected.
Breakpoints in shared library routines do work, however.
Core files dumped from dynamic executables are incomplete which means
that you can only examine the non shared parts of the binary.
.LP
The
.Cm Stop
button in the target menu doesn't work if you are hitting lots of
fragments of interpreted code that don't stop the target.
.SH ACKNOWLEDGEMENTS
.LP
The work to support Solaris 2 was made possible by the generous
support of the following people (in alphabetical order):
.RS
.nf
.sp 0.5
.ta 1.6i
Ian Edwards	Panorama Software Corporation
Paul Friberg	Incorporated Research Institutions for Seismology
Robert L. Prehn	AT&T Bell Labs
Daniel Quinlan	University of Colorado
Ricardo Telichevesky	Cadence Design Systems, Inc.
Frank Vernon	UC San Diego
.RE
.fi
.sp 0.5
Special thanks to Dan Quinlan for all the work he put into
organising the project.
.LP
The regular expression matching algorithm was written by Ozan S. Yigit
of the Department of Computer Science, York University.
.SH AUTHORS
Mark Russell, University of Kent.
Original version for the ICL Perq and many of the important ideas
by John Bovey, University of Kent.
