.ad l
.nh
.TH display 1 "1 Feb 1995" "ImageMagick"
.SH NAME
display - display an image on any workstation running X
.SH SYNOPSIS
.B "display" [ \fIoptions\fP ...] \fIfile\fP
[ [ \fIoptions\fP ...] \fIfile\fP ...]
.SH DESCRIPTION
\fBDisplay\fP is a machine architecture independent image processing
and display program.  It can display an image on any workstation
screen running an X server.  \fBDisplay\fP can read and write many of
the more popular image formats (e.g. JPEG, TIFF, PNM, Photo CD, etc.).
With \fBdisplay\fP, you can perform these functions on an image:
.PP
    o load an image from a file
    o display the next image
    o display the former image
    o display a sequence of images as a slide show
    o write the image to a file
    o print the image to a Postscript printer
    o delete the image file
    o create a Visual Image Directory
    o select the image to display by its thumbnail rather than name
    o copy a region of the image
    o paste a region to the image
    o undo last image transformation
    o half the image size
    o double the image size
    o resize the image
    o restore the image to its original size
    o refresh the image
    o crop the image
    o cut the image
    o flop image in the horizontal direction
    o flip image in the vertical direction
    o rotate the image 90 degrees clockwise
    o rotate the image 90 degrees counter-clockwise
    o rotate the image
    o shear the image
    o trim the image edges
    o invert the colors of the image
    o vary the color brightness
    o vary the color saturation
    o vary the image hue
    o gamma correct the image
    o sharpen the image contrast
    o dull the image contrast
    o perform histogram equalization on the image
    o perform histogram normalization on the image
    o negate the image colors
    o convert the image to grayscale
    o set the maximum number of unique colors in the image
    o reduce the speckles within an image
    o eliminate peak noise from an image
    o detect edges within the image
    o emboss an image
    o oil paint an image
    o segment the image by color
    o annotate the image with text
    o draw on the image
    o edit an image pixel color
    o edit the image matte information
    o composite an image with another
    o add a border to the image
    o surround image with an ornamental border
    o add an image comment
    o apply image processing techniques to a region of interest
    o display information about the image
    o show a histogram of the image
    o display image to background of a window
    o set user preferences
    o display information about this program
    o discard all images and exit program
    o change the level of magnification
    o display images specified by a World Wide Web (WWW) uniform resource locator (URL)
.SH EXAMPLES
To scale an image of a cockatoo to exactly 640 pixels in width and 480
pixels in height and position the window at location (200,200), use:
.PP
.B
     display -geometry 640x480\+200\+200! cockatoo.miff
.PP
To display an image of a cockatoo without a border centered on a
backdrop, use:
.PP
.B
     display +borderwidth -backdrop cockatoo.miff
.PP
To tile a slate texture onto the root window, use:
.PP
.B
     display -size 1280x1024 -window root slate.png
.PP
To display a visual image directory of all your JPEG images, use:
.PP
.B
     display 'vid:*.jpg'
.PP
To display a MAP image that is 640 pixels in width and 480
pixels in height with 256 colors, use:
.PP
.B
     display -size 640x480\+256 cockatoo.map
.PP
To display an image of a cockatoo specified with a World Wide Web (WWW)
uniform resource locator (URL), use
.PP
.B
     display ftp://wizards.dupont.com/images/cockatoo.jpg
.SH OPTIONS
.B "-backdrop"
display the image centered on a backdrop.

This backdrop covers the entire workstation screen and is useful for
hiding other X window activity while viewing the image.   The color of
the backdrop is specified as the background color.  Refer to \fBX
RESOURCES\fP for details.
.TP
.B "-border \fI<width>x<height>\fP"
surround the image with a border of color.  See \fBX(1)\fP for details
about the geometry specification.

The color of the border is obtained from the X server and is defined as
\fBbordercolor\fP (class \fBborderColor\fP).  See \fBX(1)\fP for details.
.TP
.B "-colormap \fItype\fP"
the type of colormap: \fBShared\fP or \fBPrivate\fP.

This option only applies when the default X server visual is
\fIPseudoColor\fP or \fIGrayScale\fP.  Refer to \fB-visual\fP for more
details.  By default, a shared colormap is allocated.  The image shares
colors with other X clients.  Some image colors could be approximated,
therefore your image may look very different than intended.  Choose
\fBPrivate\fP and the image colors appear exactly as they are
defined.  However, other clients may go \fItechnicolor\fP when the image
colormap is installed.
.TP
.B "-colors \fIvalue\fP"
preferred number of colors in the image.

The actual number of colors in the image may be less than your request,
but never more.  Note, this is a color reduction option.  Images with
less unique colors than specified with this option will remain unchanged.
Refer to \fBquantize(9)\fP for more details.

Note, options \fB-dither\fP, \fB-colorspace\fP, and \fB-treedepth\fP affect
the color reduction algorithm.
.TP
.B "-colorspace \fIvalue\fP"
the type of colorspace: \fBGRAY\fP, \fBOHTA\fP, \fBRGB\fP,
\fBTransparent\fP, \fBXYZ\fP, \fBYCbCr\fP, \fBYIQ\fP, \fBYPbPr\fP, or
\fBYUV\fP.

Color reduction, by default, takes place in the RGB color space.
Empirical evidence suggests that distances in color spaces such as YUV
or YIQ correspond to perceptual color differences more closely
than do distances in RGB space.  These color spaces may give better
results when color reducing an image.  Refer to \fBquantize(9)\fP for
more details.

The \fBTransparent\fP color space behaves uniquely in that it perserves
the matte channel of the image if it exists.

The \fB-colors\fP or \fB-monochrome\fP option is required for this option
to take effect.
.TP
.B "-comment \fIstring\fP"
annotate an image with a comment.

By default, each image is commented with its file name.  Use this
option to assign a specific comment to the image.  Optionally you can
include the image filename, type, width, height, or scene number by
embedding special format characters.  Embed \fB%f\fP for filename,
\fB%m\fP for magick, \fB%w\fP for width, \fB%h\fP for height, \fB%s\fP
for scene number, \fB%b\fP for file size in kilobytes, or \fB\\n\fP for
newline.  For example,
.PP
.B
     -comment "%m:%f %wx%h"
.PP
produces an image comment of \fBMIFF:bird.miff 512x480\fP for an image
titled \fBbird.miff\fP and whose width is 512 and height is 480.

If the first character of \fIstring\fP is \fB@\fP, the image comment is read
from a file titled by the remaining characters in the string.
.TP
.B "-compress \fItype\fP"
the type of image compression: \fIZip\fP or \fIRunlengthEncoded\fP.

Use this option with \fB-write\fP to specify the the type of image
compression.  See \fBmiff(5)\fP for details.

Specify \fB\+compress\fP to store the binary image in an uncompressed format.
The default is the compression type of the specified image file.
.TP
.B "-contrast"
enhance or reduce the image contrast.

This option enhances the intensity differences between the
lighter and darker elements of the image.  Use \fB-contrast\fP to
enhance the image or \fB+contrast\fP to reduce the image contrast.
.TP
.B "-crop \fI<width>{%}x<height>{%}{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the cropped image.  See \fBX(1)\fP for details
about the geometry specification.

To specify a percentage width or height instead, append \fB%\fP.  For example
to crop the image by ten percent on all sides of the image, use
\fB-crop 10%\fP.

Use cropping to apply image processing options to, or display, a
particular area of an image.  Use \fB-crop 0x0\fP to remove edges that are
the background color.   Omit the x and y offset
to generate one or more subimages of a uniform size.

The equivalent X resource for this option is \fBcropGeometry\fP
(class \fBCropGeometry\fP).  See \fBX RESOURCES\fP for details.
.TP
.B "-delay \fIseconds\fP"
display the next image after pausing.

This option is useful when viewing several images in sequence.  Each
image will display and wait the number of seconds specified before the
next image is displayed.  The default is to display the image
and wait until you choose to display the next image or terminate the
program.
.TP
.B "-density \fI<width>x<height>\fP
vertical and horizontal resolution in pixels of the image.

This option specifies an image density when decoding a Postscript or Portable
Document page.  The default is the same as the resolution of your X server
(see xdpyinfo(1)).
.TP
.B "-despeckle"
reduce the speckles within an image.
.TP
.B "-display \fIhost:display[.screen]\fP"
specifies the X server to contact; see \fBX(1)\fP.
.TP
.B "-dispose \fImethod\fP"
GIF disposal method.

Graphics Interchange Format (GIF) Specification 89a of July 31, 1990 for
details.
.TP
.B "-dither"
apply Floyd/Steinberg error diffusion to the image.

The basic strategy of dithering is to trade intensity resolution for
spatial resolution by averaging the intensities of several neighboring
pixels.  Images which suffer from severe contouring when reducing colors
can be improved with this option.

The \fB-colors\fP or \fB-monochrome\fP option is required
for this option to take effect.
.TP
.B "-edge \fIfactor\fP"
detect edges with an image.  Specify \fIfactor\fP as the percent enhancement
(0.0 - 99.9%).
.TP
.B "-enhance"
apply a digital filter to enhance a noisy image.
.TP
.B "-equalize"
perform histogram equalization to the image.
.TP
.B "-flip"
create a "mirror image" by reflecting the image scanlines in the vertical
direction.
.TP
.B "-flop"
create a "mirror image" by reflecting the image scanlines in the horizontal
direction.
.TP
.B "-frame \fI<width>x<height>+<outer bevel width>+<inner bevel width>\fP"
surround the image with an ornamental border.  See \fBX(1)\fP for details
about the geometry specification.

The color of the border is specified with the \fB-mattecolor\fP command line
option.
.TP
.B "-gamma \fIvalue\fP"
level of gamma correction.

The same color image displayed on two different workstations may look
different due to differences in the display monitor.  Use gamma
correction to adjust for this color difference.  Reasonable values
extend from 0.8 to 2.3.

You can apply separate gamma values to the red, green, and blue
channels of the image with a gamma value list delineated with commas
(i.e. 1.7,2.3,1.2).
.TP
.B "-geometry \fI<width>{%}x<height>{%}{\+-}<x offset>{\+-}<y offset>{!}{<}{>}\fP"
preferred size and location of the Image window.  See \fBX(1)\fP for details
about the geometry specification.  By default, the window size is the image
size and the location is chosen by you when it is mapped.

By default, the width and height are maximum values.  That is, the
image is expanded or contracted to fit the width and height value while
maintaining the aspect ratio of the image.  Append an exclamation point
to the geometry to force the image size to exactly the size you
specify.  For example, if you specify \fB640x480!\fP the image width is
set to 640 pixels and height to 480.  If only one factor is
specified, both the width and height assume the value.

To specify a percentage width or height instead, append \fB%\fP.  The
image size is multiplied by the width and height percentages to obtain
the final image dimensions.  To increase the size of an image, use a
value greater than 100 (e.g. 125%).  To decrease an image's size, use a
percentage less than 100.

Use \fB<\fP to change the dimensions of the image \fIonly\fP
if its size exceeds the geometry specification.  \fB>\fP resizes
the image \fIonly\fP if its dimensions is less than the geometry
specification.  For example, if you specify \fB640x480>\fP and the
image size is 512x512, the image size does not change.  However, if
the image is 1024x1024, it is resized to 640x480.

When displaying an image on an X server, \fI<x offset>\fP and
\fI<y offset>\fP is relative to the root window.

The equivalent X resource for this option is \fBgeometry\fP
(class \fBGeometry\fP).  See \fBX RESOURCES\fP for details.
.TP
.B "-interlace \fItype\fP"
the type of interlacing scheme: \fBNONE\fP, \fBLINE\fP, or \fBPLANE\fP.
The default is \fBPLANE\fP.

This option is used to specify the type of interlacing scheme for raw
image formats such as \fBRGB\fP or \fBYUV\fP.  \fBNONE\fP means do not
interlace (RGBRGBRGBRGBRGBRGB...), \fBLINE\fP uses scanline
interlacing (RRR...GGG...BBB...RRR...GGG...BBB...), and \fBPLANE\fP uses
plane interlacing (RRRRRR...GGGGGG...BBBBBB...).

Use \fBLINE\fP, or \fBPLANE\fP to create an interlaced GIF or progressive
JPEG image.
.TP
.B "-immutable"
displayed image cannot be modified",
.TP
.B "-label \fIname\fP"
assign a label to an image.

Use this option to assign a specific label to the image.  Optionally
you can include the image filename, type, width, height, or scene
number in the label by embedding special format characters.   Embed
\fB%f\fP for filename, \fB%m\fP for magick, \fB%w\fP for width,
\fB%h\fP for height, \fB%s\fP for scene number, \fB%b\fP for file size in
kilobytes, or \fB\\n\fP for newline.  For example,
.PP
.B
     -label "%m:%f %wx%h"
.PP
produces an image label of \fBMIFF:bird.miff 512x480\fP for an image
titled \fBbird.miff\fP and whose width is 512 and height is 480.

If the first character of \fIstring\fP is \fB@\fP, the image label is read
from a file titled by the remaining characters in the string.

When converting to Postscript, use this option to specify a header string
to print above the image.
.TP
.B "-map \fItype\fP"
display image using this Standard Colormap type.

Choose from these Standard Colormap types:
.PP
    best
    default
    gray
    red
    green
    blue
.PP
The X server must support the Standard Colormap you choose, otherwise an
error occurs.  Use \fBlist\fP as the type and \fBdisplay(1)\fP searches
the list of colormap types in top-to-bottom order until one is located. See
\fBxstdcmap(1)\fP for one way of creating Standard Colormaps.
.TP
.B "-matte"
store matte channel if the image has one.
.TP
.B "-modulate \fIvalue\fP"
vary the brightness, saturation, and hue of an image.

Specify the percent change in brightness, the color saturation, and the hue
separated by commas.  For example, to increase the color brightness
by 20% and decrease the color saturation by 10% and leave the hue
unchanged, use: \fB-modulate 20,-10\fP.
.TP
.B "-monochrome"
transform the image to black and white.
.TP
.B "-negate"
apply color inversion to image.

The red, green, and blue intensities of an image are negated.
.TP
.B "-noise"
reduce the noise in an image with a noise peak elimination filter.

The principal function of noise peak elimination filter is to smooth
the objects within an image without losing edge information and without
creating undesired structures.  The central idea of the algorithm is to
replace a pixel with its next neighbor in value within a 3 x 3 window,
if this pixel has been found to be noise.  A pixel is defined as noise
if and only if this pixel is a maximum or minimum within the 3 x 3 window.
.TP
.B "-normalize"
transform image to span the full range of color values.

This is a contrast enhancement technique.
.TP
.B "-page \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
size and location of the Postscript page.

Use this option to specify the dimensions of the Postscript page in
pixels per inch or a TEXT page in pixels.  The default for a Postscript page is
to center the image on a letter page 612 by 792 pixels. The
margins are 1/2" (i.e.  612x792+42+42).  Other common sizes are:
.PP
    Letter      612x 792
    Tabloid     792x1224
    Ledger     1224x 792
    Legal       612x1008
    Statement   396x 612
    Executive   540x 720
    A3          842x1190
    A4          595x 842
    A5          420x 595
    B4          729x1032
    B5          516x 729
    Folio       612x 936
    Quarto      610x 780
    10x14       720x1008
.PP
For convenience you can specify the page size by media (e.g. A4, Ledger, etc.).
.PP
To place a Postscript image with a given size on a given location on a
page, use -page +HOFFSET+VOFFSET -geometry WIDTHxHEIGHT (fill in
numbers). Note: this is only for generating Postscript, not Encapsulated
Postscript.
.PP
To position a GIF image, use -page +LEFT+TOP (e.g. -page +100+200).
.PP
The default page dimensions for a TEXT image is 612x792.
.TP
.B "-quality \fIvalue\fP"
JPEG quality setting.

Quality is 0 (worst) to 100 (best). The default is 75.
.TP
.B "-raise \fI<width>x<height>\fP"
lighten or darken image edges to create a 3-D effect.    See \fBX(1)\fP for
details about the geometry specification.
 
Use \fB-raise\fP to create a raised effect, otherwise use \fB+raise\fP.
.TP
.B "-roll \fI{\+-}<x offset>{\+-}<y offset>\fP"
roll an image vertically or horizontally.  See \fBX(1)\fP for details
about the geometry specification.

A negative \fIx offset\fP rolls the image left-to-right.  A negative
\fIy offset\fP rolls the image top-to-bottom.
.TP
.B "-rotate \fIdegrees\fP"
apply Paeth image rotation to the image.

Empty triangles left over from rotating the image are filled with
the color defined as \fBbordercolor\fP (class \fBborderColor\fP).
See \fBX(1)\fP for details.
.TP
.B "-sample \fIgeometry\fP"
scale image with pixel sampling.  See \fB-geometry\fP for details
about the geometry specification.
.TP
.B "-scene \fIvalue\fP"
image scene number.

Use this option to specify an image sequence with a single filename.  See
the discussion of \fIfile\fP below for details.
.TP
.B "-segment \fIvalue\fP"
eliminate clusters that are insignificant.

The number of pixels in each cluster must exceed the
the cluster threshold to be considered valid.

See \fBIMAGE SEGMENTATION\fB for details.
.TP
.B "-sharpen \fIfactor\fP"
sharpen an image.  Specify \fIfactor\fP as the percent enhancement
(0.0 - 99.9%).
.TP
.B "-shear \fI<x degrees>x<y degrees>\fP"
shear the image along the X or Y axis by a positive or negative shear angle.

Shearing slides one edge of an image along the X or Y axis, creating a
parallelogram.  An X direction shear slides an edge along the X axis,
while a Y direction shear slides an edge along the Y axis.  The amount
of the shear is controlled by a shear angle.  For X direction shears,
\fIx degrees>\fP is measured relative to the Y axis, and similarly, for
Y direction shears \fIy degrees\fP is measured relative to the X axis.

Empty triangles left over from shearing the image are filled with
the color defined as \fBbordercolor\fP (class \fBborderColor\fP).
See \fBX(1)\fP for details.
.TP
.B "-size \fI<width>{%}x<height>{%}+<offset>\fP"
width and height of the image.

Use this option to specify the width and height of raw images whose
dimensions are unknown such as \fBGRAY\fP, \fBRGB\fP, or \fBCMYK\fP.
In addition to width and height, use \fB-size\fP to skip any header
information in the image or tell the number of colors in a \fBMAP\fP
image file, (e.g. -size 640x512+256).

For Photo CD images, choose from these sizes:
.PP
     192x128
     384x256
     768x512
    1536x1024
    3072x2048
  
Finally, use this option to choose a particular resolution layer of a JBIG
image (e.g. -size 1024x768).
.TP
.B "-texture \fIfilename\fP"
name of texture to tile onto the image background.
.TP
.B "-treedepth \fIvalue\fP"
Normally, this integer value is zero or one.  A zero or one tells
\fBdisplay\fP to choose a optimal tree depth for the color reduction
algorithm.

An optimal depth generally allows the best representation of the source
image with the fastest computational speed and the least amount of
memory.  However, the default depth is inappropriate for some images.
To assure the best representation, try values between 2 and 8 for this
parameter.  Refer to \fBquantize(9)\fP for more details.

The \fB-colors\fP or \fB-monochrome\fP option is required
for this option to take effect.
.TP
.B "-update \fIseconds\fP"
detect when image file is modified and redisplay.

Suppose that while you are displaying an image the file that is
currently displayed is over-written.  \fBdisplay\fP will automatically
detect that the input file has been changed and update the displayed
image accordingly.
.TP
.B -verbose
print detailed information about the image.

This information is printed: image scene number;  image name;  image
size; the image class (\fIDirectClass\fP or \fIPseudoClass\fP);  the total
number of unique colors;  and the number of seconds to read and
transform the image.  Refer to \fBmiff(5)\fP for a description of
the image class.

If \fB-colors\fP is also specified, the total unique colors in the image
and color reduction error values are printed.  Refer to \fBquantize(9)\fP
for a description of these values.
.TP
.B "-visual \fItype\fP"
display image using this visual type.

Choose from these visual classes:
.PP
    StaticGray
    GrayScale
    StaticColor
    PseudoColor
    TrueColor
    DirectColor
    default
    \fIvisual id\fP
.PP
The X server must support the visual you choose, otherwise an error occurs.
If a visual is not specified, the visual class that can display the most
simultaneous colors on the default X server screen is chosen.
.TP
.B "-window \fIid\fP"
set the background pixmap of this window to the image.

\fIid\fP can be a window id or name.  Specify \fBroot\fP to select X's root
window as the target window.

By default the image is tiled onto the background of the target
window.   If \fB-backdrop\fP or \fB-geometry\fP are specified, the
image is surrounded by the background color.  Refer to \fBX
RESOURCES\fP for details.

The image will not display on the root window if the image has more
unique colors than the target window colormap allows.  Use
\fB-colors\fP to reduce the number of colors.
.B "-window_group \fIid\fP"
exit program when this window id is destroyed.

\fIid\fP can be a window id or name.
.TP
.B "-write \fIfilename\fP"
write image to a file.

If \fIfile\fP already exists, you will be prompted as to whether
it should be overwritten.

By default, the image is written in the format that it was read in as.
To specify a particular image format, prefix \fIfile\fP with the image
type and a colon (i.e. ps:image) or specify the image type as the
filename suffix (i.e. image.ps).  See \fBconvert(1)\fP for a list of
valid image formats.  Specify \fIfile\fP as \fI-\fP for standard
output.  If \fIfile\fP has the extension \fB.Z\fP or \fB.gz\fP, the
file size is compressed using with \fBcompress\fP or \fBgzip\fP
respectively.  Precede the image file name \fI|\fP to pipe to a system
command. If \fIfile\fP already exists, you will be prompted as to
whether it should be overwritten.

Use \fB-compress\fP to specify the type of image compression.

The equivalent X resource for this option is \fBwriteFilename\fP
(class \fBWriteFilename\fP).  See \fBX RESOURCES\fP for details.
.PP
In addition to those listed above, you can specify these standard X
resources as command line options:  \fB-background\fP,
\fB-bordercolor\fP, \fB-borderwidth\fP, \fB-font\fP, \fB-foreground\fP,
\fB-iconGeometry\fP, \fB-iconic\fP, \fB-mattecolor\fP, \fB-name\fP,
or \fB-title\fP.  See \fBX RESOURCES\fP for details.
.PP
Options are processed in command line order.
Any option you specify on the command line remains in effect until it is
explicitly changed by specifying the option again with a different effect.
For example to display two images, the first with 32 colors, and the
second with only 16 colors, use:
.PP
.B
     display -colors 32 cockatoo.miff -colors 16 macaw.miff
.PP
Change \fI-\fP to \fI\+\fP in any option above to reverse its effect.
For example, specify \fB\+matte\fP to store the image without its matte
channel.
.PP
By default, the image format is determined by its magic number. To
specify a particular image format, precede the filename with an image
format name and a colon (i.e. ps:image) or specify the image type as
the filename suffix (i.e. image.ps).  See \fBconvert(1)\fP for a list
of valid image formats.
.PP
When you specify \fBX\fP as your image type, the filename has special
meaning.  It specifies an X window by id, name, or \fBroot\fP.  If no
filename is specified, the window is selected by clicking the mouse in
the desired window.
.PP
Specify \fIfile\fP as \fI-\fP for standard input.  If \fIfile\fP has
the extension \fB.Z\fP or \fB.gz\fP, the file is uncompressed with
\fBuncompress\fP or \fBgunzip\fP respectively.  Precede the image file
name \fI|\fP to pipe from a system command.
.PP
Use an optional index enclosed in brackets after a file name to specify
a desired subimage of a multi-resolution image format like Photo CD
(e.g. img0001.pcd[4]) or a range for MPEG images (e.g. video.mpg[50-75]).
A subimage specification can be disjoint (e.g. image.tiff[2,4,7]).
For raw images, specify a subimage with a geometry (e.g.  -size 640x512
image.rgb[320x256+50+50]).
.PP
Single images are read with the filename you specify.  Alternatively,
you can display an image sequence with a single filename.  Define the
range of the image sequence with \fI-scene\fP.  Each image in the
range is read with the filename followed by a period (\fB.\fP)
and the scene number.  You can change this behavior by embedding a
\fBprintf\fP format specification in the file name.  For example,
.PP
.B
        -scene 0-9 image%02d.miff
.PP
displays files image00.miff, image01.miff, through image09.miff.
.SH BUTTONS
The effects of each button press is described below.  Three buttons are
required.  If you have a two button mouse, button 1 and 3 are returned.
Press ALT and button 3 to simulate button 2.
.TP
.B "1"
Press this button to map or unmap the Command widget.  See
the next section for more information about the Command widget.
.TP
.B "2"
Press and drag to define a region of the image to magnify.
.TP
.B "3"
Press and drag to choose from a select set of \fBdisplay(1)\fP commands.
This button behaves differently if the image being displayed is a visual
image directory.  Here, choose a particular tile of the directory and press
this button and drag to select a command from a pop-up menu.  Choose from
these menu items:
.PP
    Load
    Next
    Former
    Delete
    Update
.PP
If you choose \fBLoad\fP, the image represented by the tile is
displayed.  To return to the visual image directory, choose \fBNext\fP from
the Command widget (refer to COMMAND WIDGET).  \fBNext\fP and \fBFormer\fP
moves to the next or former image respectively.  Choose \fBDelete\fP
to delete a particular image tile.  Finally, choose \fBUpdate\fP to synchronize
all the image tiles with their respective images.  See \fBmontage(1)\fP and
\fBmiff(5)\fP for more details.
.SH COMMAND WIDGET
The Command widget lists a number of sub-menus and commands.  They are
.PP
    File
      Load...
      Next
      Former
      Select...
      Save...
      Print...
      Delete...
      Canvas...
      Visual Directory...
      Quit
    Edit
      Undo
      Redo
      Cut
      Copy
      Paste
    View
      Half Size
      Original Size
      Double Size
      Resize...
      Apply
      Refresh
      Restore
    Transform
      Crop
      Chop
      Flop
      Flip
      Rotate Right
      Rotate Left
      Rotate...
      Shear...
      Trim Edges
    Enhance
      Hue...
      Saturation...
      Brightness...
      Gamma...
      Spiff...
      Dull
      Equalize
      Normalize
      Negate
      Grayscale
      Quantize...
    Effects
      Despeckle
      Peak Noise
      Sharpen...
      Blur...
      Edge Detect...
      Emboss...
      Spread...
      Swirl...
      Implode...
      Solarize...
      Oil Painting...
      Raise...
      Segment...
    Image Edit
      Annotate...
      Draw...
      Color...
      Matte...
      Composite...
      Add Border...
      Add Frame...
      Comment...
      Launch...
      Region of Interest...
    Miscellany
      Image Info
      Zoom Image
      Show Histogram
      Background...
      Slide Show
      Preferences...
    Help
      Help
      Browse Documentation
      About Display
.PP
Menu items with a indented triangle have a sub-menu.  They are
represented above as the indented items.  To access a sub-menu item,
move the pointer to the appropriate menu and press a button and drag.
When you find the desired sub-menu item, release the button and the
command is executed.  Move the pointer away from the sub-menu if you
decide not to execute a particular command.
.SH KEYBOARD ACCELERATORS
Accelerators are one or two key presses that effect a particular command.
The keyboard accelerators that \fBdisplay(1)\fP understands is:
.TP
.B "l"
Press to load an image from a file.

Refer to \fBIMAGE LOADING\fP for more details.
.TP
.B "n"
Press to display the next image.

If the image is a multi-paged document such as a Postscript document, you
can skip ahead several pages by preceeding this command with a number.  
For example to display the fourth page beyond the current page,
press \fB4n\fP.
.TP
.B "f"
Press to display the former image.

If the image is a multi-paged document such as a Postscript document, you
can skip behind several pages by preceeding this command with a number.  
For example to display the fourth page preceeding the current page,
press \fB4n\fP.
.TP
.B "F2"
Press to select an image from the command line.
.TP
.B "s"
Press to save the image to a file.
.TP
.B "p"
Press to print the image to a Postscript printer.
.TP
.B "delete"
Press to delete an image file.
.TP
.B "C"
Press to create a blank canvas.
.TP
.B "V"
Press to create a Visual Image Directory.

Refer to \fBVISUAL IMAGE DIRECTORY\fP for more details.
.TP
.B "q"
Press to discard all images and exit program.
.TP
.B "u"
Press to undo last image transformation.
.TP
.B "F3"
Press to cut a region of the image.

Refer to \fBIMAGE CUTTING\fP for more details.
.TP
.B "F4"
Press to copy a region of the image.

Refer to \fBIMAGE COPYING\fP for more details.
.TP
.B "F5"
Press to paste a region to the image.

Refer to \fBIMAGE PASTING\fP for more details.
.TP
.B "<"
Press to half the image size.
.TP
.B "o"
Press to return to the original image size.
.TP
.B ">"
Press to double the image size.
.TP
.B "%"
Press to resize the image to a width and height you specify.
.TP
.B "A"
Press to make any image transformations permanent.

By default, any image size transformations are applied to the
original image to create the image displayed on the X server.  However, the
transformations are not permanent (i.e. the original image does not change
size only the X image does).  For example, if you press \fB>\fP the X image
will appear to double in size, but the original image will in fact remain the
same size.  To force the original image to double in size, press \fB>\fP
followed by \fBA\fP.
.TP
.B "@"
Press to refresh the Image window.
.TP
.B "r"
Press to restore the image to its original size.
.TP
.B "["
Press to crop the image.

Refer to \fBIMAGE CROPPING\fP for more details.
.TP
.B "]"
Press to chop the image.

Refer to \fBIMAGE CHOPPING\fP for more details.
.TP
.B "|"
Press to flop image in the horizontal direction.
.TP
.B "-"
Press to flip image in the vertical direction.
.TP
.B "/"
Press to rotate the image 90 degrees clockwise.
.TP
.B \(bs
Press to rotate the image 90 degrees counter-clockwise.
.TP
.B "*"
Press to rotate the image the number of degrees you specify.

Refer to \fBIMAGE ROTATION\fP for more details.
.TP
.B "F6"
Press to shear the image the number of degrees you specify.
.TP
.B "t"
Press to trim the image edges.
.TP
.B "F7"
Press to vary the color hue.
.TP
.B "F8"
Press to vary the color saturation.
.TP
.B "F9"
Press to vary the image brightness.
.TP
.B "g"
Press to gamma correct the image.
.TP
.B "F10"
Press to spiff up the image contrast.
.TP
.B "F11"
Press to dull the image contrast.
.TP
.B "="
Press to perform histogram equalization on the image.
.TP
.B "N"
Press to perform histogram normalization on the image.
.TP
.B "~"
Press to negate the colors of the image.
.TP
.B "G"
Press to convert the image colors to gray.
.TP
.B "#"
Press to set the maximum number of unique colors in the image.
.TP
.B "D"
Press to reduce the speckles in an image.
.TP
.B "P"
Press to eliminate peak noise from an image.
.TP
.B "S"
Press to sharpen an image.
.TP
.B "B"
Press to blur image an image.
.TP
.B "E"
Press to detect edges within an image.
.TP
.B "M"
Press to emboss an image.
.TP
.B "F13"
Press to displace pixels by a random amount.
.TP
.B "F14"
Press to swirl image pixels about the center.
.TP
.B "F15"
Press to implode the image pixels about the center.
.TP
.B "F16"
Press to negate all pixels above the threshold level.
.TP
.B "O"
Press to oil paint an image.
.TP
.B "^"
Press to lighten or darken image edges to create a 3-D effect.
.TP
.B "Z"
Press to segment the image by color.
.TP
.B "R"
Press to apply an image processing technique to a region of interest.

Refer to \fBREGION OF INTEREST\fP for more details.
.TP
.B "a"
Press to annotate the image with text.

Refer to \fBIMAGE ANNOTATION\fP for more details.
.TP
.B "d"
Press to draw a line on the image.

Refer to \fBIMAGE DRAWING\fP for more details.
.TP
.B "C"
Press to edit an image pixel color.

Refer to \fBCOLOR EDITING\fP for more details.
.TP
.B "m"
Press to edit the image matte information.

Refer to \fBMATTE EDITING\fP for more details.
.TP
.B "x"
Press to composite the image with another.

Refer to \fBIMAGE COMPOSITING\fP for more details.
.TP
.B "a"
Press to add a border to the image.
.TP
.B "F"
Press to add a ornamental frame to the image.
.TP
.B "!"
Press to add an image comment.
.TP
.B "L"
Press to launch a program to edit the image.
.TP
.B "i"
Press to display information about the image.
.TP
.B "z"
Press to map the zoom image window.
.TP
.B "H"
Press to show a histogram of the image.
.TP
.B "}"
Press to display image to background of a window.
.TP
.B ","
Press to display the next image after pausing.
.TP
.B "F12"
Press to set user preferences.

Refer to \fBUSER PREFERENCES\fP for more details.
.TP
.B "h"
Press to display helpful information about \fBdisplay(1)\fP.

Function keys \fIHELP\fP or \fIF1\fP are synonymous with the \fIh\fP key.
.TP
.B "Find"
Press to browse documentation about \fBImageMagick\fP.
.TP
.B "v"
Press to display the version number of \fBdisplay(1)\fP.
.TP
.B "1-9"
Press to change the level of magnification.
.PP
Use the arrow keys to move the image one pixel up, down, left, or right within
the magnify window.  Be sure to first map the magnify window by pressing
button 2.

Press \fBALT\fP and one of the arrow keys to trim off one pixel from
any side of the image.
.SH "X RESOURCES"
\fBDisplay\fP options can appear on the command line or in your X
resource file.  Options on the command line supersede values specified
in your X resource file.  See \fBX(1)\fP for more information on X
resources.

Most \fBdisplay\fP options have a corresponding X resource.  In addition,
\fBdisplay\fP uses the following X resources:
.TP
.B background (\fIclass\fP Background)
Specifies the preferred color to use for the Image window background.  The
default is #ccc.
.TP
.B borderColor (\fIclass\fP BorderColor)
Specifies the preferred color to use for the Image window border.  The
default is black.
.TP
.B borderWidth (\fIclass\fP BorderWidth)
Specifies the width in pixels of the Image window border.  The default is 2.
.TP
.B browseCommand (\fIclass\fP browseCommand)
Specifies the name of the preferred browser when displaying ImageMagick
documentation.  The default is \fBnetscape %s\fP.
.TP
.B confirmExit (\fIclass\fP ConfirmExit)
\fBDisplay\fP pops up a dialog box to confirm exiting the
program when exiting the program.  Set this resource to \fIFalse\fP
to exit without a confirmation.
.TP
.B displayGamma (\fIclass\fP DisplayGamma)
Specifies the gamma of your X server.

You can apply separate gamma values to the red, green, and blue
channels of the image with a gamma value list delineated with commas
(i.e. 1.7,2.3,1.2).

The default is \fI2.2\fP.
.TP
.B displayWarnings (\fIclass\fP DisplayWarnings)
\fBDisplay\fP pops up a dialog box whenever a warning message
occurs.  Set this resource to \fIFalse\fP to ignore warning messages.
.TP
.B editorCommand (\fIclass\fP editorCommand)
Specifies the name of the preferred editor when editing image comments.
The default is \fIxterm -title "Edit Image Comment" -e vi %s\fP.
.TP
.B font (\fIclass\fP FontList)
Specifies the name of the preferred font to use in normal formatted
text.  The default is 14 point \fIHelvetica\fP.
.TP
.B font[1-9] (\fIclass\fP Font[1-9])
Specifies the name of the preferred font to use when annotating the
Image window with text.  The default fonts are \fIfixed\fP,
\fIvariable\fP, \fI5x8\fP, \fI6x10\fP, \fI7x13bold\fP, \fI8x13bold\fP,
\fI9x15bold\fP, \fI10x20\fP, and \fI12x24\fP.  Refer to \fBIMAGE
ANNOTATION\fP for more details.
.TP
.B foreground (\fIclass\fP Foreground)
Specifies the preferred color to use for text within the Image window.  The
default is black.
.TP
.B gammaCorrect (\fIclass\fP gammaCorrect)
This resource, if true, will lighten or darken an image of known gamma to match
the gamma of the display (see resource \fIdisplayGamma\fP).
The default is True.
.TP
.B geometry (\fIclass\fP Geometry)
Specifies the preferred size and position of the image window.
It is not necessarily obeyed by all window managers.
.TP
.B iconGeometry (\fIclass\fP IconGeometry)
Specifies the preferred size and position of the application when
iconified.  It is not necessarily obeyed by all window managers.
.TP
.B iconic (\fIclass\fP Iconic)
This resource indicates that you would prefer that the application's
windows initially not be visible as if the windows had be immediately
iconified by you.  Window managers may choose not to honor the
application's request.
.TP
.B magnify (\fIclass\fP Magnify)
specifies an integral factor by which the image should be enlarged.  The
default is 3.

This value only affects the magnification window which is invoked with
button number 3 after the image is displayed.  Refer to \fBBUTTONS\fP
for more details.
.TP
.B matteColor (\fIclass\fP MatteColor)
Specify the color of windows.  It is used for the backgrounds of
windows, menus, and notices.  A 3D  effect  is achieved  by
using highlight and shadow colors derived from this color.  Default
value: #ccc.
.TP
.B name (\fIclass\fP Name)
This resource specifies the name under which resources for the
application should be found.  This resource is useful in shell aliases to
distinguish between invocations of an application, without resorting to
creating links to alter the executable file name.  The default is the
application name.
.TP
.B pen[1-9] (\fIclass\fP Pen[1-9])
Specifies the color of the preferred font to use when annotating the
Image window with text.  The default colors are \fIblack\fP,
\fIblue\fP, \fIgreen\fP, \fIcyan\fP, \fIgray\fP, \fIred\fP,
\fImagenta\fP, \fIyellow\fP, and \fIwhite\fP.  Refer to \fBIMAGE
ANNOTATION\fP for more details.
.TP
.B printCommand (\fIclass\fP PrintCommand)
This command is executed whenever \fBPrint\fP is issued (see \fBBUTTONS\fP.
In general, it is the command to print Postscript to your printer.
Default value: \fBlpr -r %s\fP.
.TP
.B sharedMemory (\fIclass\fP SharedMemory)
This resource specifies whether display should attempt use shared memory
for pixmaps.  ImageMagick must be compiled with shared memory support,
and the display must support the MIT-SHM extension.  Otherwise, this
resource is ignored.  The default is True.
.TP
.B textFont (\fIclass\fP textFont)
Specifies the name of the preferred font to use in fixed (typewriter style)
formatted text.  The default is 14 point \fICourier\fP.
.TP
.B title (\fIclass\fP Title)
This resource specifies the title to be used for the Image window.  This
information is sometimes used by a window manager to provide a
header identifying the window.  The default is the image file name.
.TP
.B undoCache (\fIclass\fP UndoCache)
Specifies, in mega-bytes, the amount of memory in the undo edit cache.  Each
time you modify the image it is saved in the undo edit cache as long as memory
is available.  You can subsequently \fIundo\fP one or more of these
transformations.  The default is 16 mega-bytes.
.TP
.B usePixmap (\fIclass\fP UsePixmap)
Images are maintained as a XImage by default.  Set this resource to True
to utilize a server Pixmap instead.  This option is useful if your image
exceeds the dimensions of your server screen and you intend to pan the
image.  Panning is much faster with Pixmaps than with a XImage.
Pixmaps are considered a precious resource, use them with discretion.
.PP
To set the geometry of the \fIMagnify\fP or \fIPan\fP or window, use the
\fIgeometry\fP resource.  For example, to set the Pan window geometry
to 256x256, use:
.PP
    display.pan.geometry: 256x256
.PP
.SH IMAGE LOADING
To select an image to display, choose \fBLoad\fP of the \fBFile\fP sub-menu
from the Command widget.  A file browser is displayed.  To choose a
particular image file, move the pointer to the filename and press any
button.  The filename is copied to the text window.  Next, press
\fBLoad\fP or press the RETURN key.  Alternatively, you can type the
image file name directly into the text window.  To descend directories,
choose a directory name and press the button twice quickly.  A scrollbar
allows a large list of filenames to be moved through the viewing area if
it exceeds the size of the list area.
.PP
You can trim the list of file names by using shell globbing characters.
For example, type \fB*.jpg\fP to list only files that end with \fB.jpg\fP.
.PP
To select your image from the X server screen instead of from a file,
Choose \fBGrab\fP of the \fBLoad\fP widget.
.SH VISUAL IMAGE DIRECTORY
To create a Visual Image Directory, choose \fBVisual Directory\fP of
the \fBFile\fP sub-menu from the Command widget.  A file browser is
displayed.  To create a Visual Image Directory from all the images in
the current directory, press \fBDirectory\fP or press the RETURN key.
Alternatively, you can select a set of image names by using shell
globbing characters.  For example, type \fB*.jpg\fP to include only
files that end with \fB.jpg\fP.  To descend directories, choose a
directory name and press the button twice quickly.  A scrollbar allows
a large list of filenames to be moved through the viewing area if it
exceeds the size of the list area.
.PP
After you select a set of files, they are turned into thumbnails and
tiled onto a single image.  Now move the pointer to a particular
thumbnail and press button 3 and drag.  Finally, select \fBLoad\fP.  The
image represented by the thumbnail is displayed at its full size.
Choose \fBNext\fP from the \fBFile\fP sub-menu of the Command widget to
return to the Visual Image Directory.
.SH IMAGE CUTTING
Note that cut information for \fIImage window\fP is not retained for
colormapped X server visuals (e.g. \fIStaticColor\fP,
\fIStaticColor\fP, \fIGrayScale\fP, \fIPseudoColor\fP).  Correct
cutting behavior may require a \fITrueColor\fP or \fIDirectColor\fP
visual or a \fIStandard Colormap\fP.
.PP
To begin, press choose \fBCut\fP of the \fBEdit\fP sub-menu from
the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively, press \fBF3\fP
in the Image window (see \fBKEYBOARD ACCELERATORS\fP).
.PP
A small window appears showing the location of the cursor in the image
window.  You are now in \fIcut\fP mode.  In \fIcut\fP mode, the Command
widget has these options:
.PP
    Help
    Dismiss
.PP
To define a cut region, press button 1 and drag.  The cut
region is defined by a highlighted rectangle that expands or contracts
as it follows the pointer.  Once you are satisfied with the cut
region, release the button.  You are now in \fIrectify\fP mode.
In \fIrectify\fP mode, the Command widget has these options:
.PP
    Cut
    Help
    Dismiss
.PP
You can make adjustments by moving the pointer to one of the cut
rectangle corners, pressing a button, and dragging.
Finally, press \fBCut\fP to commit your copy region.  To exit without
cutting the image, press \fBDismiss\fP.
.SH IMAGE COPYING
To begin, press choose \fBCopy\fP of the \fBEdit\fP sub-menu from
the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively, press \fBF4\fP
in the Image window (see \fBKEYBOARD ACCELERATORS\fP).
.PP
A small window appears showing the location of the cursor in the image
window.  You are now in \fIcopy\fP mode.  In \fIcopy\fP mode, the Command
widget has these options:
.PP
    Help
    Dismiss
.PP
To define a copy region, press button 1 and drag.  The copy
region is defined by a highlighted rectangle that expands or contracts
as it follows the pointer.  Once you are satisfied with the copy
region, release the button.  You are now in \fIrectify\fP mode.
In \fIrectify\fP mode, the Command widget has these options:
.PP
    Copy
    Help
    Dismiss
.PP
You can make adjustments by moving the pointer to one of the copy
rectangle corners, pressing a button, and dragging.
Finally, press \fBCopy\fP to commit your copy region.  To exit without
copying the image, press \fBDismiss\fP.
.SH IMAGE PASTING
To begin, press choose \fBPaste\fP of the \fBEdit\fP sub-menu from
the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively, press \fBF5\fP
in the Image window (see \fBKEYBOARD ACCELERATORS\fP).
.PP
A small window appears showing the location of the cursor in the image
window. You are now in \fIPaste\fP mode.  To exit immediately,
press \fBDismiss\fP.  In \fIPaste\fP mode, the Command widget has these
options:
.PP
    Operators
      over
      in
      out
      atop
      xor
      plus
      minus
      add
      subtract
      difference
      bumpmap
      replace
    Help
    Dismiss
.PP
Choose a composite operation from the \fBOperators\fP sub-menu of the
Command widget.  How each operator behaves is described below.
\fIImage window\fP is the image currently displayed on your X server and
\fIimage\fP is the image obtained with the File Browser widget.
.PP
.TP 9
.B over
The result is the union of the two image shapes, with \fIimage\fP
obscuring \fIImage window\fP in the region of overlap.
.TP 9
.B in
The result is simply \fIimage\fP cut by the shape of \fIimage
window\fP.  None of the image data of \fIImage window\fP is in the
result.
.TP 9
.B out
The resulting image is \fIimage\fP with the shape of \fIImage window\fP
cut out.
.TP 9
.B atop
The result is the same shape as image \fIImage window\fP, with
\fIimage\fP obscuring \fIImage window\fP where the image shapes
overlap.  Note this differs from \fBover\fP because the portion of
\fIimage\fP outside \fIImage window\fP's shape does not appear in the
result.
.TP 9
.B xor
The result is the image data from both \fIimage\fP and \fIImage window\fP
that is outside the overlap region.  The overlap region is blank.
.TP 9
.B plus
The result is just the sum of the image data.  Output values are
cropped to 255 (no overflow).  This operation is independent
of the matte channels.
.TP 9
.B minus
The result of \fIimage\fP \- \fIImage window\fP, with underflow cropped
to zero.  The matte channel is ignored (set to 255, full coverage).
.TP 9
.B add
The result of \fIimage\fP + \fIImage window\fP, with overflow wrapping
around (\fImod\fP 256).
.TP 9
.B subtract
The result of \fIimage\fP - \fIImage window\fP, with underflow wrapping
around (\fImod\fP 256).  The \fBadd\fP and \fBsubtract\fP operators can
be used to perform reversible transformations.
.TP 9
.B difference
The result of abs(\fIimage\fP \- \fIImage window\fP).  This is useful
for comparing two very similar images.
.TP 9
.B bumpmap
The result of surface normals from \fIimage\fP * \fIImage window\fP.
.TP 9
.B replace
The resulting image is \fIImage window\fP replaced with \fIimage\fP.
Here the matte information is ignored.
.PP
The image compositor requires a matte, or alpha channel in the image
for some operations.  This extra channel usually defines a mask which
represents a sort of a cookie-cutter for the image.  This is the case
when matte is 255 (full coverage) for pixels inside the shape, zero
outside, and between zero and 255 on the boundary.  If \fIimage\fP does
not have a matte channel, it is initialized with 0 for any pixel
matching in color to pixel location (0,0), otherwise 255.  See
\fBMATTE EDITING\fP for a method of defining a matte channel.
.PP
Note that matte information for \fIImage window\fP is not retained for
colormapped X server visuals (e.g. \fIStaticColor\fP,
\fIStaticColor\fP, \fIGrayScale\fP, \fIPseudoColor\fP).  Correct
compositing behavior may require a \fITrueColor\fP or \fIDirectColor\fP
visual or a \fIStandard Colormap\fP.
.PP
Choosing a composite operator is optional.  The default operator is
\fIreplace\fP.  However, you must choose a location to composite your image
and press a button.  Press and hold the button before releasing and an
outline of the image will appear to help you identify your location.
.PP
The actual colors of the pasted image is saved.  However, the color
that appears in \fIImage window\fP may be different.  For example, on a
monochrome screen \fIImage window\fP will appear black or white even
though your pasted image may have many colors.  If the image is
saved to a file it is written with the correct colors.  To assure the
correct colors are saved in the final image, any \fIPseudoClass\fP
image is promoted to \fIDirectClass\fP (see \fBmiff(5)\fP).  To force a
\fIPseudoClass\fP image to remain \fIPseudoClass\fP, use \fB-colors\fP.
.SH IMAGE CROPPING
To begin, press choose \fBCrop\fP of the \fBTransform\fP sub-menu from
the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively, press \fB[\fP
in the Image window (see \fBKEYBOARD ACCELERATORS\fP).
.PP
A small window appears showing the location of the cursor in the image
window.  You are now in \fIcrop\fP mode.  In \fIcrop\fP mode, the Command
widget has these options:
.PP
    Help
    Dismiss
.PP
To define a cropping region, press button 1 and drag.  The cropping
region is defined by a highlighted rectangle that expands or contracts
as it follows the pointer.  Once you are satisfied with the cropping
region, release the button.  You are now in \fIrectify\fP mode.
In \fIrectify\fP mode, the Command widget has these options:
.PP
    Crop
    Help
    Dismiss
.PP
You can make adjustments by moving the pointer to one of the cropping
rectangle corners, pressing a button, and dragging.
Finally, press \fBCrop\fP to commit your cropping region.  To exit without
cropping the image, press \fBDismiss\fP.
.SH IMAGE CHOPPING
An image is chopped interactively.  There is no command line argument to
chop an image.  To begin, choose \fBChop\fP of the \fBTransform\fP
sub-menu from the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively,
press \fB]\fP in the Image window (see \fBKEYBOARD ACCELERATORS\fP).
.PP
You are now in \fIChop\fP mode.  To exit immediately, press \fBDismiss\fP.
In \fIChop\fP mode, the Command widget has these options:
.PP
    Direction
      horizontal
      vertical
    Help
    Dismiss
.PP
If the you choose the \fBhorizontal\fP direction (this is the default),
the area of the image between the two horizontal endpoints of the chop
line is removed.  Otherwise, the area of the image between the two
vertical endpoints of the chop line is removed.
.PP
Select a location within the Image window to begin your chop, press and hold
any button.  Next, move the pointer to another location in the image.  As you
move a line will connect the initial location and the pointer.  When you
release the button, the area within the image to chop is determined by
which direction you choose from the Command widget.
.PP
To cancel the image chopping, move the pointer back to the starting
point of the line and release the button.
.SH IMAGE ROTATION
Press the \fB/\fP key to rotate the image 90 degrees or \fB\\\fP to
rotate -90 degrees (see \fBKEYBOARD ACCELERATORS\fP).  To interactively
choose the degree of rotation, choose \fBRotate...\fP of the \fBPixel
Transform\fP submenu from the Command Widget (see \fBCOMMAND
WIDGET\fP).  Alternatively, press \fI*\fP in the Image window (see
\fBKEYBOARD ACCELERATORS\fP).
.PP
A small horizontal line is drawn next to the pointer.  You are now in
\fIrotate\fP mode.  To exit immediately, press \fBDismiss\fP.
In \fIrotate\fP mode, the Command widget has these options:
.PP
    Pixel Color
      black
      blue
      cyan
      green
      gray
      red
      magenta
      yellow
      white
      Browser...
    Direction
      horizontal
      vertical
    Crop
      false
      true
    Sharpen
      false
      true
    Help
    Dismiss
.PP
Choose a background color from the \fBPixel Color\fP sub-menu.
Additional background colors can be specified with the color browser.
You can change the menu colors by setting the X resources \fBpen1\fP
through \fBpen9\fP.  Refer to \fBX RESOURCES\fP for more details.
.PP
If you choose the color browser and press \fBGrab\fP, you can select
the background color by moving the pointer to the desired color on the
screen and press any button. The transparent color updates the image
matte channel and is useful for image compositing.
.PP
Choose a point in the Image window and press this button and hold.
Next, move the pointer to another location in the image.  As you move a
line connects the initial location and the pointer.  When you release
the button, the degree of image rotation is determined by the slope of
the line you just drew.  The slope is relative to the direction you
choose from the \fBDirection\fP sub-menu of the Command widget.
.PP
To cancel the image rotation, move the pointer back to the starting
point of the line and release the button.
.SH IMAGE ANNOTATION
An image is annotated interactively.  There is no command line argument
to annotate an image.  To begin, choose \fIAnnotate\fP of the \fBImage
Edit\fP sub-menu from the Command widget (see \fBCOMMAND WIDGET\fP).
Alternatively, press \fIa\fP in the Image window (see \fBKEYBOARD
ACCELERATORS\fP).
.PP
A small window appears showing the location of the cursor in the image
window.  You are now in \fIannotate\fP mode.  To exit immediately,
press \fBDismiss\fP.  In \fIannotate\fP mode, the Command widget has these
options:
.PP
    Font Name
      fixed
      variable
      5x8
      6x10
      7x13bold
      8x13bold
      9x15bold
      10x20
      12x24
      Browser...
    Font Color
      black
      blue
      cyan
      green
      gray
      red
      magenta
      yellow
      white
      transparent
      Browser...
    Box Color
      black
      blue
      cyan
      green
      gray
      red
      magenta
      yellow
      white
      transparent
      Browser...
    Rotate Text
      -90
      -45
      -30
      0
      30
      45
      90
      180
      Dialog...
    Help
    Dismiss
.PP
Choose a font name from the \fBFont Name\fP sub-menu.
Additional font names can be specified with the font browser.
You can change the menu names by setting the X resources \fBfont1\fP
through \fBfont9\fP.  Refer to \fBX RESOURCES\fP for more details.
.PP
Choose a font color from the \fBFont Color\fP sub-menu.
Additional font colors can be specified with the color browser.
You can change the menu colors by setting the X resources \fBpen1\fP
through \fBpen9\fP.  Refer to \fBX RESOURCES\fP for more details.
.PP
If you select the color browser and press \fBGrab\fP, you can choose
the font color by moving the pointer to the desired color on the screen
and press any button.
.PP
If you choose to rotate the text, choose Rotate Text from the
menu and select an angle.  Typically you will only want to
rotate one line of text at a time.  Depending on the angle you
choose, subsequent lines may end up overwriting each other.
.PP
Choosing a font and its color is optional.  The default font is
\fIfixed\fP and the default color is \fIblack\fP.  However, you must
choose a location to begin entering text and press a button.  An
underscore character will appear at the location of the pointer.  The
cursor changes to a pencil to indicate you are in \fItext\fP mode.  To
exit immediately, press \fBDismiss\fP.
.PP
In \fItext\fP mode, any key presses will display the character at
the location of the underscore and advance the underscore cursor.
Enter your text and once completed press \fBDismiss\fP to finish your image
annotation.  To correct errors press \fBBACK SPACE\fP.  To delete an
entire line of text, press \fBDELETE\fP.  Any text that exceeds the
boundaries of the Image window is automatically continued onto the next
line.
.PP
The actual color you request for the font is saved in the image.
However, the color that appears in your Image window may be different.
For example, on a monochrome screen the text will appear black or white even
if you choose the color red as the font color.  However, the image saved to
a file with \fB-write\fP is written with red lettering.  To assure
the correct color text in the final image, any \fIPseudoClass\fP image
is promoted to \fIDirectClass\fP (see \fBmiff(5)\fP).  To
force a \fIPseudoClass\fP image to remain \fIPseudoClass\fP, use
\fB-colors\fP.
.SH IMAGE COMPOSITING
An image composite is created interactively.  There is no command line
argument to composite an image.  To begin, choose \fBComposite\fP of
the \fBImage Edit\fP from the Command widget (see \fBCOMMAND
WIDGET\fP).  Alternatively, press \fIx\fP in the Image window (see
\fBKEYBOARD ACCELERATORS\fP).
.PP
First a popup window is displayed requesting you to enter an image name.
Press \fBComposite\fP, \fBGrab\fP or type a file name.  Press \fBCancel\fP
if you choose not to create a composite image.  When you choose \fBGrab\fP,
move the pointer to the desired window and press any button.
.PP
A small window appears showing the location of the cursor in the image
window. You are now in \fIcomposite\fP mode.  To exit immediately,
press \fBDismiss\fP.  In \fIcomposite\fP mode, the Command widget has these
options:
.PP
    Operators
      over
      in
      out
      atop
      xor
      plus
      minus
      add
      subtract
      difference
      replace
    Blend
    Help
    Dismiss
.PP
Choose a composite operation from the \fBOperators\fP sub-menu of the
Command widget.  How each operator behaves is described below.
\fIImage window\fP is the image currently displayed on your X server and
\fIimage\fP is the image obtained with the File Browser widget.
.PP
.TP 9
.B over
The result is the union of the two image shapes, with \fIimage\fP
obscuring \fIImage window\fP in the region of overlap.
.TP 9
.B in
The result is simply \fIimage\fP cut by the shape of \fIimage
window\fP.  None of the image data of \fIImage window\fP is in the
result.
.TP 9
.B out
The resulting image is \fIimage\fP with the shape of \fIImage window\fP
cut out.
.TP 9
.B atop
The result is the same shape as image \fIImage window\fP, with
\fIimage\fP obscuring \fIImage window\fP where the image shapes
overlap.  Note this differs from \fBover\fP because the portion of
\fIimage\fP outside \fIImage window\fP's shape does not appear in the
result.
.TP 9
.B xor
The result is the image data from both \fIimage\fP and \fIImage window\fP
that is outside the overlap region.  The overlap region is blank.
.TP 9
.B plus
The result is just the sum of the image data.  Output values are
cropped to 255 (no overflow).  This operation is independent
of the matte channels.
.TP 9
.B minus
The result of \fIimage\fP \- \fIImage window\fP, with underflow cropped
to zero.  The matte channel is ignored (set to 255, full coverage).
.TP 9
.B add
The result of \fIimage\fP + \fIImage window\fP, with overflow wrapping
around (\fImod\fP 256).
.TP 9
.B subtract
The result of \fIimage\fP - \fIImage window\fP, with underflow wrapping
around (\fImod\fP 256).  The \fBadd\fP and \fBsubtract\fP operators can
be used to perform reversible transformations.
.TP 9
.B difference
The result of abs(\fIimage\fP \- \fIImage window\fP).  This is useful
for comparing two very similar images.
.TP 9
.B replace
The resulting image is \fIImage window\fP replaced with \fIimage\fP.
Here the matte information is ignored.
.PP
The image compositor requires a matte, or alpha channel in the image
for some operations.  This extra channel usually defines a mask which
represents a sort of a cookie-cutter for the image.  This is the case
when matte is 255 (full coverage) for pixels inside the shape, zero
outside, and between zero and 255 on the boundary.  If \fIimage\fP does
not have a matte channel, it is initialized with 0 for any pixel
matching in color to pixel location (0,0), otherwise 255.  See
\fBMATTE EDITING\fP for a method of defining a matte channel.
.PP
If you choose \fBBlend\fP, the composite operator becomes \fBOver\fP.
The \fIimage\fP matte channel percent transparency is initialized to
\fIfactor\fP.  The \fIimage window\fP is initialized to \fI(100-factor)\fP.
Where factor is the value you specify in the Dialog widget.
.PP
Note that matte information for \fIImage window\fP is not retained for
colormapped X server visuals (e.g. \fIStaticColor\fP,
\fIStaticColor\fP, \fIGrayScale\fP, \fIPseudoColor\fP).  Correct
compositing behavior may require a \fITrueColor\fP or \fIDirectColor\fP
visual or a \fIStandard Colormap\fP.
.PP
Choosing a composite operator is optional.  The default operator is
\fIreplace\fP.  However, you must choose a location to composite your image
and press a button.  Press and hold the button before releasing and an
outline of the image will appear to help you identify your location.
.PP
The actual colors of the composite image is saved.  However, the color
that appears in \fIImage window\fP may be different.  For example, on a
monochrome screen \fIImage window\fP will appear black or white even
though your composited image may have many colors.  If the image is
saved to a file it is written with the correct colors.  To assure the
correct colors are saved in the final image, any \fIPseudoClass\fP
image is promoted to \fIDirectClass\fP (see \fBmiff(5)\fP).  To force a
\fIPseudoClass\fP image to remain \fIPseudoClass\fP, use \fB-colors\fP.
.SH COLOR EDITING
Changing the the color of a set of pixels is performed interactively.
There is no command line argument to edit a pixel.  To begin, choose
\fBColor\fP from the \fBImage Edit\fP submenu of the Command widget
(see \fBCOMMAND WIDGET\fP).  Alternatively, press \fIc\fP in the image
window (see \fBKEYBOARD ACCELERATORS\fP).
.PP
A small window appears showing the location of the cursor in the image
window. You are now in \fIcolor edit\fP mode.  To exit immediately,
press \fBDismiss\fP.  In \fIcolor edit\fP mode, the Command widget has these
options:
.PP
    Pixel Color
      black
      blue
      cyan
      green
      gray
      red
      magenta
      yellow
      white
      Browser...
    Method
      point
      replace
      floodfill
      reset
    Delta
      0
      1
      2
      4
      8
      16
      32
      Browser...
    Undo
    Help
    Dismiss
.PP
Choose a pixel color from the \fBPixel Color\fP sub-menu.
Additional pixel colors can be specified with the color browser.
You can change the menu colors by setting the X resources \fBpen1\fP
through \fBpen9\fP.  Refer to \fBX RESOURCES\fP for more details.
.PP
Next, choose a color editing method from the \fBMethod\fP sub-menu of
the Command widget.  The \fBpoint\fP method recolors any pixel selected
with the pointer unless the button is released.  The \fBreplace\fP
method recolors any pixel that matches the color of the pixel you
select with a button press.  \fBFloodfill\fP recolors any pixel that
matches the color of the pixel you select with a button press and is a
neighbor.  Finally \fBreset\fP changes the entire image to the designated
color.
.PP
Now press a button to select a pixel within the Image window to change its
color.  Additional pixels may be recolored as prescribed by the method you
choose.  You can recolor additional pixels by increasing the Delta
value.  The Delta value is first added then subtracted from the red, green,
and blue of the target color.  Any pixels within the range is also
recolored.
.PP
If the Magnify widget is mapped, it can be helpful in positioning
your pointer within the image (refer to button 2).  Alternatively you
can select a pixel to recolor from within the Magnify widget.  Move the
pointer to the Magnify widget and position the pixel with the
cursor control keys.  Finally, press a button to recolor the selected
pixel (or pixels).
.PP
The actual color you request for the pixels is saved in the image.
However, the color that appears in your Image window may be different.
For example, on a monochrome screen the pixel will appear black or
white even if you choose the color red as the pixel color.  However, the
image saved to a file with \fB-write\fP is written with red pixels.  To
assure the correct color text in the final image, any \fIPseudoClass\fP
image is promoted to \fIDirectClass\fP (see \fBmiff(5)\fP).  To force a
\fIPseudoClass\fP image to remain \fIPseudoClass\fP, use \fB-colors\fP.
.SH MATTE EDITING
Matte information within an image is useful for some operations such as
image compositing (See \fBIMAGE COMPOSITING\fP).  This extra channel
usually defines a mask which represents a sort of a cookie-cutter for
the image.  This is the case when matte is 255 (full coverage) for
pixels inside the shape, zero outside, and between zero and 255 on the
boundary.
.PP
Setting the matte information in an image is done interactively.  There
is no command line argument to edit a pixel.  To begin, and choose
\fIMatte\fP of the \fBImage Edit\fP sub-menu from the Command widget
(see \fBCOMMAND WIDGET\fP).  Alternatively, press \fIm\fP in the image
window (see \fBKEYBOARD ACCELERATORS\fP).
.PP
A small window appears showing the location of the cursor in the image
window. You are now in \fImatte edit\fP mode.  To exit immediately,
press \fBDismiss\fP.  In \fImatte edit\fP mode, the Command widget has these
options:
.PP
    Method
      point
      replace
      floodfill
      reset
    Delta
      0
      1
      2
      4
      8
      16
      32
      Browser...
    Matte
    Undo
    Help
    Dismiss
.PP
Choose a matte editing method from the \fBMethod\fP sub-menu of the
Command widget.  The \fBpoint\fP method changes the matte value of the
any pixel selected with the pointer until the button is released.  The
\fBreplace\fP method changes the matte value of any pixel that matches
the color of the pixel you select with a button press.  \fBFloodfill\fP
changes the matte value of any pixel that matches the color of the pixel
you select with a button press and is a neighbor. Finally \fBreset\fP
changes the entire image to the designated matte value.
.PP
Choose \fBMatte Value\fP and a dialog appears requesting a matte value.  Enter
a value between 0 and 255.  This value is assigned as the matte value of the
selected pixel or pixels.
.PP
Now, press any button to select a pixel within the Image window to change
its matte value.  You can change the matte value of additional pixels by
increasing the Delta value.  The Delta value is first added then subtracted
from the red, green, and blue of the target color.  Any pixels within the
range also have their matte value updated.
.PP
If the Magnify widget is mapped, it can be helpful
in positioning your pointer within the image (refer to button 2).
Alternatively you can select a pixel to change the matte value from within the
Magnify widget.  Move the pointer to the Magnify widget and position the pixel
with the cursor control keys.  Finally, press a button to change the matte
value of the selected pixel (or pixels).
.PP
Matte information is only valid in a \fIDirectClass\fP image.
Therefore, any \fIPseudoClass\fP image is promoted to \fIDirectClass\fP
(see \fBmiff(5)\fP).  Note that matte information for \fIPseudoClass\fP
is not retained for colormapped X server visuals (e.g.
\fIStaticColor\fP, \fIStaticColor\fP, \fIGrayScale\fP,
\fIPseudoColor\fP) unless you immediately save your image to a file
(refer to \fBWrite\fP).  Correct matte editing behavior may require a
\fITrueColor\fP or \fIDirectColor\fP visual or a \fIStandard Colormap\fP.
.SH IMAGE DRAWING
An image is drawn upon interactively.  There is no command
line argument to draw on an image.  To begin, choose \fIDraw\fP of
the \fBImage Edit\fP sub-menu from the Command widget (see \fBCOMMAND
WIDGET\fP).  Alternatively, press \fId\fP in the Image window (see
\fBKEYBOARD ACCELERATORS\fP).
.PP
The cursor changes to a crosshair to indicate you are in \fIdraw\fP mode.
To exit immediately, press \fBDismiss\fP.  In \fIdraw\fP mode, the Command
widget has these options:
.PP
    Primitive
      point
      line
      rectangle
      fill rectangle
      ellipse
      fill ellipse
      polygon
      fill polygon
    Color
      black
      blue
      cyan
      green
      gray
      red
      magenta
      yellow
      white
      transparent
      Browser...
    Stipple",
      Brick",
      Diagonal",
      Scales",
      Vertical",
      Wavy",
      Translucent",
      Opaque",
      Load...",
    Width
      1
      2
      4
      8
      16
      Dialog...
    Undo
    Help
    Dismiss
.PP
Choose a drawing primitive from the \fBPrimitive\fP sub-menu.
.PP
Next, choose a color from the \fBColor\fP sub-menu.
Additional colors can be specified with the color browser.
You can change the menu colors by setting the X resources \fBpen1\fP
through \fBpen9\fP.  Refer to \fBX RESOURCES\fP for more details.
.PP
If you choose the color browser and press \fBGrab\fP, you can select
the primitive color by moving the pointer to the desired color on the
screen and press any button.  The transparent color updates the image
matte channel and is useful for image compositing.,
.PP
Choose a stipple, if appropriate, from the Stipple sub-menu.
Additional stipples can be specified with the file browser.
Stipples obtained from the file browser must be on disk in the
X11 bitmap format.
.PP
Choose a line width from the \fBWidth\fP sub-menu.
To choose a specific width select the Dialog widget.
.PP
Choose a point in the Image window and press a button and hold.
Next, move the pointer to another location in the image.  As you move, a
line connects the initial location and the pointer.  When you release
the button, the image is updated with the primitive you just drew.
For polygons, the image is updated when you press and release the button
without moving the pointer.
.PP
To cancel image drawing, move the pointer back to the starting
point of the line and release the button.
.SH REGION OF INTEREST
To begin, press choose \fBRegion of Interest\fP of the \fBTransform\fP
sub-menu from the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively,
press \fBR\fP in the Image window (see \fBKEYBOARD ACCELERATORS\fP).
.PP
A small window appears showing the location of the cursor in the image
window.  You are now in \fIregion of interest\fP mode.  In \fIregion of
interest\fP mode, the Command widget has these options:
.PP
    Help
    Dismiss
.PP
To define a region of interest, press button 1 and drag.  The region
of interest is defined by a highlighted rectangle that expands or contracts
as it follows the pointer.  Once you are satisfied with the region of
interest, release the button.  You are now in \fIapply\fP mode.
In \fIapply\fP mode the Command widget has these options:
.PP
    File
      Image Info
    Edit
      Undo
      Redo
    Transform
      Flip
      Flop
      Rotate Right
      Rotate Left
    Enhance
      Hue...
      Saturation...
      Brightness...
      Gamma...
      Spiff
      Dull
      Equalize
      Normalize
      Negate
      Grayscale
      Quantize...
    Effects
      Despeckle
      Peak Noise
      Sharpen...
      Blur...
      Edge Detect...
      Emboss...
      Spread...
      Swirl...
      Implode...
      Solarize...
      Oil Painting...
      Raise...
      Segment...
    Help
    Dismiss
.PP
You can make adjustments to the region of interest by moving the pointer to
one of the rectangle corners, pressing a button, and dragging.
Finally, choose an image processing technique from the Command widget.  You
can choose more than one image processing technique to apply to an area.
Alternatively, you can move the region of interest before applying
another image processing technique.  To exit, press \fBDismiss\fP.
.SH IMAGE PANNING
When an image exceeds the width or height of the X server screen,
\fBdisplay\fP maps a small panning icon.  The rectangle within the
panning icon shows the area that is currently displayed in the
the Image window.  To \fIpan\fP about the image, press any button and drag the
pointer within the panning icon.  The pan rectangle moves with the pointer
and the Image window is updated to reflect the location of the
rectangle within the panning icon.  When you have selected the area
of the image you wish to view, release the button.

Use the arrow keys to pan the image one pixel up, down, left, or right within
the Image window.

The panning icon is withdrawn if the image becomes smaller than the
dimensions of the X server screen.
.SH IMAGE SEGMENTATION
Use \fB-segment\fP to segment an image by analyzing the histograms of the color
components and identifying units that are homogeneous with the fuzzy c-means
technique.  The scale-space filter analyzes the histograms of the three
color components of the image and identifies a set of classes.  The
extents of each class is used to coarsely segment the image with
thresholding.  The color associated with each class is determined by
the mean color of all pixels within the extents of a particular class.
Finally, any unclassified pixels are assigned to the closest class with
the fuzzy c-means technique.
.PP
The fuzzy c-Means algorithm can be summarized as follows:
.RS
.LP
o Build a histogram, one for each color component of the image.
.LP
o For each histogram, successively apply the scale-space filter and
build an interval tree of zero crossings in the second derivative at
each scale.  Analyze this scale-space ``fingerprint'' to determine
which peaks or valleys in the histogram are most predominant.
.LP
o The fingerprint defines intervals on the axis of the histogram.  Each
interval contains either a minima or a maxima in the original signal.
If each color component lies within the maxima interval, that pixel is
considered ``classified'' and is assigned an unique class number.
.LP
o Any pixel that fails to be classified in the above thresholding pass is
classified using the fuzzy c-Means technique.  It is assigned to one
of the classes discovered in the histogram analysis phase.
.RE
.PP
The fuzzy c-Means technique attempts to cluster a pixel by finding the local
minima of the generalized within group sum of squared error objective
function.  A pixel is assigned to the closest class of which the fuzzy
membership has a maximum value.

For additional information see
.IP
Young Won Lim, Sang Uk Lee, "On The Color Image Segmentation Algorithm Based
on the Thresholding and the Fuzzy c-Means Techniques", Pattern Recognition,
Volume 23, Number 9, pages 935-952, 1990.
.SH USER PREFERENCES
Preferences affect the default behavior of \fBdisplay(1)\fP.  The preferences
are either true or false:
.TP
.B "display image centered on a backdrop"
This backdrop covers the entire workstation screen and is useful for
hiding other X window activity while viewing the image.   The color of
the backdrop is specified as the background color.  Refer to \fBX
RESOURCES\fP for details.
.TP
.B "confirm on program exit"
Ask for a confirmation before exiting the \fBdisplay(1)\fP program.
.TP
.B "correct image for display gamma"
If the image has a known gamma, the gamma is corrected to match that of the
X server (see the X resource \fBdisplayGamma\fP).
.TP
.B "apply Floyd/Steinberg error diffusion to image"
The basic strategy of dithering is to trade intensity resolution for
spatial resolution by averaging the intensities of several neighboring
pixels.  Images which suffer from severe contouring when reducing colors
can be improved with this perference.
.TP
.B "use a shared colormap for colormapped X visuals"
This option only applies when the default X server visual is
\fIPseudoColor\fP or \fIGrayScale\fP.  Refer to \fB-visual\fP for more
details.  By default, a shared colormap is allocated.  The image shares
colors with other X clients.  Some image colors could be approximated,
therefore your image may look very different than intended.  Choose
\fBPrivate\fP and the image colors appear exactly as they are
defined.  However, other clients may go \fItechnicolor\fP when the image
colormap is installed.
.TP
.B "display images as an X server pixmap"
Images are maintained as a XImage by default.  Set this resource to True
to utilize a server Pixmap instead.  This option is useful if your image
exceeds the dimensions of your server screen and you intend to pan the
image.  Panning is much faster with Pixmaps than with a XImage.
Pixmaps are considered a precious resource, use them with discretion.
.SH ENVIRONMENT
.TP
.B display
To get the default host, display number, and screen.
.SH SEE ALSO
.B
animate(1), import(1), montage(1), mogrify(1), mosaic(1), convert(1), combine(1), xtp(1)
.SH COPYRIGHT
Copyright 1996 E. I. du Pont de Nemours and Company
.PP
Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of E. I. du Pont de Nemours
and Company not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.  E. I. du Pont de Nemours and Company makes no representations
about the suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
.PP
E. I. du Pont de Nemours and Company disclaims all warranties with regard
to this software, including all implied warranties of merchantability
and fitness, in no event shall E. I. du Pont de Nemours and Company be
liable for any special, indirect or consequential damages or any
damages whatsoever resulting from loss of use, data or profits, whether
in an action of contract, negligence or other tortuous action, arising
out of or in connection with the use or performance of this software.
.SH ACKNOWLEDGEMENTS
The MIT X Consortium for making network transparent graphics a reality.
.PP
Peder Langlo, Hewlett Packard, Norway, made hundreds of suggestions and bug
reports.  Without Peder, ImageMagick would not be nearly as useful as
it is today.
.PP
Rod Bogart and John W. Peterson, University of Utah.  Image
compositing is loosely based on \fIrlecomp\fP of the Utah Raster
Toolkit.
.PP
Michael Halle, Spatial Imaging Group at MIT, for the initial
implementation of Alan Paeth's image rotation algorithm.
.PP
David Pensak, E. I. du Pont de Nemours and Company, for providing a
computing environment that made this program possible.
.PP
Paul Raveling, USC Information Sciences Institute. The spacial
subdivision color reduction algorithm is based on his \fIImg\fP software.
.SH AUTHORS
John Cristy, E.I. du Pont de Nemours and Company Incorporated
