
static char rcsid[] = "@(#)$Id: getaddrfrm.c,v 1.1.1.1 1995/04/19 20:38:32 wfp5p Exp $";

/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 1.1.1.1 $   $State: Exp $
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *      Bill Pemberton, Elm Coordinator
 *      flash@virginia.edu
 *
 *******************************************************************************
 * $Log: getaddrfrm.c,v $
 * Revision 1.1.1.1  1995/04/19  20:38:32  wfp5p
 * Initial import of elm 2.4 PL0 as base for elm 2.5.
 *
 ******************************************************************************/

/** 

**/

#include "headers.h"

#ifdef USE_EMBEDDED_ADDRESSES

get_address_from(line, buffer)
char *line, *buffer;
{
	/** This routine extracts the address from either a 'From:' line
	    or a 'Reply-To:' line.  The strategy is as follows:  if the
	    line contains a '<', then the stuff enclosed is returned.
	    Otherwise we go through the line and strip out comments
	    and return that.  White space will be elided from the result.
	**/

    register char *s;
    register int l;

    /**  Skip start of line over prefix, e.g. "From:".  **/
    if ((s = index(line, ':')) != NULL)
	line = s + 1;

    /*
     * If there is a '<' then copy from it to '>' into the buffer.  We
     * used to search with an "index()", but we need to handle RFC-822
     * conventions (e.g. "<" within a double-quote comment) correctly.
     */
    for (s = line ; *s != '\0' && *s != '<' ; s += len_next_part(s))
	;
    if (*s == '<') {
	++s;
	while (*s != '\0' && *s != '>') {
	    if ((l = len_next_part(s)) == 1 && isspace(*s)) {
		++s; /* elide embedded whitespace */
	    } else {
		while (--l >= 0)
		    *buffer++ = *s++;
	    }
	}
	*buffer = '\0';
	return;
    }

    /**  Otherwise, strip comments and get address with whitespace elided.  **/
    s = strip_parens(line);
    while (*s != '\0') {
	l = len_next_part(s);
	if (l == 1) {
	  if ( !isspace(*s) )
	    *buffer++ = *s;
	  s++;
	} else {
	  while (--l >= 0)
	    *buffer++ = *s++;
	}
    }
    *buffer = '\0';

}

#endif
