
static char rcsid[] = "@(#)$Id: a_quit.c,v 1.1.1.1 1995/04/19 20:38:34 wfp5p Exp $";

/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 1.1.1.1 $   $State: Exp $
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *      Bill Pemberton, Elm Coordinator
 *      flash@virginia.edu
 *
 *******************************************************************************
 * $Log: a_quit.c,v $
 * Revision 1.1.1.1  1995/04/19  20:38:34  wfp5p
 * Initial import of elm 2.4 PL0 as base for elm 2.5.
 *
 ******************************************************************************/

/** a_quit: leave the aliases menu and return to the main menu.
  
**/

#include "headers.h"
#include "s_aliases.h"
#include <errno.h>


extern int errno;		/* system error number on failure */

int
delete_aliases(newaliases, prompt)
int newaliases, prompt;
{
/*
 *	Update aliases by processing deletions.  Prompting is
 *	done as directed by user input and elmrc options.
 *
 *	If "prompt" is false, then no prompting is done.
 *	Otherwise prompting is dependent upon the variable
 *	question_me, as set by an elmrc option.  This behavior
 *	makes the 'q' command prompt just like '$', while
 *	retaining the 'Q' command for a quick exit that never
 *	prompts.
 *
 *	Return	1		Aliases were deleted
 * 		newalias	Aliases were not deleted
 *
 *	The return allows the caller to determine if the "newalias"
 *	routine should be run.
 */

	char buffer[SLEN];
	char **list;

	register int to_delete = 0, to_keep = 0, i,
		     marked_deleted = 0,
		     ask_questions;
	char answer;

	dprint(1, (debugfile, "\n\n-- leaving aliases --\n\n"));

	if (message_count == 0)
	  return(newaliases);	/* nothing changed */

	ask_questions = ((!prompt) ? FALSE : question_me);

	/* YES or NO on softkeys */
	if (hp_softkeys && ask_questions) {
	  define_softkeys(YESNO);
	  softkeys_on();
	}

	/* Determine if deleted messages are really to be deleted */

	/* we need to know how many there are to delete */
	for (i=0; i<message_count; i++)
	  if (ison(aliases[i]->status, DELETED))
	    marked_deleted++;

	dprint(6, (debugfile, "Number of aliases marked deleted = %d\n",
	            marked_deleted));

        if(marked_deleted) {
	  answer = (always_del ? *def_ans_yes : *def_ans_no);	/* default answer */
	  if(ask_questions) {
	    if (marked_deleted == 1)
	      MCsprintf(buffer, catgets(elm_msg_cat, AliasesSet, AliasesDelete,
			"Delete 1 alias? (%c/%c) "), *def_ans_yes, *def_ans_no);
	    else
	      MCsprintf(buffer, catgets(elm_msg_cat, AliasesSet, AliasesDeletePlural,
			"Delete %d aliases? (%c/%c) "),
			marked_deleted, *def_ans_yes, *def_ans_no);
	                    
	    answer = want_to(buffer, answer, LINES-3, 0);
	  }

	  if(answer == *def_ans_yes) {
	    list = (char **) malloc(marked_deleted*sizeof(*list));
	    for (i = 0; i < message_count; i++) {
	      if (ison(aliases[i]->status, DELETED)) {
		list[to_delete] = aliases[i]->alias;
	        dprint(8,(debugfile, "Alias number %d, %s is deletion %d\n",
	               i, list[to_delete], to_delete));
	        to_delete++;
	      }
	      else {
	        to_keep++;
	      }
	    }
	   /*
	    * Formulate message as to number of keeps and deletes.
	    * This is only complex so that the message is good English.
	    */
	    if (to_keep > 0) {
	      current = 1;		/* Reset current alias */
	      if (to_keep == 1)
		sprintf(buffer, catgets(elm_msg_cat, AliasesSet, AliasesKeepDelete,
			  "[Keeping 1 alias and deleting %d.]"), to_delete);
	      else
		MCsprintf(buffer, catgets(elm_msg_cat, AliasesSet, AliasesKeepDeletePlural,
			  "[Keeping %d aliases and deleting %d.]"), to_keep, to_delete);
	    }
	    else {
	      current = 0;		/* No aliases left */
	      sprintf(buffer, catgets(elm_msg_cat, AliasesSet, AliasesDeleteAll,
			  "[Deleting all aliases.]"));
	    }

	    dprint(2, (debugfile, "Action: %s\n", buffer));
	    error(buffer);

	    delete_from_alias_text(list, to_delete);

	    free((char *) list);
	  }
	}
	dprint(3, (debugfile, "Aliases deleted: %d\n", to_delete));

	/* If all aliases are to be kept we don't need to do anything
	 * (like run newalias for the deleted messages).
	 */

	if(to_delete == 0) {
	  dprint(3, (debugfile, "Aliases kept as is!\n"));
	  return(newaliases);
	}

	return(1);
}

exit_alias()
{

	register int i;

	/* Clear the deletes from all aliases.  */

	for(i = 0; i < message_count; i++)
	  if (ison(aliases[i]->status, DELETED))
	    clearit(aliases[i]->status, DELETED);

	dprint(6, (debugfile, "\nexit_alias:  Done clearing deletes.\n"));

}
