
static char rcsid[] = "@(#)$Id: exitprog.c,v 1.1.1.1 1995/04/19 20:38:36 wfp5p Exp $";

/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 1.1.1.1 $   $State: Exp $
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *      Bill Pemberton, Elm Coordinator
 *      flash@virginia.edu
 *
 *******************************************************************************
 * $Log: exitprog.c,v $
 * Revision 1.1.1.1  1995/04/19  20:38:36  wfp5p
 * Initial import of elm 2.4 PL0 as base for elm 2.5.
 *
 ******************************************************************************/

#include "headers.h"
#include "s_elm.h"

int
exit_prog()
{
	/** Exit, abandoning all changes to the mailbox (if there were
	    any, and if the user say's it's ok)
	**/

	char msg[SLEN], answer;
	register int i, changes;

	dprint(1, (debugfile, "\n\n-- exiting --\n\n"));

	/* Determine if any messages are scheduled for deletion, or if
	 * any message has changed status
	 */
	for (changes = 0, i = 0; i < message_count; i++)
	  if (ison(headers[i]->status, DELETED) || headers[i]->status_chgd)
	    changes++;
	
	if (changes) {
	  /* YES or NO on softkeys */
	  if (hp_softkeys) {
	    define_softkeys(YESNO);
	    softkeys_on();
	  }
	  if (changes == 1)
	    MCsprintf(msg, catgets(elm_msg_cat, ElmSet, ElmAbandonChange,
		"Abandon change to mailbox? (%c/%c) "), *def_ans_yes, *def_ans_no);
	  else
	    MCsprintf(msg, catgets(elm_msg_cat, ElmSet, ElmAbandonChangePlural,
		"Abandon changes to mailbox? (%c/%c) "), *def_ans_yes, *def_ans_no);
	  answer = want_to(msg, *def_ans_no, LINES-3, 0);

	  if(answer != *def_ans_yes) return -1;
	}

	fflush(stdout);
	return leave(0);
}
