
static char rcsid[] = "";

/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 1.3 $
 *
 * This file and all associated files and documentation:
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *      Bill Pemberton, Elm Coordinator
 *      flash@virginia.edu
 *
 *******************************************************************************
 * $Log: mlist.c,v $
 * Revision 1.3  1995/06/14  19:58:26  wfp5p
 * Changes for alpha 3 -- K&R-ized it.
 *
 *
 ******************************************************************************/


#include <stdio.h>
#include <string.h>
#ifdef STRINGS
#include <strings.h>
#endif
#include "defs.h"
#include "parseaddrs.h"
#include "sysdefs.h"

struct addrs patterns;
struct addrs mlnames;

void
mlist_init()
{
    int i;
    char buffer[SLEN];
    struct addrs tmp;
    int lineno = 0;
    extern char home[];
    FILE *ml;

    patterns.len = patterns.max = 0; patterns.str = NULL;
    mlnames.len = mlnames.max = 0; mlnames.str = NULL;
    tmp.len = tmp.max = 0; tmp.str = NULL;

   
   /* 7! no, no, no!  This should "do the right thing" and use the 
    * elm vars for lib paths!!!!!
    */
   
    sprintf(buffer, "%s/%s", home,mlistfile); 
    ml = fopen(buffer, "r");
    if (ml == NULL) {
	sprintf(buffer, "%s", system_mlist_file);   
	ml = fopen(buffer, "r");
	if (ml == NULL)
	    return;
    }

    while (1) {
	char *mlist, *mlname;
	if (fgets(buffer, sizeof(buffer), ml) == NULL)
	    break;
	lineno++;
	if (*buffer == '\n' || *buffer == '#')
	    continue;
	parseaddrs(buffer, &tmp);

	switch (tmp.len) {
	    case 0:
		break;
	    case 1:
		mlist = mlname = tmp.str[0];
		break;
	    case 2:
		mlist = tmp.str[0];
		mlname = tmp.str[1];
		break;
	    default:
		fprintf(stderr, "line %d: too many names!\n", lineno);
	}
	if (mlist == NULL)
	    continue;
	mlist_push(&patterns, mlist);
	mlist_push(&mlnames, mlname);
    }

    fclose(ml);
}


/*
 * emulate the following perl code:
 */
#if 0
/*
* subscribe ParseAddrs {
*     local($_) = shift;
*     1 while s/\([^\(\)]*\)//g;          # strip comments
*     1 while s/"[^"]*"//g;               # strip comments
*     split(/,/);                         # split into parts
*     foreach (@_) {
*         1 while s/.*<(.*)>.*/\1/;
*         s/^\s+//;
*         s/\s+$//;
*     }
* 
*     @_;
* }
*/
#endif

void
parseaddrs(p,array)
   char *p; 
   struct addrs *array;
{
    int i;
    register char *s;
    char *copy;

    if (array->len != 0 && array->str != NULL) {
	for (i=0; i < array->len; i++) {
	    free(array->str[i]);
	}
	free(array->str);
    }
    array->len = array->max = 0;
    array->str = NULL;

    copy = s = safe_strdup(p);

    /* strip comments */

    while (*p) {
	while (*p && *p != '(' && *p != '"') {
	    *s++ = *p++;
	}
	if (*p == '(') {
	    int count = 1;
	    p++;
	    while (count && *p) {
		if (*p == '(')
		    count++;
		if (*p == ')')
		    count--;
		p++;
	    }
	}
	else if (*p == '"') {
	    p++;
	    while (*p && *p != '"')
		p++;
	    if (*p == '"')
		p++;
	}
    }
    if (*(s-1) == '\n')
	s--;
    *s = '\0';

    /*printf("comment stripped string = %s\n", copy);*/

    /* split by ',' */

    p = s = copy;

    while (*s) {
	while (*s && *s != ',')
	    s++;
	if (*s == ',')
	    *s++ = '\0';
	mlist_push(array, p);
	p = s;
    }


    for (i=0; i < array->len; i++) {

	/* strip comments outside '<>' */

	int again = 1;
	while (again) {
	    char *addr = index(array->str[i], '<');
	    again = 0;
	    if (addr != NULL) {
		char *tmp = safe_strdup(addr+1);
		char *addr2 = rindex(tmp, '>');
		if (addr2 != NULL) {
		    *addr2 = '\0';
		    free(array->str[i]);
		    array->str[i] = tmp;
		    again = 1;
		}
	    }
	}

	/* trim blanks */

	s = array->str[i];
	if (*s == ' ' || *s == '\t') {
	    while (*s && (*s == ' ' || *s == '\t'))
		s++;
	    if (*s != '\0') {
		char *tmp = array->str[i];
		array->str[i] = safe_strdup(s);
		free(tmp);
	    }
	}
	p = array->str[i];
	s = array->str[i] + strlen(array->str[i]) - 1;
	if (*s == ' ' || *s == '\t') {
	    while (s != p && (*s == ' ' || *s == '\t'))
		s--;
	    if (*s != ' ' && *s != '\t')
		s++;
	    *s = '\0';
	}
	if (*p == '\0') {
	    free(array->str[i]);
	    array->str[i] = NULL;
	}
    }

    free(copy);
}

void
mlist_push(arr, str)
   struct addrs *arr;
   char *str;
{
    int index = arr->len;
    int newlen = index+1;
    if (newlen > arr->max) {
	int newmax = (newlen>2*arr->max)? newlen+1: 2*arr->max;
	char **cp;
	/* printf("growing to %d elements\n", newmax); */
	if (arr->str == (char **)0)
	  arr->str = (char **)malloc(newmax*sizeof(char*));
	else
	  arr->str = (char **)realloc(arr->str, newmax*sizeof(char*));
	arr->max = newmax;
    }
    if (newlen > arr->len)
	arr->len = newlen;
    if (str)
	arr->str[index] = safe_strdup(str);
    else
	arr->str[index] = NULL;
}

/*
 * case-insensitive searcher
 */
int
addrmatch(addr, pattern)
  struct addrs *addr;
  struct addrs *pattern;
{
    int i, j;
    static int initialized = 0;
    static char lower[256];

    if (!initialized) {
	for (i=0; i < 256; i++)
	    lower[i] = tolower(i);
	initialized = 1;
    }

    for (i=0; i < pattern->len; i++) {
	int pattlen;
	if (pattern->str[i] == NULL)
	    continue;
	pattlen = strlen(pattern->str[i]);
	for(j=0; j < addr->len; j++) {
	    register char *s1, *s2;
	    char *addrsearch = addr->str[j];
	    while (addrsearch != NULL) {
		s1 = pattern->str[i];
		s2 = addrsearch;
		while (*s1 && lower[*s1] == lower[*s2])
		    s1++, s2++;
		if (*s1 == '\0' &&
		      (*s2 == '\0' || *s2 == '@' || *s2 == '%' || *s2 == '!'))
		    return i;	/* found one */
		if ((addrsearch=strpbrk(addrsearch, "%@!:")) == NULL)
		    break;
		addrsearch++;
	    }
	}
    }
    return -1;
}
