.TH httpd 1m "October 1995"
.SH NAME
httpd \- NCSA HTTPd (hypertext transfer protocol daemon)
.SH SYNOPSIS
.B httpd 
[
.B \-v
] [
.B \-X
] [
.BI \-d " serverroot"
] [
.BI \-f " config"
]
.SH DESCRIPTION
.B httpd
is the NCSA HTTPd (HyperText Transfer Protocol daemon) server. The server may
be invoked by the Internet daemon inetd(1M) each time a connection to the
HTTP service is made, or alternatively it may run as a daemon.  We suggest
if you have any real amount of traffic to your server that you run NCSA 
HTTPd as a daemon.
.SH OPTIONS
.TP 12
.BI \-d serverroot
Set the inital value for the ServerRoot variable to \fIserverroot\fP. This
can be overriden by the ServerRoot command in the configuration file. The
default is \fB/usr/local/etc/httpd\fP.
.TP
.BI \-f config
Execute the commands in the file \fIconfig\fP on startup. If \fIconfig\fP
does not begin with a /, then it is taken to be a path relative to
the ServerRoot. The default is \fBconf/httpd.conf\fP.
.TP
.B \-v
Print the version of httpd, including compiled defaults and
command line options.
.TP
.B \-X
Execute in single request debugging mode, with no fork, no detach.  
Useful for profiling and debugging.
.SH FILES
.PD 0
.B /usr/local/etc/httpd/conf/httpd.conf
.br
.B /usr/local/etc/httpd/conf/srm.conf
.br
.B /usr/local/etc/httpd/conf/access.conf
.br
.B /usr/local/etc/httpd/conf/mime.types
.br
.B /usr/local/etc/httpd/logs/error_log
.br
.B /usr/local/etc/httpd/logs/access_log
.br
.B /usr/local/etc/httpd/logs/agent_log
.br
.B /usr/local/etc/httpd/logs/referer_log
.br
.B /usr/local/etc/httpd/logs/httpd.pid
.PD
.SH SEE ALSO
.BR inetd (1m).
.PP
Documentation for the NCSA HTTPd server is available from
http://hoohoo.ncsa.uiuc.edu/

