/*
 * tpack.h --
 *
 * Routines for module generation.  Used by Tpla, Quilt, and others.
 * For info see paper called 'Pictures with Parenthesis' in 20th DA
 * conference.
 *
 * Copyright (C) 1985 Regents of the University of California
 * All rights reserved.
 *
 *  @(#)mpack.h	1.3 MAGIC-TPACK (Berkeley) 11/2/85 
 */


/* Tiles can be created, stored, and tested for equality by a tpack program,
 * but the internal details of the tile are hidden from view.  The type	    
 * 'TILE' is a unique ID for a tile, not the tile itself.		    
 * Thus, tile1 = tile2 does not copy the tile itself, but rather just a     
 * pointer to the tile.
 */
typedef int *TILE;


/* Structures used by callers of the tpack routines */

/* An interpretation of the coordinates is not specified, some versions of this
 * program use whole lambdas while other versions use half-lambdas.  It 
 * shouldn't make any difference to you.
 */

typedef struct {
    int x_left, x_right, y_top, y_bot;
} RECTANGLE;

typedef struct {
    int x,y;
} POINT;

extern RECTANGLE origin_rect;
extern POINT origin_point;
extern TILE OutTile;


#include <stdio.h>



/*
 *
 * routines for use by tool-builders 
 *
 */


/* initalization and file manipulation */
extern 	TPinitialize();		/* parameters argc, argv, and initial file */
extern 	TPload_tiles();		/* read in a file of tiles */
extern 	TILE TPread_tile();	/* make a tile out of a file */
extern 	TPwrite_tile();		/* parameters tile, filename */
extern  int TPget_lambda();	/* Returns centi-microns per lambda,
				 * should only be called after TPinitialize().
				 */


/* tile creation, deletion, and access */
extern 	TPdelete_tile();	/* deletes the tile */
extern 	TILE TPcreate_tile();	/* returns a new tile */
extern 	TILE TPname_to_tile();	/* return a tile that corresponds to 
				   the label name */
extern 	RECTANGLE TPsize_of_tile();


/* painting routines */
extern  RECTANGLE TPpaint_tile();	/* paint one tile into another tile
					   at a specified point */
extern	RECTANGLE TPdisp_tile();	/* same as above, but no painting */
extern  RECTANGLE TPpaint_cell();	/* paint one tile into another tile,
					   but place it as a cell, not paint */



/* point alignment and manipulation */
extern	POINT align();		/* returns a point offset that causes the two
				   points to be aligned */
extern	POINT tLL();		/* returns the lower left corner of a tile */
extern 	POINT tLR();
extern	POINT tUL();
extern	POINT tUR();

extern	POINT rLL();		/* returns the lower left corner of a rect */
extern 	POINT rLR();
extern	POINT rUL();
extern	POINT rUR();


/* label manipulation */
extern TPplace_label();		/* places a rectangular label in a tile */
extern int TPfind_label();	/* finds a label within a tile		*/
extern TPstrip_labels();	/* removes all labels that start with a */
				/* given character from a tile		*/
extern TPremove_labels();	/* Removes all labels in a given area,  */
				/* and optionally only those with a	*/
				/* given name.				*/
extern TPstretch_tile();	/* stretches a tile along a line        */


/* point and rectangle addition and subtraction */
extern POINT TPadd_pp();	/* adds two points 			*/
extern POINT TPsub_pp();	/* subtracts two points			*/
extern RECTANGLE TPadd_rp();	/* adds a point to a rectangle		*/
extern RECTANGLE TPsub_rp();	/* subtracts a point from a rectangle	*/

