/* Copyright (C) 1996  TCX DataKonsult AB & Monty Program KB & Detron HB
   For a more info consult the file COPYRIGHT distributed with this file */

/* There may be prolems include all of theese. Try to test in
   configure with ones are needed? */

/*  This is needed for the definitions of strchr... on solaris */

#ifndef _m_string_h
#define _m_string_h
#if defined(HAVE_STRING_H)
#include <string.h>
#endif

/*  This is needed for the definitions of bzero... on solaris */
#if defined(HAVE_STRINGS_H) && !defined(HAVE_mit_thread)
#include <strings.h>
#endif


/*  This is needed for the definitions of memcpy... on solaris */
#if defined(HAVE_MEMORY_H) && !defined(__cplusplus)
#include <memory.h>
#endif

#if !defined(HAVE_MEMCPY)
# define memcpy(d, s, n)	bcopy ((s), (d), (n))
# define memcmp(A,B,C)		bcmp((A),(B),(C))
# define memset(A,C,B)		bfill((A),(B),(C))
# define memmove(d, s, n)	bmove ((s), (d), (n))
#else
# define bcopy(s, d, n)		memcpy((d), (s), (n))
# define bcmp(A,B,C)		memcmp((A),(B),(C))
# define bfill(A,B,C)		memset((A),(C),(B))
# define bzero(A,B)		memset((A),0,(B))
# define bmove_allign(A,B,C)	memcpy((A),(B),(C))
#ifdef HAVE_MEMMOVE
# define bmove(d, s, n)		memmove((d), (s), (n))
#else
# define memmove(d, s, n)	bmove((d), (s), (n)) /* our bmove */
#endif
#endif

#ifdef	__cplusplus
extern "C" {
#endif

extern char NEAR _dig_vec[];		/* Declared in int2str() */

#ifdef BAD_STRING_COMPILER
#define strmov(A,B)  (memccpy(A,B,0,INT_MAX)-1)
#else
#define strmov_overlapp(A,B) strmov(A,B)
#define strmake_overlapp(A,B,C) strmake(A,B,C)
#endif

#ifdef MSDOS
#undef bmove_allign
#define bmove512(A,B,C) bmove_allign(A,B,C)
#define my_itoa(A,B,C) itoa(A,B,C)
#define my_ltoa(A,B,C) ltoa(A,B,C)
extern	void bmove_allign(gptr dst,const gptr src,uint len);
#endif

#if !defined(USE_BMOVE512) || defined(HAVE_purify)
#define bmove512(A,B,C) memcpy(A,B,C)
#endif

	/* Prototypes for string functions */

#if !defined(bfill) && !defined(HAVE_BFILL)
extern	void bfill(gptr dst,uint len,pchar fill);
#endif

#if !defined(bzero) && !defined(HAVE_BZERO)
extern	void bzero(gptr dst,uint len);
#endif

#if !defined(bcmp) && !defined(HAVE_BCMP)
extern	int bcmp(const char *s1,const char *s2,uint len);
#ifdef HAVE_purify
extern	int my_bcmp(const char *s1,const char *s2,uint len);
#define bcmp(A,B,C) my_bcmp((A),(B),(C))
#endif
#endif

#ifndef bmove512
extern	void bmove512(gptr dst,const gptr src,uint len);
#endif

#if !defined(HAVE_BMOVE) && !defined(bmove)
extern	void bmove(gptr dst,const char *src,uint len);
#endif

extern	void bmove_upp(char *dst,const char *src,uint len);
extern	void bchange(char *dst,uint old_len,const char *src,
		     uint new_len,uint tot_len);
extern	void strappend(char *s,uint len,pchar fill);
extern	char *strend(const char *s);
extern char *strcend(const char *, pchar);
extern	char *strfield(char *src,int fields,int chars,int blanks,
			   int tabch);
extern	char *strfill(char *s,uint len,pchar fill);
extern	uint strinstr(const char *str,const char *search);
extern	char *strkey(char *dst,char *head,char *tail,char *flags);
extern	char *strmake(char *dst,const char *src,uint length);
#ifndef strmake_overlapp
extern	char *strmake_overlapp(char *dst,const char *src, uint length);
#endif

#ifndef strmov
extern	char *strmov(char *dst,const char *src);
#endif
extern	uint strnlen(const char *s,uint n);
extern	char *strnmov(char *dst,const char *src,uint n);
extern	char *strsuff(const char *src,const char *suffix);
extern	char *strcont(const char *src,const char *set);
extern	char *strxcat _VARARGS((char *dst,const char *src, ...));
extern	char *strxmov _VARARGS((char *dst,const char *src, ...));
extern	char *strxcpy _VARARGS((char *dst,const char *src, ...));
extern	char *strxncat _VARARGS((char *dst,uint len, const char *src, ...));
extern	char *strxnmov _VARARGS((char *dst,uint len, const char *src, ...));
extern	char *strxncpy _VARARGS((char *dst,uint len, const char *src, ...));

/* Prototypes of normal stringfunctions (with may ours) */

#ifdef WANT_STRING_PROTOTYPES
extern char *strcat(char *, const char *);
extern char *strchr(const char *, pchar);
extern char *strrchr(const char *, pchar);
extern char *strcpy(char *, const char *);
extern int strcmp(const char *, const char *);
#ifndef __GNUC__
extern size_t strlen(const char *);
#endif
#endif

#if !defined(__cplusplus) && !defined(_WINDOWS)
extern char *strpbrk(const char *, const char *);
extern size_t strspn(const char *, const char *);
extern char *strstr(const char *, const char *);
#endif
extern qsort_cmp get_ptr_compare(uint);
extern int is_prefix(const char *, const char *);

/* Conversion rutins */

#ifdef USE_MY_ITOA
extern char *my_itoa(int val,char *dst,int radix);
extern char *my_ltoa(long val,char *dst,int radix);
#endif

#ifndef HAVE_STRTOUL
extern long strtol(const char *str, char **ptr, int base);
extern ulong strtoul(const char *str, char **ptr, int base);
#endif

extern char *int2str(long val,char *dst,int radix);
extern char *str2int(const char *src,int radix,long lower,long upper,
			 long *val);
#ifdef HAVE_LONG_LONG
extern char *longlong2str(longlong val,char *dst,int radix);
#if !defined(HAVE_STRTOULL) || defined(HAVE_mit_thread)
extern longlong strtoll(const char *str, char **ptr, int base);
extern ulonglong strtoull(const char *str, char **ptr, int base);
#endif
#endif

#ifdef	__cplusplus
}
#endif
#endif
