package SYS::dfent;

use Carp;

require Exporter;
@ISA = qw(Exporter Struct);
@EXPORT = qw(setdfent enddfent getdfent getdfname);
@EXPORT_OK = qw(fetch_mountpoints);

use SYS::statfs qw(statfs);
use SYS::mntent	qw(endmntent getmntent);
use SYS::stat	qw(stat);

# This is mostly to shutup -w.  Note that
# for the sym deref we intend to do, these must
# not be lexical variables.

# these need to all be the as in the export ok list
# actually, struct is going 

use Struct;
struct SYS::dfent qw{
    filesystem mountpoint
    kbytes ubytes kused kavail kcapacity
    inodes iavail iused icapacity type
    fsinfo
};

sub dfinfo { 
    my $dir = $_[0];

    confess "Expected name" unless $dir;

    refresh_mtab();

    unless (defined($dev = $dir2dev{$dir})) {
	if (-b $dir) { 
	    $dev = stat($dir)->rdev;
	    unless ($dev2dir{$dev}) { 
		carp "Block special file $dir (dev $dev) not in mount table";
		return undef;
	    }
	    $dir = $dev2dir{$dev};
	} else {
	    my $sb = stat($dir);
	    if (!($sb && ($dev = $sb->dev))) {
		#carp "Can't stat $dir: $!";
		return undef;
	    } 
	}
    }

    unless ($fsinfo = statfs($dir)) { 
	carp "can't statfs $dir: $!";
	return undef;
    }

    $filesystem = $dev2fs{$dev};
    $mountpoint = $dev2mntpnt{$dev};
    $type	= $fsinfo->type;
    $kfactor    = $fsinfo->bsize() / 1024;
    $kbytes     = $fsinfo->blocks() * $kfactor;
    $kused      = $kbytes - $fsinfo->bfree() * $kfactor;
    $kavail     = $fsinfo->bavail() * $kfactor;
    $ubytes     = $kbytes * 0.90;
    $kcapacity  = ($ubytes - $kused) / $ubytes;
    $ubytes     = int($ubytes);
    $kcapacity  = 100 - int($kcapacity * 100 + 0.5);
    $inodes     = $fsinfo->files;
    $iavail     = $fsinfo->ffree;
    $iused      = $inodes - $iavail;
    $icapacity  = 100 - int($iavail/$inodes * 100 + 0.5);

    my $fs = new SYS::dfent;
    while (($name, $number) = each %{$fs->_fieldnos} ) {
	no strict 'refs';
	$fs->[$number] = $$name;
    } 
    return $fs;
}

sub load_mtab {
    my $devcount = 0;
    while ($m = getmntent()) {
        my $dev = stat($m->dir)->dev;

	$dev2mntpnt{$dev} = $m->dir;
	$dev2fs{$dev}     = $m->fsname;
	$devnum{$dev}     = $devcount++;
	$dir2dev{$m->dir} = $dev;
	$dev2dir{$dev}	  = $m->dir;

    }
    endmntent();
}

sub refresh_mtab { 
    # reload new mtab if they called setmntent themselves
    load_mtab() unless %dev2mntpnt || defined fileno(SYS::mntent::MTAB);
}

sub fetch_mountpoints { 
    confess "Don't call me in a scalar context" unless wantarray;
    refresh_mtab();
    @dev2mntpnt{sort {$devnum{$a} <=> $devnum{$b}} keys %devnum};
}

sub getdfname {
    my $mp = $_[0];
    confess "Expected name" unless $mp;
    cache_mountpoints();
    dfinfo($mp);
} 

sub getdfent {
    confess "Don't call me with arguments" if @_;
    cache_mountpoints();
    my $mp;
    if (wantarray) {
	my @minfo;
	carp "getdfent: returning all entries in array context";
	for $mp ( @MP_Cache ) {
	    push(@minfo, dfinfo($mp));
	} 
	return @minfo;
    } 
    $mp = shift @MP_Cache;
    return $mp ? dfinfo($mp) : undef;
} 

sub setdfent {
    cache_mountpoints();
} 

sub enddfent {
    endmntent() if defined fileno(SYS::mntent::MTAB);
    undef @MP_Cache;
} 

sub cache_mountpoints {
    @MP_Cache = fetch_mountpoints() unless defined @MP_Cache;
} 
